/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.AbstractRDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class AbstractOWLAnonymousClass
extends AbstractRDFSClass
implements OWLAnonymousClass {
    public AbstractOWLAnonymousClass(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    public AbstractOWLAnonymousClass() {
    }

    public String getBrowserText() {
        return this.getOWLModel().getOWLClassDisplay().getDisplayText(this);
    }

    public Collection getDependingClasses() {
        return Collections.EMPTY_SET;
    }

    public OWLAnonymousClass getExpressionRoot() {
        RDFProperty rDFProperty = this.getOWLModel().getRDFFirstProperty();
        Collection collection = this.getReferences();
        for (Reference reference : collection) {
            RDFResource rDFResource;
            if (reference.getFrame() instanceof OWLAnonymousClass) {
                rDFResource = (OWLAnonymousClass)reference.getFrame();
                return rDFResource.getExpressionRoot();
            }
            if (!(reference.getFrame() instanceof RDFList) || !rDFProperty.equals(reference.getSlot())) continue;
            rDFResource = (RDFList)reference.getFrame();
            RDFList rDFList = rDFResource.getStart();
            HashSet hashSet = new HashSet();
            OWLUtil.getReferringLogicalClasses(rDFList, hashSet);
            if (hashSet.size() <= 0) continue;
            OWLAnonymousClass oWLAnonymousClass = (OWLAnonymousClass)hashSet.iterator().next();
            return oWLAnonymousClass.getExpressionRoot();
        }
        return this;
    }

    public Icon getIcon() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 8);
        if (this.isEditable()) {
            return OWLIcons.getImageIcon(string2);
        }
        return OWLIcons.getReadOnlyClsIcon(OWLIcons.getImageIcon(string2));
    }

    public ImageIcon getImageIcon() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 8);
        return OWLIcons.getImageIcon(string2);
    }

    public OWLNamedClass getOwner() {
        Collection collection = this.getSubclasses(false);
        if (collection.isEmpty()) {
            OWLAnonymousClass oWLAnonymousClass = this.getExpressionRoot();
            if (this.equals(oWLAnonymousClass)) {
                return null;
            }
            return oWLAnonymousClass.getOwner();
        }
        return (OWLNamedClass)collection.iterator().next();
    }

    public boolean isAnonymous() {
        return true;
    }

    public boolean isVisible() {
        return false;
    }
}

