/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.framestore.DeleteSimplificationFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.framestore.AbstractRestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.framestore.AllValuesFromRestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.framestore.CardinalityRestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.framestore.HasValueRestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.framestore.RestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLCardinality;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLHasValue;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLFrameStore
extends FrameStoreAdapter {
    private Hashtable<Class, AbstractRestrictionUpdater> class2Updater = new Hashtable();
    private Hashtable<Facet, AbstractRestrictionUpdater> facet2Updater = new Hashtable();
    protected boolean facetHandlingBlocked;
    private AllValuesFromRestrictionUpdater allValuesFromRestrictionUpdater;
    private CardinalityRestrictionUpdater cardinalityRestrictionUpdater;
    private HasValueRestrictionUpdater hasValueRestrictionUpdater;
    private AbstractOWLModel owlModel;
    protected boolean superclassHandlingBlocked;
    private boolean suppressUpdateTemplateSlots = false;
    public static final String IGNORE_PREFIXES_IN_SEARCH = "OWL-TOLERATE-PREFIXES-IN-SEARCH";
    private boolean superclassSynchronizationBlocked = false;
    private boolean deletingRDFSDatatype = false;
    public static boolean autoDeleteOfAnonymousClses = true;
    public static boolean allowDuplicateOwnSlotValues = false;
    public boolean suppressUpdateRDFSDomain = false;

    public OWLFrameStore(AbstractOWLModel abstractOWLModel) {
        this.owlModel = abstractOWLModel;
        this.initRestrictionUpdaters();
    }

    public void addDirectSuperclass(Cls cls, Cls cls2) {
        if (!cls.hasDirectSuperclass(cls2)) {
            super.addDirectSuperclass(cls, cls2);
            if (cls2 instanceof OWLIntersectionClass && cls instanceof OWLNamedClass && cls2.hasDirectSuperclass(cls)) {
                this.addNamedOperandsToDirectSuperclasses((OWLNamedClass)cls, (OWLIntersectionClass)cls2);
            } else if (cls instanceof OWLIntersectionClass && cls2 instanceof OWLNamedClass && cls2.hasDirectSuperclass(cls)) {
                this.addNamedOperandsToDirectSuperclasses((OWLNamedClass)cls2, (OWLIntersectionClass)cls);
            }
            if (!this.superclassHandlingBlocked && cls instanceof OWLNamedClass) {
                OWLNamedClass oWLNamedClass = (OWLNamedClass)cls;
                if (cls2 instanceof OWLRestriction) {
                    this.copyFacetValuesIntoOWLNamedClass(oWLNamedClass, (OWLRestriction)cls2);
                }
            }
            if (cls instanceof OWLNamedClass && cls2 instanceof OWLNamedClass && cls.isEditable() && ((OWLNamedClass)cls2).getSubclassesDisjoint()) {
                OWLUtil.ensureSubclassesDisjoint((OWLNamedClass)cls2);
            }
            if (!this.superclassSynchronizationBlocked) {
                if (cls instanceof RDFSNamedClass) {
                    this.updateRDFSSubClassOf((RDFSNamedClass)cls);
                }
                if (cls2 instanceof RDFSNamedClass) {
                    this.updateRDFSSubClassOf((RDFSNamedClass)cls2);
                }
            }
        }
    }

    public void addDirectSuperslot(Slot slot, Slot slot2) {
        super.addDirectSuperslot(slot, slot2);
        if (slot instanceof RDFProperty) {
            RDFProperty rDFProperty = (RDFProperty)slot;
            if (rDFProperty instanceof OWLProperty && slot2 instanceof OWLProperty && ((OWLProperty)slot2).isAnnotationProperty()) {
                this.addDirectType((Instance)slot, this.owlModel.getCls("owl:AnnotationProperty"));
            }
            if (rDFProperty.getRange() == null) {
                slot.setDirectOwnSlotValue(this.owlModel.getSlot(":SLOT-VALUE-TYPE"), null);
            }
            if (!rDFProperty.isDomainDefined()) {
                slot.setDirectOwnSlotValue(this.owlModel.getSlot(":DIRECT-DOMAIN"), null);
            }
        }
    }

    public void addDirectType(Instance instance, Cls cls) {
        if (instance instanceof RDFProperty && cls.equals(this.owlModel.getOWLFunctionalPropertyClass())) {
            ((Slot)instance).setAllowsMultipleValues(false);
        }
        if (instance instanceof RDFResource && !instance.getDirectOwnSlotValues((Slot)this.owlModel.getRDFTypeProperty()).contains(cls) && !cls.equals(this.owlModel.getRDFUntypedResourcesClass())) {
            instance.addOwnSlotValue((Slot)this.owlModel.getRDFTypeProperty(), (Object)cls);
        }
        super.addDirectType(instance, cls);
    }

    private void addNamedOperandsToDirectSuperclasses(OWLNamedClass oWLNamedClass, OWLIntersectionClass oWLIntersectionClass) {
        for (RDFSClass rDFSClass : oWLIntersectionClass.getOperands()) {
            if (!(rDFSClass instanceof OWLNamedClass)) continue;
            oWLNamedClass.addSuperclass(rDFSClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFacetValuesIntoNamedClses() {
        boolean bl = this.owlModel.isUndoEnabled();
        this.owlModel.setUndoEnabled(false);
        try {
            for (Cls cls : this.owlModel.getRDFSClasses()) {
                if (!(cls instanceof OWLRestriction)) continue;
                this.copyFacetValuesIntoOWLNamedClass((OWLRestriction)cls);
            }
        }
        finally {
            this.owlModel.setUndoEnabled(bl);
        }
    }

    private void copyFacetValuesIntoOWLNamedClass(OWLRestriction oWLRestriction) {
        if (oWLRestriction.getSubclasses(false).size() == 1) {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)oWLRestriction.getSubclasses(false).toArray()[0];
            this.copyFacetValuesIntoOWLNamedClass(rDFSNamedClass, oWLRestriction);
        }
    }

    private void copyFacetValuesIntoOWLNamedClass(RDFSNamedClass rDFSNamedClass, OWLRestriction oWLRestriction) {
        Class<?> clazz = oWLRestriction.getClass();
        RestrictionUpdater restrictionUpdater = this.class2Updater.get(clazz);
        if (restrictionUpdater != null) {
            this.facetHandlingBlocked = true;
            restrictionUpdater.copyFacetValuesIntoNamedClass(rDFSNamedClass, oWLRestriction);
            this.facetHandlingBlocked = false;
        }
    }

    public Cls createCls(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl) {
        Cls cls = super.createCls(frameID, string, collection, collection2, bl);
        if (cls instanceof OWLNamedClass && cls.isEditable()) {
            for (Cls cls2 : collection2) {
                if (!(cls2 instanceof OWLNamedClass) || !((OWLNamedClass)cls2).getSubclassesDisjoint()) continue;
                OWLUtil.ensureSubclassesDisjoint((OWLNamedClass)cls2);
            }
        }
        if (cls instanceof RDFSNamedClass) {
            ((RDFSNamedClass)cls).setPropertyValues(this.owlModel.getRDFSSubClassOfProperty(), collection2);
            cls.setDirectOwnSlotValues((Slot)this.owlModel.getRDFTypeProperty(), collection);
        } else if (cls instanceof OWLRestriction) {
            cls.setDirectOwnSlotValue((Slot)this.owlModel.getRDFTypeProperty(), (Object)this.owlModel.getRDFSNamedClass("owl:Restriction"));
        } else if (cls instanceof OWLAnonymousClass) {
            cls.setDirectOwnSlotValue((Slot)this.owlModel.getRDFTypeProperty(), (Object)this.owlModel.getOWLNamedClassClass());
        }
        return cls;
    }

    public Slot createSlot(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl) {
        Slot slot = super.createSlot(frameID, string, collection, collection2, bl);
        if (slot instanceof RDFProperty) {
            RDFProperty rDFProperty = (RDFProperty)slot;
            slot.setAllowsMultipleValues(true);
            if (slot instanceof OWLObjectProperty && collection2.isEmpty()) {
                rDFProperty.setValueType(ValueType.INSTANCE);
            }
            slot.setDirectOwnSlotValues((Slot)this.owlModel.getRDFTypeProperty(), collection);
            rDFProperty.setDomainDefined(false);
        }
        return slot;
    }

    public SimpleInstance createSimpleInstance(FrameID frameID, String string, Collection collection, boolean bl) {
        SimpleInstance simpleInstance = super.createSimpleInstance(frameID, string, collection, bl);
        if (simpleInstance instanceof RDFResource && !collection.contains(this.owlModel.getRDFUntypedResourcesClass())) {
            simpleInstance.setDirectOwnSlotValues((Slot)this.owlModel.getRDFTypeProperty(), collection);
        }
        return simpleInstance;
    }

    private void deleteAnonymousClass(OWLAnonymousClass oWLAnonymousClass) {
        if (oWLAnonymousClass.getDirectSubclassCount() == 1) {
            Cls cls = (Cls)oWLAnonymousClass.getDirectSubclasses().iterator().next();
            cls.removeDirectSuperclass((Cls)oWLAnonymousClass);
            return;
        }
        Set<RDFSClass> set = this.getReferringAnonymousClassesAndDeleteDependingListInstances(oWLAnonymousClass);
        if (set.size() > 0) {
            this.deleteAnonymousClses(set);
        } else {
            this.deleteAnonymousClses(Collections.singleton(oWLAnonymousClass));
        }
    }

    private Set<RDFSClass> getReferringAnonymousClassesAndDeleteDependingListInstances(OWLAnonymousClass oWLAnonymousClass) {
        Slot slot = oWLAnonymousClass.getKnowledgeBase().getSlot(":DIRECT-SUBCLASSES");
        RDFProperty rDFProperty = oWLAnonymousClass.getOWLModel().getRDFFirstProperty();
        RDFList rDFList = this.owlModel.getRDFNil();
        HashSet<RDFSClass> hashSet = new HashSet<RDFSClass>();
        for (Reference reference : oWLAnonymousClass.getReferences()) {
            Frame frame = reference.getFrame();
            Slot slot2 = reference.getSlot();
            if (frame instanceof OWLAnonymousClass) {
                if (slot.equals(slot2)) continue;
                hashSet.add((RDFSClass)frame);
                continue;
            }
            if (!(frame instanceof RDFList) || !rDFProperty.equals(slot2)) continue;
            RDFList rDFList2 = (RDFList)frame;
            RDFList rDFList3 = rDFList2.getStart();
            OWLUtil.getReferringLogicalClasses(rDFList3, hashSet);
            if (rDFList.equals(rDFList2)) continue;
            this.deleteListInstance(rDFList2);
        }
        if (oWLAnonymousClass instanceof RDFResource) {
            this.deleteRDFListsThatArePropertyValues(oWLAnonymousClass);
        }
        return hashSet;
    }

    private void deleteAnonymousClses(Collection collection) {
        this.deleteAnonymousClasses(collection, Collections.EMPTY_LIST);
    }

    private void deleteAnonymousClasses(Collection collection, Collection collection2) {
        if (!collection.isEmpty()) {
            HashSet<OWLAnonymousClass> hashSet = new HashSet<OWLAnonymousClass>();
            for (Object object : collection) {
                if (object instanceof OWLAnonymousClass) {
                    OWLAnonymousClass oWLAnonymousClass = ((OWLAnonymousClass)object).getExpressionRoot();
                    if (collection2.contains(oWLAnonymousClass)) continue;
                    hashSet.add(oWLAnonymousClass);
                    continue;
                }
                if (!(object instanceof OWLDataRange)) continue;
                ((OWLDataRange)object).delete();
            }
            for (OWLAnonymousClass oWLAnonymousClass : hashSet) {
                this.deleteAnonymousTree(oWLAnonymousClass);
            }
        }
    }

    private void deleteAnonymousTree(OWLAnonymousClass oWLAnonymousClass) {
        Object object;
        if (oWLAnonymousClass instanceof OWLIntersectionClass) {
            object = (OWLIntersectionClass)oWLAnonymousClass;
            this.ensureRDFSSubClassOfStatementsExistForNamedOperands((OWLIntersectionClass)object);
        }
        object = oWLAnonymousClass.getDependingClasses();
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            OWLAnonymousClass oWLAnonymousClass2 = (OWLAnonymousClass)object2.next();
            this.deleteAnonymousTree(oWLAnonymousClass2);
        }
        this.deleteRDFListsThatArePropertyValues(oWLAnonymousClass);
        if (oWLAnonymousClass instanceof OWLQuantifierRestriction && (object2 = ((OWLQuantifierRestriction)oWLAnonymousClass).getFiller()) instanceof RDFSDatatype && object2.isAnonymous()) {
            this.deletingRDFSDatatype = true;
            object2.delete();
            this.deletingRDFSDatatype = false;
        }
        super.deleteCls((Cls)oWLAnonymousClass);
    }

    public void deleteCls(Cls cls) {
        if (cls instanceof OWLAnonymousClass) {
            this.deleteAnonymousClass((OWLAnonymousClass)cls);
        } else if (cls instanceof RDFSNamedClass) {
            this.deleteNamedClass((RDFSNamedClass)cls);
        } else {
            this.deleteDependingListInstances((Instance)cls);
            super.deleteCls(cls);
        }
    }

    private void deleteDependingAnonymousClses(Cls cls) {
        Collection collection = this.getClsesToDelete(cls);
        for (Cls cls2 : collection) {
            if (!(cls2 instanceof RDFSNamedClass)) continue;
            Set set = ((RDFSNamedClass)cls2).getReferringAnonymousClasses();
            this.deleteAnonymousClses(set);
            for (Cls cls3 : new ArrayList(cls2.getDirectSuperclasses())) {
                if (!(cls3 instanceof OWLAnonymousClass)) continue;
                cls3.delete();
            }
        }
    }

    private void deleteDependingAnonymousClses(Slot slot) {
        Collection collection = this.getSlotsToDelete(slot);
        for (Slot slot2 : collection) {
            if (!(slot2 instanceof RDFProperty)) continue;
            Set set = ((RDFProperty)slot2).getReferringAnonymousClasses();
            this.deleteAnonymousClses(set);
        }
    }

    private void deleteDependingListInstances(Instance instance) {
        RDFList rDFList = this.owlModel.getRDFNil();
        Set set = this.getReferences(instance);
        RDFProperty rDFProperty = this.owlModel.getRDFFirstProperty();
        for (Reference reference : set) {
            RDFList rDFList2;
            if (!rDFProperty.equals(reference.getSlot()) || rDFList.equals(rDFList2 = (RDFList)reference.getFrame())) continue;
            this.deleteListInstance(rDFList2);
        }
        if (instance instanceof RDFResource) {
            this.deleteRDFListsThatArePropertyValues((RDFResource)instance);
        }
    }

    private void deleteRDFListsThatArePropertyValues(RDFResource rDFResource) {
        RDFList rDFList = this.owlModel.getRDFNil();
        for (RDFProperty rDFProperty : rDFResource.getPossibleRDFProperties()) {
            ArrayList arrayList = new ArrayList(rDFResource.getPropertyValues(rDFProperty));
            for (Object e : arrayList) {
                if (!(e instanceof RDFList) || rDFList.equals(e)) continue;
                RDFList rDFList2 = (RDFList)e;
                rDFResource.removePropertyValue(rDFProperty, rDFList2);
                rDFList2.delete();
            }
        }
    }

    private void deleteListInstance(RDFList rDFList) {
        RDFList rDFList2 = rDFList.getRest();
        if (this.owlModel.getRDFNil().equals(rDFList2)) {
            rDFList2 = null;
        }
        rDFList.setRest(null);
        if (rDFList2 != null) {
            RDFProperty rDFProperty = this.owlModel.getRDFRestProperty();
            for (Reference reference : this.getReferences(rDFList)) {
                Frame frame = reference.getFrame();
                Slot slot = reference.getSlot();
                if (slot.isSystem() && !slot.equals(rDFProperty) && !slot.equals(this.owlModel.getOWLIntersectionOfProperty()) && !slot.equals(this.owlModel.getOWLUnionOfProperty()) && !slot.equals(this.owlModel.getOWLOneOfProperty()) && !slot.equals(this.owlModel.getOWLDistinctMembersProperty())) continue;
                frame.addOwnSlotValue(slot, (Object)rDFList2);
            }
        }
        rDFList.delete();
    }

    private void deleteNamedClass(RDFSNamedClass rDFSNamedClass) {
        this.deleteNamedClassFromDomainsAndRanges(rDFSNamedClass);
        this.deleteDependingAnonymousClses(rDFSNamedClass);
        this.deleteAnonymousClses(rDFSNamedClass.getSuperclasses(false));
        this.deleteAnonymousClses(rDFSNamedClass.getReferringAnonymousClasses());
        this.deleteDependingListInstances(rDFSNamedClass);
        super.deleteCls((Cls)rDFSNamedClass);
    }

    private void deleteNamedClassFromDomainsAndRanges(RDFSNamedClass rDFSNamedClass) {
        Object object2;
        Set set = rDFSNamedClass.getReferringAnonymousClasses();
        for (Object object2 : set) {
            if (!(object2 instanceof OWLUnionClass)) continue;
            for (Object object3 : this.owlModel.getReferences((Frame)object2)) {
                if (!(object3.getFrame() instanceof RDFProperty)) continue;
                RDFProperty rDFProperty = (RDFProperty)object3.getFrame();
                if (object3.getSlot().equals(this.owlModel.getRDFSDomainProperty())) {
                    rDFProperty.removeUnionDomainClass(rDFSNamedClass);
                    continue;
                }
                if (!object3.getSlot().equals(this.owlModel.getRDFSRangeProperty())) continue;
                ArrayList arrayList = new ArrayList(rDFProperty.getUnionRangeClasses());
                arrayList.remove(rDFSNamedClass);
                rDFProperty.setUnionRangeClasses(arrayList);
            }
        }
        Collection collection = this.owlModel.getReferences((Frame)rDFSNamedClass);
        object2 = collection.iterator();
        while (object2.hasNext()) {
            Object object3;
            Reference reference = (Reference)object2.next();
            if (!reference.getSlot().equals(this.owlModel.getRDFSDomainProperty())) continue;
            object3 = (RDFProperty)reference.getFrame();
            object3.removeUnionDomainClass(rDFSNamedClass);
        }
    }

    public void deleteQuantifierRestrictions(OWLProperty oWLProperty) {
        HashSet<OWLAnonymousClass> hashSet = new HashSet<OWLAnonymousClass>();
        for (Reference object : this.owlModel.getReferences((Frame)oWLProperty)) {
            if (!(object.getFrame() instanceof OWLQuantifierRestriction)) continue;
            OWLQuantifierRestriction oWLQuantifierRestriction = (OWLQuantifierRestriction)object.getFrame();
            hashSet.add(oWLQuantifierRestriction.getExpressionRoot());
        }
        for (OWLAnonymousClass oWLAnonymousClass : hashSet) {
            OWLFrameStore.log("- Deleting quantifier restriction root " + oWLAnonymousClass.getBrowserText());
            oWLAnonymousClass.delete();
        }
    }

    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        if (simpleInstance instanceof RDFList) {
            this.deleteListChain((RDFList)simpleInstance);
        }
        this.deleteDependingListInstances((Instance)simpleInstance);
        if (simpleInstance instanceof RDFResource && !this.deletingRDFSDatatype) {
            RDFResource rDFResource = (RDFResource)simpleInstance;
            this.deleteAnonymousClses(rDFResource.getReferringAnonymousClasses());
        }
        super.deleteSimpleInstance(simpleInstance);
    }

    private void deleteListChain(RDFList rDFList) {
        RDFList rDFList2;
        Object object = rDFList.getFirst();
        if (object instanceof OWLAnonymousClass) {
            rDFList.setFirst(null);
            ((OWLAnonymousClass)object).delete();
        }
        if ((rDFList2 = rDFList.getRest()) != null && !this.owlModel.getRDFNil().equals(rDFList2)) {
            rDFList2.delete();
        }
    }

    public void deleteSlot(Slot slot) {
        this.deleteDependingListInstances((Instance)slot);
        if (slot instanceof RDFProperty) {
            RDFProperty rDFProperty = (RDFProperty)slot;
            this.deleteDependingAnonymousClses(rDFProperty);
            if (rDFProperty.hasObjectRange()) {
                this.deleteAnonymousClses(rDFProperty.getPropertyValues(this.owlModel.getRDFSRangeProperty()));
            }
            Collection collection = slot.getDirectDomain();
            this.deleteAnonymousClses(collection);
            RDFResource rDFResource = rDFProperty.getRange();
            if (rDFResource instanceof RDFSDatatype && rDFResource.isAnonymous()) {
                rDFResource.delete();
            }
        }
        super.deleteSlot(slot);
    }

    private void ensureRDFSSubClassOfStatementsExistForNamedOperands(OWLIntersectionClass oWLIntersectionClass) {
        Collection collection = oWLIntersectionClass.getSuperclasses(false);
        if (collection.size() == 1) {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)collection.iterator().next();
            RDFProperty rDFProperty = this.owlModel.getRDFSSubClassOfProperty();
            Iterator iterator = oWLIntersectionClass.listOperands();
            while (iterator.hasNext()) {
                RDFSClass rDFSClass = (RDFSClass)iterator.next();
                if (!(rDFSClass instanceof RDFSNamedClass) || rDFSNamedClass.getPropertyValues(rDFProperty).contains(rDFSClass)) continue;
                rDFSNamedClass.addPropertyValue(rDFProperty, rDFSClass);
            }
        }
    }

    public Collection getClsesToDelete(Cls cls) {
        Set set = this.getSubclasses(cls);
        HashSet<Cls> hashSet = new HashSet<Cls>(set);
        hashSet.add(cls);
        for (Cls cls2 : set) {
            if (cls2.equals(cls) || !this.isReachableByAnotherRoute(cls2, hashSet)) continue;
            hashSet.remove(cls2);
            HashSet hashSet2 = new HashSet(this.getSubclasses(cls2));
            hashSet2.remove(cls);
            hashSet.removeAll(hashSet2);
        }
        return hashSet;
    }

    private DeleteSimplificationFrameStore getDeleteSimplificationFrameStore() {
        for (FrameStore frameStore : this.owlModel.getFrameStores()) {
            if (!(frameStore instanceof DeleteSimplificationFrameStore)) continue;
            return (DeleteSimplificationFrameStore)frameStore;
        }
        return null;
    }

    public List getLiteralValues(List list) {
        ArrayList arrayList = new ArrayList();
        for (Object e : list) {
            if (e instanceof RDFSLiteral) {
                arrayList.add(e);
                continue;
            }
            arrayList.add(this.owlModel.createRDFSLiteral(e));
        }
        return arrayList;
    }

    public Set getClsesWithMatchingBrowserText(String string, Collection collection, int n) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(super.getClsesWithMatchingBrowserText(string, collection, n));
        if (OWLFrameStore.isIgnorePrefixesInSearch(this.owlModel)) {
            for (String string2 : this.owlModel.getNamespaceManager().getPrefixes()) {
                hashSet.addAll(super.getClsesWithMatchingBrowserText(string2 + ":" + string, collection, n));
            }
        }
        return hashSet;
    }

    public Set getFramesWithMatchingDirectOwnSlotValue(Slot slot, String string, int n) {
        Set set = super.getFramesWithMatchingDirectOwnSlotValue(slot, string, n);
        if (OWLFrameStore.isIgnorePrefixesInSearch(this.owlModel)) {
            for (String string2 : this.owlModel.getNamespaceManager().getPrefixes()) {
                set.addAll(super.getFramesWithMatchingDirectOwnSlotValue(slot, string2 + ":" + string, n));
            }
        }
        return set;
    }

    public Set getMatchingReferences(String string, int n) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(super.getMatchingReferences(string, n));
        if (OWLFrameStore.isIgnorePrefixesInSearch(this.owlModel)) {
            for (String string2 : this.owlModel.getNamespaceManager().getPrefixes()) {
                hashSet.addAll(super.getMatchingReferences(string2 + ":" + string, n));
            }
        }
        return hashSet;
    }

    private Collection getSlotsToDelete(Slot slot) {
        DeleteSimplificationFrameStore deleteSimplificationFrameStore = this.getDeleteSimplificationFrameStore();
        return deleteSimplificationFrameStore.getSlotsToDelete(slot);
    }

    private void initRestrictionUpdaters() {
        this.allValuesFromRestrictionUpdater = new AllValuesFromRestrictionUpdater(this.owlModel);
        this.cardinalityRestrictionUpdater = new CardinalityRestrictionUpdater(this.owlModel);
        this.hasValueRestrictionUpdater = new HasValueRestrictionUpdater(this.owlModel);
        this.facet2Updater.put(this.owlModel.getFacet(":VALUE-TYPE"), this.allValuesFromRestrictionUpdater);
        this.facet2Updater.put(this.owlModel.getFacet(":MAXIMUM-CARDINALITY"), this.cardinalityRestrictionUpdater);
        this.facet2Updater.put(this.owlModel.getFacet(":MINIMUM-CARDINALITY"), this.cardinalityRestrictionUpdater);
        this.facet2Updater.put(this.owlModel.getFacet(":VALUES"), this.hasValueRestrictionUpdater);
        this.class2Updater.put(DefaultOWLAllValuesFrom.class, this.allValuesFromRestrictionUpdater);
        this.class2Updater.put(DefaultOWLCardinality.class, this.cardinalityRestrictionUpdater);
        this.class2Updater.put(DefaultOWLHasValue.class, this.hasValueRestrictionUpdater);
        this.class2Updater.put(DefaultOWLMaxCardinality.class, this.cardinalityRestrictionUpdater);
        this.class2Updater.put(DefaultOWLMinCardinality.class, this.cardinalityRestrictionUpdater);
    }

    public static boolean isIgnorePrefixesInSearch(OWLModel oWLModel) {
        return Boolean.TRUE.equals(oWLModel.getOWLProject().getSettingsMap().getBoolean(IGNORE_PREFIXES_IN_SEARCH));
    }

    private boolean isReachableByAnotherRoute(Cls cls, Collection collection) {
        ArrayList arrayList = new ArrayList(this.getDirectSuperclasses(cls));
        arrayList.remove(this.owlModel.getAnonymousRootCls());
        if (arrayList.size() > 1) {
            for (Cls cls2 : arrayList) {
                if (!(cls2 instanceof RDFSNamedClass) || collection.contains(cls2)) continue;
                return true;
            }
        }
        return false;
    }

    private static void log(String string) {
    }

    public void removeDirectSuperclass(Cls cls, Cls cls2) {
        boolean bl = cls2.hasDirectSuperclass(cls);
        super.removeDirectSuperclass(cls, cls2);
        if (cls instanceof OWLNamedClass && cls2 instanceof OWLIntersectionClass && bl) {
            this.removeNamedOperandsFromDirectSuperclasses((OWLNamedClass)cls, (OWLIntersectionClass)cls2, this.owlModel.getSlot(":DIRECT-SUPERCLASSES"));
        } else if (cls2 instanceof OWLNamedClass && cls instanceof OWLIntersectionClass && bl) {
            this.removeNamedOperandsFromDirectSuperclasses((OWLNamedClass)cls2, (OWLIntersectionClass)cls, this.owlModel.getSlot(":DIRECT-SUBCLASSES"));
        }
        if (!this.superclassHandlingBlocked && cls instanceof OWLNamedClass && cls2 instanceof OWLRestriction) {
            this.copyFacetValuesIntoOWLNamedClass((OWLNamedClass)cls, (OWLRestriction)cls2);
        }
        if (cls2 instanceof OWLAnonymousClass && autoDeleteOfAnonymousClses) {
            cls2.delete();
        }
        if (cls instanceof RDFSNamedClass) {
            this.updateRDFSSubClassOf((RDFSNamedClass)cls);
        } else if (cls2 instanceof RDFSNamedClass) {
            this.updateRDFSSubClassOf((RDFSNamedClass)cls2);
        }
    }

    public void removeDirectSuperslot(Slot slot, Slot slot2) {
        super.removeDirectSuperslot(slot, slot2);
        if (slot instanceof OWLObjectProperty && slot.getDirectSuperslotCount() == 0 && slot.getAllowedClses().isEmpty()) {
            slot.setValueType(ValueType.INSTANCE);
        }
        if (slot instanceof RDFProperty && slot.getDirectDomain().isEmpty() && slot.getDirectSuperslotCount() == 0) {
            this.owlModel.getOWLThingClass().addDirectTemplateSlot(slot);
        }
    }

    public void removeDirectType(Instance instance, Cls cls) {
        if (instance instanceof RDFProperty && cls.equals(this.owlModel.getOWLFunctionalPropertyClass())) {
            ((Slot)instance).setAllowsMultipleValues(true);
        }
        if (instance instanceof RDFResource) {
            instance.removeOwnSlotValue((Slot)this.owlModel.getRDFTypeProperty(), (Object)cls);
        }
        super.removeDirectType(instance, cls);
    }

    private void removeNamedOperandsFromDirectSuperclasses(OWLNamedClass oWLNamedClass, OWLIntersectionClass oWLIntersectionClass, Slot slot) {
        Collection collection = oWLIntersectionClass.getNamedOperands();
        if (!collection.isEmpty()) {
            for (RDFSClass rDFSClass : oWLNamedClass.getDirectOwnSlotValues(slot)) {
                if (!(rDFSClass instanceof OWLIntersectionClass)) continue;
                collection.removeAll(((OWLIntersectionClass)rDFSClass).getNamedOperands());
            }
            for (RDFSClass rDFSClass : collection) {
                if (rDFSClass.hasEquivalentClass(oWLNamedClass)) continue;
                oWLNamedClass.removeSuperclass(rDFSClass);
            }
        }
    }

    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection abstractCollection) {
        Object object;
        int n = abstractCollection.size();
        if (!allowDuplicateOwnSlotValues && n > 1 && n != new HashSet(abstractCollection).size()) {
            System.err.println("[OWLFrameStore] Warning: Attempted to assign duplicate value to " + frame.getBrowserText() + "." + slot.getBrowserText());
            for (Object e : abstractCollection) {
                System.err.println("[OWLFrameStore]  - " + e);
            }
            abstractCollection = new HashSet(abstractCollection);
        }
        if (frame instanceof RDFProperty && slot.equals(this.owlModel.getRDFSRangeProperty())) {
            object = frame.getDirectOwnSlotValues(slot);
            if (abstractCollection.size() > 0 && abstractCollection.iterator().next() instanceof RDFSClass) {
                this.updatePropertyAllowedClasses((RDFProperty)frame, abstractCollection);
            } else {
                this.updatePropertyValueType((RDFProperty)frame, abstractCollection);
            }
            super.setDirectOwnSlotValues(frame, slot, (Collection)abstractCollection);
            this.deleteAnonymousClasses((Collection)object, abstractCollection);
        } else if (frame instanceof RDFProperty && slot.equals(this.owlModel.getRDFSDomainProperty())) {
            if (abstractCollection.size() > 1 && abstractCollection.contains(this.owlModel.getOWLThingClass())) {
                abstractCollection = new ArrayList(abstractCollection);
                abstractCollection.remove(this.owlModel.getOWLThingClass());
            }
            object = frame.getDirectOwnSlotValues(slot);
            super.setDirectOwnSlotValues(frame, slot, (Collection)abstractCollection);
            if (!this.suppressUpdateTemplateSlots) {
                this.updateSlotDomain((Slot)frame, abstractCollection);
            }
            this.deleteAnonymousClasses((Collection)object, abstractCollection);
        } else {
            super.setDirectOwnSlotValues(frame, slot, (Collection)abstractCollection);
        }
    }

    public void setSuperclassSynchronizationBlocked(boolean bl) {
        this.superclassSynchronizationBlocked = bl;
    }

    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        super.addDirectTemplateSlot(cls, slot);
        if (!this.suppressUpdateRDFSDomain && slot instanceof RDFProperty && cls instanceof RDFSClass) {
            this.updateRDFSDomain((RDFProperty)slot);
        }
    }

    private void printDeprecationWarning(String string) {
        System.out.println("Warning: The method " + string + " is not recommended in OWL.");
        System.out.println("         Please use the rdfs:domain methods in RDFProperty.");
        System.out.println("         The following stack trace helps you replace your code.");
        System.out.println("         This message may be deleted in future versions.");
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            return;
        }
    }

    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        super.removeDirectTemplateSlot(cls, slot);
        if (!this.suppressUpdateRDFSDomain && slot instanceof RDFProperty && cls instanceof RDFSClass) {
            this.updateRDFSDomain((RDFProperty)slot);
        }
    }

    private void updateRDFSDomain(RDFProperty rDFProperty) {
        Collection collection = rDFProperty.getDirectDomain();
        RDFSClass rDFSClass = null;
        rDFSClass = collection.size() == 1 ? (RDFSClass)collection.iterator().next() : this.owlModel.createOWLUnionClass(collection);
        this.suppressUpdateTemplateSlots = true;
        rDFProperty.setDomain(rDFSClass);
        this.suppressUpdateTemplateSlots = false;
    }

    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        super.setDirectTemplateFacetValues(cls, slot, facet, collection);
        if (!this.facetHandlingBlocked && cls instanceof OWLNamedClass && slot instanceof RDFProperty) {
            this.updateRestrictions((OWLNamedClass)cls, (RDFProperty)slot, facet);
        }
        if (!this.superclassHandlingBlocked && cls instanceof OWLRestriction) {
            OWLRestriction oWLRestriction = (OWLRestriction)cls;
            this.copyFacetValuesIntoOWLNamedClass(oWLRestriction);
        }
    }

    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        super.setDirectTemplateSlotValues(cls, slot, collection);
        if (!this.facetHandlingBlocked && cls instanceof OWLNamedClass && slot instanceof RDFProperty) {
            this.updateRestrictions((OWLNamedClass)cls, (RDFProperty)slot, this.owlModel.getFacet(":VALUES"));
        }
    }

    private void updatePropertyAllowedClasses(RDFProperty rDFProperty, Collection collection) {
        rDFProperty.setValueType(ValueType.INSTANCE);
        RDFSClass rDFSClass = (RDFSClass)collection.iterator().next();
        if (rDFSClass instanceof OWLUnionClass) {
            rDFProperty.setAllowedClses(((OWLUnionClass)rDFSClass).getOperands());
        } else {
            rDFProperty.setAllowedClses(Collections.singleton(rDFSClass));
        }
    }

    private void updatePropertyValueType(RDFProperty rDFProperty, Collection collection) {
        ValueType valueType = ValueType.ANY;
        if (rDFProperty instanceof OWLObjectProperty && rDFProperty.getSuperpropertyCount() == 0) {
            valueType = ValueType.INSTANCE;
        }
        if (!collection.isEmpty()) {
            RDFSDatatype rDFSDatatype;
            Object e = collection.iterator().next();
            if (e instanceof RDFSDatatype) {
                valueType = XMLSchemaDatatypes.getValueType(((RDFSDatatype)e).getURI());
            } else if (e instanceof RDFSClass) {
                valueType = ValueType.INSTANCE;
            } else if (e instanceof OWLDataRange && (rDFSDatatype = ((OWLDataRange)e).getRDFDatatype()) != null) {
                valueType = XMLSchemaDatatypes.getValueType(rDFSDatatype.getURI());
            }
        }
        if (valueType != rDFProperty.getValueType()) {
            rDFProperty.setValueType(valueType);
        }
        if (valueType == ValueType.INSTANCE) {
            rDFProperty.setAllowedClses(Collections.EMPTY_LIST);
        }
    }

    private void updateRestrictions(OWLNamedClass oWLNamedClass, RDFProperty rDFProperty, Facet facet) {
        RestrictionUpdater restrictionUpdater = this.facet2Updater.get(facet);
        if (restrictionUpdater != null) {
            this.superclassHandlingBlocked = true;
            restrictionUpdater.updateRestrictions(oWLNamedClass, rDFProperty, facet);
            this.superclassHandlingBlocked = false;
        }
    }

    private void updateRDFSSubClassOf(RDFSNamedClass rDFSNamedClass) {
        Slot slot = this.owlModel.getSlot(":DIRECT-SUPERCLASSES");
        RDFProperty rDFProperty = this.owlModel.getRDFSSubClassOfProperty();
        RDFProperty rDFProperty2 = this.owlModel.getOWLEquivalentClassProperty();
        HashSet hashSet = new HashSet(rDFSNamedClass.getPropertyValues(rDFProperty));
        HashSet hashSet2 = new HashSet(rDFSNamedClass.getPropertyValues(rDFProperty2));
        ArrayList<Cls> arrayList = new ArrayList<Cls>();
        ArrayList<Cls> arrayList2 = new ArrayList<Cls>();
        for (Cls cls : rDFSNamedClass.getDirectSuperclasses()) {
            TripleStore tripleStore;
            if (!(cls instanceof RDFSClass)) continue;
            if (cls.hasDirectSuperclass((Cls)rDFSNamedClass)) {
                arrayList2.add(cls);
                if (!hashSet2.contains(cls)) {
                    tripleStore = TripleStoreUtil.getTripleStoreOf(rDFSNamedClass, slot, cls);
                    TripleStoreUtil.addToTripleStore(this.owlModel, tripleStore, rDFSNamedClass, rDFProperty2, cls);
                }
                if (!(cls instanceof RDFSNamedClass)) continue;
                arrayList.add(cls);
                if (hashSet.contains(cls)) continue;
                tripleStore = TripleStoreUtil.getTripleStoreOf(rDFSNamedClass, slot, cls);
                TripleStoreUtil.addToTripleStore(this.owlModel, tripleStore, rDFSNamedClass, rDFProperty, cls);
                continue;
            }
            arrayList.add(cls);
            if (hashSet.contains(cls)) continue;
            tripleStore = TripleStoreUtil.getTripleStoreOf(rDFSNamedClass, slot, cls);
            TripleStoreUtil.addToTripleStore(this.owlModel, tripleStore, rDFSNamedClass, rDFProperty, cls);
        }
        hashSet.removeAll(arrayList);
        for (Cls cls : hashSet) {
            rDFSNamedClass.removePropertyValue(rDFProperty, cls);
        }
        hashSet2.removeAll(arrayList2);
        for (Cls cls : hashSet2) {
            rDFSNamedClass.removePropertyValue(rDFProperty2, cls);
        }
    }

    private void updateSlotDomain(Slot slot, Collection collection) {
        Object object;
        this.suppressUpdateRDFSDomain = true;
        ArrayList arrayList = new ArrayList();
        if (collection.size() == 1) {
            object = (RDFSClass)collection.iterator().next();
            if (object instanceof OWLUnionClass) {
                arrayList.addAll(((OWLUnionClass)object).getOperands());
            } else {
                arrayList.add(object);
            }
        }
        for (Object object2 : new ArrayList(slot.getDirectDomain())) {
            if (arrayList.contains(object2)) continue;
            object2.removeDirectTemplateSlot(slot);
        }
        object = new ArrayList(slot.getDirectDomain());
        for (Cls cls : arrayList) {
            if (object.contains(cls)) continue;
            cls.addDirectTemplateSlot(slot);
        }
        this.suppressUpdateRDFSDomain = false;
    }
}

