/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.factory;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultCls;
import edu.stanford.smi.protege.model.DefaultFacet;
import edu.stanford.smi.protege.model.DefaultSimpleInstance;
import edu.stanford.smi.protege.model.DefaultSlot;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.DefaultFrameFactory;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFNames;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.factory.FrameTypeId2OWLJavaClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLDataRange;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLIndividual;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFIndividual;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFList;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSDatatype;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFUntypedResource;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;

public class OWLJavaFactory
extends DefaultFrameFactory {
    private static Hashtable<String, String> clsNames = new Hashtable();
    private static final String CLASSNAME_PREFIX = "edu.stanford.smi.protegex.owl.model.impl.Default";
    private static final Class[] CONSTRUCTOR_PARAMETERS;
    private AbstractOWLModel owlModel;

    public OWLJavaFactory(AbstractOWLModel abstractOWLModel) {
        super((KnowledgeBase)abstractOWLModel);
        this.owlModel = abstractOWLModel;
    }

    public Frame createFrameFromClassId(int n, FrameID frameID) {
        Cls cls = null;
        switch (n) {
            case 6: {
                cls = this.createCls(frameID, DefaultCls.class);
                break;
            }
            case 7: {
                cls = this.createSlot(frameID, DefaultSlot.class);
                break;
            }
            case 8: {
                cls = this.createFacet(frameID, DefaultFacet.class);
                break;
            }
            case 5: {
                cls = this.createSimpleInstance(frameID, DefaultSimpleInstance.class);
            }
        }
        if (cls != null) {
            return cls;
        }
        Class clazz = null;
        try {
            clazz = FrameTypeId2OWLJavaClass.getJavaClass(n);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Error at creating Java class with Java Frame type id: " + n, exception);
        }
        if (clazz == null) {
            throw new RuntimeException("Invalid java class id: " + n);
        }
        return this.createInstance(frameID, clazz);
    }

    public int getJavaClassId(Frame frame) {
        boolean bl = false;
        Iterator<Class> iterator = FrameTypeId2OWLJavaClass.getOrderedJavaClasses().iterator();
        while (iterator.hasNext()) {
            try {
                Class clazz = iterator.next();
                if (!clazz.isInstance(frame)) continue;
                return FrameTypeId2OWLJavaClass.getFrameTypeId(clazz);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.WARNING, "Error at getting the Java class Id for: " + frame, exception);
            }
        }
        return super.getJavaClassId(frame);
    }

    private Instance createInstance(FrameID frameID, Class clazz) {
        Instance instance = null;
        try {
            Constructor constructor = clazz.getConstructor(CONSTRUCTOR_PARAMETERS);
            instance = (Instance)constructor.newInstance(this.owlModel, frameID);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString((Throwable)exception));
        }
        return instance;
    }

    public RDFResource as(RDFResource rDFResource, Class clazz) {
        if (clazz.isAssignableFrom(rDFResource.getClass())) {
            return rDFResource;
        }
        Constructor constructor = this.getImplementationConstructor(clazz);
        try {
            return (RDFResource)constructor.newInstance(rDFResource.getOWLModel(), rDFResource.getFrameID());
        }
        catch (Exception exception) {
            System.err.println("[OWLJavaFactory] Fatal Error: Could not create Java object for " + clazz);
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            return rDFResource;
        }
    }

    public boolean canAs(RDFResource rDFResource, Class clazz) {
        if (clazz.isAssignableFrom(rDFResource.getClass())) {
            return true;
        }
        HashSet<RDFSClass> hashSet = new HashSet<RDFSClass>();
        for (Object object : rDFResource.getProtegeTypes()) {
            hashSet.add((RDFSClass)object);
            hashSet.addAll(object.getSuperclasses(true));
        }
        Object object = clazz.getName();
        object = ((String)object).substring(((String)object).lastIndexOf(46) + 1);
        for (RDFSClass rDFSClass : hashSet) {
            String string;
            if (!(rDFSClass instanceof RDFSNamedClass) || !(string = this.getJavaInterfaceName(rDFSClass)).equals(object)) continue;
            return true;
        }
        return false;
    }

    public String getImplementationClassName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        String string2 = string.substring(n + 1);
        return string.substring(0, n + 1) + "impl.Default" + string2;
    }

    public Class getImplementationClass(Class clazz) throws ClassNotFoundException {
        return Class.forName(this.getImplementationClassName(clazz));
    }

    public Constructor getImplementationConstructor(Class clazz) {
        try {
            Class clazz2 = this.getImplementationClass(clazz);
            try {
                return clazz2.getConstructor(OWLModel.class, FrameID.class);
            }
            catch (Exception exception) {
                return clazz2.getConstructor(KnowledgeBase.class, FrameID.class);
            }
        }
        catch (Exception exception) {
            Log.getLogger().severe("[OWLJavaFactory] Fatal Error: Could not find constructor for " + clazz);
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            return null;
        }
    }

    public String getJavaInterfaceName(RDFSClass rDFSClass) {
        String string = rDFSClass.getLocalName();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!this.isValidCharacter(c, stringBuffer.length())) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public Cls createCls(FrameID frameID, Collection collection) {
        if (frameID.equals((Object)Model.ClsID.THING)) {
            return new DefaultOWLNamedClass(this.owlModel, frameID);
        }
        Cls cls = this.owlModel.getRDFSClassMetaClassCls();
        Cls cls2 = this.owlModel.getOWLNamedClassMetaClassCls();
        boolean bl = false;
        for (Instance instance : collection) {
            String string = instance.getName();
            String string2 = clsNames.get(string);
            if (string2 != null) {
                return this.createCls(string2, frameID);
            }
            if (!instance.isSystem()) {
                if (instance instanceof Cls) {
                    if (((Cls)instance).hasSuperclass(cls2)) {
                        return new DefaultOWLNamedClass(this.owlModel, frameID);
                    }
                    if (!((Cls)instance).hasSuperclass(cls)) continue;
                    bl = true;
                    continue;
                }
                return new DefaultOWLNamedClass(this.owlModel, frameID);
            }
            if (!instance.equals(this.owlModel.getOWLDeprecatedClassClass())) continue;
            bl = true;
        }
        if (bl) {
            return new DefaultRDFSNamedClass(this.owlModel, frameID);
        }
        return super.createCls(frameID, collection);
    }

    private Cls createCls(String string, FrameID frameID) {
        try {
            Class<?> clazz = Class.forName(CLASSNAME_PREFIX + string);
            Class[] classArray = new Class[]{KnowledgeBase.class, FrameID.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this.owlModel, frameID};
            return (Cls)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            System.err.println("Fatal Error: Could not create Cls from OWL metaclass " + string);
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            return new DefaultOWLNamedClass(this.owlModel, frameID);
        }
    }

    public SimpleInstance createSimpleInstance(FrameID frameID, Collection collection) {
        if (collection.contains(this.owlModel.getOWLAllDifferentClassCls())) {
            return new DefaultOWLAllDifferent(this.owlModel, frameID);
        }
        if (collection.contains(this.owlModel.getOWLDataRangeClass())) {
            return new DefaultOWLDataRange(this.owlModel, frameID);
        }
        if (collection.contains(this.owlModel.getRDFSDatatypeClass())) {
            return new DefaultRDFSDatatype(this.owlModel, frameID);
        }
        if (collection.contains(this.owlModel.getRDFUntypedResourcesClass())) {
            return new DefaultRDFUntypedResource(this.owlModel, frameID);
        }
        if (collection.contains(this.owlModel.getRDFListCls()) || collection.size() > 0 && ((Cls)collection.iterator().next()).hasSuperclass((Cls)this.owlModel.getRDFListClass())) {
            return new DefaultRDFList(this.owlModel, frameID);
        }
        if (collection.contains(this.owlModel.getOWLOntologyCls())) {
            return new DefaultOWLOntology(this.owlModel, frameID);
        }
        if (collection.size() == 0 || collection.toArray()[0] instanceof OWLClass) {
            return new DefaultOWLIndividual(this.owlModel, frameID);
        }
        return new DefaultRDFIndividual(this.owlModel, frameID);
    }

    public Slot createSlot(FrameID frameID, Collection collection) {
        MergingNarrowFrameStore mergingNarrowFrameStore;
        OWLNamedClass oWLNamedClass = this.owlModel.getOWLDatatypePropertyClass();
        OWLNamedClass oWLNamedClass2 = this.owlModel.getOWLObjectPropertyClass();
        RDFSNamedClass rDFSNamedClass = this.owlModel.getRDFPropertyClass();
        boolean bl = false;
        if (frameID.isSystem() && collection.isEmpty() && (mergingNarrowFrameStore = MergingNarrowFrameStore.get((KnowledgeBase)this.owlModel)) != null) {
            return (Slot)mergingNarrowFrameStore.getSystemFrameStore().getFrame(frameID);
        }
        for (Cls cls : collection) {
            if (cls.equals(oWLNamedClass) || cls.hasSuperclass((Cls)oWLNamedClass)) {
                return new DefaultOWLDatatypeProperty(this.owlModel, frameID);
            }
            if (cls.equals(oWLNamedClass2) || cls.hasSuperclass((Cls)oWLNamedClass2)) {
                return new DefaultOWLObjectProperty(this.owlModel, frameID);
            }
            if (bl || !cls.equals(rDFSNamedClass) && !cls.hasSuperclass((Cls)rDFSNamedClass)) continue;
            bl = true;
        }
        if (bl) {
            return new DefaultRDFProperty(this.owlModel, frameID);
        }
        return super.createSlot(frameID, collection);
    }

    public boolean isCorrectJavaImplementationClass(FrameID frameID, Collection collection, Class clazz) {
        Cls cls = this.owlModel.getOWLNamedClassMetaClassCls();
        Cls cls2 = this.owlModel.getOWLDatatypePropertyMetaClassCls();
        Cls cls3 = this.owlModel.getOWLObjectPropertyMetaClassCls();
        for (Cls cls4 : collection) {
            String string = clsNames.get(cls4.getName());
            if (string != null) {
                return clazz.getName().equals(CLASSNAME_PREFIX + string);
            }
            if (cls4.hasSuperclass(cls)) {
                return clazz.getName().equals("edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass");
            }
            if (cls4.hasSuperclass(cls2)) {
                return clazz.getName().equals("edu.stanford.smi.protegex.owl.model.impl.DefaultOWLDatatypeProperty");
            }
            if (!cls4.hasSuperclass(cls3)) continue;
            return clazz.getName().equals("edu.stanford.smi.protegex.owl.model.impl.DefaultOWLObjectProperty");
        }
        return clazz.getName().equals("edu.stanford.smi.protegex.owl.model.impl.DefaultRDFIndividual");
    }

    static {
        clsNames.put("owl:Class", "OWLNamedClass");
        clsNames.put("rdf:Property", "RDFProperty");
        clsNames.put("rdfs:Class", "RDFSNamedClass");
        clsNames.put("owl:EnumeratedClass", "OWLEnumeratedClass");
        clsNames.put("owl:AllValuesFromRestriction", "OWLAllValuesFrom");
        clsNames.put("owl:SomeValuesFromRestriction", "OWLSomeValuesFrom");
        clsNames.put("owl:HasValueRestriction", "OWLHasValue");
        clsNames.put("owl:MaxCardinalityRestriction", "OWLMaxCardinality");
        clsNames.put("owl:MinCardinalityRestriction", "OWLMinCardinality");
        clsNames.put("owl:CardinalityRestriction", "OWLCardinality");
        clsNames.put("owl:ComplementClass", "OWLComplementClass");
        clsNames.put("owl:IntersectionClass", "OWLIntersectionClass");
        clsNames.put("owl:UnionClass", "OWLUnionClass");
        clsNames.put("owl:AllDifferent", "OWLAllDifferent");
        clsNames.put(RDFNames.Cls.EXTERNAL_RESOURCE, "RDFUntypedResource");
        clsNames.put("rdfs:Datatype", "RDFSDatatype");
        clsNames.put("owl:DataRange", "OWLDataRange");
        clsNames.put("rdf:List", "RDFList");
        clsNames.put("owl:Ontology", "OWLOntology");
        clsNames.put("owl:DatatypeProperty", "OWLDatatypeProperty");
        clsNames.put("owl:ObjectProperty", "OWLObjectProperty");
        CONSTRUCTOR_PARAMETERS = new Class[]{KnowledgeBase.class, FrameID.class};
    }
}

