/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classparser.manchester;

import com.hp.hpl.jena.ontology.OntClass;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.XSPNames;
import edu.stanford.smi.protegex.owl.model.classparser.AmbiguousNameException;
import edu.stanford.smi.protegex.owl.model.classparser.DatatypeNameChecker;
import edu.stanford.smi.protegex.owl.model.classparser.ParserUtils;
import edu.stanford.smi.protegex.owl.model.classparser.manchester.JavaCharStream;
import edu.stanford.smi.protegex.owl.model.classparser.manchester.ManchesterOWLParserConstants;
import edu.stanford.smi.protegex.owl.model.classparser.manchester.ManchesterOWLParserTokenManager;
import edu.stanford.smi.protegex.owl.model.classparser.manchester.ParseException;
import edu.stanford.smi.protegex.owl.model.classparser.manchester.Token;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public class ManchesterOWLParser
implements ManchesterOWLParserConstants {
    public static boolean nextCouldBeCls;
    public static boolean nextCouldBeInstance;
    public static boolean nextCouldBeSlot;
    public static RDFProperty recentHasValueProperty;
    public static String errorMessage;
    public static boolean nextCouldBeDatatypeName;
    private static DatatypeNameChecker datatypeNameChecker;
    private OWLModel owlModel;
    private boolean create;
    public ManchesterOWLParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[18];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static DatatypeNameChecker getDatatypeNameChecker() {
        return datatypeNameChecker;
    }

    private static void createDatatypeNameChecker(OWLModel oWLModel) {
        datatypeNameChecker = new DatatypeNameChecker(oWLModel);
    }

    public static void checkClass(OWLModel oWLModel, String string) throws ParseException {
        ManchesterOWLParser.reset();
        ManchesterOWLParser.createDatatypeNameChecker(oWLModel);
        ManchesterOWLParser manchesterOWLParser = new ManchesterOWLParser(new StringReader(string));
        manchesterOWLParser.owlModel = oWLModel;
        manchesterOWLParser.create = false;
        manchesterOWLParser.parseFile();
    }

    private void checkFeatureSupported(OntClass ontClass) throws ParseException {
        if (!ProfilesManager.isFeatureSupported(this.owlModel, ontClass)) {
            String string = ontClass.getLabel(null);
            if (string == null) {
                string = ontClass.getLocalName();
            }
            errorMessage = "Feature \"" + string + "\" unavailable in current language profile";
            throw this.generateParseException();
        }
    }

    public static void checkHasValueFiller(OWLModel oWLModel, String string) throws ParseException {
        ManchesterOWLParser.reset();
        ManchesterOWLParser.createDatatypeNameChecker(oWLModel);
        ManchesterOWLParser manchesterOWLParser = new ManchesterOWLParser(new StringReader(string));
        manchesterOWLParser.owlModel = oWLModel;
        manchesterOWLParser.create = false;
        manchesterOWLParser.OWLHasValueValue();
    }

    public static void checkQuantifierFiller(OWLModel oWLModel, String string) throws ParseException {
        ManchesterOWLParser.reset();
        ManchesterOWLParser.createDatatypeNameChecker(oWLModel);
        ManchesterOWLParser manchesterOWLParser = new ManchesterOWLParser(new StringReader(string));
        manchesterOWLParser.owlModel = oWLModel;
        manchesterOWLParser.create = false;
        if (manchesterOWLParser.DataType() == null) {
            throw new ParseException("Unknown datatype \"" + string + "\".");
        }
    }

    public static RDFSClass parseClass(OWLModel oWLModel, String string) throws ParseException {
        ManchesterOWLParser.reset();
        ManchesterOWLParser.createDatatypeNameChecker(oWLModel);
        ManchesterOWLParser manchesterOWLParser = new ManchesterOWLParser(new StringReader(string));
        manchesterOWLParser.owlModel = oWLModel;
        manchesterOWLParser.create = true;
        return manchesterOWLParser.parseFile();
    }

    public static Object parseHasValueFiller(OWLModel oWLModel, String string) throws ParseException {
        ManchesterOWLParser.reset();
        ManchesterOWLParser.createDatatypeNameChecker(oWLModel);
        ManchesterOWLParser manchesterOWLParser = new ManchesterOWLParser(new StringReader(string));
        manchesterOWLParser.owlModel = oWLModel;
        manchesterOWLParser.create = true;
        return manchesterOWLParser.OWLHasValueValue();
    }

    public static Object parseQuantifierFiller(OWLModel oWLModel, String string) throws ParseException {
        ManchesterOWLParser.reset();
        ManchesterOWLParser.createDatatypeNameChecker(oWLModel);
        ManchesterOWLParser manchesterOWLParser = new ManchesterOWLParser(new StringReader(string));
        manchesterOWLParser.owlModel = oWLModel;
        manchesterOWLParser.create = false;
        return manchesterOWLParser.DataType();
    }

    private static void reset() {
        nextCouldBeCls = false;
        nextCouldBeSlot = false;
        nextCouldBeInstance = false;
        nextCouldBeDatatypeName = false;
        errorMessage = null;
    }

    public final RDFSClass parseFile() throws ParseException {
        String string;
        RDFProperty rDFProperty;
        String string2 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                Token token = this.jj_consume_token(20);
                string2 = token.image;
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        RDFSClass rDFSClass = this.OWLUnionClass();
        if (string2 != null && rDFSClass != null && rDFSClass.isAnonymous() && this.owlModel.isProtegeMetaOntologyImported() && (rDFProperty = this.owlModel.getRDFProperty(string = ProtegeNames.Slot.IS_COMMENTED_OUT)) != null) {
            rDFSClass.setPropertyValue(rDFProperty, "true");
        }
        return rDFSClass;
    }

    public final RDFSClass OWLUnionClass() throws ParseException {
        ArrayList<RDFSClass> arrayList = new ArrayList<RDFSClass>();
        RDFSClass rDFSClass = this.OWLIntersectionClass();
        arrayList.add(rDFSClass);
        while (this.jj_2_1(2)) {
            this.jj_consume_token(13);
            rDFSClass = this.OWLIntersectionClass();
            arrayList.add(rDFSClass);
        }
        if (arrayList.size() == 1) {
            return rDFSClass;
        }
        this.checkFeatureSupported(OWLProfiles.Union_Classes);
        if (this.create) {
            return this.owlModel.createOWLUnionClass(arrayList);
        }
        return null;
    }

    public final RDFSClass OWLIntersectionClass() throws ParseException {
        ArrayList<RDFSClass> arrayList = new ArrayList<RDFSClass>();
        RDFSClass rDFSClass = this.OWLComplementClass();
        arrayList.add(rDFSClass);
        while (this.jj_2_2(2)) {
            this.jj_consume_token(12);
            rDFSClass = this.OWLComplementClass();
            arrayList.add(rDFSClass);
        }
        if (arrayList.size() == 1) {
            return rDFSClass;
        }
        if (this.create) {
            return this.owlModel.createOWLIntersectionClass(arrayList);
        }
        return null;
    }

    public final RDFSClass OWLComplementClass() throws ParseException {
        RDFSClass rDFSClass;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                RDFSClass rDFSClass2 = this.OWLRestrictionOrNamedClass();
                this.checkFeatureSupported(OWLProfiles.Complement_Classes);
                if (this.create) {
                    return this.owlModel.createOWLComplementClass(rDFSClass2);
                }
                return null;
            }
            case 15: 
            case 26: 
            case 30: {
                rDFSClass = this.OWLRestrictionOrNamedClass();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return rDFSClass;
    }

    public final RDFSClass OWLRestrictionOrNamedClass() throws ParseException {
        RDFSClass rDFSClass;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                rDFSClass = this.OWLEnumeratedClass();
                break;
            }
            case 26: {
                rDFSClass = this.IDClass();
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                rDFSClass = this.OWLUnionClass();
                this.jj_consume_token(16);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return rDFSClass;
    }

    public final RDFSClass IDClass() throws ParseException {
        Frame frame;
        String string = this.Identifier();
        try {
            frame = ParserUtils.getFrameByName(this.owlModel, string);
        }
        catch (AmbiguousNameException ambiguousNameException) {
            nextCouldBeCls = true;
            nextCouldBeSlot = true;
            errorMessage = ambiguousNameException.getMessage();
            throw this.generateParseException();
        }
        if (frame instanceof RDFSClass) {
            return (RDFSClass)frame;
        }
        if (frame instanceof RDFProperty && !((RDFProperty)frame).isAnnotationProperty()) {
            recentHasValueProperty = (RDFProperty)frame;
            return this.Restriction(recentHasValueProperty);
        }
        nextCouldBeCls = true;
        nextCouldBeSlot = true;
        errorMessage = "Class or property name expected";
        throw this.generateParseException();
    }

    public final OWLRestriction Restriction(RDFProperty rDFProperty) throws ParseException {
        OWLRestriction oWLRestriction;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: {
                oWLRestriction = this.OWLCardinalityBase(rDFProperty);
                break;
            }
            case 8: {
                oWLRestriction = this.OWLHasValue(rDFProperty);
                break;
            }
            case 7: {
                oWLRestriction = this.OWLAllValuesFrom(rDFProperty);
                break;
            }
            case 6: {
                oWLRestriction = this.OWLSomeValuesFrom(rDFProperty);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return oWLRestriction;
    }

    public final OWLCardinalityBase OWLCardinalityBase(RDFProperty rDFProperty) throws ParseException {
        OWLCardinalityBase oWLCardinalityBase;
        RDFSClass rDFSClass = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                oWLCardinalityBase = this.OWLMaxCardinality(rDFProperty);
                break;
            }
            case 9: {
                oWLCardinalityBase = this.OWLMinCardinality(rDFProperty);
                break;
            }
            case 11: {
                oWLCardinalityBase = this.OWLCardinality(rDFProperty);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 26: 
            case 30: {
                rDFSClass = this.OWLUnionClass();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        if (this.create && rDFSClass != null) {
            oWLCardinalityBase.setValuesFrom(rDFSClass);
        }
        return oWLCardinalityBase;
    }

    public final OWLMaxCardinality OWLMaxCardinality(RDFProperty rDFProperty) throws ParseException {
        this.jj_consume_token(10);
        int n = this.CardinalityValue();
        this.checkFeatureSupported(OWLProfiles.MaxCardinality_Restrictions);
        if (this.create) {
            return this.owlModel.createOWLMaxCardinality(rDFProperty, n);
        }
        return null;
    }

    public final OWLMinCardinality OWLMinCardinality(RDFProperty rDFProperty) throws ParseException {
        this.jj_consume_token(9);
        int n = this.CardinalityValue();
        this.checkFeatureSupported(OWLProfiles.MinCardinality_Restrictions);
        if (this.create) {
            return this.owlModel.createOWLMinCardinality(rDFProperty, n);
        }
        return null;
    }

    public final OWLCardinality OWLCardinality(RDFProperty rDFProperty) throws ParseException {
        this.jj_consume_token(11);
        int n = this.CardinalityValue();
        this.checkFeatureSupported(OWLProfiles.MinCardinality_Restrictions);
        this.checkFeatureSupported(OWLProfiles.MaxCardinality_Restrictions);
        if (this.create) {
            return this.owlModel.createOWLCardinality(rDFProperty, n);
        }
        return null;
    }

    public final OWLHasValue OWLHasValue(RDFProperty rDFProperty) throws ParseException {
        this.jj_consume_token(8);
        Object object = this.OWLHasValueValue();
        this.checkFeatureSupported(OWLProfiles.HasValue_Restrictions);
        if (!(rDFProperty instanceof OWLDatatypeProperty)) {
            if (OWLUtil.hasOWLDLProfile(this.owlModel) && (object instanceof Cls || object instanceof Slot)) {
                object = null;
            }
            if (!(object instanceof Instance)) {
                nextCouldBeInstance = true;
                if (OWLUtil.hasOWLFullProfile(this.owlModel)) {
                    nextCouldBeSlot = true;
                    nextCouldBeCls = true;
                    errorMessage = "Individual, class or property expected";
                } else {
                    errorMessage = "Individual expected (in OWL DL)";
                }
                throw this.generateParseException();
            }
        } else if (rDFProperty instanceof OWLDatatypeProperty && object instanceof Instance) {
            errorMessage = "Datatype literal expected";
            throw this.generateParseException();
        }
        if (this.create) {
            return this.owlModel.createOWLHasValue(rDFProperty, object);
        }
        return null;
    }

    public final Object OWLHasValueValueAndEOF() throws ParseException {
        Object object = this.OWLHasValueValue();
        this.jj_consume_token(0);
        return object;
    }

    public final Object OWLHasValueValue() throws ParseException {
        Object object;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: {
                object = this.OWLHasValueValueString();
                break;
            }
            case 22: {
                object = this.OWLHasValueValueFloat();
                break;
            }
            case 21: {
                object = this.OWLHasValueValueInteger();
                break;
            }
            case 26: {
                object = this.OWLHasValueValueBooleanOrInstance();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return object;
    }

    public final String OWLHasValueValueString() throws ParseException {
        Token token = this.jj_consume_token(24);
        String string = token.image;
        int n = string.length();
        return string.substring(1, n - 1);
    }

    public final Float OWLHasValueValueFloat() throws ParseException {
        Token token = this.jj_consume_token(22);
        return Float.valueOf(token.image);
    }

    public final Integer OWLHasValueValueInteger() throws ParseException {
        Token token = this.jj_consume_token(21);
        return Integer.valueOf(token.image);
    }

    public final Object OWLHasValueValueBooleanOrInstance() throws ParseException {
        String string = this.Identifier();
        if (string.equals("true")) {
            return Boolean.TRUE;
        }
        if (string.equals("false")) {
            return Boolean.FALSE;
        }
        RDFResource rDFResource = ParserUtils.getRDFResourceFromName(this.owlModel, string);
        if (rDFResource == null) {
            nextCouldBeInstance = true;
            nextCouldBeSlot = true;
            nextCouldBeCls = true;
            errorMessage = "Instance or datatype literal expected";
            throw this.generateParseException();
        }
        return rDFResource;
    }

    public final int CardinalityValue() throws ParseException {
        Token token = this.jj_consume_token(21);
        int n = Integer.parseInt(token.image);
        if (n >= 0) {
            return n;
        }
        throw this.generateParseException();
    }

    public final String Identifier() throws ParseException {
        Token token = this.jj_consume_token(26);
        return ParserUtils.dequoteIdentifier(token.image);
    }

    public final RDFSClass OWLEnumeratedClass() throws ParseException {
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        this.jj_consume_token(30);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 26: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            String string = this.Identifier();
            Instance instance = (Instance)ParserUtils.getFrameByName(this.owlModel, string);
            if (OWLUtil.hasOWLDLProfile(this.owlModel) && (instance instanceof Cls || instance instanceof Slot)) {
                instance = null;
            }
            if (instance == null) {
                nextCouldBeInstance = true;
                if (OWLUtil.hasOWLFullProfile(this.owlModel)) {
                    nextCouldBeCls = true;
                    nextCouldBeSlot = true;
                    errorMessage = "Name of an individual, class or property expected";
                } else {
                    errorMessage = "Name of an individual expected (in OWL DL)";
                }
                throw this.generateParseException();
            }
            arrayList.add(instance);
        }
        this.jj_consume_token(31);
        this.checkFeatureSupported(OWLProfiles.Enumerated_Classes);
        if (this.create) {
            return this.owlModel.createOWLEnumeratedClass(arrayList);
        }
        return null;
    }

    public final OWLAllValuesFrom OWLAllValuesFrom(RDFProperty rDFProperty) throws ParseException {
        this.jj_consume_token(7);
        this.checkFeatureSupported(OWLProfiles.AllValuesFrom_Restrictions);
        Object object = this.DataType();
        if (object instanceof RDFSClass || object == ValueType.INSTANCE) {
            if (rDFProperty instanceof OWLDatatypeProperty) {
                errorMessage = "owl:ObjectProperty or rdf:Property expected";
                throw this.generateParseException();
            }
            if (this.create) {
                return this.owlModel.createOWLAllValuesFrom(rDFProperty, (RDFSClass)object);
            }
            return null;
        }
        if (object == null) {
            errorMessage = "XML Schema datatype expected";
            throw this.generateParseException();
        }
        if (!(rDFProperty instanceof OWLDatatypeProperty)) {
            errorMessage = "owl:DatatypeProperty expected";
            throw this.generateParseException();
        }
        if (this.create) {
            if (object instanceof RDFSDatatype) {
                return this.owlModel.createOWLAllValuesFrom(rDFProperty, (RDFSDatatype)object);
            }
            return this.owlModel.createOWLAllValuesFrom(rDFProperty, (RDFSLiteral[])object);
        }
        return null;
    }

    public final OWLSomeValuesFrom OWLSomeValuesFrom(RDFProperty rDFProperty) throws ParseException {
        this.jj_consume_token(6);
        this.checkFeatureSupported(OWLProfiles.SomeValuesFrom_Restrictions);
        Object object = this.DataType();
        if (object instanceof RDFSClass || object == ValueType.INSTANCE) {
            if (rDFProperty instanceof OWLDatatypeProperty) {
                errorMessage = "owl:ObjectProperty or rdf:Property expected";
                throw this.generateParseException();
            }
            if (this.create) {
                return this.owlModel.createOWLSomeValuesFrom(rDFProperty, (RDFSClass)object);
            }
            return null;
        }
        if (!(rDFProperty instanceof OWLDatatypeProperty)) {
            errorMessage = "owl:DatatypeProperty expected";
            throw this.generateParseException();
        }
        if (object == null) {
            errorMessage = "XML Schema datatype expected";
            throw this.generateParseException();
        }
        if (this.create) {
            if (object instanceof RDFSDatatype) {
                return this.owlModel.createOWLSomeValuesFrom(rDFProperty, (RDFSDatatype)object);
            }
            return this.owlModel.createOWLSomeValuesFrom(rDFProperty, (RDFSLiteral[])object);
        }
        return null;
    }

    public final Object DataType() throws ParseException {
        RDFSLiteral[] rDFSLiteralArray = null;
        RDFSClass rDFSClass = null;
        boolean bl = false;
        RDFProperty rDFProperty = null;
        RDFProperty rDFProperty2 = null;
        String string = null;
        String string2 = null;
        nextCouldBeDatatypeName = true;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                this.jj_consume_token(25);
                rDFSLiteralArray = this.OneOfValues();
                return rDFSLiteralArray;
            }
            case 27: {
                this.token = this.jj_consume_token(27);
                String string3 = datatypeNameChecker.getDatatypeQName(this.token.image);
                RDFSDatatype rDFSDatatype = this.owlModel.getRDFSDatatypeByName(string3);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: 
                    case 17: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 15: {
                                this.token = this.jj_consume_token(15);
                                rDFProperty = XSPNames.getRDFProperty(this.owlModel, 3);
                                break;
                            }
                            case 17: {
                                this.token = this.jj_consume_token(17);
                                rDFProperty = XSPNames.getRDFProperty(this.owlModel, 4);
                                break;
                            }
                            default: {
                                this.jj_la1[8] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        block12 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 19: 
                            case 21: 
                            case 22: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 21: {
                                        this.token = this.jj_consume_token(21);
                                        string = this.token.image;
                                        break block12;
                                    }
                                    case 22: {
                                        this.token = this.jj_consume_token(22);
                                        string = this.token.image;
                                        break block12;
                                    }
                                    case 19: {
                                        this.jj_consume_token(19);
                                        break block12;
                                    }
                                }
                                this.jj_la1[9] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                            default: {
                                this.jj_la1[10] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(32);
                        block20 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 19: 
                            case 21: 
                            case 22: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 21: {
                                        this.token = this.jj_consume_token(21);
                                        string2 = this.token.image;
                                        break block20;
                                    }
                                    case 22: {
                                        this.token = this.jj_consume_token(22);
                                        string2 = this.token.image;
                                        break block20;
                                    }
                                    case 19: {
                                        this.jj_consume_token(19);
                                        break block20;
                                    }
                                }
                                this.jj_la1[11] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                            default: {
                                this.jj_la1[12] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 16: {
                                this.token = this.jj_consume_token(16);
                                rDFProperty2 = XSPNames.getRDFProperty(this.owlModel, 5);
                                break;
                            }
                            case 18: {
                                this.token = this.jj_consume_token(18);
                                rDFProperty2 = XSPNames.getRDFProperty(this.owlModel, 6);
                                break;
                            }
                            default: {
                                this.jj_la1[13] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        bl = true;
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                    }
                }
                if (!bl) {
                    return rDFSDatatype;
                }
                if (this.create) {
                    RDFSDatatype rDFSDatatype2 = this.owlModel.createRDFSDatatype(this.owlModel.getNextAnonymousResourceName());
                    rDFSDatatype2.setPropertyValue(XSPNames.getRDFProperty(this.owlModel, 0), rDFSDatatype);
                    if (rDFProperty != null && string != null) {
                        rDFSDatatype2.setPropertyValue(rDFProperty, this.owlModel.createRDFSLiteral(string, rDFSDatatype));
                    }
                    if (rDFProperty2 != null && string2 != null) {
                        rDFSDatatype2.setPropertyValue(rDFProperty2, this.owlModel.createRDFSLiteral(string2, rDFSDatatype));
                    }
                    return rDFSDatatype2;
                }
                return rDFSDatatype;
            }
            case 14: 
            case 15: 
            case 26: 
            case 30: {
                rDFSClass = this.OWLComplementClass();
                if (this.create) {
                    return rDFSClass;
                }
                return ValueType.INSTANCE;
            }
        }
        this.jj_la1[15] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final RDFSLiteral[] OneOfValues() throws ParseException {
        ArrayList<RDFSLiteral> arrayList;
        block9: {
            arrayList = new ArrayList<RDFSLiteral>();
            Token token = null;
            Number number = null;
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: 
                    case 22: 
                    case 24: {
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        token = this.jj_consume_token(24);
                        String string = token.image;
                        int n = string.length();
                        arrayList.add(this.owlModel.createRDFSLiteral(string.substring(1, n - 1)));
                        continue block8;
                    }
                    case 21: {
                        number = this.OWLHasValueValueInteger();
                        arrayList.add(this.owlModel.createRDFSLiteral(number));
                        continue block8;
                    }
                    case 22: {
                        number = this.OWLHasValueValueFloat();
                        arrayList.add(this.owlModel.createRDFSLiteral(number));
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[17] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(31);
        return arrayList.toArray(new RDFSLiteral[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    private final boolean jj_3R_12() {
        return this.jj_scan_token(15);
    }

    private final boolean jj_3R_11() {
        return this.jj_3R_14();
    }

    private final boolean jj_3R_10() {
        return this.jj_3R_13();
    }

    private final boolean jj_3R_7() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3R_9() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_10()) {
            this.jj_scanpos = token;
            if (this.jj_3R_11()) {
                this.jj_scanpos = token;
                if (this.jj_3R_12()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_15() {
        return this.jj_scan_token(26);
    }

    private final boolean jj_3R_5() {
        return this.jj_3R_6();
    }

    private final boolean jj_3R_6() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_7()) {
            this.jj_scanpos = token;
            if (this.jj_3R_8()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_5();
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        return this.jj_3R_6();
    }

    private final boolean jj_3R_14() {
        return this.jj_3R_15();
    }

    private final boolean jj_3R_8() {
        return this.jj_3R_9();
    }

    private final boolean jj_3R_13() {
        return this.jj_scan_token(30);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0x100000, 0x4400C000, 0x44008000, 4032, 3584, 0x4400C000, 0x5600000, 0x4000000, 163840, 0x680000, 0x680000, 0x680000, 0x680000, 327680, 163840, 1308672000, 0x1600000, 0x1600000};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public ManchesterOWLParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public ManchesterOWLParser(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream = new JavaCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new ManchesterOWLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 18; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 18; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public ManchesterOWLParser(Reader reader) {
        int n;
        this.jj_input_stream = new JavaCharStream(reader, 1, 1);
        this.token_source = new ManchesterOWLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 18; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 18; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public ManchesterOWLParser(ManchesterOWLParserTokenManager manchesterOWLParserTokenManager) {
        int n;
        this.token_source = manchesterOWLParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 18; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(ManchesterOWLParserTokenManager manchesterOWLParserTokenManager) {
        int n;
        this.token_source = manchesterOWLParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 18; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[33];
        for (n2 = 0; n2 < 33; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 18; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) == 0) continue;
                blArray[32 + n] = true;
            }
        }
        for (n2 = 0; n2 < 33; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        ManchesterOWLParser.jj_la1_0();
        ManchesterOWLParser.jj_la1_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

