/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classparser.dl;

import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.classparser.AmbiguousNameException;
import edu.stanford.smi.protegex.owl.model.classparser.DatatypeNameChecker;
import edu.stanford.smi.protegex.owl.model.classparser.ParserUtils;
import edu.stanford.smi.protegex.owl.model.classparser.dl.DLSyntaxParserConstants;
import edu.stanford.smi.protegex.owl.model.classparser.dl.DLSyntaxParserTokenManager;
import edu.stanford.smi.protegex.owl.model.classparser.dl.JavaCharStream;
import edu.stanford.smi.protegex.owl.model.classparser.dl.ParseException;
import edu.stanford.smi.protegex.owl.model.classparser.dl.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Vector;

public class DLSyntaxParser
implements DLSyntaxParserConstants {
    private static DatatypeNameChecker datatypeChecker;
    private boolean create;
    private OWLModel owlModel;
    public DLSyntaxParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[17];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static DatatypeNameChecker getDatatypeNameChecker() {
        return datatypeChecker;
    }

    public OWLModel getOWLModel() {
        return this.owlModel;
    }

    public void setCreate(boolean bl) {
        this.create = bl;
    }

    public static OWLClass parseExpression(OWLModel oWLModel, String string, boolean bl) throws ParseException {
        DLSyntaxParserTokenManager dLSyntaxParserTokenManager = new DLSyntaxParserTokenManager(new JavaCharStream(new StringReader(string)));
        dLSyntaxParserTokenManager.setOWLModel(oWLModel);
        DLSyntaxParser dLSyntaxParser = new DLSyntaxParser(dLSyntaxParserTokenManager);
        dLSyntaxParser.setCreate(bl);
        dLSyntaxParser.owlModel = oWLModel;
        datatypeChecker = new DatatypeNameChecker(oWLModel);
        return dLSyntaxParser.parse();
    }

    public final OWLClass parse() throws ParseException {
        OWLClass oWLClass = this.OWLUnionClass();
        this.jj_consume_token(0);
        return oWLClass;
    }

    public final OWLClass OWLUnionClass() throws ParseException {
        ArrayList<OWLClass> arrayList = new ArrayList<OWLClass>();
        OWLClass oWLClass = this.OWLIntersectionClass();
        arrayList.add(oWLClass);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 31: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(31);
            oWLClass = this.OWLIntersectionClass();
            arrayList.add(oWLClass);
        }
        if (this.create) {
            if (arrayList.size() > 1) {
                return this.owlModel.createOWLUnionClass(arrayList);
            }
            return oWLClass;
        }
        return null;
    }

    public final OWLClass OWLIntersectionClass() throws ParseException {
        ArrayList<OWLClass> arrayList = new ArrayList<OWLClass>();
        OWLClass oWLClass = this.IntersectionClassOperand();
        arrayList.add(oWLClass);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(32);
            oWLClass = this.IntersectionClassOperand();
            arrayList.add(oWLClass);
        }
        if (this.create) {
            if (arrayList.size() > 1) {
                return this.owlModel.createOWLIntersectionClass(arrayList);
            }
            return oWLClass;
        }
        return null;
    }

    public final OWLClass IntersectionClassOperand() throws ParseException {
        OWLClass oWLClass;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                oWLClass = this.OWLNamedClass();
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                oWLClass = this.OWLUnionClass();
                this.jj_consume_token(7);
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                oWLClass = this.OWLRestriction();
                break;
            }
            case 38: {
                oWLClass = this.OWLComplementClass();
                break;
            }
            case 39: {
                oWLClass = this.OWLEnumeratedClass();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return oWLClass;
    }

    public final OWLClass OWLNamedClass() throws ParseException {
        Token token = this.jj_consume_token(25);
        try {
            String string = ParserUtils.dequoteIdentifier(token.image);
            return ParserUtils.getOWLClassFromName(this.owlModel, string);
        }
        catch (AmbiguousNameException ambiguousNameException) {
            throw new ParseException(ambiguousNameException.getMessage());
        }
    }

    public final OWLClass OWLRestriction() throws ParseException {
        OWLClass oWLClass;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                oWLClass = this.OWLAllValuesFromRestriction();
                break;
            }
            case 34: {
                oWLClass = this.OWLSomeValuesFromRestriction();
                break;
            }
            case 36: {
                oWLClass = this.OWLMaxCardinalityRestriction();
                break;
            }
            case 35: {
                oWLClass = this.OWLMinCardinalityRestriction();
                break;
            }
            case 37: {
                oWLClass = this.OWLCardinalityRestriction();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return oWLClass;
    }

    public final OWLClass OWLAllValuesFromRestriction() throws ParseException {
        OWLClass oWLClass;
        this.jj_consume_token(33);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                oWLClass = this.OWLAllValuesFromDatatypePart();
                break;
            }
            case 26: {
                oWLClass = this.OWLAllValuesFromObjectPart();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return oWLClass;
    }

    public final OWLClass OWLAllValuesFromDatatypePart() throws ParseException {
        OWLDatatypeProperty oWLDatatypeProperty = this.DatatypeProperty();
        RDFSDatatype rDFSDatatype = this.Datatype();
        if (this.create) {
            return this.owlModel.createOWLAllValuesFrom((RDFProperty)oWLDatatypeProperty, rDFSDatatype);
        }
        return null;
    }

    public final OWLClass OWLAllValuesFromObjectPart() throws ParseException {
        OWLObjectProperty oWLObjectProperty = this.ObjectProperty();
        OWLClass oWLClass = this.NestedClass();
        if (this.create) {
            return this.owlModel.createOWLAllValuesFrom((RDFProperty)oWLObjectProperty, oWLClass);
        }
        return null;
    }

    public final OWLClass OWLSomeValuesFromRestriction() throws ParseException {
        OWLClass oWLClass;
        this.jj_consume_token(34);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                oWLClass = this.OWLSomeValuesFromDatatypePart();
                break;
            }
            case 26: {
                oWLClass = this.OWLSomeValuesFromObjectPart();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return oWLClass;
    }

    public final OWLClass OWLSomeValuesFromDatatypePart() throws ParseException {
        OWLDatatypeProperty oWLDatatypeProperty = this.DatatypeProperty();
        RDFSDatatype rDFSDatatype = this.Datatype();
        if (this.create) {
            return this.owlModel.createOWLSomeValuesFrom((RDFProperty)oWLDatatypeProperty, rDFSDatatype);
        }
        return null;
    }

    public final OWLClass OWLSomeValuesFromObjectPart() throws ParseException {
        OWLObjectProperty oWLObjectProperty = this.ObjectProperty();
        OWLClass oWLClass = this.NestedClass();
        if (this.create) {
            return this.owlModel.createOWLSomeValuesFrom((RDFProperty)oWLObjectProperty, oWLClass);
        }
        return null;
    }

    public final OWLClass OWLMinCardinalityRestriction() throws ParseException {
        OWLMinCardinality oWLMinCardinality = null;
        this.jj_consume_token(35);
        int n = this.Integer();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                oWLMinCardinality = this.OWLMinCardinalityDatatypePart();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: {
                        oWLMinCardinality = this.OWLMinCardinalityObjectPart();
                        break block0;
                    }
                }
                this.jj_la1[6] = this.jj_gen;
            }
        }
        if (this.create && oWLMinCardinality != null) {
            oWLMinCardinality.setCardinality(n);
            return oWLMinCardinality;
        }
        return null;
    }

    public final OWLMinCardinality OWLMinCardinalityDatatypePart() throws ParseException {
        OWLDatatypeProperty oWLDatatypeProperty = this.DatatypeProperty();
        if (this.create) {
            OWLMinCardinality oWLMinCardinality = this.owlModel.createOWLMinCardinality();
            oWLMinCardinality.setOnProperty(oWLDatatypeProperty);
            return oWLMinCardinality;
        }
        return null;
    }

    public final OWLMinCardinality OWLMinCardinalityObjectPart() throws ParseException {
        OWLClass oWLClass = null;
        OWLObjectProperty oWLObjectProperty = this.ObjectProperty();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 25: 
            case 38: 
            case 39: {
                oWLClass = this.NestedClass();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        if (this.create) {
            OWLMinCardinality oWLMinCardinality = this.owlModel.createOWLMinCardinality();
            oWLMinCardinality.setOnProperty(oWLObjectProperty);
            if (oWLClass != null) {
                oWLMinCardinality.setValuesFrom(oWLClass);
            }
            return oWLMinCardinality;
        }
        return null;
    }

    public final OWLClass OWLMaxCardinalityRestriction() throws ParseException {
        OWLMaxCardinality oWLMaxCardinality = null;
        this.jj_consume_token(36);
        int n = this.Integer();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                oWLMaxCardinality = this.OWLMaxCardinalityDatatypePart();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: {
                        oWLMaxCardinality = this.OWLMaxCardinalityObjectPart();
                        break block0;
                    }
                }
                this.jj_la1[9] = this.jj_gen;
            }
        }
        if (this.create && oWLMaxCardinality != null) {
            oWLMaxCardinality.setCardinality(n);
            return oWLMaxCardinality;
        }
        return null;
    }

    public final OWLMaxCardinality OWLMaxCardinalityDatatypePart() throws ParseException {
        OWLDatatypeProperty oWLDatatypeProperty = this.DatatypeProperty();
        if (this.create) {
            OWLMaxCardinality oWLMaxCardinality = this.owlModel.createOWLMaxCardinality();
            oWLMaxCardinality.setOnProperty(oWLDatatypeProperty);
            return oWLMaxCardinality;
        }
        return null;
    }

    public final OWLMaxCardinality OWLMaxCardinalityObjectPart() throws ParseException {
        OWLClass oWLClass = null;
        OWLObjectProperty oWLObjectProperty = this.ObjectProperty();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 25: 
            case 38: 
            case 39: {
                oWLClass = this.NestedClass();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        if (this.create) {
            OWLMaxCardinality oWLMaxCardinality = this.owlModel.createOWLMaxCardinality();
            oWLMaxCardinality.setOnProperty(oWLObjectProperty);
            if (oWLClass != null) {
                oWLMaxCardinality.setValuesFrom(oWLClass);
            }
            return oWLMaxCardinality;
        }
        return null;
    }

    public final OWLClass OWLCardinalityRestriction() throws ParseException {
        OWLCardinality oWLCardinality = null;
        this.jj_consume_token(37);
        int n = this.Integer();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                oWLCardinality = this.OWLCardinalityDatatypePart();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: {
                        oWLCardinality = this.OWLCardinalityObjectPart();
                        break block0;
                    }
                }
                this.jj_la1[12] = this.jj_gen;
            }
        }
        if (this.create && oWLCardinality != null) {
            oWLCardinality.setCardinality(n);
            return oWLCardinality;
        }
        return null;
    }

    public final OWLCardinality OWLCardinalityDatatypePart() throws ParseException {
        OWLDatatypeProperty oWLDatatypeProperty = this.DatatypeProperty();
        if (this.create) {
            OWLCardinality oWLCardinality = this.owlModel.createOWLCardinality();
            oWLCardinality.setOnProperty(oWLDatatypeProperty);
            return oWLCardinality;
        }
        return null;
    }

    public final OWLCardinality OWLCardinalityObjectPart() throws ParseException {
        OWLClass oWLClass = null;
        OWLObjectProperty oWLObjectProperty = this.ObjectProperty();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 25: 
            case 38: 
            case 39: {
                oWLClass = this.NestedClass();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        if (this.create) {
            OWLCardinality oWLCardinality = this.owlModel.createOWLCardinality();
            oWLCardinality.setOnProperty(oWLObjectProperty);
            if (oWLClass != null) {
                oWLCardinality.setValuesFrom(oWLClass);
            }
            return oWLCardinality;
        }
        return null;
    }

    public final OWLClass OWLComplementClass() throws ParseException {
        this.jj_consume_token(38);
        OWLClass oWLClass = this.NestedClass();
        if (this.create) {
            return this.owlModel.createOWLComplementClass(oWLClass);
        }
        return null;
    }

    public final OWLClass OWLEnumeratedClass() throws ParseException {
        ArrayList<OWLIndividual> arrayList = new ArrayList<OWLIndividual>();
        this.jj_consume_token(39);
        OWLIndividual oWLIndividual = this.Individual();
        arrayList.add(oWLIndividual);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 28: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            oWLIndividual = this.Individual();
            arrayList.add(oWLIndividual);
        }
        this.jj_consume_token(40);
        return this.owlModel.createOWLEnumeratedClass(arrayList);
    }

    public final RDFSDatatype Datatype() throws ParseException {
        Token token = this.jj_consume_token(24);
        String string = ParserUtils.dequoteIdentifier(token.image);
        return this.owlModel.getRDFSDatatypeByName(datatypeChecker.getDatatypeQName(string));
    }

    public final OWLDatatypeProperty DatatypeProperty() throws ParseException {
        OWLDatatypeProperty oWLDatatypeProperty;
        Token token = this.jj_consume_token(27);
        try {
            String string = ParserUtils.dequoteIdentifier(token.image);
            oWLDatatypeProperty = ParserUtils.getOWLDatatypePropertyFromName(this.owlModel, string);
        }
        catch (AmbiguousNameException ambiguousNameException) {
            throw new ParseException(ambiguousNameException.getMessage());
        }
        return oWLDatatypeProperty;
    }

    public final OWLObjectProperty ObjectProperty() throws ParseException {
        OWLObjectProperty oWLObjectProperty;
        Token token = this.jj_consume_token(26);
        try {
            String string = ParserUtils.dequoteIdentifier(token.image);
            oWLObjectProperty = ParserUtils.getOWLObjectPropertyFromName(this.owlModel, string);
        }
        catch (AmbiguousNameException ambiguousNameException) {
            throw new ParseException(ambiguousNameException.getMessage());
        }
        return oWLObjectProperty;
    }

    public final OWLIndividual Individual() throws ParseException {
        Token token = this.jj_consume_token(28);
        try {
            String string = ParserUtils.dequoteIdentifier(token.image);
            return ParserUtils.getOWLIndividualFromName(this.owlModel, string);
        }
        catch (AmbiguousNameException ambiguousNameException) {
            throw new ParseException(ambiguousNameException.getMessage());
        }
    }

    public final OWLClass NestedClass() throws ParseException {
        OWLClass oWLClass;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                oWLClass = this.OWLNamedClass();
                break;
            }
            case 39: {
                oWLClass = this.OWLEnumeratedClass();
                break;
            }
            case 38: {
                oWLClass = this.OWLComplementClass();
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                oWLClass = this.OWLUnionClass();
                this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return oWLClass;
    }

    public final int Integer() throws ParseException {
        Token token = this.jj_consume_token(18);
        return Integer.parseInt(token.image);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{Integer.MIN_VALUE, 0, 0x2000040, 0, 0xC000000, 0xC000000, 0x4000000, 0x8000000, 0x2000040, 0x4000000, 0x8000000, 0x2000040, 0x4000000, 0x8000000, 0x2000040, 0x10000000, 0x2000040};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 1, 254, 62, 0, 0, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 192};
    }

    public DLSyntaxParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public DLSyntaxParser(InputStream inputStream, String string) {
        try {
            this.jj_input_stream = new JavaCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new DLSyntaxParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public DLSyntaxParser(Reader reader) {
        this.jj_input_stream = new JavaCharStream(reader, 1, 1);
        this.token_source = new DLSyntaxParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader reader) {
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public DLSyntaxParser(DLSyntaxParserTokenManager dLSyntaxParserTokenManager) {
        this.token_source = dLSyntaxParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(DLSyntaxParserTokenManager dLSyntaxParserTokenManager) {
        this.token_source = dLSyntaxParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[41];
        for (n2 = 0; n2 < 41; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 17; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) == 0) continue;
                blArray[32 + n] = true;
            }
        }
        for (n2 = 0; n2 < 41; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        DLSyntaxParser.jj_la1_0();
        DLSyntaxParser.jj_la1_1();
    }
}

