/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.triplestore;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.protege2jena.Protege2Jena;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class JenaMemoryTripleWriter
implements TripleWriter {
    private Node defaultOntologyNode;
    private OntModel ontModel;
    private OutputStream os;

    public JenaMemoryTripleWriter() {
        this(null);
    }

    public JenaMemoryTripleWriter(OutputStream outputStream) {
        this(outputStream, ModelFactory.createOntologyModel());
    }

    public JenaMemoryTripleWriter(OutputStream outputStream, OntModel ontModel) {
        this.ontModel = ontModel;
        this.os = outputStream;
    }

    public void addImport(String string) {
        this.addTriple(this.defaultOntologyNode, OWL.imports.getNode(), Node.create((String)string));
    }

    public void addTriple(Node node, Node node2, Node node3) {
        this.ontModel.getBaseModel().getGraph().add(new Triple(node, node2, node3));
    }

    public void close() throws Exception {
        String string = "RDF/XML-ABBREV";
        RDFWriter rDFWriter = this.ontModel.getWriter(string);
        String string2 = this.ontModel.getNsPrefixURI("");
        Jena.prepareWriter(rDFWriter, string, string2);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.os, "UTF-8");
        String string3 = string2;
        if (string3.endsWith("#")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        Protege2Jena.removeRedundantRDFLists((Model)this.ontModel);
        rDFWriter.write(this.ontModel.getBaseModel(), (Writer)outputStreamWriter, string3);
        this.os.close();
    }

    private Node createNodeFromRDFResource(RDFResource rDFResource) {
        if (rDFResource.isAnonymous()) {
            AnonId anonId = new AnonId("_:" + rDFResource.getName());
            return Node.createAnon((AnonId)anonId);
        }
        return Node.create((String)rDFResource.getURI());
    }

    private Node createNodeFromRDFSLiteral(RDFSLiteral rDFSLiteral, OWLModel oWLModel) {
        String string = rDFSLiteral.getLanguage();
        if (string != null) {
            String string2 = rDFSLiteral.getString();
            return Node.createLiteral((String)string2, (String)string, (RDFDatatype)XMLSchemaDatatypes.getXSDDatatype(oWLModel.getXSDstring()));
        }
        XSDDatatype xSDDatatype = XMLSchemaDatatypes.getXSDDatatype(rDFSLiteral.getDatatype());
        if (xSDDatatype == null && oWLModel.getRDFXMLLiteralType().equals(rDFSLiteral.getDatatype())) {
            xSDDatatype = XMLLiteralType.theXMLLiteralType;
        }
        return Node.createLiteral((String)rDFSLiteral.getString(), (String)"", (RDFDatatype)xSDDatatype);
    }

    public OntModel getOntModel() {
        return this.ontModel;
    }

    public void init(String string) {
        this.defaultOntologyNode = Node.create((String)string);
        this.addTriple(this.defaultOntologyNode, RDF.type.getNode(), OWL.Ontology.getNode());
    }

    public void write(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        Node node = this.createNodeFromRDFResource(rDFResource);
        Node node2 = this.createNodeFromRDFResource(rDFProperty);
        Node node3 = null;
        if (object instanceof RDFResource) {
            node3 = this.createNodeFromRDFResource((RDFResource)object);
        } else if (object instanceof RDFSLiteral) {
            node3 = this.createNodeFromRDFSLiteral((RDFSLiteral)object, rDFResource.getOWLModel());
        } else {
            OWLModel oWLModel = rDFResource.getOWLModel();
            RDFSLiteral rDFSLiteral = oWLModel.asRDFSLiteral(object);
            node3 = this.createNodeFromRDFSLiteral(rDFSLiteral, oWLModel);
        }
        this.addTriple(node, node2, node3);
    }

    public void writePrefix(String string, String string2) {
        this.ontModel.setNsPrefix(string, string2);
    }
}

