/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.rdf2owl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protegex.owl.jena.Jena;
import java.util.Iterator;

public class RDF2OWL {
    private Model model;

    public RDF2OWL(Model model) {
        this.model = model;
    }

    private void convertRDFSClasses() {
        StmtIterator stmtIterator = this.model.listStatements(null, RDF.type, (RDFNode)RDFS.Class);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Resource resource = statement.getSubject();
            statement.getModel().add(resource, RDF.type, (RDFNode)OWL.Class);
            stmtIterator.remove();
            this.log("Converted rdfs:Class " + resource + " into owl:Class");
        }
    }

    private void convertProperties() {
        StmtIterator stmtIterator = this.model.listStatements(null, RDF.type, (RDFNode)RDF.Property);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Resource resource = statement.getSubject();
            Resource resource2 = this.getPropertyType(resource);
            statement.getModel().add(resource, RDF.type, (RDFNode)resource2);
            stmtIterator.remove();
            this.log("Converted rdf:Property " + resource + " into " + resource2);
        }
    }

    private void convertRDFSResource() {
        StmtIterator stmtIterator = this.model.listStatements(null, null, (RDFNode)RDFS.Resource);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            statement.getModel().add(statement.getSubject(), statement.getPredicate(), (RDFNode)OWL.Thing);
            this.log("Replaced triple " + statement + " with (x, x, owl:Thing)");
            stmtIterator.remove();
        }
    }

    private Resource getPropertyType(Resource resource) {
        StmtIterator stmtIterator = this.model.listStatements(resource, RDFS.range, (RDFNode)null);
        if (stmtIterator.hasNext()) {
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                RDFNode rDFNode = statement.getObject();
                if (!rDFNode.canAs(Resource.class) || !this.model.contains((Resource)rDFNode.as(Resource.class), RDF.type, (RDFNode)OWL.Class)) continue;
                return OWL.ObjectProperty;
            }
        }
        return OWL.DatatypeProperty;
    }

    private void log(String string) {
        System.out.println("[RDF2OWL] " + string);
    }

    public void run() {
        this.unifyRDFSVersion();
        this.convertRDFSResource();
    }

    private void unifyRDFSVersion() {
        String[] stringArray = new String[]{"http://www.w3.org/TR/1999/PR-rdf-schema-19990303#"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.unifyRDFSVersion(string);
        }
    }

    private void unifyRDFSVersion(String string) {
        Iterator iterator = Jena.cloneIt((Iterator)this.model.listStatements());
        while (iterator.hasNext()) {
            Resource resource;
            Statement statement = (Statement)iterator.next();
            Resource resource2 = statement.getSubject();
            Property property = statement.getPredicate();
            RDFNode rDFNode = statement.getObject();
            boolean bl = false;
            if (string.equals(resource2.getNameSpace())) {
                bl = true;
                resource2 = this.model.getResource(RDFS.getURI() + resource2.getLocalName());
            }
            if (string.equals(property.getNameSpace())) {
                bl = true;
                property = this.model.getProperty(RDFS.getURI() + property.getLocalName());
            }
            if (rDFNode.canAs(Resource.class) && string.equals((resource = (Resource)rDFNode.as(Resource.class)).getNameSpace())) {
                bl = true;
                rDFNode = this.model.getResource(RDFS.getURI() + resource.getLocalName());
            }
            if (!bl) continue;
            this.model.add(resource2, property, rDFNode);
            this.log("Replaced deprecated triple " + statement + " with " + resource2 + ", " + property + ", " + rDFNode);
            iterator.remove();
        }
    }
}

