/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.graph;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.AddDeniedException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import edu.stanford.smi.protegex.owl.jena.graph.ProtegeCapabilities;
import edu.stanford.smi.protegex.owl.jena.graph.ProtegePrefixMapping;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProtegeGraph
extends GraphBase
implements Graph {
    private Capabilities capabilities = new ProtegeCapabilities();
    private OWLModel owlModel;
    private PrefixMapping prefixMapping;
    private TripleStore ts;

    public ProtegeGraph(OWLModel oWLModel, TripleStore tripleStore) {
        this.owlModel = oWLModel;
        this.ts = tripleStore;
        this.prefixMapping = new ProtegePrefixMapping(oWLModel, tripleStore);
    }

    public void add(Triple triple) throws AddDeniedException {
        throw new RuntimeException("Not supported yet");
    }

    public void close() {
    }

    private ExtendedIterator createExtendedIterator(Iterator iterator) {
        List list = this.createJenaTriplesList(iterator);
        return WrappedIterator.create(list.iterator());
    }

    private List createJenaTriplesList(Iterator iterator) {
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        while (iterator.hasNext()) {
            edu.stanford.smi.protegex.owl.model.triplestore.Triple triple = (edu.stanford.smi.protegex.owl.model.triplestore.Triple)iterator.next();
            Node node = this.createNode(triple.getSubject());
            Node node2 = this.createNode(triple.getPredicate());
            Node node3 = this.createNode(triple.getObject());
            arrayList.add(new Triple(node, node2, node3));
        }
        return arrayList;
    }

    private Node createNode(Object object) {
        if (object instanceof RDFResource) {
            RDFResource rDFResource = (RDFResource)object;
            if (rDFResource.isAnonymous()) {
                return Node.createAnon((AnonId)new AnonId(rDFResource.getName()));
            }
            return Node.createURI((String)rDFResource.getURI());
        }
        if (!(object instanceof RDFSLiteral)) {
            object = this.owlModel.createRDFSLiteral(object);
        }
        RDFSLiteral rDFSLiteral = (RDFSLiteral)object;
        String string = rDFSLiteral.getLanguage();
        String string2 = rDFSLiteral.toString();
        if (string != null) {
            RDFDatatype rDFDatatype = this.getRDFDatatype(this.owlModel.getXSDstring());
            return Node.createLiteral((String)string2, (String)string, (RDFDatatype)rDFDatatype);
        }
        RDFDatatype rDFDatatype = this.getRDFDatatype(rDFSLiteral.getDatatype());
        return Node.createLiteral((String)string2, null, (RDFDatatype)rDFDatatype);
    }

    private RDFSLiteral createRDFSLiteral(LiteralLabel literalLabel) {
        String string = literalLabel.getDatatypeURI();
        if (string == null) {
            String string2 = literalLabel.getLexicalForm();
            return this.owlModel.createRDFSLiteral(string2, this.owlModel.getXSDstring());
        }
        RDFSDatatype rDFSDatatype = this.owlModel.getRDFSDatatypeByURI(string);
        String string3 = literalLabel.getLexicalForm();
        return this.owlModel.createRDFSLiteral(string3, rDFSDatatype);
    }

    public boolean dependsOn(Graph graph) {
        return false;
    }

    private ExtendedIterator findAllTriples() {
        Iterator<edu.stanford.smi.protegex.owl.model.triplestore.Triple> iterator = this.ts.listTriples();
        return this.createExtendedIterator(iterator);
    }

    private ExtendedIterator findWithObjectOnly(Node node) {
        RDFObject rDFObject = this.getRDFObject(node);
        if (rDFObject == null) {
            return new NullIterator();
        }
        return this.createExtendedIterator(this.ts.listTriplesWithObject(rDFObject));
    }

    private ExtendedIterator findWithPredicateOnly(Node node) {
        RDFProperty rDFProperty = this.getRDFProperty(node);
        if (rDFProperty != null) {
            ArrayList<Triple> arrayList = new ArrayList<Triple>();
            Iterator<RDFResource> iterator = this.ts.listSubjects(rDFProperty);
            while (iterator.hasNext()) {
                RDFResource rDFResource = iterator.next();
                Node node2 = this.createNode(rDFResource);
                Iterator iterator2 = rDFResource.listPropertyValues(rDFProperty);
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    Node node3 = this.createNode(e);
                    arrayList.add(new Triple(node2, node, node3));
                }
            }
            return WrappedIterator.create(arrayList.iterator());
        }
        return new NullIterator();
    }

    private ExtendedIterator findWithPredicateAndObject(Node node, Node node2) {
        RDFObject rDFObject;
        RDFProperty rDFProperty = this.getRDFProperty(node);
        if (rDFProperty != null && (rDFObject = this.getRDFObject(node2)) != null) {
            ArrayList<Triple> arrayList = new ArrayList<Triple>();
            Iterator iterator = this.ts.listSubjects(rDFProperty, rDFObject);
            while (iterator.hasNext()) {
                RDFResource rDFResource = (RDFResource)iterator.next();
                Node node3 = this.createNode(rDFResource);
                Triple triple = new Triple(node3, node, node2);
                arrayList.add(triple);
            }
            return WrappedIterator.create(arrayList.iterator());
        }
        return new NullIterator();
    }

    private ExtendedIterator findWithSubject(Node node, RDFResource rDFResource, Node node2, Node node3) {
        if (node2 != null) {
            String string = this.getResourceName(node2);
            if (string == null) {
                return new NullIterator();
            }
            RDFResource rDFResource2 = this.owlModel.getRDFResource(string);
            if (rDFResource2 instanceof RDFProperty) {
                return this.findWithSubjectAndPredicate(node, rDFResource, node2, (RDFProperty)rDFResource2, node3);
            }
            return new NullIterator();
        }
        if (node3 != null) {
            return this.findWithSubjectAndObject(node, rDFResource, node3);
        }
        return this.findWithSubjectOnly(node, rDFResource);
    }

    private ExtendedIterator findWithSubjectOnly(Node node, RDFResource rDFResource) {
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        Iterator<edu.stanford.smi.protegex.owl.model.triplestore.Triple> iterator = this.ts.listTriples();
        while (iterator.hasNext()) {
            edu.stanford.smi.protegex.owl.model.triplestore.Triple triple = iterator.next();
            if (!triple.getSubject().equals(rDFResource)) continue;
            Node node2 = this.createNode(triple.getPredicate());
            Node node3 = this.createNode(triple.getObject());
            arrayList.add(new Triple(node, node2, node3));
        }
        return WrappedIterator.create(arrayList.iterator());
    }

    private ExtendedIterator findWithSubjectAndObject(Node node, RDFResource rDFResource, Node node2) {
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        Iterator<edu.stanford.smi.protegex.owl.model.triplestore.Triple> iterator = this.ts.listTriples();
        while (iterator.hasNext()) {
            Node node3;
            edu.stanford.smi.protegex.owl.model.triplestore.Triple triple = iterator.next();
            if (!triple.getSubject().equals(rDFResource) || !(node3 = this.createNode(triple.getObject())).equals((Object)node2)) continue;
            Node node4 = this.createNode(triple.getPredicate());
            arrayList.add(new Triple(node, node4, node2));
        }
        return WrappedIterator.create(arrayList.iterator());
    }

    private ExtendedIterator findWithSubjectAndPredicate(Node node, RDFResource rDFResource, Node node2, RDFProperty rDFProperty, Node node3) {
        if (node3 != null) {
            RDFObject rDFObject = null;
            if (node3.isLiteral()) {
                rDFObject = this.createRDFSLiteral(node3.getLiteral());
            } else {
                rDFObject = this.getRDFResource(node3);
                if (rDFObject == null) {
                    return new NullIterator();
                }
            }
            if (this.ts.contains(rDFResource, rDFProperty, rDFObject)) {
                return new SingletonIterator((Object)new Triple(node, node2, node3));
            }
            return new NullIterator();
        }
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        Iterator iterator = this.ts.listObjects(rDFResource, rDFProperty);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Node node4 = this.createNode(e);
            arrayList.add(new Triple(node, node2, node4));
        }
        return WrappedIterator.create(arrayList.iterator());
    }

    private RDFDatatype getRDFDatatype(RDFSDatatype rDFSDatatype) {
        return XMLSchemaDatatypes.getRDFDatatype(rDFSDatatype);
    }

    private RDFObject getRDFObject(Node node) {
        RDFObject rDFObject = null;
        rDFObject = node.isLiteral() ? this.createRDFSLiteral(node.getLiteral()) : this.getRDFResource(node);
        return rDFObject;
    }

    private RDFProperty getRDFProperty(Node node) {
        RDFResource rDFResource = this.getRDFResource(node);
        if (rDFResource instanceof RDFProperty) {
            return (RDFProperty)rDFResource;
        }
        return null;
    }

    private RDFResource getRDFResource(Node node) {
        String string = this.getResourceName(node);
        if (string == null) {
            return null;
        }
        return this.owlModel.getRDFResource(string);
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public GraphEventManager getEventManager() {
        return null;
    }

    public PrefixMapping getPrefixMapping() {
        return this.prefixMapping;
    }

    private String getResourceName(Node node) {
        if (node.isBlank()) {
            return node.getBlankNodeId().toString();
        }
        String string = node.getURI();
        return this.owlModel.getResourceNameForURI(string);
    }

    protected ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
        Node node = tripleMatch.getMatchSubject();
        Node node2 = tripleMatch.getMatchPredicate();
        Node node3 = tripleMatch.getMatchObject();
        if (node != null) {
            RDFResource rDFResource = this.getRDFResource(node);
            if (rDFResource == null) {
                return new NullIterator();
            }
            return this.findWithSubject(node, rDFResource, node2, node3);
        }
        if (node2 != null) {
            if (node3 != null) {
                return this.findWithPredicateAndObject(node2, node3);
            }
            return this.findWithPredicateOnly(node2);
        }
        if (node3 != null) {
            return this.findWithObjectOnly(node3);
        }
        return this.findAllTriples();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isIsomorphicWith(Graph graph) {
        return false;
    }

    public QueryHandler queryHandler() {
        return new SimpleQueryHandler((Graph)this);
    }
}

