/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena;

import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.plugin.AbstractCreateProjectPlugin;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.OWLFilesPlugin;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.util.ImportHelper;
import edu.stanford.smi.protegex.owl.model.util.XSDVisibility;
import edu.stanford.smi.protegex.owl.swrl.ui.SWRLProjectPlugin;
import edu.stanford.smi.protegex.owl.swrl.ui.tab.SWRLTab;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.cls.SwitchClassDefinitionResourceDisplayPlugin;
import edu.stanford.smi.protegex.owl.ui.jena.OWLFilesWizardPage;
import edu.stanford.smi.protegex.owl.ui.menu.OWLMenuProjectPlugin;
import edu.stanford.smi.protegex.owl.ui.metadatatab.OntologyURIWizardPage;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfileSelectionWizardPage;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OWLFilesCreateProjectPlugin
extends AbstractCreateProjectPlugin
implements OWLFilesPlugin {
    private static transient Logger log = Log.getLogger(OWLFilesCreateProjectPlugin.class);
    private Class defaultClassView;
    private String defaultNamespace;
    private Collection imports = new ArrayList();
    private Map importPrefixes = new HashMap();
    private String fileURI;
    private String lang;
    private String profileURI;

    public OWLFilesCreateProjectPlugin() {
        super("OWL Files");
        JenaKnowledgeBaseFactory.useStandalone = false;
    }

    public void addImport(String string, String string2) {
        this.imports.add(string);
        this.importPrefixes.put(string, string2);
    }

    protected void addImports(Project project) {
        Object object;
        JenaOWLModel jenaOWLModel = (JenaOWLModel)project.getKnowledgeBase();
        if (this.imports.contains("http://www.w3.org/2003/11/swrl")) {
            object = project.getTabWidgetDescriptors();
            WidgetDescriptor widgetDescriptor = project.getTabWidgetDescriptor(SWRLTab.class.getName());
            widgetDescriptor.setVisible(true);
            project.setTabWidgetDescriptorOrder((Collection)object);
            jenaOWLModel.getNamespaceManager().setPrefix("http://www.w3.org/2003/11/swrl#", "swrl");
            jenaOWLModel.getNamespaceManager().setPrefix("http://www.w3.org/2003/11/swrlb#", "swrlb");
            jenaOWLModel.getNamespaceManager().setPrefix("http://swrl.stanford.edu/ontologies/built-ins/3.3/swrlx.owl#", "swrlx");
        }
        object = new ImportHelper(jenaOWLModel);
        for (String string : this.imports) {
            String string2 = (String)this.importPrefixes.get(string);
            String string3 = string;
            if (!string3.endsWith("#") && !string3.endsWith("/")) {
                string3 = string3 + "#";
            }
            jenaOWLModel.getNamespaceManager().setPrefix(string3, string2);
            if (string3.equals(ProtegeNames.NS)) {
                jenaOWLModel.getNamespaceManager().setPrefix("http://www.owl-ontologies.com/2005/08/07/xsp.owl#", "xsp");
            }
            try {
                URI uRI = new URI(string);
                ((ImportHelper)object).addImport(uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                log.log(Level.SEVERE, "Exception caught", uRISyntaxException);
            }
        }
        try {
            ((ImportHelper)object).importOntologies();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception caught", exception);
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(jenaOWLModel, "Could not load import:\n" + exception);
        }
        if (!this.imports.isEmpty()) {
            jenaOWLModel.getTripleStoreModel().updateEditableResourceState();
        }
    }

    private void addViewSettings(PropertyList propertyList) {
        String string = null;
        string = this.defaultClassView == null ? SwitchClassDefinitionResourceDisplayPlugin.getDefaultClassView() : this.defaultClassView.getName();
        SwitchClassDefinitionResourceDisplayPlugin.setClassesView(propertyList, string);
        SwitchClassDefinitionResourceDisplayPlugin.setDefaultClassesView(string);
        if (this.profileURI != null) {
            ProfilesManager.setProfile(propertyList, this.profileURI);
        }
    }

    protected Project buildNewProject(KnowledgeBaseFactory knowledgeBaseFactory) {
        Project project = this.buildNewProject2(knowledgeBaseFactory);
        if (project != null) {
            OWLModel oWLModel = (OWLModel)project.getKnowledgeBase();
            OWLMenuProjectPlugin.makeHiddenClsesWithSubclassesVisible(oWLModel);
            if (SWRLProjectPlugin.isSWRLImported(oWLModel)) {
                SWRLProjectPlugin.adjustGUI(project);
            }
            XSDVisibility.updateVisibility(oWLModel);
        }
        return project;
    }

    private Project buildNewProject2(KnowledgeBaseFactory knowledgeBaseFactory) {
        ArrayList arrayList = new ArrayList();
        Project project = Project.createNewProject((KnowledgeBaseFactory)knowledgeBaseFactory, arrayList);
        this.initialize(project);
        URI uRI = this.getBuildProjectURI();
        if (uRI != null) {
            project.setProjectURI(uRI);
        }
        project.createDomainKnowledgeBase(knowledgeBaseFactory, arrayList, true);
        this.handleErrors(arrayList);
        return project;
    }

    public boolean canCreateProject(KnowledgeBaseFactory knowledgeBaseFactory, boolean bl) {
        return knowledgeBaseFactory.getClass() == JenaKnowledgeBaseFactory.class;
    }

    public WizardPage createCreateProjectWizardPage(CreateProjectWizard createProjectWizard, boolean bl) {
        ProfileSelectionWizardPage.isBuild = bl;
        if (bl) {
            return new OWLFilesWizardPage((Wizard)createProjectWizard, this);
        }
        return new OntologyURIWizardPage((Wizard)createProjectWizard, this);
    }

    protected Project createNewProject(KnowledgeBaseFactory knowledgeBaseFactory) {
        ArrayList arrayList = new ArrayList();
        Project project = Project.createNewProject((KnowledgeBaseFactory)knowledgeBaseFactory, arrayList);
        OWLModel oWLModel = (OWLModel)project.getKnowledgeBase();
        if (this.defaultNamespace != null) {
            oWLModel.getNamespaceManager().setDefaultNamespace(this.defaultNamespace);
        }
        this.addViewSettings(project.getSources());
        this.addImports(project);
        OWLMenuProjectPlugin.makeHiddenClsesWithSubclassesVisible(oWLModel);
        return project;
    }

    protected URI getBuildProjectURI() {
        int n;
        if (this.fileURI != null && this.fileURI.startsWith("file:") && (n = this.fileURI.lastIndexOf(46)) > 0) {
            String string = FileUtilities.replaceExtension((String)this.fileURI, (String)".pprj");
            try {
                return new URI(string);
            }
            catch (Exception exception) {
                Log.emptyCatchBlock((Throwable)exception);
            }
        }
        return super.getBuildProjectURI();
    }

    protected void initializeSources(PropertyList propertyList) {
        JenaKnowledgeBaseFactory.setOWLFileName(propertyList, this.fileURI);
        JenaKnowledgeBaseFactory.setOWLFileLanguage(propertyList, this.lang);
        this.addViewSettings(propertyList);
    }

    public void setDublinCoreRedirectToDLVersion(boolean bl) {
    }

    public void setFile(String string) {
        this.fileURI = string;
    }

    public void setLanguage(String string) {
        this.lang = string;
    }

    public void setDefaultClassView(Class clazz) {
        this.defaultClassView = clazz;
        SwitchClassDefinitionResourceDisplayPlugin.setDefaultClassesView(clazz.getName());
    }

    public void setDefaultNamespace(String string) {
        this.defaultNamespace = string;
    }

    public void setProfile(String string) {
        this.profileURI = string;
    }
}

