/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.reasoner.ProtegeReasoner;
import edu.stanford.smi.protegex.owl.inference.reasoner.exception.ProtegeReasonerException;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerUtil;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.util.Collection;
import java.util.Iterator;

public class UpdateInferredHierarchyTask
extends AbstractReasonerTask {
    private ProtegeReasoner protegeReasoner;

    public UpdateInferredHierarchyTask(ProtegeReasoner protegeReasoner) {
        super(protegeReasoner);
        this.protegeReasoner = protegeReasoner;
    }

    public int getTaskSize() {
        return ReasonerUtil.getInstance().getNamedClses(this.protegeReasoner.getOWLModel()).size();
    }

    public void run() throws ProtegeReasonerException {
        OWLModel oWLModel = this.protegeReasoner.getOWLModel();
        ReasonerLogRecord reasonerLogRecord = ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Compute inferred hierarchy", null);
        this.doAbortCheck();
        this.postLogRecord(reasonerLogRecord);
        this.setProgress(0);
        this.setDescription("Computing inferred hierarchy");
        this.setMessage("Querying reasoner and updating Protege-OWL...");
        TimeDifference timeDifference = new TimeDifference();
        timeDifference.markStart();
        boolean bl = oWLModel.setGenerateEventsEnabled(false);
        try {
            oWLModel.beginTransaction("Compute and update inferred class hierarchy");
            Collection collection = ReasonerUtil.getInstance().getNamedClses(oWLModel);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object object;
                this.doAbortCheck();
                OWLNamedClass oWLNamedClass = (OWLNamedClass)iterator.next();
                if (oWLNamedClass.isConsistent()) {
                    object = this.protegeReasoner.getSuperclasses(oWLNamedClass);
                    Object object2 = object.iterator();
                    while (object2.hasNext()) {
                        RDFSClass rDFSClass = (RDFSClass)object2.next();
                        if (!rDFSClass.isVisible()) continue;
                        oWLNamedClass.addInferredSuperclass(rDFSClass);
                    }
                    object2 = oWLNamedClass.getNamedSuperclasses();
                    if (!object2.containsAll((Collection<?>)object) || !object.containsAll((Collection<?>)object2)) {
                        oWLNamedClass.setClassificationStatus(3);
                    } else {
                        oWLNamedClass.setClassificationStatus(1);
                    }
                } else {
                    object = oWLNamedClass.getNamedSuperclasses().iterator();
                    while (object.hasNext()) {
                        oWLNamedClass.addInferredSuperclass((RDFSClass)object.next());
                    }
                }
                this.setProgress(this.getProgress() + 1);
            }
            oWLModel.commitTransaction();
        }
        catch (ProtegeReasonerException protegeReasonerException) {
            this.setTaskFailed();
            oWLModel.rollbackTransaction();
            throw protegeReasonerException;
        }
        catch (Exception exception) {
            this.setTaskFailed();
            oWLModel.rollbackTransaction();
            Log.getLogger().warning("Exception in transaction. Rollback. Exception: " + exception.getMessage());
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.initCause(exception);
            throw runtimeException;
        }
        oWLModel.setGenerateEventsEnabled(bl);
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to update Protege-OWL = " + timeDifference, reasonerLogRecord));
        this.setTaskCompleted();
    }
}

