/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner;

import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.reasoner.ProtegeReasoner;
import edu.stanford.smi.protegex.owl.inference.reasoner.exception.ProtegeReasonerException;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLModel;

public class SynchronizeReasonerTask
extends AbstractReasonerTask {
    private ProtegeReasoner protegeReasoner;

    public SynchronizeReasonerTask(ProtegeReasoner protegeReasoner) {
        super(protegeReasoner);
        this.protegeReasoner = protegeReasoner;
    }

    public int getTaskSize() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws ProtegeReasonerException {
        TimeDifference timeDifference = new TimeDifference();
        this.setDescription("Synchronizing reasoner");
        this.setMessage("Synchronizing reasoner...");
        ReasonerLogRecordFactory reasonerLogRecordFactory = ReasonerLogRecordFactory.getInstance();
        ReasonerLogRecord reasonerLogRecord = reasonerLogRecordFactory.createInformationMessageLogRecord("Synchronize reasoner", null);
        this.postLogRecord(reasonerLogRecord);
        timeDifference.markStart();
        this.setProgressIndeterminate(true);
        this.doAbortCheck();
        this.setMessage("Updating reasoner...");
        OWLModel oWLModel = this.protegeReasoner.getOWLModel();
        boolean bl = oWLModel.setGenerateEventsEnabled(false);
        try {
            this.clearKnowledgeBase(reasonerLogRecord);
            this.doAbortCheck();
            this.transmitToReasoner(reasonerLogRecord);
        }
        catch (Exception exception) {
            this.postLogRecord(ReasonerLogRecordFactory.getInstance().createErrorMessageLogRecord("Errors at synchronization: " + exception.getMessage(), null));
        }
        finally {
            oWLModel.setGenerateEventsEnabled(bl);
        }
        this.doAbortCheck();
        this.setProgressIndeterminate(false);
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to synchronize = " + timeDifference, reasonerLogRecord));
        this.setMessage("Reasoner synchronized");
        this.setProgress(1);
        this.setTaskCompleted();
    }

    protected void clearKnowledgeBase(ReasonerLogRecord reasonerLogRecord) throws ProtegeReasonerException {
        TimeDifference timeDifference = new TimeDifference();
        timeDifference.markStart();
        this.setMessage("Clearing knowledge base...");
        this.protegeReasoner.reset();
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to clear knowledgebase = " + timeDifference, reasonerLogRecord));
    }

    protected void transmitToReasoner(ReasonerLogRecord reasonerLogRecord) throws ProtegeReasonerException {
        TimeDifference timeDifference = new TimeDifference();
        this.setMessage("Updating reasoner...");
        timeDifference.markStart();
        this.protegeReasoner.rebind();
        timeDifference.markEnd();
        this.doAbortCheck();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to update reasoner = " + timeDifference, reasonerLogRecord));
    }
}

