/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner;

import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.BooleanResultReasonerTask;
import edu.stanford.smi.protegex.owl.inference.reasoner.ProtegeReasoner;
import edu.stanford.smi.protegex.owl.inference.reasoner.exception.ProtegeReasonerException;
import edu.stanford.smi.protegex.owl.model.OWLClass;

public class IsConceptIntersectionSatisfiableTask
extends AbstractReasonerTask
implements BooleanResultReasonerTask {
    private OWLClass[] clses;
    private ProtegeReasoner protegeReasoner;
    private boolean satisfiable;

    public IsConceptIntersectionSatisfiableTask(OWLClass[] oWLClassArray, ProtegeReasoner protegeReasoner) {
        super(protegeReasoner);
        this.clses = oWLClassArray;
        this.protegeReasoner = protegeReasoner;
        this.satisfiable = true;
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws ProtegeReasonerException {
        this.setProgress(0);
        this.setDescription("Computing satisfiability of concept intersection");
        this.setMessage("Querying reasoner...");
        this.satisfiable = this.protegeReasoner.isIntersectionSatisfiable(this.clses);
        this.setMessage("Complete");
        this.setProgress(1);
        this.setTaskCompleted();
    }

    public boolean getResult() {
        return this.satisfiable;
    }
}

