/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner;

import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.CollectionResultReasonerTask;
import edu.stanford.smi.protegex.owl.inference.reasoner.ProtegeReasoner;
import edu.stanford.smi.protegex.owl.inference.reasoner.exception.ProtegeReasonerException;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public abstract class AbstractSingleConceptWithConceptCollectionResultTask
extends AbstractReasonerTask
implements CollectionResultReasonerTask {
    private OWLClass aClass;
    private ProtegeReasoner protegeReasoner;
    private HashSet parents;
    private String taskDesciption;

    public AbstractSingleConceptWithConceptCollectionResultTask(String string, OWLClass oWLClass, ProtegeReasoner protegeReasoner) {
        super(protegeReasoner);
        this.taskDesciption = string;
        this.aClass = oWLClass;
        this.protegeReasoner = protegeReasoner;
        this.parents = new HashSet();
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws ProtegeReasonerException {
        this.setDescription(this.taskDesciption);
        this.setMessage("Building reasoner query...");
        this.setProgress(0);
        this.doAbortCheck();
        this.setMessage("Querying reasoner...");
        this.parents.addAll(this.getQueryResults());
        ReasonerLogRecordFactory reasonerLogRecordFactory = ReasonerLogRecordFactory.getInstance();
        ReasonerLogRecord reasonerLogRecord = reasonerLogRecordFactory.createInformationMessageLogRecord("Concepts", null);
        this.postLogRecord(reasonerLogRecord);
        Iterator iterator = this.parents.iterator();
        while (iterator.hasNext()) {
            this.postLogRecord(reasonerLogRecordFactory.createOWLInstanceLogRecord((RDFResource)iterator.next(), reasonerLogRecord));
        }
        this.setProgress(1);
        this.doAbortCheck();
        this.setTaskCompleted();
    }

    public Collection getResult() {
        return this.parents;
    }

    public abstract Collection getQueryResults() throws ProtegeReasonerException;

    protected OWLClass getCls() {
        return this.aClass;
    }

    protected ProtegeReasoner getProtegeReasoner() {
        return this.protegeReasoner;
    }
}

