/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.emf;

import edu.stanford.smi.protegex.owl.emf.EditableEMFGeneratorOptions;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.project.OWLProject;
import java.io.File;

public class ProjectBasedEMFGeneratorOptions
implements EditableEMFGeneratorOptions {
    public static final String FILE_NAME = "EMFFileName";
    public static final String PACKAGE = "EMFPackage";
    private OWLProject project;

    public ProjectBasedEMFGeneratorOptions(OWLModel oWLModel) {
        this.project = oWLModel.getOWLProject();
    }

    public File getOutputFolder() {
        String string = this.project.getSettingsMap().getString(FILE_NAME);
        if (string == null) {
            return new File("");
        }
        return new File(string);
    }

    public String getPackage() {
        return this.project.getSettingsMap().getString(PACKAGE);
    }

    public void setOutputFolder(File file) {
        if (file == null) {
            this.project.getSettingsMap().remove(FILE_NAME);
        } else {
            this.project.getSettingsMap().setString(FILE_NAME, file.getAbsolutePath());
        }
    }

    public void setPackage(String string) {
        if (string == null) {
            this.project.getSettingsMap().remove(PACKAGE);
        } else {
            this.project.getSettingsMap().setString(PACKAGE, string);
        }
    }
}

