/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.EnglishGrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.util.Filters;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeBankGrammaticalStructureWrapper
extends AbstractCollection<GrammaticalStructure> {
    public final Treebank treebank;
    public final boolean keepPunct;
    private Map<GrammaticalStructure, Tree> origTrees = new WeakHashMap<GrammaticalStructure, Tree>();

    public TreeBankGrammaticalStructureWrapper(Treebank wrappedTreeBank) {
        this.treebank = wrappedTreeBank;
        this.keepPunct = false;
    }

    public TreeBankGrammaticalStructureWrapper(Treebank wrappedTreeBank, boolean keepPunct) {
        this.treebank = wrappedTreeBank;
        this.keepPunct = keepPunct;
    }

    @Override
    public Iterator<GrammaticalStructure> iterator() {
        return new gsIterator();
    }

    public Tree getOriginalTree(GrammaticalStructure gs) {
        return this.origTrees.get(gs);
    }

    @Override
    public int size() {
        return this.treebank.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class gsIterator
    implements Iterator<GrammaticalStructure> {
        Iterator<Tree> tbIterator;

        private gsIterator() {
            this.tbIterator = TreeBankGrammaticalStructureWrapper.this.treebank.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.tbIterator.hasNext();
        }

        @Override
        public GrammaticalStructure next() {
            Tree t = this.tbIterator.next();
            EnglishGrammaticalStructure gs = TreeBankGrammaticalStructureWrapper.this.keepPunct ? new EnglishGrammaticalStructure(t, Filters.<String>acceptFilter()) : new EnglishGrammaticalStructure(t);
            TreeBankGrammaticalStructureWrapper.this.origTrees.put(gs, t);
            return gs;
        }

        @Override
        public void remove() {
            this.tbIterator.remove();
        }
    }
}

