/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CyclicCoreLabel;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.ViterbiParserWithOptions;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.trees.CoordinationTransformer;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeBankGrammaticalStructureWrapper;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnglishGrammaticalStructure
extends GrammaticalStructure {
    private static final long serialVersionUID = -1866362375001969402L;
    public static final String CONJ_MARKER = "conj_";
    public static final String DEFAULT_PARSER_FILE = "/u/nlp/data/lexparser/englishPCFG.ser.gz";
    private static final boolean DEBUG = false;
    private static String[][] MULTIWORD_PREPS = new String[][]{{"according", "to"}, {"across", "from"}, {"ahead", "of"}, {"along", "with"}, {"alongside", "of"}, {"apart", "from"}, {"as", "for"}, {"as", "from"}, {"as", "of"}, {"as", "per"}, {"as", "to"}, {"aside", "from"}, {"away", "from"}, {"based", "on"}, {"because", "of"}, {"close", "by"}, {"close", "to"}, {"contrary", "to"}, {"compared", "to"}, {"compared", "with"}, {"due", "to"}, {"depending", "on"}, {"except", "for"}, {"exclusive", "of"}, {"far", "from"}, {"followed", "by"}, {"inside", "of"}, {"instead", "of"}, {"irrespective", "of"}, {"next", "to"}, {"near", "to"}, {"off", "of"}, {"out", "of"}, {"outside", "of"}, {"owing", "to"}, {"preliminary", "to"}, {"preparatory", "to"}, {"previous", "to"}, {"prior", "to"}, {"pursuant", "to"}, {"regardless", "of"}, {"subsequent", "to"}, {"such", "as"}, {"thanks", "to"}, {"together", "with"}};
    private static String[][] THREEWORD_PREPS = new String[][]{{"by", "means", "of"}, {"in", "accordance", "with"}, {"in", "addition", "to"}, {"in", "case", "of"}, {"in", "front", "of"}, {"in", "lieu", "of"}, {"in", "place", "of"}, {"in", "spite", "of"}, {"on", "account", "of"}, {"on", "behalf", "of"}, {"on", "top", "of"}, {"with", "regard", "to"}, {"with", "respect", "to"}};
    public static final int CoNLLX_WordField = 1;
    public static final int CoNLLX_POSField = 3;
    public static final int CoNLLX_GovField = 6;
    public static final int CoNLLX_RelnField = 7;
    public static final int CoNLLX_FieldCount = 10;
    private static final Map<String, GrammaticalRelation> shortNameToGRel = new ConcurrentHashMap<String, GrammaticalRelation>();

    public EnglishGrammaticalStructure(Tree t) {
        this(t, false);
    }

    public EnglishGrammaticalStructure(List<TypedDependency> projectiveDependencies, TreeGraphNode root) {
        super(projectiveDependencies, root);
    }

    public EnglishGrammaticalStructure(Tree t, boolean threadSafe) {
        this(t, new PennTreebankLanguagePack().punctuationWordRejectFilter(), threadSafe);
    }

    public EnglishGrammaticalStructure(Tree t, Filter<String> puncFilter) {
        this(t, puncFilter, (HeadFinder)new SemanticHeadFinder(true), false);
    }

    public EnglishGrammaticalStructure(Tree t, Filter<String> puncFilter, boolean threadSafe) {
        this(t, puncFilter, (HeadFinder)new SemanticHeadFinder(true), threadSafe);
    }

    public EnglishGrammaticalStructure(Tree t, HeadFinder hf) {
        this(t, null, hf, false);
    }

    public EnglishGrammaticalStructure(Tree t, Filter<String> puncFilter, HeadFinder hf) {
        this(t, puncFilter, hf, false);
    }

    public EnglishGrammaticalStructure(Tree t, Filter<String> puncFilter, HeadFinder hf, boolean threadSafe) {
        super(new CoordinationTransformer().transformTree(t), EnglishGrammaticalRelations.values(threadSafe), threadSafe ? EnglishGrammaticalRelations.valuesLock() : null, hf, puncFilter);
    }

    public static TreeGraphNode getSubject(TreeGraphNode t) {
        TreeGraphNode subj = EnglishGrammaticalStructure.getNodeInRelation(t, EnglishGrammaticalRelations.NOMINAL_SUBJECT);
        if (subj != null) {
            return subj;
        }
        subj = EnglishGrammaticalStructure.getNodeInRelation(t, EnglishGrammaticalRelations.CLAUSAL_SUBJECT);
        if (subj != null) {
            return subj;
        }
        return EnglishGrammaticalStructure.getNodeInRelation(t, EnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT);
    }

    @Override
    protected void correctDependencies(Collection<TypedDependency> list) {
        EnglishGrammaticalStructure.correctSubjPassAndPoss(list);
    }

    private static void printListSorted(String title, Collection<TypedDependency> list) {
        ArrayList<TypedDependency> lis = new ArrayList<TypedDependency>(list);
        Collections.sort(lis);
        if (title != null) {
            System.err.println(title);
        }
        System.err.println(lis);
    }

    @Override
    protected void collapseDependencies(List<TypedDependency> list, boolean CCprocess) {
        this.correctDependencies(list);
        EnglishGrammaticalStructure.eraseMultiConj(list);
        EnglishGrammaticalStructure.collapse2WP(list);
        EnglishGrammaticalStructure.collapseFlatMWP(list);
        EnglishGrammaticalStructure.collapse2WPbis(list);
        EnglishGrammaticalStructure.collapse3WP(list);
        EnglishGrammaticalStructure.collapsePrepAndPoss(list);
        EnglishGrammaticalStructure.collapseConj(list);
        if (CCprocess) {
            EnglishGrammaticalStructure.treatCC(list);
        }
        EnglishGrammaticalStructure.collapseReferent(list);
        Collections.sort(list);
    }

    @Override
    protected void collapseDependenciesTree(List<TypedDependency> list) {
        this.correctDependencies(list);
        EnglishGrammaticalStructure.eraseMultiConj(list);
        EnglishGrammaticalStructure.collapse2WP(list);
        EnglishGrammaticalStructure.collapseFlatMWP(list);
        EnglishGrammaticalStructure.collapse2WPbis(list);
        EnglishGrammaticalStructure.collapse3WP(list);
        EnglishGrammaticalStructure.collapsePrepAndPoss(list);
        EnglishGrammaticalStructure.collapseConj(list);
        Collections.sort(list);
    }

    protected static GrammaticalRelation conjValue(String conj) {
        String newConj = conj.toLowerCase();
        if (newConj.equals("not") || newConj.equals("instead") || newConj.equals("rather")) {
            newConj = "negcc";
        } else if (newConj.equals("to") || newConj.equals("also") || newConj.contains("well")) {
            newConj = "and";
        }
        return EnglishGrammaticalRelations.getConj(newConj);
    }

    private static void treatCC(Collection<TypedDependency> list) {
        HashMap map = new HashMap();
        HashMap<TreeGraphNode, TypedDependency> subjectMap = new HashMap<TreeGraphNode, TypedDependency>();
        HashMap<TreeGraphNode, TypedDependency> objectMap = new HashMap<TreeGraphNode, TypedDependency>();
        for (TypedDependency typedDep : list) {
            if (!map.containsKey(typedDep.dep())) {
                map.put(typedDep.dep(), new TreeSet());
            }
            ((Set)map.get(typedDep.dep())).add(typedDep);
            if (!(typedDep.reln().getParent() != EnglishGrammaticalRelations.NOMINAL_SUBJECT && typedDep.reln().getParent() != EnglishGrammaticalRelations.SUBJECT && typedDep.reln().getParent() != EnglishGrammaticalRelations.CLAUSAL_SUBJECT || subjectMap.containsKey(typedDep.gov()))) {
                subjectMap.put(typedDep.gov(), typedDep);
            }
            if (typedDep.reln() != EnglishGrammaticalRelations.DIRECT_OBJECT || objectMap.containsKey(typedDep.gov())) continue;
            objectMap.put(typedDep.gov(), typedDep);
        }
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>(list);
        for (TypedDependency td : list) {
            if (!EnglishGrammaticalRelations.getConjs().contains(td.reln())) continue;
            TreeGraphNode gov = td.gov();
            TreeGraphNode dep = td.dep();
            Set gov_relations = (Set)map.get(gov);
            if (gov_relations != null) {
                for (TypedDependency td1 : gov_relations) {
                    TreeGraphNode newGov = td1.gov();
                    GrammaticalRelation newRel = td1.reln();
                    newTypedDeps.add(new TypedDependency(newRel, newGov, dep));
                }
            }
            if (subjectMap.containsKey(gov) && (dep.parent().value().startsWith("VB") || dep.parent().value().startsWith("JJ")) && !subjectMap.containsKey(dep)) {
                TypedDependency tdsubj = (TypedDependency)subjectMap.get(gov);
                GrammaticalRelation relation = tdsubj.reln();
                if (relation == EnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT && (dep.parent().value().equals("VB") || dep.parent().value().startsWith("JJ"))) {
                    relation = EnglishGrammaticalRelations.NOMINAL_SUBJECT;
                }
                if (relation == EnglishGrammaticalRelations.CLAUSAL_PASSIVE_SUBJECT && (dep.parent().value().equals("VB") || dep.parent().value().startsWith("JJ"))) {
                    relation = EnglishGrammaticalRelations.CLAUSAL_SUBJECT;
                }
                newTypedDeps.add(new TypedDependency(relation, dep, tdsubj.dep()));
            }
            if (!objectMap.containsKey(gov) || !dep.parent().value().startsWith("VB") || objectMap.containsKey(dep)) continue;
            TypedDependency tdobj = (TypedDependency)objectMap.get(gov);
            newTypedDeps.add(new TypedDependency(tdobj.reln(), dep, tdobj.dep()));
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    private static void collapseConj(Collection<TypedDependency> list) {
        ArrayList<TreeGraphNode> govs = new ArrayList<TreeGraphNode>();
        for (TypedDependency td : list) {
            if (td.reln() != EnglishGrammaticalRelations.COORDINATION) continue;
            TreeGraphNode gov = td.gov();
            GrammaticalRelation conj = EnglishGrammaticalStructure.conjValue(td.dep().value());
            boolean foundOne = false;
            for (TypedDependency td1 : list) {
                if (td1.gov() != gov) continue;
                if (td1.reln() == EnglishGrammaticalRelations.CONJUNCT) {
                    td1.setReln(conj);
                    foundOne = true;
                    continue;
                }
                if (td1.reln() != EnglishGrammaticalRelations.COORDINATION) continue;
                conj = EnglishGrammaticalStructure.conjValue(td1.dep().value());
            }
            if (!foundOne) continue;
            govs.add(gov);
        }
        Iterator<TypedDependency> iter = list.iterator();
        while (iter.hasNext()) {
            TypedDependency td2 = iter.next();
            if (td2.reln() != EnglishGrammaticalRelations.COORDINATION || !govs.contains(td2.gov())) continue;
            iter.remove();
        }
    }

    private static void collapseReferent(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> refs = new ArrayList<TypedDependency>();
        Iterator<TypedDependency> iter = list.iterator();
        while (iter.hasNext()) {
            TypedDependency td = iter.next();
            if (td.reln() != EnglishGrammaticalRelations.REFERENT) continue;
            refs.add(td);
            iter.remove();
        }
        for (TypedDependency ref : refs) {
            TreeGraphNode dep = ref.dep();
            TreeGraphNode ant = ref.gov();
            for (TypedDependency td : list) {
                if (td.dep() != dep || td.reln() == EnglishGrammaticalRelations.RELATIVE || td.reln() == EnglishGrammaticalRelations.REFERENT || td.gov() == ant) continue;
                td.setDep(ant);
            }
        }
    }

    private static void correctSubjPassAndPoss(Collection<TypedDependency> list) {
        ArrayList<TreeGraphNode> list_auxpass = new ArrayList<TreeGraphNode>();
        for (TypedDependency td : list) {
            if (td.reln() != EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER) continue;
            list_auxpass.add(td.gov());
        }
        for (TypedDependency td : list) {
            if (td.reln() == EnglishGrammaticalRelations.NOMINAL_SUBJECT && list_auxpass.contains(td.gov())) {
                td.setReln(EnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT);
            }
            if (td.reln() == EnglishGrammaticalRelations.CLAUSAL_SUBJECT && list_auxpass.contains(td.gov())) {
                td.setReln(EnglishGrammaticalRelations.CLAUSAL_PASSIVE_SUBJECT);
            }
            String tag = td.dep().parent().value();
            if (td.reln() != GrammaticalRelation.DEPENDENT || !tag.equals("PRP$") && !tag.equals("WP$")) continue;
            td.setReln(EnglishGrammaticalRelations.POSSESSION_MODIFIER);
        }
    }

    private static void collapsePrepAndPoss(Collection<TypedDependency> list) {
        Set<TypedDependency> possibles;
        String td1DepPOS;
        TreeGraphNode td1Dep;
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        HashMap map = new HashMap();
        ArrayList<TreeGraphNode> partmod = new ArrayList<TreeGraphNode>();
        for (TypedDependency typedDep : list) {
            if (!map.containsKey(typedDep.gov())) {
                map.put(typedDep.gov(), new TreeSet());
            }
            ((SortedSet)map.get(typedDep.gov())).add(typedDep);
            if (typedDep.reln() != EnglishGrammaticalRelations.PARTICIPIAL_MODIFIER) continue;
            partmod.add(typedDep.dep());
        }
        for (TypedDependency td1 : list) {
            TypedDependency tdNew;
            if (td1.reln() == GrammaticalRelation.KILL) continue;
            td1Dep = td1.dep();
            td1DepPOS = td1Dep.parent().value();
            possibles = (SortedSet)map.get(td1Dep);
            if (possibles == null) continue;
            TypedDependency prepDep = null;
            TypedDependency ccDep = null;
            TypedDependency conjDep = null;
            TypedDependency prep2Dep = null;
            TypedDependency prepOtherDep = null;
            TreeSet<TypedDependency> otherDtrs = new TreeSet<TypedDependency>();
            boolean pobj = true;
            for (TypedDependency td2 : possibles) {
                String td3DepPOS;
                TreeGraphNode td3Dep;
                Set possibles2;
                if (td2.reln() != EnglishGrammaticalRelations.CONJUNCT) continue;
                TreeGraphNode td2Dep = td2.dep();
                String td2DepPOS = td2Dep.parent().value();
                if ((td2DepPOS.equals("IN") || td2DepPOS.equals("TO")) && td2Dep.value().equals(td1Dep.value())) {
                    conjDep = td2;
                    possibles2 = (Set)map.get(td2Dep);
                    if (possibles2 == null) continue;
                    for (TypedDependency td3 : possibles2) {
                        td3Dep = td3.dep();
                        td3DepPOS = td3Dep.parent().value();
                        if (!(td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || prep2Dep != null || td3DepPOS.equals("IN") || td3DepPOS.equals("TO"))) {
                            prep2Dep = td3;
                            if (td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                            pobj = false;
                            continue;
                        }
                        otherDtrs.add(td3);
                    }
                    continue;
                }
                if (!td2DepPOS.equals("IN") && !td2DepPOS.equals("TO")) continue;
                conjDep = td2;
                possibles2 = (Set)map.get(td2Dep);
                if (possibles2 == null) continue;
                for (TypedDependency td3 : possibles2) {
                    td3Dep = td3.dep();
                    td3DepPOS = td3Dep.parent().value();
                    if (!(td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || prepOtherDep != null || td3DepPOS.equals("IN") || td3DepPOS.equals("TO"))) {
                        prepOtherDep = td3;
                        if (td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                        pobj = false;
                        continue;
                    }
                    otherDtrs.add(td3);
                }
            }
            if (conjDep != null) {
                int index = conjDep.dep().index();
                for (TypedDependency td2 : possibles) {
                    if (td2.reln() == EnglishGrammaticalRelations.COORDINATION && td2.dep().index() < index) {
                        ccDep = td2;
                        continue;
                    }
                    TreeGraphNode td2Dep = td2.dep();
                    String td2DepPOS = td2Dep.parent().value();
                    if (!(td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER && td1.reln() != EnglishGrammaticalRelations.RELATIVE || td2.reln() != GrammaticalRelation.DEPENDENT && td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || !td1DepPOS.equals("IN") && !td1DepPOS.equals("TO") && !td1DepPOS.equals("VBG") || prepDep != null || td2DepPOS.equals("RB") || td2DepPOS.equals("IN") || td2DepPOS.equals("TO"))) {
                        prepDep = td2;
                        if (td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                        pobj = false;
                        continue;
                    }
                    if (td2 == conjDep) continue;
                    otherDtrs.add(td2);
                }
            }
            if (prepDep != null && ccDep != null && conjDep != null && prep2Dep != null) {
                TypedDependency tdNew2;
                boolean agent = false;
                if (td1Dep.value().equals("by")) {
                    Set aux_pass_poss = (Set)map.get(td1.gov());
                    if (aux_pass_poss != null) {
                        for (TypedDependency td_pass : aux_pass_poss) {
                            if (td_pass.reln() != EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER) continue;
                            agent = true;
                        }
                    }
                    if (!partmod.isEmpty() && partmod.contains(td1.gov())) {
                        agent = true;
                    }
                }
                if (agent) {
                    tdNew2 = new TypedDependency(EnglishGrammaticalRelations.AGENT, td1.gov(), prepDep.dep());
                } else {
                    GrammaticalRelation reln = td1.reln() == EnglishGrammaticalRelations.RELATIVE ? EnglishGrammaticalRelations.RELATIVE : (pobj ? EnglishGrammaticalRelations.getPrep(td1Dep.value().toLowerCase()) : EnglishGrammaticalRelations.getPrepC(td1Dep.value().toLowerCase()));
                    tdNew2 = new TypedDependency(reln, td1.gov(), prepDep.dep());
                }
                newTypedDeps.add(tdNew2);
                TypedDependency tdNew22 = new TypedDependency(EnglishGrammaticalStructure.conjValue(ccDep.dep().value()), prepDep.dep(), prep2Dep.dep());
                newTypedDeps.add(tdNew22);
                td1.setReln(GrammaticalRelation.KILL);
                prepDep.setReln(GrammaticalRelation.KILL);
                ccDep.setReln(GrammaticalRelation.KILL);
                conjDep.setReln(GrammaticalRelation.KILL);
                prep2Dep.setReln(GrammaticalRelation.KILL);
                for (TypedDependency otd : otherDtrs) {
                    if (otd.dep().parent().value().equals("IN")) {
                        otd.setReln(EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER);
                    }
                    otd.setGov(td1.gov());
                }
                for (TypedDependency td2 : possibles) {
                    if (td2.reln() == GrammaticalRelation.KILL || td2.gov() != td1.dep()) continue;
                    td2.setGov(td1.gov());
                }
            }
            if (ccDep != null && conjDep != null && prepDep != null && prepOtherDep == null) {
                prepOtherDep = new TypedDependency(prepDep.reln(), conjDep.dep(), prepDep.dep());
            }
            if (prepDep == null || ccDep == null || conjDep == null || prepOtherDep == null) continue;
            TreeGraphNode copy = new TreeGraphNode(td1.gov());
            CyclicCoreLabel label = new CyclicCoreLabel(td1.gov().label());
            label.set(CoreAnnotations.CopyAnnotation.class, true);
            copy.setLabel(label);
            boolean agent = false;
            if (td1Dep.value().equals("by")) {
                Set aux_pass_poss = (Set)map.get(td1.gov());
                if (aux_pass_poss != null) {
                    for (TypedDependency td_pass : aux_pass_poss) {
                        if (td_pass.reln() != EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER) continue;
                        agent = true;
                    }
                }
                if (!partmod.isEmpty() && partmod.contains(td1.gov())) {
                    agent = true;
                }
            }
            if (agent) {
                tdNew = new TypedDependency(EnglishGrammaticalRelations.AGENT, td1.gov(), prepDep.dep());
            } else {
                GrammaticalRelation reln = td1.reln() == EnglishGrammaticalRelations.RELATIVE ? EnglishGrammaticalRelations.RELATIVE : (pobj ? EnglishGrammaticalRelations.getPrep(td1Dep.value().toLowerCase()) : EnglishGrammaticalRelations.getPrepC(td1Dep.value().toLowerCase()));
                tdNew = new TypedDependency(reln, td1.gov(), prepDep.dep());
            }
            newTypedDeps.add(tdNew);
            TypedDependency tdNew2 = new TypedDependency(EnglishGrammaticalStructure.conjValue(ccDep.dep().value()), td1.gov(), copy);
            newTypedDeps.add(tdNew2);
            GrammaticalRelation reln = td1.reln() == EnglishGrammaticalRelations.RELATIVE ? EnglishGrammaticalRelations.RELATIVE : (pobj ? EnglishGrammaticalRelations.getPrep(prepOtherDep.gov().value().toLowerCase()) : EnglishGrammaticalRelations.getPrepC(prepOtherDep.gov().value().toLowerCase()));
            TypedDependency tdNew3 = new TypedDependency(reln, copy, prepOtherDep.dep());
            newTypedDeps.add(tdNew3);
            td1.setReln(GrammaticalRelation.KILL);
            prepDep.setReln(GrammaticalRelation.KILL);
            ccDep.setReln(GrammaticalRelation.KILL);
            conjDep.setReln(GrammaticalRelation.KILL);
            prepOtherDep.setReln(GrammaticalRelation.KILL);
            for (TypedDependency otd : otherDtrs) {
                if (otd.dep().parent().value().equals("IN")) {
                    otd.setReln(EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER);
                }
                otd.setGov(td1.gov());
            }
            for (TypedDependency td2 : possibles) {
                if (td2.reln() == GrammaticalRelation.KILL) continue;
                td2.setGov(td1.gov());
            }
        }
        for (TypedDependency td1 : list) {
            if (td1.reln() == GrammaticalRelation.KILL) continue;
            td1Dep = td1.dep();
            td1DepPOS = td1Dep.parent().value();
            possibles = (Set)map.get(td1Dep);
            if (possibles == null) continue;
            boolean agent = false;
            boolean pobj = true;
            for (TypedDependency td2 : possibles) {
                TypedDependency td3;
                if (td2.reln() == EnglishGrammaticalRelations.COORDINATION || td2.reln() == EnglishGrammaticalRelations.CONJUNCT) continue;
                TreeGraphNode td2Dep = td2.dep();
                String td2DepPOS = td2Dep.parent().value();
                if (td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER && td1.reln() != EnglishGrammaticalRelations.RELATIVE || td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || !td1DepPOS.equals("IN") && !td1DepPOS.equals("TO") && !td1DepPOS.equals("VBG") || td2DepPOS.equals("RB") || td2DepPOS.equals("IN") || td2DepPOS.equals("TO") || EnglishGrammaticalStructure.isConjWithNoPrep(td2.gov(), possibles)) continue;
                if (td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) {
                    pobj = false;
                }
                if (td1Dep.value().equals("by")) {
                    Set aux_pass_poss = (Set)map.get(td1.gov());
                    if (aux_pass_poss != null) {
                        for (TypedDependency td_pass : aux_pass_poss) {
                            if (td_pass.reln() != EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER) continue;
                            agent = true;
                        }
                    }
                    if (!partmod.isEmpty() && partmod.contains(td1.gov())) {
                        agent = true;
                    }
                }
                if (agent) {
                    td3 = new TypedDependency(EnglishGrammaticalRelations.AGENT, td1.gov(), td2.dep());
                    agent = false;
                } else {
                    GrammaticalRelation reln = td1.reln() == EnglishGrammaticalRelations.RELATIVE ? EnglishGrammaticalRelations.RELATIVE : (pobj ? EnglishGrammaticalRelations.getPrep(td1Dep.value().toLowerCase()) : EnglishGrammaticalRelations.getPrepC(td1Dep.value().toLowerCase()));
                    td3 = new TypedDependency(reln, td1.gov(), td2.dep());
                }
                newTypedDeps.add(td3);
                td1.setReln(GrammaticalRelation.KILL);
                td2.setReln(GrammaticalRelation.KILL);
            }
            if (td1.reln() != GrammaticalRelation.KILL) continue;
            for (TypedDependency td2 : possibles) {
                if (td2.reln() == GrammaticalRelation.KILL) continue;
                td2.setGov(td1.gov());
            }
        }
        for (TypedDependency td : list) {
            boolean keep = true;
            if (td.reln() == GrammaticalRelation.KILL) {
                keep = false;
            } else if (td.reln() == EnglishGrammaticalRelations.POSSESSIVE_MODIFIER) {
                keep = false;
                TreeGraphNode dep = td.dep();
                for (TypedDependency typedD : list) {
                    if (!typedD.gov().equals(dep)) continue;
                    keep = true;
                    break;
                }
            }
            if (!keep) continue;
            newTypedDeps.add(td);
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    private static boolean isConjWithNoPrep(TreeGraphNode node, Collection<TypedDependency> list) {
        for (TypedDependency td : list) {
            String tdDepPOS;
            if (td.gov() != node || td.reln() != EnglishGrammaticalRelations.CONJUNCT || (tdDepPOS = td.dep().parent().value()).equals("IN") || tdDepPOS.equals("TO")) continue;
            return true;
        }
        return false;
    }

    private static void collapse2WP(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (String[] mwp : MULTIWORD_PREPS) {
            EnglishGrammaticalStructure.collapseMultiWordPrep(list, newTypedDeps, mwp[0], mwp[1], mwp[0], mwp[1]);
            EnglishGrammaticalStructure.collapseMultiWordPrep(list, newTypedDeps, mwp[0], mwp[1], mwp[1], mwp[0]);
        }
    }

    private static void collapseMultiWordPrep(Collection<TypedDependency> list, Collection<TypedDependency> newTypedDeps, String str_mwp0, String str_mwp1, String w_mwp0, String w_mwp1) {
        TreeGraphNode mwp0 = null;
        TreeGraphNode mwp1 = null;
        TypedDependency dep = null;
        for (TypedDependency td : list) {
            if (!td.gov().value().equalsIgnoreCase(w_mwp0) || !td.dep().value().equalsIgnoreCase(w_mwp1) || Math.abs(td.gov().index() - td.dep().index()) != 1) continue;
            mwp0 = td.gov();
            mwp1 = td.dep();
            dep = td;
        }
        TreeGraphNode governor = null;
        TypedDependency prep = null;
        for (TypedDependency td1 : list) {
            if (td1.dep() != mwp0 || td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER && td1.reln() != EnglishGrammaticalRelations.ADVERBIAL_MODIFIER && td1.reln() != EnglishGrammaticalRelations.ADJECTIVAL_MODIFIER && td1.reln() != GrammaticalRelation.DEPENDENT) continue;
            prep = td1;
            governor = prep.gov();
        }
        TypedDependency pobj = null;
        TypedDependency newtd = null;
        for (TypedDependency td2 : list) {
            if (td2.gov() != mwp1 && td2.gov() != mwp0 || td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || pobj != null && pobj.dep().index() <= td2.dep().index()) continue;
            pobj = td2;
            GrammaticalRelation gr = td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT ? EnglishGrammaticalRelations.getPrepC(str_mwp0 + '_' + str_mwp1) : EnglishGrammaticalRelations.getPrep(str_mwp0 + '_' + str_mwp1);
            if (governor == null) continue;
            newtd = new TypedDependency(gr, governor, pobj.dep());
        }
        if (prep != null && dep != null && pobj != null && newtd != null) {
            prep.setReln(GrammaticalRelation.KILL);
            dep.setReln(GrammaticalRelation.KILL);
            pobj.setReln(GrammaticalRelation.KILL);
            newTypedDeps.add(newtd);
            for (TypedDependency td1 : list) {
                if (td1.reln() == GrammaticalRelation.KILL) continue;
                if (td1.gov() == mwp0 || td1.gov() == mwp1) {
                    if (td1.reln() == EnglishGrammaticalRelations.TEMPORAL_MODIFIER) {
                        td1.setGov(pobj.dep());
                    } else {
                        td1.setGov(governor);
                    }
                }
                if (newTypedDeps.contains(td1)) continue;
                newTypedDeps.add(td1);
            }
            list.clear();
            list.addAll(newTypedDeps);
        }
    }

    private static void collapse2WPbis(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (String[] mwp : MULTIWORD_PREPS) {
            TreeGraphNode mwp0 = null;
            TreeGraphNode mwp1 = null;
            TreeGraphNode governor = null;
            TypedDependency prep = null;
            TypedDependency dep = null;
            TypedDependency pobj = null;
            TypedDependency newtd = null;
            for (TypedDependency td : list) {
                if (!td.dep().value().equalsIgnoreCase(mwp[0]) || td.reln() != EnglishGrammaticalRelations.PHRASAL_VERB_PARTICLE && td.reln() != EnglishGrammaticalRelations.ADVERBIAL_MODIFIER && td.reln() != GrammaticalRelation.DEPENDENT) continue;
                governor = td.gov();
                mwp0 = td.dep();
                dep = td;
            }
            for (TypedDependency td1 : list) {
                if (mwp0 == null || !td1.dep().value().equalsIgnoreCase(mwp[1]) || td1.gov() != governor || td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER || Math.abs(td1.dep().index() - mwp0.index()) != 1) continue;
                mwp1 = td1.dep();
                prep = td1;
            }
            for (TypedDependency td2 : list) {
                GrammaticalRelation gr;
                if (td2.gov() == mwp1 && td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT) {
                    pobj = td2;
                    gr = EnglishGrammaticalRelations.getPrep(mwp[0] + '_' + mwp[1]);
                    if (governor != null) {
                        newtd = new TypedDependency(gr, governor, pobj.dep());
                    }
                }
                if (td2.gov() != mwp1 || td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                pobj = td2;
                gr = EnglishGrammaticalRelations.getPrepC(mwp[0] + '_' + mwp[1]);
                if (governor == null) continue;
                newtd = new TypedDependency(gr, governor, pobj.dep());
            }
            if (prep == null || pobj == null || newtd == null) continue;
            prep.setReln(GrammaticalRelation.KILL);
            dep.setReln(GrammaticalRelation.KILL);
            pobj.setReln(GrammaticalRelation.KILL);
            newTypedDeps.add(newtd);
            for (TypedDependency td1 : list) {
                if (td1.reln() == GrammaticalRelation.KILL) continue;
                if (td1.gov() == mwp0 || td1.gov() == mwp1) {
                    td1.setGov(governor);
                }
                if (newTypedDeps.contains(td1)) continue;
                newTypedDeps.add(td1);
            }
            list.clear();
            list.addAll(newTypedDeps);
        }
    }

    private static void collapse3WP(Collection<TypedDependency> list) {
        GrammaticalRelation gr;
        TypedDependency newtd;
        TypedDependency pobj;
        TypedDependency prep;
        TreeGraphNode governor;
        TypedDependency dep2;
        TypedDependency dep1;
        TreeGraphNode mwp2;
        TreeGraphNode mwp1;
        TreeGraphNode mwp0;
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (String[] mwp : THREEWORD_PREPS) {
            mwp0 = null;
            mwp1 = null;
            mwp2 = null;
            dep1 = null;
            dep2 = null;
            for (TypedDependency td : list) {
                if (!td.gov().value().equalsIgnoreCase(mwp[0]) || !td.dep().value().equalsIgnoreCase(mwp[1]) || Math.abs(td.gov().index() - td.dep().index()) != 1) continue;
                mwp0 = td.gov();
                mwp1 = td.dep();
                dep1 = td;
            }
            for (TypedDependency td : list) {
                if (td.gov() != mwp1 || !td.dep().value().equalsIgnoreCase(mwp[2]) || Math.abs(td.gov().index() - td.dep().index()) != 1) continue;
                mwp2 = td.dep();
                dep2 = td;
            }
            if (dep1 == null || dep2 == null) continue;
            governor = null;
            prep = null;
            for (TypedDependency td1 : list) {
                if (td1.dep() != mwp0 || td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER) continue;
                prep = td1;
                governor = prep.gov();
            }
            pobj = null;
            newtd = null;
            for (TypedDependency td2 : list) {
                if (td2.gov() == mwp2 && td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT) {
                    pobj = td2;
                    gr = EnglishGrammaticalRelations.getPrep(mwp[0] + '_' + mwp[1] + '_' + mwp[2]);
                    if (governor != null) {
                        newtd = new TypedDependency(gr, governor, pobj.dep());
                    }
                }
                if (td2.gov() != mwp2 || td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                pobj = td2;
                gr = EnglishGrammaticalRelations.getPrepC(mwp[0] + '_' + mwp[1] + '_' + mwp[2]);
                if (governor == null) continue;
                newtd = new TypedDependency(gr, governor, pobj.dep());
            }
            if (prep == null || pobj == null || newtd == null) continue;
            prep.setReln(GrammaticalRelation.KILL);
            dep1.setReln(GrammaticalRelation.KILL);
            dep2.setReln(GrammaticalRelation.KILL);
            pobj.setReln(GrammaticalRelation.KILL);
            newTypedDeps.add(newtd);
            for (TypedDependency td1 : list) {
                if (td1.reln() == GrammaticalRelation.KILL) continue;
                if (td1.gov() == mwp0 || td1.gov() == mwp1 || td1.gov() == mwp2) {
                    td1.setGov(governor);
                }
                if (newTypedDeps.contains(td1)) continue;
                newTypedDeps.add(td1);
            }
            list.clear();
            list.addAll(newTypedDeps);
        }
        for (String[] mwp : THREEWORD_PREPS) {
            mwp0 = null;
            mwp1 = null;
            mwp2 = null;
            dep1 = null;
            dep2 = null;
            for (TypedDependency td : list) {
                if (!td.gov().value().equalsIgnoreCase(mwp[0]) || !td.dep().value().equalsIgnoreCase(mwp[1]) || Math.abs(td.gov().index() - td.dep().index()) != 1) continue;
                mwp0 = td.gov();
                mwp1 = td.dep();
                dep1 = td;
            }
            for (TypedDependency td : list) {
                if (td.gov() != mwp0 || !td.dep().value().equalsIgnoreCase(mwp[2]) || Math.abs(td.gov().index() - td.dep().index()) != 2) continue;
                mwp2 = td.dep();
                dep2 = td;
            }
            if (dep1 == null || dep2 == null) continue;
            governor = null;
            prep = null;
            for (TypedDependency td1 : list) {
                if (td1.dep() != mwp0 || td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER) continue;
                prep = td1;
                governor = prep.gov();
            }
            pobj = null;
            newtd = null;
            for (TypedDependency td2 : list) {
                if (td2.gov() == mwp0 && td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT) {
                    pobj = td2;
                    gr = EnglishGrammaticalRelations.getPrep(mwp[0] + '_' + mwp[1] + '_' + mwp[2]);
                    if (governor != null) {
                        newtd = new TypedDependency(gr, governor, pobj.dep());
                    }
                }
                if (td2.gov() != mwp0 || td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                pobj = td2;
                gr = EnglishGrammaticalRelations.getPrepC(mwp[0] + '_' + mwp[1] + '_' + mwp[2]);
                if (governor == null) continue;
                newtd = new TypedDependency(gr, governor, pobj.dep());
            }
            if (prep == null || pobj == null || newtd == null) continue;
            prep.setReln(GrammaticalRelation.KILL);
            dep1.setReln(GrammaticalRelation.KILL);
            dep2.setReln(GrammaticalRelation.KILL);
            pobj.setReln(GrammaticalRelation.KILL);
            newTypedDeps.add(newtd);
            for (TypedDependency td1 : list) {
                if (td1.reln() == GrammaticalRelation.KILL) continue;
                if (td1.gov() == mwp0 || td1.gov() == mwp1 || td1.gov() == mwp2) {
                    td1.setGov(governor);
                }
                if (newTypedDeps.contains(td1)) continue;
                newTypedDeps.add(td1);
            }
            list.clear();
            list.addAll(newTypedDeps);
        }
    }

    private static void collapseFlatMWP(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (String[] mwp : MULTIWORD_PREPS) {
            TreeGraphNode mwp1 = null;
            TreeGraphNode governor = null;
            TypedDependency prep = null;
            TypedDependency dep = null;
            TypedDependency pobj = null;
            for (TypedDependency td : list) {
                if (!td.gov().value().equalsIgnoreCase(mwp[1]) || !td.dep().value().equalsIgnoreCase(mwp[0]) || Math.abs(td.gov().index() - td.dep().index()) != 1) continue;
                mwp1 = td.gov();
                dep = td;
            }
            for (TypedDependency td1 : list) {
                if (td1.dep() != mwp1 || td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER) continue;
                prep = td1;
                governor = prep.gov();
            }
            for (TypedDependency td2 : list) {
                GrammaticalRelation gr;
                if (td2.gov() == mwp1 && td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT) {
                    pobj = td2;
                    gr = EnglishGrammaticalRelations.getPrep(mwp[0] + '_' + mwp[1]);
                    newTypedDeps.add(new TypedDependency(gr, governor, pobj.dep()));
                }
                if (td2.gov() != mwp1 || td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                pobj = td2;
                gr = EnglishGrammaticalRelations.getPrepC(mwp[0] + '_' + mwp[1]);
                newTypedDeps.add(new TypedDependency(gr, governor, pobj.dep()));
            }
            if (prep == null || dep == null || pobj == null) continue;
            prep.setReln(GrammaticalRelation.KILL);
            dep.setReln(GrammaticalRelation.KILL);
            pobj.setReln(GrammaticalRelation.KILL);
            for (TypedDependency td1 : list) {
                if (td1.reln() == GrammaticalRelation.KILL) continue;
                if (td1.gov() == mwp1) {
                    td1.setGov(governor);
                }
                if (newTypedDeps.contains(td1)) continue;
                newTypedDeps.add(td1);
            }
            list.clear();
            list.addAll(newTypedDeps);
        }
    }

    private static void eraseMultiConj(Collection<TypedDependency> list) {
        for (TypedDependency td1 : list) {
            if (td1.reln() != EnglishGrammaticalRelations.COORDINATION) continue;
            TreeGraphNode x = td1.dep();
            for (TypedDependency td2 : list) {
                if (!td2.gov().equals(x) || td2.reln() != GrammaticalRelation.DEPENDENT) continue;
                td2.setReln(GrammaticalRelation.KILL);
            }
        }
        Iterator<TypedDependency> iter = list.iterator();
        while (iter.hasNext()) {
            TypedDependency td = iter.next();
            if (td.reln() != GrammaticalRelation.KILL) continue;
            iter.remove();
        }
    }

    private static void printDependencies(Collection<TypedDependency> deps, Tree tree, boolean conllx) {
        if (conllx) {
            List<Tree> leaves = tree.getLeaves();
            ArrayList<String> words = new ArrayList<String>(leaves.size());
            ArrayList<String> pos = new ArrayList<String>(leaves.size());
            String[] relns = new String[leaves.size()];
            int[] govs = new int[leaves.size()];
            for (Tree leaf : leaves) {
                words.add(leaf.value());
                pos.add(leaf.parent(tree).value());
            }
            for (TypedDependency dep : deps) {
                int depIdx = dep.dep().index() - 1;
                govs[depIdx] = dep.gov().index();
                relns[depIdx] = dep.reln().toString();
            }
            for (int i = 0; i < relns.length; ++i) {
                System.out.printf("%d\t%s\t_\t%s\t%s\t_\t%d\t%s\t_\t_\n", i + 1, words.get(i), pos.get(i), pos.get(i), govs[i], relns[i]);
            }
            System.out.println();
        } else {
            System.out.println(StringUtils.join(deps, "\n"));
            System.out.println();
        }
    }

    public static List<GrammaticalStructure> readCoNLLXGrammaticStructureCollection(String fileName) throws IOException {
        LineNumberReader reader = new LineNumberReader(new FileReader(fileName));
        LinkedList<GrammaticalStructure> gsList = new LinkedList<GrammaticalStructure>();
        ArrayList<List<String>> tokenFields = new ArrayList<List<String>>();
        String inline = reader.readLine();
        while (inline != null) {
            if (!"".equals(inline)) {
                List<String> fields = Arrays.asList(inline.split("\t"));
                if (fields.size() != 10) {
                    throw new RuntimeException(String.format("Error (line %d): 10 fields expected but %d are present", reader.getLineNumber(), fields.size()));
                }
                tokenFields.add(fields);
            } else if (!tokenFields.isEmpty()) {
                ArrayList<TreeGraphNode> tgWordNodes = new ArrayList<TreeGraphNode>(tokenFields.size());
                ArrayList<TreeGraphNode> tgPOSNodes = new ArrayList<TreeGraphNode>(tokenFields.size());
                for (List list : tokenFields) {
                    TreeGraphNode word = new TreeGraphNode(new Word((String)list.get(1)));
                    TreeGraphNode pos = new TreeGraphNode(new Word((String)list.get(3)));
                    tgWordNodes.add(word);
                    tgPOSNodes.add(pos);
                    Tree[] childArr = new TreeGraphNode[]{word};
                    pos.setChildren(childArr);
                    word.setParent(pos);
                }
                TreeGraphNode root = new TreeGraphNode(new Word("-" + (tgWordNodes.size() + 1)));
                root.setChildren(tgPOSNodes.toArray(new TreeGraphNode[tgPOSNodes.size()]));
                ArrayList<TypedDependency> arrayList = new ArrayList<TypedDependency>(tgWordNodes.size());
                for (int i = 0; i < tgWordNodes.size(); ++i) {
                    String parentIdStr = (String)((List)tokenFields.get(i)).get(6);
                    int parentId = Integer.parseInt(parentIdStr) - 1;
                    String grelString = (String)((List)tokenFields.get(i)).get(7);
                    if (parentId == -1 || grelString.equals("null")) continue;
                    GrammaticalRelation grel = shortNameToGRel.get(grelString);
                    if (grel == null) {
                        throw new RuntimeException("Unknown grammatical relation " + grelString + " fields: " + tokenFields.get(i) + "\nNode: " + tgWordNodes.get(i));
                    }
                    TypedDependency tdep = new TypedDependency(grel, (TreeGraphNode)tgWordNodes.get(parentId), (TreeGraphNode)tgWordNodes.get(i));
                    arrayList.add(tdep);
                }
                gsList.add(new EnglishGrammaticalStructure(arrayList, root));
                tokenFields = new ArrayList();
            }
            inline = reader.readLine();
        }
        return gsList;
    }

    public static void main(String[] args) {
        boolean portray;
        MemoryTreebank tb = new MemoryTreebank(new TreeNormalizer());
        Collection<GrammaticalStructure> gsBank = null;
        Properties props = StringUtils.argsToProperties(args);
        String treeFileName = props.getProperty("treeFile");
        String sentFileName = props.getProperty("sentFile");
        String conllXFileName = props.getProperty("conllxFile");
        if (sentFileName == null && treeFileName == null && conllXFileName == null) {
            try {
                System.err.println("Usage: java EnglishGrammaticalStructure [options]* [-sentFile|-treeFile|-conllxFile file] [-testGraph]");
                System.err.println("  options: -basic, -collapsed, -CCprocessed [the default], -collapsedTree, -parseTree, -test, -parserFile file, -conllx, -keepPunct");
                PennTreeReader tr = new PennTreeReader((Reader)new StringReader("((S (NP (NNP Sam)) (VP (VBD died) (NP-TMP (NN today)))))"), new LabeledScoredTreeFactory());
                ((AbstractCollection)tb).add(tr.readTree());
            }
            catch (Exception e) {
                System.err.println("Horrible error: " + e);
                e.printStackTrace();
            }
        } else if (treeFileName != null) {
            tb.loadPath(treeFileName);
        } else {
            BufferedReader reader;
            ViterbiParserWithOptions lp;
            if (conllXFileName != null) {
                try {
                    gsBank = EnglishGrammaticalStructure.readCoNLLXGrammaticStructureCollection(conllXFileName);
                }
                catch (IOException e) {
                    System.err.println("Error reading " + conllXFileName);
                    return;
                }
            }
            String parserFile = props.getProperty("parserFile");
            if (parserFile == null || "".equals(parserFile)) {
                parserFile = DEFAULT_PARSER_FILE;
            }
            try {
                Class[] classes = new Class[]{String.class};
                Constructor<?> constr = Class.forName("edu.stanford.nlp.parser.lexparser.LexicalizedParser").getConstructor(classes);
                String[] opts = new String[]{"-retainTmpSubcategories"};
                lp = (ViterbiParserWithOptions)constr.newInstance(parserFile);
                lp.setOptionFlags(opts);
            }
            catch (Exception cnfe) {
                cnfe.printStackTrace();
                return;
            }
            try {
                reader = new BufferedReader(new FileReader(sentFileName));
            }
            catch (IOException e) {
                System.err.println("Cannot open file " + sentFileName);
                return;
            }
            try {
                String line;
                System.err.println("Processing sentence file " + sentFileName);
                while ((line = reader.readLine()) != null) {
                    PTBTokenizer<Word> ptb = PTBTokenizer.newPTBTokenizer(new StringReader(line));
                    List words = ptb.tokenize();
                    lp.parse(words);
                    Tree parseTree = lp.getBestParse();
                    ((AbstractCollection)tb).add(parseTree);
                }
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("IOexception reading key file " + sentFileName);
                return;
            }
        }
        boolean basic = props.getProperty("basic") != null;
        boolean collapsed = props.getProperty("collapsed") != null;
        boolean CCprocessed = props.getProperty("CCprocessed") != null;
        boolean tree = props.getProperty("collapsedTree") != null;
        boolean parseTree = props.getProperty("parseTree") != null;
        boolean test = props.getProperty("test") != null;
        boolean conllx = props.getProperty("conllx") != null;
        boolean keepPunct = props.getProperty("keepPunct") != null;
        boolean checkConnected = props.getProperty("checkConnected") != null;
        boolean bl = portray = props.getProperty("portray") != null;
        if (conllXFileName == null) {
            gsBank = new TreeBankGrammaticalStructureWrapper(tb, keepPunct);
        }
        for (GrammaticalStructure gs : gsBank) {
            Tree t = gsBank instanceof TreeBankGrammaticalStructureWrapper ? ((TreeBankGrammaticalStructureWrapper)gsBank).getOriginalTree(gs) : gs.root();
            if (test) {
                System.out.println("============= parse tree =======================");
                t.pennPrint();
                System.out.println();
                System.out.println("------------- GrammaticalStructure -------------");
                System.out.println(gs);
                System.out.println("------------- basic dependencies ---------------");
                System.out.println(StringUtils.join(gs.typedDependencies(false), "\n"));
                System.out.println("------------- collapsed dependencies -----------");
                System.out.println(StringUtils.join(gs.typedDependenciesCollapsed(true), "\n"));
                System.out.println("------------- collapsed dependencies tree -----------");
                System.out.println(StringUtils.join(gs.typedDependenciesCollapsedTree(), "\n"));
                System.out.println("------------- CCprocessed dependencies --------");
                System.out.println(StringUtils.join(gs.typedDependenciesCCprocessed(true), "\n"));
                System.out.println("-----------------------------------------------");
                boolean connected = GrammaticalStructure.isConnected(gs.typedDependenciesCollapsed(true));
                System.out.println("collapsed dependencies form a connected graph: " + connected);
                if (!connected) {
                    System.out.println("possible offending nodes: " + GrammaticalStructure.getRoots(gs.typedDependenciesCollapsed(true)));
                }
            } else {
                if (parseTree) {
                    System.out.println("============= parse tree =======================");
                    t.pennPrint();
                    System.out.println();
                }
                if (basic) {
                    if (collapsed || CCprocessed || tree) {
                        System.out.println("------------- basic dependencies ---------------");
                    }
                    EnglishGrammaticalStructure.printDependencies(gs.typedDependencies(false), t, conllx);
                }
                if (collapsed) {
                    if (basic || CCprocessed || tree) {
                        System.out.println("----------- collapsed dependencies -----------");
                    }
                    EnglishGrammaticalStructure.printDependencies(gs.typedDependenciesCollapsed(true), t, conllx);
                }
                if (CCprocessed) {
                    if (basic || collapsed || tree) {
                        System.out.println("---------- CCprocessed dependencies ----------");
                    }
                    List<TypedDependency> deps = gs.typedDependenciesCCprocessed(true);
                    if (checkConnected && !GrammaticalStructure.isConnected(deps)) {
                        System.err.println("Graph is not connected for:");
                        System.err.println(t);
                        System.err.println("possible offending nodes: " + GrammaticalStructure.getRoots(deps));
                    }
                    EnglishGrammaticalStructure.printDependencies(deps, t, conllx);
                }
                if (tree) {
                    if (basic || CCprocessed || collapsed) {
                        System.out.println("----------- collapsed dependencies tree-----------");
                    }
                    EnglishGrammaticalStructure.printDependencies(gs.typedDependenciesCollapsedTree(), t, conllx);
                }
                if (!(basic || collapsed || CCprocessed || tree)) {
                    EnglishGrammaticalStructure.printDependencies(gs.typedDependenciesCCprocessed(true), t, conllx);
                }
            }
            if (!portray) continue;
            try {
                Class<?> sgu = Class.forName("edu.stanford.nlp.trees.semgraph.SemanticGraphUtils");
                Method m = sgu.getDeclaredMethod("render", GrammaticalStructure.class, String.class);
                m.invoke(null, gs, "Collapsed, CC processed deps");
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't use swing to portray semantic graph", e);
            }
        }
    }

    static {
        for (GrammaticalRelation gr : EnglishGrammaticalRelations.values()) {
            shortNameToGRel.put(gr.getShortName(), gr);
        }
    }
}

