/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.trees.AbstractCollinsHeadFinder;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.pennchinese.ChineseTreebankLanguagePack;
import java.util.HashMap;

public class ChineseHeadFinder
extends AbstractCollinsHeadFinder {
    private static final boolean coordSwitch = false;
    private static final long serialVersionUID = 6143632784691159283L;

    public ChineseHeadFinder() {
        this(new ChineseTreebankLanguagePack());
    }

    public ChineseHeadFinder(TreebankLanguagePack tlp) {
        super(tlp);
        this.nonTerminalInfo = new HashMap();
        String left = "left";
        String right = "right";
        String rightdis = "rightdis";
        this.defaultRule = new String[]{right};
        this.nonTerminalInfo.put("ROOT", new String[][]{{left, "IP"}});
        this.nonTerminalInfo.put("PAIR", new String[][]{{left, "IP"}});
        this.nonTerminalInfo.put("ADJP", new String[][]{{left, "JJ", "ADJP"}});
        this.nonTerminalInfo.put("ADVP", new String[][]{{left, "AD", "CS", "ADVP", "JJ"}});
        this.nonTerminalInfo.put("CLP", new String[][]{{right, "M", "CLP"}});
        this.nonTerminalInfo.put("CP", new String[][]{{right, "DEC", "WHNP", "WHPP"}});
        this.nonTerminalInfo.put("DNP", new String[][]{{right, "DEG"}});
        this.nonTerminalInfo.put("DP", new String[][]{{left, "DT", "DP"}});
        this.nonTerminalInfo.put("DVP", new String[][]{{right, "DEV"}});
        this.nonTerminalInfo.put("FRAG", new String[][]{{right, "VV", "NN"}});
        this.nonTerminalInfo.put("INTJ", new String[][]{{right, "INTJ", "IJ", "SP"}});
        this.nonTerminalInfo.put("IP", new String[][]{{left, "IP", "VP"}});
        this.nonTerminalInfo.put("LCP", new String[][]{{right, "LC", "LCP"}});
        this.nonTerminalInfo.put("LST", new String[][]{{right, "CD", "PU"}});
        this.nonTerminalInfo.put("NP", new String[][]{{right, "NN", "NR", "NT", "NP", "PN", "CP"}});
        this.nonTerminalInfo.put("PP", new String[][]{{left, "P", "PP"}});
        this.nonTerminalInfo.put("PRN", new String[][]{{left, "NP", "VP", "IP", "QP", "PP", "ADJP", "CLP", "LCP"}, {rightdis, "NN", "NR", "NT", "FW"}});
        this.nonTerminalInfo.put("QP", new String[][]{{right, "QP", "CLP", "CD", "OD", "NP", "NT", "M"}});
        this.nonTerminalInfo.put("UCP", new String[][]{{left}});
        this.nonTerminalInfo.put("VP", new String[][]{{left, "VP", "VPT", "VV", "VA", "VC", "VE", "IP"}});
        this.nonTerminalInfo.put("VCD", new String[][]{{left, "VCD", "VV", "VA", "VC", "VE"}});
        this.nonTerminalInfo.put("VCP", new String[][]{{left, "VCD", "VV", "VA", "VC", "VE"}});
        this.nonTerminalInfo.put("VRD", new String[][]{{left, "VCD", "VRD", "VV", "VA", "VC", "VE"}});
        this.nonTerminalInfo.put("VSB", new String[][]{{right, "VCD", "VSB", "VV", "VA", "VC", "VE"}});
        this.nonTerminalInfo.put("VNV", new String[][]{{left, "VV", "VA", "VC", "VE"}});
        this.nonTerminalInfo.put("VPT", new String[][]{{left, "VV", "VA", "VC", "VE"}});
        this.nonTerminalInfo.put("CD", new String[][]{{right, "CD"}});
        this.nonTerminalInfo.put("NN", new String[][]{{right, "NN"}});
        this.nonTerminalInfo.put("NR", new String[][]{{right, "NR"}});
        this.nonTerminalInfo.put("VV", new String[][]{{left}});
        this.nonTerminalInfo.put("VA", new String[][]{{left}});
        this.nonTerminalInfo.put("VC", new String[][]{{left}});
        this.nonTerminalInfo.put("VE", new String[][]{{left}});
        this.nonTerminalInfo.put("FLR", new String[][]{{left}});
    }
}

