/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.Generics;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnglishGrammaticalRelations {
    private static final String timeWordRegex = "/(?i)^Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|February|March|April|May|June|July|August|September|October|November|December|today|yesterday|tomorrow|spring|summer|fall|autumn|winter$/";
    private static final String timeWordLotRegex = "/(?i)^Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|February|March|April|May|June|July|August|September|October|November|December|today|yesterday|tomorrow|spring|summer|fall|autumn|winter|lot$/";
    public static final GrammaticalRelation PREDICATE = new GrammaticalRelation(GrammaticalRelation.Language.English, "pred", "predicate", PredicateGRAnnotation.class, GrammaticalRelation.DEPENDENT, "S|SINV", new String[]{"S < VP=target"});
    public static final GrammaticalRelation AUX_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "aux", "auxiliary", AuxModifierGRAnnotation.class, GrammaticalRelation.DEPENDENT, "VP|SQ|SINV", new String[]{"VP < VP < /^(?:TO|MD|VB.*|AUXG?)$/=target", "SQ|SINV < (/^VB|MD|AUXG?/=target $++ /^(?:VP|ADJP)/)"});
    public static final GrammaticalRelation AUX_PASSIVE_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "auxpass", "passive auxiliary", AuxPassiveGRAnnotation.class, AUX_MODIFIER, "VP|SQ", new String[]{"VP < (/^(?:VB|AUXG?)/=target < /be|was|'s|is|are|were|been|being|am|Been|Being|WAS|IS|get|got|getting|gets|Get|gotten|becomes|become|became|felt|feels|feel|seems|seem|seemed|remains|remained|remain/) < (VP|ADJP < VBN|VBD)", "VP < (/^(?:VB|AUXG?)/=target < /be|was|'s|is|are|were|been|being|am|Been|Being|WAS|IS|get|got|getting|gets|Get|gotten|becomes|become|became|felt|feels|feel|seems|seem|seemed|remains|remained|remain/) < (VP|ADJP < (VP|ADJP < VBN|VBD) < CC)", "SQ < (/^(?:VB|AUX)/=target < /^(?:was|is|are|were|am|Was|Is|Are|Were|Am|WAS|IS|ARE|WERE|AM)$/ $++ (VP < /^VB[DN]$/))"});
    public static final GrammaticalRelation COPULA = new GrammaticalRelation(GrammaticalRelation.Language.English, "cop", "copula", CopulaGRAnnotation.class, AUX_MODIFIER, "VP|SQ", new String[]{"VP < (/^VB|AUX?/=target < /(?i)^(?:am|'m|are|'re|is|'s|be|being|was|were|seem|seems|seemed|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|become|becomes|became)$/ [ $++ (ADJP|NP !< VBN) | $++ (S <: (ADJP < JJ)) ] )", "SQ <, (/^VB|AUX?/=target < /(?i)^(am|are|is|was|were)$/) !$ /^WH*/"});
    public static final GrammaticalRelation CONJUNCT = new GrammaticalRelation(GrammaticalRelation.Language.English, "conj", "conjunct", ConjunctGRAnnotation.class, GrammaticalRelation.DEPENDENT, "VP|NP|ADJP|PP|QP|ADVP|UCP|S|NX|SBAR", new String[]{"VP|ADJP|PP|QP|NP|ADVP|UCP|S|NX|SBAR < (CC|CONJP $- __ $+ !/^(?:PRN|,)$/=target) !<, CC", "VP|ADJP|PP|NP|ADVP|UCP|S|NX|SBAR < (CC|CONJP $- __ $+ (ADVP $+ !/^(?:PRN|,)$/=target))", "VP|ADJP|PP|NP|ADVP|UCP|S|NX|SBAR < (CC|CONJP $- __) < (/^(?:,|PRN)$/ $+ /^S$|^(A|N|V|PP|PRP|J|W|R)/=target)", "NX < (CC|CONJP $- __) < (/^,$/ $- /^(A|N|V|PP|PRP|J|W|R|S)/=target)", "VP|ADJP|PP|QP|NP|ADVP|UCP|S|NX|SBAR < (CC $++ (CC|CONJP $+ !/^(?:PRN|,)$/=target))"});
    public static final GrammaticalRelation COORDINATION = new GrammaticalRelation(GrammaticalRelation.Language.English, "cc", "coordination", CoordinationGRAnnotation.class, GrammaticalRelation.DEPENDENT, "S|VP|NP|ADJP|PP|QP|ADVP|UCP|NX|SBAR", new String[]{"S|VP|NP|QP|ADJP|PP|ADVP|UCP|NX|SBAR < (CC|CONJP=target !< /either|neither|both|Either|Neither|Both/)"});
    public static final GrammaticalRelation PUNCTUATION = new GrammaticalRelation(GrammaticalRelation.Language.English, "punct", "punctuation", PunctuationGRAnnotation.class, GrammaticalRelation.DEPENDENT, ".*", new String[]{"__ < /^(?:\\.|:|,|''|``|-LRB-|-RRB-)$/=target"});
    public static final GrammaticalRelation ARGUMENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "arg", "argument", ArgumentGRAnnotation.class, GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation SUBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "subj", "subject", SubjectGRAnnotation.class, ARGUMENT);
    public static final GrammaticalRelation NOMINAL_SUBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "nsubj", "nominal subject", NominalSubjectGRAnnotation.class, SUBJECT, "S|SQ|SBARQ|SINV|SBAR", new String[]{"S < ((NP|WHNP=target !< EX !< (/^NN/ < (/(?i)^Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|February|March|April|May|June|July|August|September|October|November|December|today|yesterday|tomorrow|spring|summer|fall|autumn|winter$/))) $++ VP)", "S < ( NP=target < (/^NN/ < /(?i)^Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|February|March|April|May|June|July|August|September|October|November|December|today|yesterday|tomorrow|spring|summer|fall|autumn|winter$/) !$++ NP $++VP)", "SQ < ((NP=target !< EX) $++ VP)", "SQ < ((NP=target !< EX) $- /^VB|AUX/ !$++ VP)", "SQ < ((NP=target !< EX) $- (RB $- /^VB|AUX/) ![$++ VP])", "SBARQ < WHNP=target < (SQ < (VP ![$-- NP]))", "SBARQ < (SQ=target < /^VB|AUX/ !< VP)", "SINV < (/^NP|WHNP$/=target [ $- VP|VBZ|VBD|VBP|VB|MD|AUX | $- (@RB|ADVP $- VP|VBZ|VBD|VBP|VB|MD|AUX) ] )", "S < (NP=target $+ NP|ADJP) > VP", "SBAR <, WHNP=target [ < (S < (VP !$-- NP) !< SBAR) | < (VP !$-- NP) !< S ]", "SBAR !< WHNP < (S !< (NP $++ VP)) > (VP > (S $- WHNP=target))", "SQ < ((NP < EX) $++ NP=target)", "S < (NP < EX) < (VP < NP=target)"});
    public static final GrammaticalRelation NOMINAL_PASSIVE_SUBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "nsubjpass", "nominal passive subject", NominalPassiveSubjectGRAnnotation.class, NOMINAL_SUBJECT, "S|VP", new String[]{"S < /^NP|WHNP$/=target < (VP|SQ < (VP < VBN|VBD) < (/^(VB|AUXG?)/ < /be|was|is|are|were|been|being|'s|'re|'m|am|Been|Being|WAS|IS|get|got|getting|gets|Get|gotten|becomes|become|became|felt|feels|feel|seems|seem|seemed|remains|remained|remain/))", "S < /^(NP|WHNP)$/=target < (VP|SQ <+(VP) (VP < VBN|VBD > (VP < (/^(VB|AUXG?)/ < /be|was|is|are|were|been|being|'s|'re|'m|am|Been|Being|WAS|IS|get|got|getting|gets|Get|gotten|becomes|become|became|felt|feels|feel|seems|seem|seemed|remains|remained|remain/))))"});
    public static final GrammaticalRelation CLAUSAL_SUBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "csubj", "clausal subject", ClausalSubjectGRAnnotation.class, SUBJECT, "S", new String[]{"S < (SBAR|S=target !$+ /^,$/ $++ (VP !$-- NP))"});
    public static final GrammaticalRelation CLAUSAL_PASSIVE_SUBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "csubjpass", "clausal subject", ClausalPassiveSubjectGRAnnotation.class, CLAUSAL_SUBJECT, "S", new String[]{"S < (SBAR|S=target !$+ /^,$/ $++ (VP < (VP < VBN|VBD) < (/^(VB|AUXG?)/ < /be|was|is|are|were|been|being|'s|'re|'m|am|Been|Being|WAS|IS|get|got|getting|gets|Get|gotten|becomes|become|became|felt|feels|feel|seems|seem|seemed|remains|remained|remain/) !$-- NP))", "S < (SBAR|S=target !$+ /^,$/ $++ (VP <+(VP) (VP < VBN|VBD > (VP < (/^(VB|AUXG?)/ < /be|was|is|are|were|been|being|'s|'re|'m|am|Been|Being|WAS|IS|get|got|getting|gets|Get|gotten|becomes|become|became|felt|feels|feel|seems|seem|seemed|remains|remained|remain/))) !$-- NP))"});
    public static final GrammaticalRelation COMPLEMENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "comp", "complement", ComplementGRAnnotation.class, ARGUMENT);
    public static final GrammaticalRelation OBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "obj", "object", ObjectGRAnnotation.class, COMPLEMENT);
    public static final GrammaticalRelation DIRECT_OBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "dobj", "direct object", DirectObjectGRAnnotation.class, OBJECT, "SBARQ|VP|SBAR", new String[]{"VP < (NP $+ (/^(NP|WHNP)$/=target !< (/^NN/ < /(?i)^Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|February|March|April|May|June|July|August|September|October|November|December|today|yesterday|tomorrow|spring|summer|fall|autumn|winter|lot$/))) !<(/^VB|AUXG?/ < /^(am|is|are|being|Being|be|'s|'re|'m|was|were|seem|seems|seemed|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|become|becomes|became)$/) ", "VP < (NP < (NP $+ (/^(NP|WHNP)$/=target !< (/^NN/ < /(?i)^Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|February|March|April|May|June|July|August|September|October|November|December|today|yesterday|tomorrow|spring|summer|fall|autumn|winter|lot$/))))!< (/^VB|AUX?/ < /^(am|is|are|be|being|Being|'s|'re|'m|was|were|seem|seems|seemed|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|become|becomes|became)$/)", "VP !<(/^VB|AUXG?/ < /^(am|is|are|be|being|Being|'s|'re|'m|was|were|seem|seems|seemed|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|become|becomes|became)$/) < (/^(NP|WHNP)$/=target !< (/^NN/ < /(?i)^Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|February|March|April|May|June|July|August|September|October|November|December|today|yesterday|tomorrow|spring|summer|fall|autumn|winter$/) !$+ NP)", "VP !<(/^VB|AUXG?/ < /^(am|is|are|be|being|Being|'s|'re|'m|was|were|seem|seems|seemed|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|become|becomes|became)$/) < (/^(NP|WHNP)$/=target $+ NP-TMP)", "VP !<(/^VB|AUXG?/ < /^(am|is|are|be|being|Being|'s|'re|'m|was|were|seem|seems|seemed|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|become|becomes|became)$/) < (/^(NP|WHNP)$/=target $+ (NP < (/^NN/ < /(?i)^Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|February|March|April|May|June|July|August|September|October|November|December|today|yesterday|tomorrow|spring|summer|fall|autumn|winter$/)))", "SBARQ <, (WHNP=target !< WRB) <+(SQ|SINV|S|VP) (VP !< (S < (VP < TO)) $-- (NP !< /^-NONE-$/))", "SBAR <, (WHNP=target !< WRB) < (S < NP < (VP !< PP !< SBAR !< (S < (VP < TO))))", "SBAR !< WHNP < (S < (NP $++ (VP !$++ NP))) > (VP > (S < NP $- WHNP=target))"});
    public static final GrammaticalRelation INDIRECT_OBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "iobj", "indirect object", IndirectObjectGRAnnotation.class, OBJECT, "VP", new String[]{"VP < (NP=target !< /\\$/ !< (/^NN/ < /(?i)^Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|February|March|April|May|June|July|August|September|October|November|December|today|yesterday|tomorrow|spring|summer|fall|autumn|winter$/) $+ (NP !< (/^NN/ < /(?i)^Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|February|March|April|May|June|July|August|September|October|November|December|today|yesterday|tomorrow|spring|summer|fall|autumn|winter$/)))", "VP < (NP=target < (NP !< /\\$/ $++ (NP !< (/^NN/ < /^lot$/)) !$ CC !$ CONJP !$ /^,$/ !$++ /^:$/))"});
    public static final GrammaticalRelation PREPOSITIONAL_OBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "pobj", "prepositional object", PrepositionalObjectGRAnnotation.class, OBJECT, "PP(?:-TMP)?|WHPP", new String[]{"/^PP(?:-TMP)?|WHPP$/ < (IN|VBG|TO|FW $++ (/^NP(?:-TMP)?|WHNP|ADJP$/=target !$- @NP))", "/^PP(?:-TMP)?$/ < (/^IN|VBG|TO/ $+ (ADVP=target [ < (RB < /^(here|there)$/) | < (ADVP < /^NP(?:-TMP)?$/) ] ))"});
    public static final GrammaticalRelation PREPOSITIONAL_COMPLEMENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "pcomp", "prepositional complement", PrepositionalComplementGRAnnotation.class, OBJECT, "^PP(?:-TMP)?$", new String[]{"/^PP(?:-TMP)?$/ < (IN|VBG|TO $+ SBAR|S=target)", "/^PP(?:-TMP)?$/ < (SBAR=target <, (IN $+ S))"});
    public static final GrammaticalRelation ATTRIBUTIVE = new GrammaticalRelation(GrammaticalRelation.Language.English, "attr", "attributive", AttributiveGRAnnotation.class, COMPLEMENT, "VP|SBARQ|SQ", new String[]{"VP !$ (NP < EX) < NP=target <(/^VB|AUXG?/ < /^(am|is|are|be|being|'s|'re|'m|was|were|seem|seems|seemed|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|become|becomes|became)$/)", "SBARQ < (WHNP=target $+ (SQ < (/^VB|AUX?/ < /^(am|is|are|'s|'re|'m|was|were|seem|seems|seemed|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|become|becomes|became)$/ !$++ (VP < VBG))))", "SQ <, (/^VB|AUX?/ < /^(Am|am|Is|is|Are|are|be|being|'s|'re|'m|Was|was|Were|were)$/) < (NP=target $-- (NP !< EX))"});
    public static final GrammaticalRelation CLAUSAL_COMPLEMENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "ccomp", "clausal complement", ClausalComplementGRAnnotation.class, COMPLEMENT, "VP|SINV|S|ADJP|NP", new String[]{"VP < (S=target < (VP !<, TO|VBG) !$-- NP)", "VP < (SBAR=target < (S <+(S) VP) <, (IN|DT < /^(that|whether)$/))", "VP < (SBAR=target < (S < VP) !$-- NP !<, (IN|WHADVP))", "VP < (SBAR=target < (S < VP) !$-- NP <, (WHADVP < (WRB < /^[Hh]ow$/)))", "S|SINV < (S|SBARQ=target $+ /^(,|.|'')$/ !$- /^:|CC$/ !< (VP < TO|VBG))", "ADJP < (SBAR=target < (S < VP))", "S <, (SBAR=target <, (IN < /^([Tt]hat|[Ww]hether)$/) !$+ VP)", "@NP < NN|NNS < SBAR=target"});
    public static final GrammaticalRelation XCLAUSAL_COMPLEMENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "xcomp", "xclausal complement", XClausalComplementGRAnnotation.class, COMPLEMENT, "VP|ADJP", new String[]{"VP !> (VP < (VB|AUX < be)) < (S=target !$- (NN < /^order$/) < (VP < TO))", "ADJP < (S=target <, (VP <, TO))", "VP < (S=target !$- (NN < /^order$/) < (NP $+ NP|ADJP))", "VP < (/^VB|AUX/ $+ (VP=target < VB < NP))", "VP !> (VP < (VB|AUX < be)) < (SBAR=target < (S !$- (NN < /^order$/) < (VP < TO)))", "VP > VP < (S=target !$- (NN < /^order$/) <: NP)", "VP < (S=target !< NP < (VP < VBG))"});
    public static final GrammaticalRelation COMPLEMENTIZER = new GrammaticalRelation(GrammaticalRelation.Language.English, "complm", "complementizer", ComplementizerGRAnnotation.class, COMPLEMENT, "SBAR", new String[]{"SBAR <, (IN|DT=target < /^(?:that|whether)$/) $-- /^VB|AUXG?/", "SBAR <, (IN|DT=target < /^(?:that|whether)$/) $- NP|NN|NNS", "SBAR <, (IN|DT=target < /^(?:that|whether)$/) > ADJP|PP", "SBAR <, (IN|DT=target < /^(?:That|Whether)$/)"});
    public static final GrammaticalRelation MARKER = new GrammaticalRelation(GrammaticalRelation.Language.English, "mark", "marker", MarkerGRAnnotation.class, COMPLEMENT, "^SBAR(?:-TMP)?$", new String[]{"/^SBAR(?:-TMP)?$/ <, (IN=target !< /(?i)^that|whether$/) < S|FRAG"});
    public static final GrammaticalRelation RELATIVE = new GrammaticalRelation(GrammaticalRelation.Language.English, "rel", "relative", RelativeGRAnnotation.class, COMPLEMENT, "SBAR", new String[]{"SBAR <, /^WH/=target > /^NP/ [ !<, /^WHNP/ | < (S < (VP $-- (/^NP/ !< /^-NONE-$/)))]"});
    public static final GrammaticalRelation REFERENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "ref", "referent", ReferentGRAnnotation.class, GrammaticalRelation.DEPENDENT, "NP", new String[]{"NP $+ (SBAR < (WHNP|WHPP <+(@WHNP|WHPP|NP|PP) /^WDT|WP|WP\\$$/=target)) > NP", "NP $+ (/^(,|PP|PRN)$/ $+ (SBAR < (WHNP|WHPP <+(@WHNP|WHPP|NP|PP) /^WDT|WP|WP\\$$/=target))) > NP"});
    public static final GrammaticalRelation EXPLETIVE = new GrammaticalRelation(GrammaticalRelation.Language.English, "expl", "expletive", ExpletiveGRAnnotation.class, GrammaticalRelation.DEPENDENT, "S|SQ", new String[]{"S|SQ < (NP=target < EX)"});
    public static final GrammaticalRelation ADJECTIVAL_COMPLEMENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "acomp", "adjectival complement", AdjectivalComplementGRAnnotation.class, COMPLEMENT, "VP", new String[]{"VP < (ADJP=target !$-- NP)"});
    public static final GrammaticalRelation MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "mod", "modifier", ModifierGRAnnotation.class, GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation ADV_CLAUSE_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "advcl", "adverbial clause modifier", AdvClauseModifierGRAnnotation.class, MODIFIER, "VP|S|SQ", new String[]{"VP < (@SBAR=target [ <, (IN !< /^([Tt]hat|[Ww]hether)$/ !$+ (NN < /^order$/)) | <: (SINV <1 /^(?:VB|MD)/) ] )", "S|SQ <, (/^SBAR(?:-TMP)?$/=target <, (IN !< /^([Tt]hat|[Ww]hether)$/ !$+ (NN < /^order$/)) !$+ VP)", "S|SQ <, (/^SBAR(?:-TMP)?$/=target <2 (IN !< /^([Tt]hat|[Ww]hether)$/ !$+ (NN < /^order$/)))", "VP < (/^SBAR(?:-TMP)?$/=target <, (WHADVP|WHNP < (WRB !< /^[Hh]ow$/)) !< (S < (VP < TO)))", "S|SQ <, (/^SBAR(?:-TMP)$/=target <, (WHADVP|WHNP < (WRB !< /^[Hh]ow$/)) !< (S < (VP < TO)))", "S|SQ <, (PP=target <, RB)"});
    public static final GrammaticalRelation PURPOSE_CLAUSE_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "purpcl", "purpose clause modifier", PurposeClauseModifierGRAnnotation.class, MODIFIER, "VP", new String[]{"VP < (/^SBAR/=target < (IN < in) < (NN < order) < (S < (VP < TO)))", "VP > (VP < (VB|AUX < be)) < (S=target !$- /^,$/ < (VP < TO|VBG) !$-- NP)"});
    public static final GrammaticalRelation TEMPORAL_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "tmod", "temporal modifier", TemporalModifierGRAnnotation.class, MODIFIER, "VP|S|ADJP|PP", new String[]{"VP|ADJP < /^NP-TMP$/=target", "VP|ADJP < (NP=target < (/^NN/ < /(?i)^Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|February|March|April|May|June|July|August|September|October|November|December|today|yesterday|tomorrow|spring|summer|fall|autumn|winter$/))", "@PP < (IN|TO|VBG|FW $++ (@NP $+ /^NP-TMP$/=target))", "@PP < (IN|TO|VBG|FW $++ (@NP $+ (NP=target < (/^NN/ < /(?i)^Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|February|March|April|May|June|July|August|September|October|November|December|today|yesterday|tomorrow|spring|summer|fall|autumn|winter$/))))", "S < (/^NP-TMP$/=target $++ (NP $++ VP))", "S < (NP=target < (/^NN/ < /(?i)^Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|February|March|April|May|June|July|August|September|October|November|December|today|yesterday|tomorrow|spring|summer|fall|autumn|winter$/) $++ (NP $++ VP))"});
    public static final GrammaticalRelation RELATIVE_CLAUSE_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "rcmod", "relative clause modifier", RelativeClauseModifierGRAnnotation.class, MODIFIER, "NP", new String[]{"NP $++ (SBAR=target <+(SBAR) WHPP|WHNP) > NP", "NP $++ (SBAR=target <: (S !<, (VP <, TO))) > NP", "NP $++ (SBAR=target < (WHADVP < (WRB </^(where|why)/))) > NP", "NP $++ RRC=target"});
    public static final GrammaticalRelation ADJECTIVAL_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "amod", "adjectival modifier", AdjectivalModifierGRAnnotation.class, MODIFIER, "^NP(?:-TMP|-ADV)?|NX|WHNP$", new String[]{"/^NP(?:-TMP|-ADV)?|NX|WHNP$/ < (ADJP|WHADJP|JJ|JJR|JJS|VBN|VBG|VBD=target !< QP !$- CC)"});
    public static final GrammaticalRelation NUMERIC_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "num", "numeric modifier", NumericModifierGRAnnotation.class, MODIFIER, "NP(?:-TMP|-ADV)?", new String[]{"/^NP(?:-TMP|-ADV)?$/ < (CD|QP=target !$- CC)", "/^NP(?:-TMP|-ADV)?$/ < (ADJP=target <: QP)"});
    public static final GrammaticalRelation NUMBER_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "number", "compound number modifier", NumberModifierGRAnnotation.class, MODIFIER, "QP", new String[]{"QP < (CD=target !$- CC)"});
    public static final GrammaticalRelation QUANTIFIER_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "quantmod", "quantifier modifier", QuantifierModifierGRAnnotation.class, MODIFIER, "QP", new String[]{"QP < /^IN|RB|DT|JJ|XS$/=target"});
    public static final GrammaticalRelation NOUN_COMPOUND_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "nn", "nn modifier", NounCompoundModifierGRAnnotation.class, MODIFIER, "^NP(?:-TMP|-ADV)?$", new String[]{"/^NP(?:-TMP|-ADV)?$/ < (NP|NN|NNS|NNP|NNPS|FW=target $++ NN|NNS|NNP|NNPS|FW|CD !<- POS !$- /^,$/ )", "/^NP(?:-TMP|-ADV)?$/ < (NP|NN|NNS|NNP|NNPS|FW=target !<- POS $+ JJ|JJR|JJS) <# NN|NNS|NNP|NNPS !<- POS"});
    public static final GrammaticalRelation APPOSITIONAL_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "appos", "appositional modifier", AppositionalModifierGRAnnotation.class, MODIFIER, "^NP(?:-TMP|-ADV)?$", new String[]{"/^NP(?:-TMP|-ADV)?$/ < (NP=target $- /^,$/ $-- NP !$ CC|CONJP)", "/^NP(?:-TMP|-ADV)?$/ < (PRN=target < (NP < /^NNS?|CD$/ $-- /^-LRB-$/ $+ /^-RRB-$/))", "/^NP(?:-TMP|-ADV)?$/ < (NNP $+ (/^,$/ $+ NNP=target)) !< CC|CONJP"});
    public static final GrammaticalRelation ABBREVIATION_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "abbrev", "abbreviation modifier", AbbreviationModifierGRAnnotation.class, APPOSITIONAL_MODIFIER, "^NP(?:-TMP|-ADV)?$", new String[]{"/^NP(?:-TMP|-ADV)?$/ < (PRN=target <, /^-LRB-$/ <- /^-RRB-$/ !<< /^(?:POS|PRP\\$|[,$#]|CC|RB|CD)$/ <+(NP) (NNP|NN < /^(?:[A-Z]\\.?){2,}/) )"});
    public static final GrammaticalRelation PARTICIPIAL_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "partmod", "participial modifier", ParticipialModifierGRAnnotation.class, MODIFIER, "^NP(?:-TMP|-ADV)?|VP|S$", new String[]{"/^NP(?:-TMP|-ADV)?$/ < (VP=target < VBG|VBN $-- NP)", "/^NP(?:-TMP|-ADV)?$/ < (/^,$/ $+ (VP=target <, VBG|VBN))", "S <, (NP $+ (/^,$/ $+ (S=target < (VP <, VBG|VBN))))"});
    public static final GrammaticalRelation INFINITIVAL_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "infmod", "infinitival modifier", InfinitivalModifierGRAnnotation.class, MODIFIER, "^NP(?:-TMP|-ADV)?$", new String[]{"/^NP(?:-[A-Z]+)?$/ < (S=target < (VP < TO) $-- /^NP|NNP?S?$/)", "/^NP(?:-[A-Z]+)?$/ < (SBAR=target < (S < (VP < TO)) $-- /^NP|NNP?S?$/)"});
    private static final String NOT_PAT = "/^(?i:not|n't|never)$/";
    public static final GrammaticalRelation ADVERBIAL_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "advmod", "adverbial modifier", AdverbialModifierGRAnnotation.class, MODIFIER, "VP|ADJP|WHADJP|ADVP|WHADVP|S|SBAR|SINV|SQ|SBARQ|XS|NP(?:-TMP|-ADV)?|RRC", new String[]{"/^VP|ADJP|WHADJP|S|SBAR|SINV|SQ|XS|NP(?:-TMP|-ADV)?|RRC$/ < (RB|RBR|RBS|WRB|ADVP|WHADVP=target !< /^(?i:not|n't|never)$/)", "ADVP|WHADVP < (RB|RBR|RBS|WRB|ADVP|WHADVP|JJ=target !< /^(?i:not|n't|never)$/) !< CC !< CONJP", "SBAR < (WHNP=target < WRB)", "SBARQ <, WHADVP=target", "XS < /^JJ$/=target"});
    public static final GrammaticalRelation NEGATION_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "neg", "negation modifier", NegationModifierGRAnnotation.class, ADVERBIAL_MODIFIER, "VP|ADJP|S|SBAR|SINV|SQ|NP(?:-TMP|-ADV)?|FRAG", new String[]{"/^VP|NP(?:-TMP|-ADV)?|ADJP|SQ|S|FRAG$/< (RB=target < /^(?i:not|n't|never)$/)", "VP|ADJP|S|SBAR|SINV|FRAG < (ADVP=target <# (RB < /^(?i:not|n't|never)$/))", "VP > SQ $-- (RB=target < /^(?i:not|n't|never)$/)"});
    public static final GrammaticalRelation MEASURE_PHRASE = new GrammaticalRelation(GrammaticalRelation.Language.English, "measure", "measure-phrase", MeasurePhraseGRAnnotation.class, MODIFIER, "ADJP|ADVP", new String[]{"ADJP <- JJ <, (NP=target !< NNP)", "ADVP|ADJP <# (/^JJ|IN$/ $- NP=target)"});
    public static final GrammaticalRelation DETERMINER = new GrammaticalRelation(GrammaticalRelation.Language.English, "det", "determiner", DeterminerGRAnnotation.class, MODIFIER, "^NP(?:-TMP|-ADV)?|WHNP", new String[]{"/^NP(?:-TMP|-ADV)?$/ < (DT=target !</both|either|neither/ !$- DT !$++ CC $++ /^N[NX]/)", "/^NP(?:-TMP|-ADV)?$/ < (DT=target < /both|either|neither/ !$- DT !$++ CC $++ /^N[NX]/ !$++ (NP < CC))", "/^NP(?:-TMP|-ADV)?$/ < (DT=target !< /both|neither|either/ $++ CC $++ /^N[NX]/)", "/^NP(?:-TMP|-ADV)?$/ < (DT=target $++ (/^JJ/ !$+ /^NN/) !$++CC)", "/^NP(?:-TMP|-ADV)?$/ < (RB=target $++ (/PDT/ $+ /^NN/))", "WHNP < (NP $-- (WHNP=target < WDT))", "WHNP < (/^NN/ $-- WDT|WP=target)"});
    public static final GrammaticalRelation PREDETERMINER = new GrammaticalRelation(GrammaticalRelation.Language.English, "predet", "predeterminer", PredeterminerGRAnnotation.class, MODIFIER, "^NP(?:-TMP|-ADV)?", new String[]{"/^NP(?:-TMP|-ADV)?$/ < (PDT|DT=target $+ /DT|PRP\\$/ $++ /^N[NX]/ !$++ CC)", "/^NP(?:-TMP|-ADV)?$/ < (PDT|DT=target $+ DT $++ (/^JJ/ !$+ /^NN/)) !$++ CC", "/^NP(?:-TMP|-ADV)?$/ < PDT=target <- DT"});
    public static final GrammaticalRelation PRECONJUNCT = new GrammaticalRelation(GrammaticalRelation.Language.English, "preconj", "preconjunct", PreconjunctGRAnnotation.class, MODIFIER, "S|VP|ADJP|PP|ADVP|UCP|NX|SBAR|^NP(?:-TMP|-ADV)?", new String[]{"/^NP(?:-TMP|-ADV)?|NX$/ < (PDT|CC=target < /Both|both|Neitehr|neither|Either|either/ $++ /^N[NX]/) $++ CC", "/^NP(?:-TMP|-ADV)?|NX$/ < (PDT|CC=target < /Both|both|Neitehr|neither|Either|either/ $++ (/^JJ/ !$+ /^NN/)) $++ CC", "/^NP(?:-TMP|-ADV)?|NX$/ < (PDT|CC|DT=target < /Both|both|Neitehr|neither|Either|either/ $++ CC)", "/^NP(?:-TMP|-ADV)?|NX$/ < (PDT|CC|DT=target </Both|both|Neitehr|neither|Either|either/) < (NP < CC)", "S|VP|ADJP|PP|ADVP|UCP|NX|SBAR < (PDT|DT|CC=target < /Both|both|Neitehr|neither|Either|either/ $++ CC)"});
    public static final GrammaticalRelation POSSESSION_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "poss", "possession modifier", PossessionModifierGRAnnotation.class, MODIFIER, "^NP(?:-TMP|-ADV)?$", new String[]{"/^NP(?:-TMP|-ADV)?$/ < (/^PRP\\$/=target $++ /^NN/)", "/^NP(?:-TMP|-ADV)?$/ < (NP=target < POS)", "/^NP(?:-TMP|-ADV)?$/ < (NNS=target $+ (POS < /'/))"});
    public static final GrammaticalRelation POSSESSIVE_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "possessive", "possessive modifier", PossessiveModifierGRAnnotation.class, MODIFIER, "^NP(?:-TMP|-ADV)?$", new String[]{"/^NP(?:-TMP|-ADV)?$/ <- POS=target"});
    public static final GrammaticalRelation PREPOSITIONAL_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "prep", "prepositional modifier", PrepositionalModifierGRAnnotation.class, MODIFIER, "NP(?:-TMP|-ADV)?|WHNP|VP|S|SINV|ADJP|SBARQ|NAC", new String[]{"/^NP(?:-TMP|-ADV)?|WHNP|VP|ADJP|NAC$/ < /^(?:WH)?PP(?:-TMP)?$/=target", "S|SINV < (/^PP(?:-TMP)?$/=target !< SBAR) < VP", "SBARQ < /^WHPP/=target < SQ"});
    public static final GrammaticalRelation PHRASAL_VERB_PARTICLE = new GrammaticalRelation(GrammaticalRelation.Language.English, "prt", "phrasal verb particle", PhrasalVerbParticleGRAnnotation.class, MODIFIER, "VP", new String[]{"VP < PRT=target"});
    public static final GrammaticalRelation PARATAXIS = new GrammaticalRelation(GrammaticalRelation.Language.English, "parataxis", "parataxis", ParataxisGRAnnotation.class, GrammaticalRelation.DEPENDENT, "S|VP", new String[]{"VP < (PRN=target < /^S|SBAR$/)", "VP $ (PRN=target < /^S|SBAR$/)", "S|VP < (/^:$/ $+ /^S/=target)"});
    public static final GrammaticalRelation SEMANTIC_DEPENDENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "sdep", "semantic dependent", SemanticDependentGRAnnotation.class, GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation CONTROLLING_SUBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "xsubj", "controlling subject", ControllingSubjectGRAnnotation.class, SEMANTIC_DEPENDENT, "VP", new String[]{"VP < TO > (S !$- NP !< NP !>> (VP < (VB|AUX < be)) >+(VP) (VP $-- NP=target))"});
    public static final GrammaticalRelation AGENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "agent", "agent", AgentGRAnnotation.class, GrammaticalRelation.DEPENDENT);
    private static final List<GrammaticalRelation> values = Generics.newArrayList(Arrays.asList(GrammaticalRelation.GOVERNOR, GrammaticalRelation.DEPENDENT, PREDICATE, ATTRIBUTIVE, AUX_MODIFIER, AUX_PASSIVE_MODIFIER, COPULA, CONJUNCT, COORDINATION, PUNCTUATION, ARGUMENT, SUBJECT, NOMINAL_SUBJECT, NOMINAL_PASSIVE_SUBJECT, CLAUSAL_SUBJECT, CLAUSAL_PASSIVE_SUBJECT, COMPLEMENT, OBJECT, DIRECT_OBJECT, INDIRECT_OBJECT, PREPOSITIONAL_OBJECT, PREPOSITIONAL_COMPLEMENT, CLAUSAL_COMPLEMENT, XCLAUSAL_COMPLEMENT, COMPLEMENTIZER, MARKER, RELATIVE, REFERENT, EXPLETIVE, ADJECTIVAL_COMPLEMENT, MODIFIER, ADV_CLAUSE_MODIFIER, TEMPORAL_MODIFIER, RELATIVE_CLAUSE_MODIFIER, NUMERIC_MODIFIER, ADJECTIVAL_MODIFIER, NOUN_COMPOUND_MODIFIER, APPOSITIONAL_MODIFIER, ABBREVIATION_MODIFIER, PARTICIPIAL_MODIFIER, INFINITIVAL_MODIFIER, ADVERBIAL_MODIFIER, NEGATION_MODIFIER, DETERMINER, PREDETERMINER, PRECONJUNCT, POSSESSION_MODIFIER, POSSESSIVE_MODIFIER, PREPOSITIONAL_MODIFIER, PHRASAL_VERB_PARTICLE, SEMANTIC_DEPENDENT, CONTROLLING_SUBJECT, AGENT, NUMBER_MODIFIER, PURPOSE_CLAUSE_MODIFIER, QUANTIFIER_MODIFIER, MEASURE_PHRASE, PARATAXIS));
    private static final List<GrammaticalRelation> unmodifiableValues = Collections.unmodifiableList(values);
    private static final List<GrammaticalRelation> synchronizedValues = Collections.synchronizedList(values);
    private static final List<GrammaticalRelation> unmodifiableSynchronizedValues = Collections.unmodifiableList(values);
    public static final ReadWriteLock valuesLock = new ReentrantReadWriteLock();
    private static final Map<String, GrammaticalRelation> conjs = Generics.newHashMap();
    private static final Map<String, GrammaticalRelation> preps = Generics.newHashMap();
    private static final Map<String, GrammaticalRelation> prepsC = Generics.newHashMap();

    private EnglishGrammaticalRelations() {
    }

    public static List<GrammaticalRelation> values() {
        return EnglishGrammaticalRelations.values(false);
    }

    public static List<GrammaticalRelation> values(boolean threadSafe) {
        return threadSafe ? unmodifiableSynchronizedValues : unmodifiableValues;
    }

    public static Lock valuesLock() {
        return valuesLock.readLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void threadSafeAddRelation(GrammaticalRelation relation) {
        valuesLock.writeLock().lock();
        try {
            synchronizedValues.add(relation);
        }
        finally {
            valuesLock.writeLock().unlock();
        }
    }

    public static Collection<GrammaticalRelation> getConjs() {
        return conjs.values();
    }

    public static GrammaticalRelation getConj(String conjunctionString) {
        GrammaticalRelation result = conjs.get(conjunctionString);
        if (result == null) {
            result = new GrammaticalRelation(GrammaticalRelation.Language.English, "conj", "conj_collapsed", null, GrammaticalRelation.DEPENDENT, conjunctionString);
            conjs.put(conjunctionString, result);
            EnglishGrammaticalRelations.threadSafeAddRelation(result);
        }
        return result;
    }

    public static Collection<GrammaticalRelation> getPreps() {
        return preps.values();
    }

    public static Collection<GrammaticalRelation> getPrepsC() {
        return prepsC.values();
    }

    public static GrammaticalRelation getPrep(String prepositionString) {
        GrammaticalRelation result = preps.get(prepositionString);
        if (result == null) {
            result = new GrammaticalRelation(GrammaticalRelation.Language.English, "prep", "prep_collapsed", null, GrammaticalRelation.DEPENDENT, prepositionString);
            preps.put(prepositionString, result);
            EnglishGrammaticalRelations.threadSafeAddRelation(result);
        }
        return result;
    }

    public static GrammaticalRelation getPrepC(String prepositionString) {
        GrammaticalRelation result = prepsC.get(prepositionString);
        if (result == null) {
            result = new GrammaticalRelation(GrammaticalRelation.Language.English, "prepc", "prepc_collapsed", null, GrammaticalRelation.DEPENDENT, prepositionString);
            prepsC.put(prepositionString, result);
            EnglishGrammaticalRelations.threadSafeAddRelation(result);
        }
        return result;
    }

    public static GrammaticalRelation valueOf(String s) {
        return GrammaticalRelation.valueOf(s, values);
    }

    public static GrammaticalRelation valueOf(Object o) {
        if (o instanceof GrammaticalRelation) {
            return (GrammaticalRelation)o;
        }
        if (o instanceof Class) {
            try {
                return GrammaticalRelation.getRelation((Class)o);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (o instanceof String) {
            return EnglishGrammaticalRelations.valueOf((String)o);
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(GrammaticalRelation.DEPENDENT.toPrettyString());
    }

    public static class AgentGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ControllingSubjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class SemanticDependentGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ParataxisGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PhrasalVerbParticleGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PrepositionalModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PossessiveModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PossessionModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PreconjunctGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PredeterminerGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class DeterminerGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class MeasurePhraseGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NegationModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AdverbialModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class InfinitivalModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ParticipialModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AbbreviationModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AppositionalModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NounCompoundModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class QuantifierModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NumberModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NumericModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AdjectivalModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class RelativeClauseModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class TemporalModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PurposeClauseModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AdvClauseModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AdjectivalComplementGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ExpletiveGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ReferentGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class RelativeGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class MarkerGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ComplementizerGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class XClausalComplementGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ClausalComplementGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AttributiveGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PrepositionalComplementGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PrepositionalObjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class IndirectObjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class DirectObjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ObjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ComplementGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ClausalPassiveSubjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ClausalSubjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NominalPassiveSubjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NominalSubjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class SubjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ArgumentGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PunctuationGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class CoordinationGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ConjunctGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class CopulaGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AuxPassiveGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AuxModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PredicateGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }
}

