/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Filter;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dependencies {
    private Dependencies() {
    }

    public static Comparator<Dependency> dependencyIndexComparator() {
        return ComparatorHolder.dc;
    }

    private static class ComparatorHolder {
        private static final Comparator<Dependency> dc = new DependencyIdxComparator();

        private ComparatorHolder() {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class DependencyIdxComparator
        implements Comparator<Dependency> {
            private DependencyIdxComparator() {
            }

            @Override
            public int compare(Dependency dep1, Dependency dep2) {
                CoreMap dep1lab = (CoreMap)dep1.dependent();
                CoreMap dep2lab = (CoreMap)dep2.dependent();
                int dep1idx = (Integer)dep1lab.get(CoreAnnotations.IndexAnnotation.class);
                int dep2idx = (Integer)dep2lab.get(CoreAnnotations.IndexAnnotation.class);
                return dep1idx - dep2idx;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DependentPuncTagRejectFilter<G extends Label, D extends Label, N>
    implements Filter<Dependency<G, D, N>> {
        private Filter<String> tagRejectFilter;
        private static final long serialVersionUID = -7732189363171164852L;

        public DependentPuncTagRejectFilter(Filter<String> trf) {
            this.tagRejectFilter = trf;
        }

        @Override
        public boolean accept(Dependency<G, D, N> d) {
            if (d == null) {
                return false;
            }
            if (!(d.dependent() instanceof HasTag)) {
                return false;
            }
            String tag = ((HasTag)d.dependent()).tag();
            return this.tagRejectFilter.accept(tag);
        }
    }
}

