/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammar;
import edu.stanford.nlp.parser.lexparser.Test;
import edu.stanford.nlp.parser.lexparser.Train;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class Options
implements Serializable {
    public int numStates = -1;
    public LexOptions lexOptions = new LexOptions();
    public TreebankLangParserParams tlpParams;
    public boolean forceCNF = false;
    public boolean doPCFG = true;
    public boolean doDep = true;
    public boolean freeDependencies = false;
    public boolean directional = true;
    public boolean genStop = true;
    public boolean distance = true;
    public boolean coarseDistance = false;
    public boolean dcTags = true;
    public boolean nodePrune = false;
    private static final long serialVersionUID = 4L;

    public Options() {
        this(new EnglishTreebankParserParams());
    }

    public Options(TreebankLangParserParams tlpParams) {
        this.tlpParams = tlpParams;
    }

    public void setOptions(String ... flags) {
        this.setOptions(flags, 0, flags.length);
    }

    public void setOptions(String[] flags, int startIndex, int endIndexPlusOne) {
        int i = startIndex;
        while (i < endIndexPlusOne) {
            i = this.setOption(flags, i);
        }
    }

    public void setOptionsOrWarn(String ... flags) {
        this.setOptionsOrWarn(flags, 0, flags.length);
    }

    public void setOptionsOrWarn(String[] flags, int startIndex, int endIndexPlusOne) {
        int i = startIndex;
        while (i < endIndexPlusOne) {
            i = this.setOptionOrWarn(flags, i);
        }
    }

    public int setOptionOrWarn(String[] flags, int i) {
        int j = this.setOptionFlag(flags, i);
        if (j == i) {
            j = this.tlpParams.setOptionFlag(flags, i);
        }
        if (j == i) {
            System.err.println("WARNING! lexparser.Options: Unknown option ignored: " + flags[i]);
            ++j;
        }
        return j;
    }

    public int setOption(String[] flags, int i) {
        int j = this.setOptionFlag(flags, i);
        if (j == i) {
            j = this.tlpParams.setOptionFlag(flags, i);
        }
        if (j == i) {
            throw new IllegalArgumentException("Unknown option: " + flags[i]);
        }
        return j;
    }

    private int setOptionFlag(String[] args, int i) {
        if (args[i].equalsIgnoreCase("-PCFG")) {
            this.doDep = false;
            this.doPCFG = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-dep")) {
            this.doDep = true;
            this.doPCFG = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-factored")) {
            this.doDep = true;
            this.doPCFG = true;
            Test.useFastFactored = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-fastFactored")) {
            this.doDep = true;
            this.doPCFG = true;
            Test.useFastFactored = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noRecoveryTagging")) {
            Test.noRecoveryTagging = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-useLexiconToScoreDependencyPwGt")) {
            Test.useLexiconToScoreDependencyPwGt = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-useSmoothTagProjection")) {
            MLEDependencyGrammar.useSmoothTagProjection = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-useUnigramWordSmoothing")) {
            MLEDependencyGrammar.useUnigramWordSmoothing = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-useNonProjectiveDependencyParser")) {
            Test.useNonProjectiveDependencyParser = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-maxLength") && i + 1 < args.length) {
            Test.maxLength = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-MAX_ITEMS") && i + 1 < args.length) {
            Test.MAX_ITEMS = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-iterativeCKY")) {
            Test.iterativeCKY = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-vMarkov") && i + 1 < args.length) {
            int order = Integer.parseInt(args[i + 1]);
            if (order <= 1) {
                Train.PA = false;
                Train.gPA = false;
            } else if (order == 2) {
                Train.PA = true;
                Train.gPA = false;
            } else if (order >= 3) {
                Train.PA = true;
                Train.gPA = true;
            }
            i += 2;
        } else if (args[i].equalsIgnoreCase("-vSelSplitCutOff") && i + 1 < args.length) {
            Train.selectiveSplitCutOff = Double.parseDouble(args[i + 1]);
            Train.selectiveSplit = Train.selectiveSplitCutOff > 0.0;
            i += 2;
        } else if (args[i].equalsIgnoreCase("-vSelPostSplitCutOff") && i + 1 < args.length) {
            Train.selectivePostSplitCutOff = Double.parseDouble(args[i + 1]);
            Train.selectivePostSplit = Train.selectivePostSplitCutOff > 0.0;
            i += 2;
        } else if (args[i].equalsIgnoreCase("-deleteSplitters") && i + 1 < args.length) {
            String[] toDel = args[i + 1].split(" *, *");
            Train.deleteSplitters = new HashSet<String>(Arrays.asList(toDel));
            i += 2;
        } else if (args[i].equalsIgnoreCase("-postSplitWithBaseCategory")) {
            Train.postSplitWithBaseCategory = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-vPostMarkov") && i + 1 < args.length) {
            int order = Integer.parseInt(args[i + 1]);
            if (order <= 1) {
                Train.postPA = false;
                Train.postGPA = false;
            } else if (order == 2) {
                Train.postPA = true;
                Train.postGPA = false;
            } else if (order >= 3) {
                Train.postPA = true;
                Train.postGPA = true;
            }
            i += 2;
        } else if (args[i].equalsIgnoreCase("-hMarkov") && i + 1 < args.length) {
            int order = Integer.parseInt(args[i + 1]);
            if (order >= 0) {
                Train.markovOrder = order;
                Train.markovFactor = true;
            } else {
                Train.markovFactor = false;
            }
            i += 2;
        } else if (args[i].equalsIgnoreCase("-distanceBins") && i + 1 < args.length) {
            int numBins = Integer.parseInt(args[i + 1]);
            if (numBins <= 1) {
                this.distance = false;
            } else if (numBins == 4) {
                this.distance = true;
                this.coarseDistance = true;
            } else if (numBins == 5) {
                this.distance = true;
                this.coarseDistance = false;
            } else {
                throw new IllegalArgumentException("Invalid value for -distanceBin: " + args[i + 1]);
            }
            i += 2;
        } else if (args[i].equalsIgnoreCase("-noStop")) {
            this.genStop = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-nonDirectional")) {
            this.directional = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-depWeight") && i + 1 < args.length) {
            Test.depWeight = Double.parseDouble(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-printPCFGkBest") && i + 1 < args.length) {
            Test.printPCFGkBest = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-printFactoredKGood") && i + 1 < args.length) {
            Test.printFactoredKGood = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-smoothTagsThresh") && i + 1 < args.length) {
            this.lexOptions.smoothInUnknownsThreshold = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-unseenSmooth") && i + 1 < args.length) {
            Test.unseenSmooth = Double.parseDouble(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-fractionBeforeUnseenCounting") && i + 1 < args.length) {
            Train.fractionBeforeUnseenCounting = Double.parseDouble(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-hSelSplitThresh") && i + 1 < args.length) {
            Train.HSEL_CUT = Integer.parseInt(args[i + 1]);
            Train.hSelSplit = Train.HSEL_CUT > 0;
            i += 2;
        } else if (args[i].equalsIgnoreCase("-tagPA")) {
            Train.tagPA = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-tagSelSplitCutOff") && i + 1 < args.length) {
            Train.tagSelectiveSplitCutOff = Double.parseDouble(args[i + 1]);
            Train.tagSelectiveSplit = Train.tagSelectiveSplitCutOff > 0.0;
            i += 2;
        } else if (args[i].equalsIgnoreCase("-tagSelPostSplitCutOff") && i + 1 < args.length) {
            Train.tagSelectivePostSplitCutOff = Double.parseDouble(args[i + 1]);
            Train.tagSelectivePostSplit = Train.tagSelectivePostSplitCutOff > 0.0;
            i += 2;
        } else if (args[i].equalsIgnoreCase("-noTagSplit")) {
            Train.noTagSplit = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-uwm") && i + 1 < args.length) {
            this.lexOptions.useUnknownWordSignatures = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-unknownSuffixSize") && i + 1 < args.length) {
            this.lexOptions.unknownSuffixSize = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-unknownPrefixSize") && i + 1 < args.length) {
            this.lexOptions.unknownPrefixSize = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-uwModel") && i + 1 < args.length) {
            this.lexOptions.uwModel = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-openClassThreshold") && i + 1 < args.length) {
            Train.openClassTypesThreshold = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-leaveItAll") && i + 1 < args.length) {
            Train.leaveItAll = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-unary") && i + 1 < args.length) {
            Train.markUnary = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-unaryTags")) {
            Train.markUnaryTags = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-mutate")) {
            this.lexOptions.smartMutation = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-useUnicodeType")) {
            this.lexOptions.useUnicodeType = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-rightRec")) {
            Train.rightRec = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noRightRec")) {
            Train.rightRec = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-preTag")) {
            Test.preTag = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-forceTags")) {
            Test.forceTags = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-taggerSerializedFile")) {
            Test.taggerSerializedFile = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-forceTagBeginnings")) {
            Test.forceTagBeginnings = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noFunctionalForcing")) {
            Test.noFunctionalForcing = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-scTags")) {
            this.dcTags = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-dcTags")) {
            this.dcTags = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-evalb")) {
            Test.evalb = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-v") || args[i].equalsIgnoreCase("-verbose")) {
            Test.verbose = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-outputFilesDirectory") && i + 1 < args.length) {
            Test.outputFilesDirectory = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-outputFilesExtension") && i + 1 < args.length) {
            Test.outputFilesExtension = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-writeOutputFiles")) {
            Test.writeOutputFiles = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-printAllBestParses")) {
            Test.printAllBestParses = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-outputTreeFormat") || args[i].equalsIgnoreCase("-outputFormat")) {
            Test.outputFormat = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-outputTreeFormatOptions") || args[i].equalsIgnoreCase("-outputFormatOptions")) {
            Test.outputFormatOptions = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-addMissingFinalPunctuation")) {
            Test.addMissingFinalPunctuation = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-flexiTag")) {
            this.lexOptions.flexiTag = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-lexiTag")) {
            this.lexOptions.flexiTag = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-compactGrammar")) {
            Train.compactGrammar = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-markFinalStates")) {
            Train.markFinalStates = args[i + 1].equalsIgnoreCase("true");
            i += 2;
        } else if (args[i].equalsIgnoreCase("-leftToRight")) {
            Train.leftToRight = args[i + 1].equals("true");
            i += 2;
        } else if (args[i].equalsIgnoreCase("-cnf")) {
            this.forceCNF = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-nodePrune") && i + 1 < args.length) {
            this.nodePrune = args[i + 1].equalsIgnoreCase("true");
            i += 2;
        } else if (args[i].equalsIgnoreCase("-acl03pcfg")) {
            this.doDep = false;
            this.doPCFG = true;
            Train.markUnary = 1;
            Train.PA = true;
            Train.gPA = false;
            Train.tagPA = true;
            Train.tagSelectiveSplit = false;
            Train.rightRec = true;
            Train.selectiveSplit = true;
            Train.selectiveSplitCutOff = 400.0;
            Train.markovFactor = true;
            Train.markovOrder = 2;
            Train.hSelSplit = true;
            this.lexOptions.useUnknownWordSignatures = 2;
            this.lexOptions.flexiTag = true;
            this.dcTags = false;
        } else if (args[i].equalsIgnoreCase("-jenny")) {
            this.doDep = false;
            this.doPCFG = true;
            Train.markUnary = 1;
            Train.PA = false;
            Train.gPA = false;
            Train.tagPA = false;
            Train.tagSelectiveSplit = false;
            Train.rightRec = true;
            Train.selectiveSplit = false;
            Train.markovFactor = false;
            Train.hSelSplit = false;
            this.lexOptions.useUnknownWordSignatures = 2;
            this.lexOptions.flexiTag = true;
            this.dcTags = false;
        } else if (args[i].equalsIgnoreCase("-goodPCFG")) {
            this.doDep = false;
            this.doPCFG = true;
            Train.markUnary = 1;
            Train.PA = true;
            Train.gPA = false;
            Train.tagPA = true;
            Train.tagSelectiveSplit = false;
            Train.rightRec = true;
            Train.selectiveSplit = true;
            Train.selectiveSplitCutOff = 400.0;
            Train.markovFactor = true;
            Train.markovOrder = 2;
            Train.hSelSplit = true;
            this.lexOptions.useUnknownWordSignatures = 2;
            this.lexOptions.flexiTag = true;
            this.dcTags = false;
            String[] delSplit = new String[]{"-deleteSplitters", "VP^NP,VP^VP,VP^SINV,VP^SQ"};
            if (this.setOptionFlag(delSplit, 0) != 2) {
                System.err.println("Error processing deleteSplitters");
            }
        } else if (args[i].equalsIgnoreCase("-linguisticPCFG")) {
            this.doDep = false;
            this.doPCFG = true;
            Train.markUnary = 1;
            Train.PA = true;
            Train.gPA = false;
            Train.tagPA = true;
            Train.tagSelectiveSplit = false;
            Train.rightRec = false;
            Train.selectiveSplit = true;
            Train.selectiveSplitCutOff = 400.0;
            Train.markovFactor = true;
            Train.markovOrder = 2;
            Train.hSelSplit = true;
            this.lexOptions.useUnknownWordSignatures = 5;
            this.lexOptions.flexiTag = false;
            this.dcTags = false;
        } else if (args[i].equalsIgnoreCase("-ijcai03")) {
            this.doDep = true;
            this.doPCFG = true;
            Train.markUnary = 0;
            Train.PA = true;
            Train.gPA = false;
            Train.tagPA = false;
            Train.tagSelectiveSplit = false;
            Train.rightRec = false;
            Train.selectiveSplit = true;
            Train.selectiveSplitCutOff = 300.0;
            Train.markovFactor = true;
            Train.markovOrder = 2;
            Train.hSelSplit = true;
            Train.compactGrammar = 0;
            this.lexOptions.useUnknownWordSignatures = 2;
            this.lexOptions.flexiTag = false;
            this.dcTags = true;
        } else if (args[i].equalsIgnoreCase("-goodFactored")) {
            this.doDep = true;
            this.doPCFG = true;
            Train.markUnary = 0;
            Train.PA = true;
            Train.gPA = false;
            Train.tagPA = false;
            Train.tagSelectiveSplit = false;
            Train.rightRec = false;
            Train.selectiveSplit = true;
            Train.selectiveSplitCutOff = 300.0;
            Train.markovFactor = true;
            Train.markovOrder = 2;
            Train.hSelSplit = true;
            Train.compactGrammar = 0;
            this.lexOptions.useUnknownWordSignatures = 5;
            this.lexOptions.flexiTag = false;
            this.dcTags = true;
        } else if (args[i].equalsIgnoreCase("-chineseFactored")) {
            this.dcTags = false;
            this.lexOptions.useUnicodeType = true;
            Train.markovOrder = 2;
            Train.hSelSplit = true;
            Train.markovFactor = true;
            Train.HSEL_CUT = 50;
        } else if (args[i].equalsIgnoreCase("-arabicFactored")) {
            this.doDep = true;
            this.doPCFG = true;
            this.dcTags = false;
            Train.markovFactor = true;
            Train.markovOrder = 2;
            Train.hSelSplit = true;
            Train.HSEL_CUT = 75;
            Train.PA = true;
            Train.gPA = false;
            Train.selectiveSplit = true;
            Train.selectiveSplitCutOff = 300.0;
            Train.markUnary = 1;
            this.lexOptions.useUnknownWordSignatures = 9;
            this.lexOptions.unknownPrefixSize = 1;
            this.lexOptions.unknownSuffixSize = 1;
            Test.MAX_ITEMS = 500000;
        } else if (args[i].equalsIgnoreCase("-chinesePCFG")) {
            this.doDep = false;
            this.doPCFG = true;
            this.dcTags = false;
        } else if (args[i].equalsIgnoreCase("-printTT") && i + 1 < args.length) {
            Train.printTreeTransformations = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-printAnnotatedRuleCounts")) {
            Train.printAnnotatedRuleCounts = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-printAnnotatedStateCounts")) {
            Train.printAnnotatedStateCounts = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-printAnnotated") && i + 1 < args.length) {
            try {
                Train.printAnnotatedPW = this.tlpParams.pw(new FileOutputStream(args[i + 1]));
            }
            catch (IOException ioe) {
                Train.printAnnotatedPW = null;
            }
            i += 2;
        } else if (args[i].equalsIgnoreCase("-printBinarized") && i + 1 < args.length) {
            try {
                Train.printBinarizedPW = this.tlpParams.pw(new FileOutputStream(args[i + 1]));
            }
            catch (IOException ioe) {
                Train.printBinarizedPW = null;
            }
            i += 2;
        } else if (args[i].equalsIgnoreCase("-printStates")) {
            Train.printStates = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-evals")) {
            Test.evals = StringUtils.stringToProperties(args[i + 1], Test.evals);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-fastFactoredCandidateMultiplier")) {
            Test.fastFactoredCandidateMultiplier = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-fastFactoredCandidateAddend")) {
            Test.fastFactoredCandidateAddend = Integer.parseInt(args[i + 1]);
            i += 2;
        }
        return i;
    }

    public TreebankLanguagePack langpack() {
        return this.tlpParams.treebankLanguagePack();
    }

    public void display() {
        System.err.println("Options parameters:");
        this.writeData(new PrintWriter(System.err));
        if (Train.printStates) {
            Options.dumpNumberer(Numberer.getGlobalNumberer("states"), "states", this.tlpParams.pw(System.err));
        }
    }

    public void writeData(Writer w) {
        this.numStates = Numberer.getGlobalNumberer("states").total();
        PrintWriter out2 = new PrintWriter(w);
        StringBuilder sb = new StringBuilder();
        sb.append("numStates ").append(this.numStates).append("\n");
        sb.append(this.lexOptions.toString());
        sb.append("parserParams ").append(this.tlpParams.getClass().getName()).append("\n");
        sb.append("forceCNF ").append(this.forceCNF).append("\n");
        sb.append("doPCFG ").append(this.doPCFG).append("\n");
        sb.append("doDep ").append(this.doDep).append("\n");
        sb.append("freeDependencies ").append(this.freeDependencies).append("\n");
        sb.append("directional ").append(this.directional).append("\n");
        sb.append("genStop ").append(this.genStop).append("\n");
        sb.append("distance ").append(this.distance).append("\n");
        sb.append("coarseDistance ").append(this.coarseDistance).append("\n");
        sb.append("dcTags ").append(this.dcTags).append("\n");
        sb.append("nPrune ").append(this.nodePrune).append("\n");
        out2.print(sb.toString());
        out2.flush();
    }

    private static void dumpNumberer(Numberer num, String name, PrintWriter pw) {
        pw.println("### Sorted contents of " + name);
        ArrayList lis = new ArrayList((Collection)ErasureUtils.uncheckedCast(num.objects()));
        Collections.sort(lis);
        for (Comparable obj : lis) {
            pw.println(obj);
        }
        pw.println("### End sorted contents of " + name);
        pw.flush();
    }

    public void readData(BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null && !line.matches("^numStates.*")) {
        }
        if (line == null) {
            throw new IOException("Bad Options format: no numStates");
        }
        String value = line.substring(line.indexOf(32) + 1);
        this.numStates = Integer.parseInt(value);
        this.lexOptions.readData(in);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        try {
            this.tlpParams = (TreebankLangParserParams)Class.forName(value).newInstance();
        }
        catch (Exception e) {
            IOException ioe = new IOException("Problem instantiating parserParams: " + line);
            ioe.initCause(e);
            throw ioe;
        }
        line = in.readLine();
        if (line.matches("^forceCNF.*")) {
            value = line.substring(line.indexOf(32) + 1);
            this.forceCNF = Boolean.parseBoolean(value);
            line = in.readLine();
        }
        value = line.substring(line.indexOf(32) + 1);
        this.doPCFG = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.doDep = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.freeDependencies = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.directional = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.genStop = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.distance = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.coarseDistance = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.dcTags = Boolean.parseBoolean(value);
        line = in.readLine();
        if (!line.matches("^nPrune.*")) {
            throw new RuntimeException("Expected nPrune, found: " + line);
        }
        value = line.substring(line.indexOf(32) + 1);
        this.nodePrune = Boolean.parseBoolean(value);
        line = in.readLine();
        if (line.length() != 0) {
            throw new RuntimeException("Expected blank line, found: " + line);
        }
    }

    public static class LexOptions
    implements Serializable {
        public int useUnknownWordSignatures = 0;
        public int smoothInUnknownsThreshold = 100;
        public boolean smartMutation = false;
        public boolean useUnicodeType = false;
        public int unknownSuffixSize = 1;
        public int unknownPrefixSize = 1;
        public String uwModel;
        public boolean flexiTag = false;
        private static final long serialVersionUID = 2805351374506855632L;
        private static final String[] params = new String[]{"useUnknownWordSignatures", "smoothInUnknownsThreshold", "smartMutation", "useUnicodeType", "unknownSuffixSize", "unknownPrefixSize", "flexiTag"};

        public String toString() {
            return params[0] + " " + this.useUnknownWordSignatures + "\n" + params[1] + " " + this.smoothInUnknownsThreshold + "\n" + params[2] + " " + this.smartMutation + "\n" + params[3] + " " + this.useUnicodeType + "\n" + params[4] + " " + this.unknownSuffixSize + "\n" + params[5] + " " + this.unknownPrefixSize + "\n" + params[6] + " " + this.flexiTag + "\n";
        }

        public void readData(BufferedReader in) throws IOException {
            block9: for (int i = 0; i < params.length; ++i) {
                String line = in.readLine();
                int idx = line.indexOf(32);
                String key = line.substring(0, idx);
                String value = line.substring(idx + 1);
                if (!key.equalsIgnoreCase(params[i])) {
                    System.err.println("Yikes!!! Expected " + params[i] + " got " + key);
                }
                switch (i) {
                    case 0: {
                        this.useUnknownWordSignatures = Integer.parseInt(value);
                        continue block9;
                    }
                    case 1: {
                        this.smoothInUnknownsThreshold = Integer.parseInt(value);
                        continue block9;
                    }
                    case 2: {
                        this.smartMutation = Boolean.parseBoolean(value);
                        continue block9;
                    }
                    case 3: {
                        this.useUnicodeType = Boolean.parseBoolean(value);
                        continue block9;
                    }
                    case 4: {
                        this.unknownSuffixSize = Integer.parseInt(value);
                        continue block9;
                    }
                    case 5: {
                        this.unknownPrefixSize = Integer.parseInt(value);
                        continue block9;
                    }
                    case 6: {
                        this.flexiTag = Boolean.parseBoolean(value);
                    }
                }
            }
        }
    }
}

