/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.util.AbstractIterator;
import edu.stanford.nlp.util.ErasureUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtils {
    private static final int SLURPBUFFSIZE = 16000;

    private IOUtils() {
    }

    public static File writeObjectToFile(Object o, String filename) throws IOException {
        return IOUtils.writeObjectToFile(o, new File(filename));
    }

    public static File writeObjectToFile(Object o, File file) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
        oos.writeObject(o);
        oos.close();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeObjectToFileNoExceptions(Object o, String filename) {
        File file = null;
        ObjectOutputStream oos = null;
        try {
            file = new File(filename);
            oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
            oos.writeObject(o);
            oos.close();
            IOUtils.closeIgnoringExceptions(oos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeIgnoringExceptions(oos);
        }
        return file;
    }

    public static File writeObjectToTempFile(Object o, String filename) throws IOException {
        File file = File.createTempFile(filename, ".tmp");
        file.deleteOnExit();
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
        oos.writeObject(o);
        oos.close();
        return file;
    }

    public static File writeObjectToTempFileNoExceptions(Object o, String filename) {
        try {
            return IOUtils.writeObjectToTempFile(o, filename);
        }
        catch (Exception e) {
            System.err.println("Error writing object to file " + filename);
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T readObjectFromFile(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
        Object o = ois.readObject();
        ois.close();
        return ErasureUtils.uncheckedCast(o);
    }

    public static <T> T readObjectFromFile(String filename) throws IOException, ClassNotFoundException {
        return ErasureUtils.uncheckedCast(IOUtils.readObjectFromFile(new File(filename)));
    }

    public static <T> T readObjectFromFileNoExceptions(File file) {
        Object o = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
            o = ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return ErasureUtils.uncheckedCast(o);
    }

    public static int lineCount(File textFile) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(textFile));
        int numLines = 0;
        while (r.readLine() != null) {
            ++numLines;
        }
        return numLines;
    }

    public static ObjectOutputStream writeStreamFromString(String serializePath) throws IOException {
        ObjectOutputStream oos = serializePath.endsWith(".gz") ? new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(serializePath)))) : new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(serializePath)));
        return oos;
    }

    public static ObjectInputStream readStreamFromString(String filenameOrUrl) throws IOException {
        InputStream is;
        if (filenameOrUrl.matches("https?://.*")) {
            URL u = new URL(filenameOrUrl);
            URLConnection uc = u.openConnection();
            is = uc.getInputStream();
        } else {
            is = new FileInputStream(filenameOrUrl);
        }
        ObjectInputStream in = filenameOrUrl.endsWith(".gz") ? new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(is))) : new ObjectInputStream(new BufferedInputStream(is));
        return in;
    }

    private static InputStream getInputStreamFromString(String textFileOrUrl) throws IOException {
        InputStream is;
        if (textFileOrUrl.matches("https?://.*")) {
            URL u = new URL(textFileOrUrl);
            URLConnection uc = u.openConnection();
            is = uc.getInputStream();
        } else {
            is = new FileInputStream(textFileOrUrl);
        }
        if (textFileOrUrl.endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        return is;
    }

    public static BufferedReader readReaderFromString(String textFileOrUrl) throws IOException {
        return new BufferedReader(new InputStreamReader(IOUtils.getInputStreamFromString(textFileOrUrl)));
    }

    public static BufferedReader readReaderFromString(String textFileOrUrl, String encoding) throws IOException {
        InputStream is = IOUtils.getInputStreamFromString(textFileOrUrl);
        return new BufferedReader(new InputStreamReader(is, encoding));
    }

    public static Iterable<String> readLines(String path) {
        return IOUtils.readLines(new File(path));
    }

    public static Iterable<String> readLines(File file) {
        return IOUtils.readLines(file, null);
    }

    public static Iterable<String> readLines(final File file, final Class<? extends InputStream> fileInputStreamWrapper) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    protected BufferedReader reader = this.getReader();
                    protected String line = this.getLine();

                    @Override
                    public boolean hasNext() {
                        return this.line != null;
                    }

                    @Override
                    public String next() {
                        String nextLine = this.line;
                        if (nextLine == null) {
                            throw new NoSuchElementException();
                        }
                        this.line = this.getLine();
                        return nextLine;
                    }

                    protected String getLine() {
                        try {
                            String result = this.reader.readLine();
                            if (result == null) {
                                this.reader.close();
                            }
                            return result;
                        }
                        catch (IOException e) {
                            throw new RuntimeIOException(e);
                        }
                    }

                    protected BufferedReader getReader() {
                        try {
                            InputStream stream = new FileInputStream(file);
                            if (fileInputStreamWrapper != null) {
                                stream = (InputStream)fileInputStreamWrapper.getConstructor(InputStream.class).newInstance(stream);
                            }
                            return new BufferedReader(new InputStreamReader(stream));
                        }
                        catch (Exception e) {
                            throw new RuntimeIOException(e);
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static InputStream openFile(File file) throws RuntimeIOException {
        try {
            FilterInputStream is = new BufferedInputStream(new FileInputStream(file));
            if (file.getName().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            return is;
        }
        catch (Exception e) {
            throw new RuntimeIOException(e);
        }
    }

    public static void closeIgnoringExceptions(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static Iterable<File> iterFilesRecursive(File dir) {
        return IOUtils.iterFilesRecursive(dir, (Pattern)null);
    }

    public static Iterable<File> iterFilesRecursive(File dir, String ext) {
        return IOUtils.iterFilesRecursive(dir, Pattern.compile(Pattern.quote(ext) + "$"));
    }

    public static Iterable<File> iterFilesRecursive(final File dir, final Pattern pattern) {
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new AbstractIterator<File>(){
                    private Queue<File> files;
                    private File file;
                    {
                        this.files = new LinkedList<File>(Collections.singleton(dir));
                        this.file = this.findNext();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.file != null;
                    }

                    @Override
                    public File next() {
                        File result = this.file;
                        if (result == null) {
                            throw new NoSuchElementException();
                        }
                        this.file = this.findNext();
                        return result;
                    }

                    private File findNext() {
                        File next = null;
                        while (!this.files.isEmpty() && next == null) {
                            next = this.files.remove();
                            if (next.isDirectory()) {
                                this.files.addAll(Arrays.asList(next.listFiles()));
                                next = null;
                                continue;
                            }
                            if (pattern == null || pattern.matcher(next.getPath()).find()) continue;
                            next = null;
                        }
                        return next;
                    }
                };
            }
        };
    }

    public static String slurpFile(File file) throws IOException {
        FileReader r = new FileReader(file);
        return IOUtils.slurpReader(r);
    }

    public static String slurpGZippedFile(String filename) throws IOException {
        InputStreamReader r = new InputStreamReader(new GZIPInputStream(new FileInputStream(filename)));
        return IOUtils.slurpReader(r);
    }

    public static String slurpGZippedFile(File file) throws IOException {
        InputStreamReader r = new InputStreamReader(new GZIPInputStream(new FileInputStream(file)));
        return IOUtils.slurpReader(r);
    }

    public static String slurpGBFileNoExceptions(String filename) {
        return IOUtils.slurpFileNoExceptions(filename, "GB18030");
    }

    public static String slurpFile(String filename, String encoding) throws IOException {
        InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(filename), encoding);
        return IOUtils.slurpReader(r);
    }

    public static String slurpFileNoExceptions(String filename, String encoding) {
        try {
            return IOUtils.slurpFile(filename, encoding);
        }
        catch (Exception e) {
            throw new RuntimeIOException("slurpFile IO problem", e);
        }
    }

    public static String slurpGBFile(String filename) throws IOException {
        return IOUtils.slurpFile(filename, "GB18030");
    }

    public static String slurpFile(String filename) throws IOException {
        return IOUtils.slurpReader(new FileReader(filename));
    }

    public static String slurpGBURL(URL u) throws IOException {
        return IOUtils.slurpURL(u, "GB18030");
    }

    public static String slurpGBURLNoExceptions(URL u) {
        try {
            return IOUtils.slurpGBURL(u);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpURLNoExceptions(URL u, String encoding) {
        try {
            return IOUtils.slurpURL(u, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpURL(URL u, String encoding) throws IOException {
        String temp;
        InputStream is;
        String lineSeparator = System.getProperty("line.separator");
        URLConnection uc = u.openConnection();
        uc.setReadTimeout(30000);
        try {
            is = uc.getInputStream();
        }
        catch (SocketTimeoutException e) {
            System.err.println("Time out. Return empty string");
            return "";
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
        StringBuilder buff = new StringBuilder(16000);
        while ((temp = br.readLine()) != null) {
            buff.append(temp);
            buff.append(lineSeparator);
        }
        br.close();
        return buff.toString();
    }

    public static String slurpURL(URL u) throws IOException {
        String temp;
        String lineSeparator = System.getProperty("line.separator");
        URLConnection uc = u.openConnection();
        InputStream is = uc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder buff = new StringBuilder(16000);
        while ((temp = br.readLine()) != null) {
            buff.append(temp);
            buff.append(lineSeparator);
        }
        br.close();
        return buff.toString();
    }

    public static String slurpURLNoExceptions(URL u) {
        try {
            return IOUtils.slurpURL(u);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpURL(String path) throws Exception {
        return IOUtils.slurpURL(new URL(path));
    }

    public static String slurpURLNoExceptions(String path) {
        try {
            return IOUtils.slurpURL(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpFileNoExceptions(File file) {
        try {
            return IOUtils.slurpReader(new FileReader(file));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpFileNoExceptions(String filename) {
        try {
            return IOUtils.slurpFile(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpReader(Reader reader) {
        BufferedReader r = new BufferedReader(reader);
        StringBuilder buff = new StringBuilder();
        try {
            int amountRead;
            char[] chars = new char[16000];
            while ((amountRead = r.read(chars, 0, 16000)) >= 0) {
                buff.append(chars, 0, amountRead);
            }
            r.close();
        }
        catch (Exception e) {
            throw new RuntimeIOException("slurpReader IO problem", e);
        }
        return buff.toString();
    }

    public static void writeStreamToStream(InputStream input, OutputStream output) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = input.read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
    }
}

