/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace;

import edu.mit.blocks.renderable.BlockUtilities;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;

public class TrashCan
extends JComponent
implements MouseListener,
WorkspaceWidget,
ComponentListener {
    private static final long serialVersionUID = 328149080275L;
    private Image tcImage;
    private Image openedTcImage;
    private Image currentImage;
    private Color currentColor = Color.BLACK;

    public TrashCan(Image trashCanImage, Image openedTrashCanImage) {
        this.tcImage = trashCanImage;
        this.openedTcImage = openedTrashCanImage;
        this.currentImage = this.tcImage;
        int width = 0;
        int height = 0;
        width = this.tcImage.getWidth(null) > this.openedTcImage.getWidth(null) ? this.tcImage.getWidth(null) : this.openedTcImage.getWidth(null);
        height = this.tcImage.getHeight(null) > this.openedTcImage.getHeight(null) ? this.tcImage.getHeight(null) : this.openedTcImage.getHeight(null);
        if (width > 0 && height > 0) {
            this.setSize(width, height);
            this.setPreferredSize(new Dimension(width, height));
        } else {
            this.setSize(150, 200);
            this.setPreferredSize(new Dimension(150, 200));
        }
        this.setLayout(null);
        this.setLocation(500, 400);
        this.addMouseListener(this);
        Workspace.getInstance().addComponentListener(this);
    }

    @Override
    public void paint(Graphics g) {
        if (this.currentImage == null) {
            g.setColor(this.currentColor);
            ((Graphics2D)g).fillRect(0, 0, 150, 200);
        } else {
            g.drawImage(this.currentImage, 0, 0, null);
        }
    }

    @Override
    public void blockDropped(RenderableBlock block) {
        BlockUtilities.deleteBlock(block);
        this.currentColor = Color.BLACK;
        this.currentImage = this.tcImage;
        this.revalidate();
        this.repaint();
    }

    @Override
    public void addBlock(RenderableBlock block) {
    }

    @Override
    public void addBlocks(Collection<RenderableBlock> block) {
    }

    @Override
    public void removeBlock(RenderableBlock block) {
    }

    @Override
    public void blockDragged(RenderableBlock block) {
    }

    @Override
    public void blockEntered(RenderableBlock block) {
        this.currentColor = Color.RED;
        this.currentImage = this.openedTcImage;
        this.repaint();
    }

    @Override
    public void blockExited(RenderableBlock block) {
        this.currentColor = Color.BLACK;
        this.currentImage = this.tcImage;
        this.repaint();
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    public Collection<RenderableBlock> getBlocks() {
        return new ArrayList<RenderableBlock>();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Point location = new Point(Workspace.getInstance().getWidth(), Workspace.getInstance().getHeight());
        location.translate(-this.getWidth() - 50, -this.getHeight() - 50);
        this.setLocation(location);
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

