/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace;

import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.BlockCanvas;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ContextMenu
extends PopupMenu
implements ActionListener {
    private static final long serialVersionUID = 328149080421L;
    private static ContextMenu rndBlockMenu = new ContextMenu();
    private static ContextMenu addCommentMenu = new ContextMenu();
    private static MenuItem addCommentItem;
    private static final String ADD_COMMENT_BLOCK = "ADDCOMMENT";
    private static boolean addCommentMenuInit;
    private static ContextMenu removeCommentMenu;
    private static MenuItem removeCommentItem;
    private static final String REMOVE_COMMENT_BLOCK = "REMOVECOMMENT";
    private static boolean removeCommentMenuInit;
    private static ContextMenu canvasMenu;
    private static MenuItem arrangeAllBlocks;
    private static final String ARRANGE_ALL_BLOCKS = "ARRANGE_ALL_BLOCKS";
    private static boolean canvasMenuInit;
    private static Object activeComponent;

    private ContextMenu() {
    }

    private static void initAddCommentMenu() {
        addCommentItem = new MenuItem("Add Comment");
        addCommentItem.setActionCommand(ADD_COMMENT_BLOCK);
        addCommentItem.addActionListener(rndBlockMenu);
        addCommentMenu.add(addCommentItem);
        addCommentMenuInit = true;
    }

    private static void initRemoveCommentMenu() {
        removeCommentItem = new MenuItem("Delete Comment");
        removeCommentItem.setActionCommand(REMOVE_COMMENT_BLOCK);
        removeCommentItem.addActionListener(rndBlockMenu);
        removeCommentMenu.add(removeCommentItem);
        removeCommentMenuInit = true;
    }

    private static void initCanvasMenu() {
        arrangeAllBlocks = new MenuItem("Organize all blocks");
        arrangeAllBlocks.setActionCommand(ARRANGE_ALL_BLOCKS);
        arrangeAllBlocks.addActionListener(canvasMenu);
        canvasMenu.add(arrangeAllBlocks);
        canvasMenuInit = true;
    }

    public static PopupMenu getContextMenuFor(Object o) {
        if (o instanceof RenderableBlock) {
            if (((RenderableBlock)o).hasComment()) {
                if (!removeCommentMenuInit) {
                    ContextMenu.initRemoveCommentMenu();
                }
                activeComponent = o;
                return removeCommentMenu;
            }
            if (!addCommentMenuInit) {
                ContextMenu.initAddCommentMenu();
            }
            activeComponent = o;
            return addCommentMenu;
        }
        if (o instanceof BlockCanvas) {
            if (!canvasMenuInit) {
                ContextMenu.initCanvasMenu();
            }
            activeComponent = o;
            return canvasMenu;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        if (a.getActionCommand() == ARRANGE_ALL_BLOCKS) {
            if (activeComponent != null && activeComponent instanceof BlockCanvas) {
                ((BlockCanvas)activeComponent).arrangeAllBlocks();
            }
        } else if (a.getActionCommand() == ADD_COMMENT_BLOCK) {
            if (activeComponent != null && activeComponent instanceof RenderableBlock) {
                ((RenderableBlock)activeComponent).addComment();
            }
        } else if (a.getActionCommand() == REMOVE_COMMENT_BLOCK && activeComponent != null && activeComponent instanceof RenderableBlock) {
            ((RenderableBlock)activeComponent).removeComment();
        }
    }

    static {
        addCommentMenuInit = false;
        removeCommentMenu = new ContextMenu();
        removeCommentMenuInit = false;
        canvasMenu = new ContextMenu();
        canvasMenuInit = false;
        activeComponent = null;
    }
}

