/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.renderable;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockConnectorShape;
import edu.mit.blocks.codeblocks.BlockLink;
import edu.mit.blocks.codeblocks.BlockLinkChecker;
import edu.mit.blocks.codeblocks.BlockShape;
import edu.mit.blocks.codeblocks.BlockStub;
import edu.mit.blocks.codeblocks.InfixBlockShape;
import edu.mit.blocks.codeblocks.JComponentDragHandler;
import edu.mit.blocks.codeblocks.rendering.BlockShapeUtil;
import edu.mit.blocks.codeblockutil.CToolTip;
import edu.mit.blocks.codeblockutil.GraphicsManager;
import edu.mit.blocks.renderable.BlockImageIcon;
import edu.mit.blocks.renderable.BlockLabel;
import edu.mit.blocks.renderable.BlockUtilities;
import edu.mit.blocks.renderable.CollapseLabel;
import edu.mit.blocks.renderable.Comment;
import edu.mit.blocks.renderable.CommentLabel;
import edu.mit.blocks.renderable.CommentSource;
import edu.mit.blocks.renderable.ConnectorTag;
import edu.mit.blocks.renderable.NameLabel;
import edu.mit.blocks.renderable.PageLabel;
import edu.mit.blocks.renderable.RBHighlightHandler;
import edu.mit.blocks.renderable.SocketLabel;
import edu.mit.blocks.workspace.ContextMenu;
import edu.mit.blocks.workspace.FactoryManager;
import edu.mit.blocks.workspace.ISupportMemento;
import edu.mit.blocks.workspace.MiniMap;
import edu.mit.blocks.workspace.RBParent;
import edu.mit.blocks.workspace.SearchableElement;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEvent;
import edu.mit.blocks.workspace.WorkspaceWidget;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RenderableBlock
extends JComponent
implements SearchableElement,
MouseListener,
MouseMotionListener,
ISupportMemento,
CommentSource {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private static final double NEARBY_RADIUS = 20.0;
    private static final float DRAGGING_ALPHA = 0.66f;
    private static final Map<Long, RenderableBlock> ALL_RENDERABLE_BLOCKS = new HashMap<Long, RenderableBlock>();
    private final Long blockID;
    private WorkspaceWidget parent;
    private WorkspaceWidget lastDragWidget = null;
    private Comment comment = null;
    private boolean commentLabelChanged = false;
    private JComponent blockWidget = null;
    private BlockShape blockShape;
    private Area abstractBlockArea;
    private Area blockArea;
    private BufferedImage buffImg = null;
    private RBHighlightHandler highlighter;
    private JComponentDragHandler dragHandler;
    private boolean isSearchResult = false;
    private boolean pickedUp = false;
    private boolean dragging = false;
    private boolean linkedDefArgsBefore = false;
    private boolean isLoading = false;
    private final NameLabel blockLabel;
    private final PageLabel pageLabel;
    private final ConnectorTag plugTag;
    private final ConnectorTag afterTag;
    private final ConnectorTag beforeTag;
    private List<ConnectorTag> socketTags = new ArrayList<ConnectorTag>();
    private CollapseLabel collapseLabel;
    private HashMap<BlockImageIcon.ImageLocation, BlockImageIcon> imageMap = new HashMap();
    private double unzoomedX;
    private double unzoomedY;
    private double zoom = 1.0;

    public RenderableBlock(WorkspaceWidget parent, Long blockID) {
        this(parent, blockID, false);
    }

    private RenderableBlock(WorkspaceWidget parent, Long blockID, boolean isLoading) {
        this.setFocusTraversalKeysEnabled(false);
        this.parent = parent;
        this.blockID = blockID;
        ALL_RENDERABLE_BLOCKS.put(this.blockID, this);
        for (BlockImageIcon img : this.getBlock().getInitBlockImageMap().values()) {
            this.imageMap.put(img.getImageLocation(), new BlockImageIcon(img.getImageIcon(), img.getImageLocation(), img.isEditable(), img.wrapText()));
            this.add(this.imageMap.get((Object)img.getImageLocation()));
        }
        this.setLayout(null);
        this.dragHandler = new JComponentDragHandler(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.plugTag = new ConnectorTag(this.getBlock().getPlug());
        this.afterTag = new ConnectorTag(this.getBlock().getAfterConnector());
        this.beforeTag = new ConnectorTag(this.getBlock().getBeforeConnector());
        this.blockLabel = new NameLabel(this.getBlock().getBlockLabel(), BlockLabel.Type.NAME_LABEL, this.getBlock().isLabelEditable(), blockID);
        this.pageLabel = new PageLabel(this.getBlock().getPageLabel(), BlockLabel.Type.PAGE_LABEL, false, blockID);
        this.add(this.pageLabel.getJComponent());
        this.add((Component)this.blockLabel.getJComponent(), 0);
        this.synchronizeSockets();
        if (this.getBlock().isProcedureDeclBlock() && (parent == null || !(parent instanceof FactoryManager))) {
            this.collapseLabel = new CollapseLabel(blockID);
            this.add(this.collapseLabel);
        }
        this.blockShape = this.getBlock().isInfix() ? new InfixBlockShape(this) : new BlockShape(this);
        if (!isLoading) {
            this.reformBlockShape();
            this.updateBuffImg();
        } else {
            this.blockArea = new Area();
        }
        this.highlighter = new RBHighlightHandler(this);
        String blockDescription = this.getBlock().getBlockDescription();
        if (blockDescription != null) {
            this.setBlockToolTip(this.getBlock().getBlockDescription().trim());
        }
        this.setCursor(this.dragHandler.getDragHintCursor());
    }

    @Override
    public Long getBlockID() {
        return this.blockID;
    }

    public int getBlockHeight() {
        return this.blockArea.getBounds().height;
    }

    public Dimension getBlockSize() {
        return this.blockArea.getBounds().getSize();
    }

    public int getBlockWidth() {
        return this.blockArea.getBounds().width;
    }

    public BlockShape getBlockShape() {
        return this.blockShape;
    }

    Area getAbstractBlockArea() {
        return this.abstractBlockArea;
    }

    void setAbstractBlockArea(Area abstractBlockArea) {
        this.abstractBlockArea = abstractBlockArea;
    }

    @Override
    public void setLocation(int x, int y) {
        int dx = x - this.getX();
        int dy = y - this.getY();
        super.setLocation(x, y);
        if (this.hasComment() && (dx != x || dy != y)) {
            if (this.getComment().getParent() != this.getParent()) {
                this.getComment().setParent(this.getParent(), Workspace.DRAGGED_BLOCK_LAYER);
            }
            this.getComment().translatePosition(dx, dy);
        }
    }

    @Override
    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public int getHighlightStrokeWidth() {
        return 12;
    }

    public Rectangle getStackBounds() {
        return new Rectangle(this.getLocation(), this.calcStackDimensions(this));
    }

    private Dimension calcStackDimensions(RenderableBlock rb) {
        if (rb.getBlock().getAfterBlockID() != Block.NULL) {
            Dimension dim = this.calcStackDimensions(RenderableBlock.getRenderableBlock(rb.getBlock().getAfterBlockID()));
            return new Dimension(Math.max(rb.getBlockWidth() + rb.getMaxWidthOfSockets(rb.getBlockID()), dim.width), rb.getBlockHeight() + dim.height);
        }
        return new Dimension(rb.getBlockWidth() + rb.getMaxWidthOfSockets(rb.blockID), rb.getBlockHeight());
    }

    public void switchToLabelEditingMode(boolean highlighted) {
        if (this.getBlock().isLabelEditable()) {
            if (highlighted) {
                this.blockLabel.setEditingState(true);
                this.blockLabel.highlightText();
            } else {
                this.blockLabel.setEditingState(true);
            }
        }
    }

    JComponent getBlockWidget() {
        return this.blockWidget;
    }

    public Dimension getBlockWidgetDimension() {
        if (this.blockWidget == null) {
            return new Dimension(0, 0);
        }
        return this.blockWidget.getSize();
    }

    public void setBlockWidget(JComponent blockWidget) {
        if (this.blockWidget != null) {
            this.remove(this.blockWidget);
        }
        this.blockWidget = blockWidget;
        if (blockWidget != null) {
            this.add(blockWidget);
        }
        this.revalidate();
    }

    public static void reset() {
        ALL_RENDERABLE_BLOCKS.clear();
        BlockUtilities.reset();
        Block.reset();
        BlockStub.reset();
        System.gc();
    }

    public JComponentDragHandler getDragHandler() {
        return this.dragHandler;
    }

    public BlockImageIcon getImageIconAt(BlockImageIcon.ImageLocation location) {
        return this.imageMap.get((Object)location);
    }

    private boolean synchronizeSockets() {
        boolean changed = false;
        ArrayList<ConnectorTag> newSocketTags = new ArrayList<ConnectorTag>();
        for (ConnectorTag tag : this.socketTags) {
            if (tag.getLabel() == null) continue;
            this.remove(tag.getLabel().getJComponent());
        }
        for (int i = 0; i < this.getBlock().getNumSockets(); ++i) {
            String argumentToolTip;
            SocketLabel label;
            BlockConnector socket = this.getBlock().getSocketAt(i);
            ConnectorTag tag = this.getConnectorTag(socket);
            if (tag == null) {
                tag = new ConnectorTag(socket);
                if (SocketLabel.ignoreSocket(socket)) {
                    tag.setLabel(null);
                } else {
                    label = new SocketLabel(socket, socket.getLabel(), BlockLabel.Type.PORT_LABEL, socket.isLabelEditable(), this.blockID);
                    argumentToolTip = this.getBlock().getArgumentDescription(i);
                    if (argumentToolTip != null) {
                        label.setToolTipText(this.getBlock().getArgumentDescription(i).trim());
                    }
                    tag.setLabel(label);
                    label.setZoomLevel(this.getZoom());
                    label.setText(socket.getLabel());
                    this.add(label.getJComponent());
                    changed = true;
                }
            } else {
                label = tag.getLabel();
                if (!SocketLabel.ignoreSocket(socket)) {
                    if (label == null) {
                        label = new SocketLabel(socket, socket.getLabel(), BlockLabel.Type.PORT_LABEL, socket.isLabelEditable(), this.blockID);
                        argumentToolTip = this.getBlock().getArgumentDescription(i);
                        if (argumentToolTip != null) {
                            label.setToolTipText(this.getBlock().getArgumentDescription(i).trim());
                        }
                        tag.setLabel(label);
                        label.setText(socket.getLabel());
                        this.add(label.getJComponent());
                        changed = true;
                    } else {
                        label.setText(socket.getLabel());
                        this.add(label.getJComponent());
                        changed = true;
                    }
                    label.setZoomLevel(this.getZoom());
                }
            }
            newSocketTags.add(tag);
        }
        this.socketTags.clear();
        this.socketTags = newSocketTags;
        return changed;
    }

    private boolean synchronizeLabelsAndSockets() {
        BlockConnector plug;
        Block plugBlock;
        boolean blockLabelChanged = this.getBlock().getBlockLabel() != null && !this.blockLabel.getText().equals(this.getBlock().getBlockLabel());
        boolean pageLabelChanged = this.getBlock().getPageLabel() != null && !this.pageLabel.getText().equals(this.getBlock().getPageLabel());
        boolean socketLabelsChanged = false;
        for (int i = 0; i < this.getBlock().getNumSockets(); ++i) {
            BlockConnector socket = this.getBlock().getSocketAt(i);
            ConnectorTag tag = this.getConnectorTag(socket);
            if (tag != null && tag.getLabel() != null && !tag.getLabel().getText().equals(socket.getLabel())) {
                socketLabelsChanged = this.synchronizeSockets();
                break;
            }
            if (socket.isLabelEditable()) continue;
            socketLabelsChanged = this.synchronizeSockets();
            break;
        }
        if (blockLabelChanged) {
            this.blockLabel.setText(this.getBlock().getBlockLabel());
        }
        if (pageLabelChanged) {
            this.pageLabel.setText(this.getBlock().getPageLabel());
        }
        if (blockLabelChanged || pageLabelChanged || socketLabelsChanged || this.commentLabelChanged) {
            this.reformBlockShape();
            this.commentLabelChanged = false;
        }
        if (BlockLinkChecker.hasPlugEquivalent(this.getBlock()) && (plugBlock = Block.getBlock((plug = BlockLinkChecker.getPlugEquivalent(this.getBlock())).getBlockID())) != null) {
            if (plugBlock.getConnectorTo(this.blockID) == null) {
                throw new RuntimeException("one-sided connection from " + this.getBlock().getBlockLabel() + " to " + Block.getBlock(this.blockID).getBlockLabel());
            }
            RenderableBlock.getRenderableBlock(plug.getBlockID()).updateSocketSpace(plugBlock.getConnectorTo(this.blockID), this.blockID, true);
        }
        return false;
    }

    public int accomodateLabelsWidth() {
        int maxSocketWidth = 0;
        int width = 0;
        for (ConnectorTag tag : this.socketTags) {
            SocketLabel label = tag.getLabel();
            if (label == null) continue;
            maxSocketWidth = Math.max(maxSocketWidth, label.getAbstractWidth());
        }
        if (this.getBlock().hasPageLabel()) {
            width += Math.max(this.blockLabel.getAbstractWidth(), this.pageLabel.getAbstractWidth()) + maxSocketWidth;
            width += this.getControlLabelsWidth();
        } else {
            width += this.blockLabel.getAbstractWidth() + maxSocketWidth;
            width += this.getControlLabelsWidth() + 4;
        }
        return width;
    }

    public int accomodatePageLabelHeight() {
        if (this.getBlock().hasPageLabel()) {
            return this.pageLabel.getAbstractHeight();
        }
        return 0;
    }

    public void setBlockLabelUneditable() {
        this.blockLabel.setEditable(false);
    }

    public int accomodateImagesHeight() {
        int maxImgHt = 0;
        for (BlockImageIcon img : this.getBlock().getInitBlockImageMap().values()) {
            maxImgHt += img.getImageIcon().getIconHeight();
        }
        return maxImgHt;
    }

    public int accomodateImagesWidth() {
        int maxImgWt = 0;
        for (BlockImageIcon img : this.getBlock().getInitBlockImageMap().values()) {
            maxImgWt += img.getImageIcon().getIconWidth();
        }
        return maxImgWt;
    }

    public BlockLink getNearbyLink() {
        return BlockLinkChecker.getLink(this, Workspace.getInstance().getBlockCanvas().getBlocks());
    }

    public int getMaxSocketShapeWidth() {
        int maxSocketWidth = 0;
        for (BlockConnector socket : this.getBlock().getSockets()) {
            int socketWidth = BlockConnectorShape.getConnectorDimensions((BlockConnector)socket).width;
            if (socketWidth <= maxSocketWidth) continue;
            maxSocketWidth = socketWidth;
        }
        return maxSocketWidth;
    }

    public Point getSocketPixelPoint(BlockConnector socket) {
        ConnectorTag tag = this.getConnectorTag(socket);
        if (tag != null) {
            return tag.getPixelLocation();
        }
        System.out.println("Error, Socket has no connector tag: " + socket);
        return new Point(0, -100);
    }

    public Point getSocketAbstractPoint(BlockConnector socket) {
        ConnectorTag tag = this.getConnectorTag(socket);
        return tag.getAbstractLocation();
    }

    public void updateSocketPoint(BlockConnector socket, Point2D point) {
        ConnectorTag tag = this.getConnectorTag(socket);
        tag.setAbstractLocation(point);
    }

    public void updateConnectors() {
        Block b = Block.getBlock(this.blockID);
        this.afterTag.setSocket(b.getAfterConnector());
        this.beforeTag.setSocket(b.getBeforeConnector());
        this.plugTag.setSocket(b.getPlug());
    }

    @Override
    public WorkspaceWidget getParentWidget() {
        return this.parent;
    }

    public void setParentWidget(WorkspaceWidget widget) {
        this.parent = widget;
    }

    @Override
    public boolean contains(int x, int y) {
        return this.blockArea.contains(x, y);
    }

    public Block getBlock() {
        return Block.getBlock(this.blockID);
    }

    public Color getBLockColor() {
        return this.getBlock().getColor();
    }

    public void linkDefArgs() {
        if (!this.linkedDefArgsBefore && this.getBlock().hasDefaultArgs()) {
            Iterator<Long> ids = this.getBlock().linkAllDefaultArgs().iterator();
            Iterator<BlockConnector> sockets = this.getBlock().getSockets().iterator();
            ArrayList<Long> idList = new ArrayList<Long>();
            ArrayList<BlockConnector> socketList = new ArrayList<BlockConnector>();
            ArrayList<RenderableBlock> argList = new ArrayList<RenderableBlock>();
            while (ids.hasNext() && sockets.hasNext()) {
                Long id = ids.next();
                BlockConnector socket = sockets.next();
                if (id == Block.NULL) continue;
                RenderableBlock arg = new RenderableBlock(this.getParentWidget(), id);
                arg.setZoomLevel(this.zoom);
                Point myLocation = this.getLocation();
                Point socketPt = this.getSocketPixelPoint(socket);
                Point plugPt = arg.getSocketPixelPoint(arg.getBlock().getPlug());
                arg.setLocation((int)(((Point2D)socketPt).getX() + (double)myLocation.x - ((Point2D)plugPt).getX()), (int)(((Point2D)socketPt).getY() + (double)myLocation.y - ((Point2D)plugPt).getY()));
                this.getConnectorTag(socket).setDimension(new Dimension(arg.getBlockWidth() - 8, arg.getBlockHeight()));
                this.getParentWidget().addBlock(arg);
                idList.add(id);
                socketList.add(socket);
                argList.add(arg);
            }
            int size = idList.size();
            for (int i = 0; i < size; ++i) {
                Workspace.getInstance().notifyListeners(new WorkspaceEvent(this.getParentWidget(), ((RenderableBlock)argList.get(i)).getBlockID(), 3, true));
                this.blockConnected((BlockConnector)socketList.get(i), (Long)idList.get(i));
                ((RenderableBlock)argList.get(i)).repaint();
            }
            this.redrawFromTop();
            this.linkedDefArgsBefore = true;
        }
    }

    public void ignoreDefaultArguments() {
        this.linkedDefArgsBefore = true;
    }

    public static RenderableBlock getRenderableBlock(Long blockID) {
        return ALL_RENDERABLE_BLOCKS.get(blockID);
    }

    public Dimension getSocketSpaceDimension(BlockConnector socket) {
        if (this.getConnectorTag(socket) == null) {
            return null;
        }
        return this.getConnectorTag(socket).getDimension();
    }

    private void updateSocketSpace(BlockConnector connectedSocket, long connectedToBlockID, boolean isConnected) {
        if (!isConnected) {
            this.getConnectorTag(connectedSocket).setDimension(null);
        } else {
            if (this.getBlock().getBeforeBlockID() != Block.NULL && BlockConnectorShape.isCommandConnector(connectedSocket) && connectedSocket.getPositionType() == BlockConnector.PositionType.BOTTOM) {
                Long beforeID = this.getBlock().getBeforeBlockID();
                BlockConnector beforeSocket = Block.getBlock(beforeID).getConnectorTo(this.getBlockID());
                RenderableBlock.getRenderableBlock(beforeID).updateSocketSpace(beforeSocket, this.getBlockID(), true);
                return;
            }
            this.getConnectorTag(connectedSocket).setDimension(this.calcDimensionOfSocket(connectedSocket));
        }
        this.reformBlockShape();
        this.clearBufferedImage();
        BlockConnector plugEquiv = BlockLinkChecker.getPlugEquivalent(this.getBlock());
        if (plugEquiv != null && plugEquiv.hasBlock()) {
            Long plugID = plugEquiv.getBlockID();
            BlockConnector socketEquiv = Block.getBlock(plugID).getConnectorTo(this.getBlockID());
            RenderableBlock.getRenderableBlock(plugID).updateSocketSpace(socketEquiv, this.getBlockID(), true);
        }
    }

    private Dimension calcDimensionOfSocket(BlockConnector socket) {
        Dimension finalDimension = new Dimension(0, 0);
        long curBlockID = socket.getBlockID();
        while (curBlockID != Block.NULL) {
            Block curBlock = Block.getBlock(curBlockID);
            RenderableBlock curRenderableBlock = RenderableBlock.getRenderableBlock(curBlockID);
            Dimension curRBSize = curRenderableBlock.getBlockSize();
            finalDimension.height += curRBSize.height;
            if (curBlock.hasAfterConnector()) {
                finalDimension.height = (int)((float)finalDimension.height - 4.0f);
            }
            int width = curRBSize.width;
            if (curBlock.getNumSockets() > 0 && !curBlock.isInfix()) {
                int maxSocWidth = this.getMaxWidthOfSockets(curBlockID);
                if (maxSocWidth == 0) {
                    width = (int)((double)width + 20.0 * curRenderableBlock.getZoom());
                }
                if (maxSocWidth > 0) {
                    maxSocWidth = (int)((float)maxSocWidth - 8.0f);
                    width = (int)((double)width + (double)maxSocWidth * curRenderableBlock.getZoom());
                }
            }
            if (width > finalDimension.width) {
                finalDimension.width = width;
            }
            curBlockID = Block.getBlock(curBlockID).getAfterBlockID();
        }
        return finalDimension;
    }

    public void redrawFromTop() {
        this.isLoading = false;
        for (BlockConnector socket : BlockLinkChecker.getSocketEquivalents(this.getBlock())) {
            if (socket.hasBlock()) {
                long curBlockID = socket.getBlockID();
                if (RenderableBlock.getRenderableBlock(curBlockID) == null) {
                    System.out.println("does not exist yet, block: " + curBlockID);
                    continue;
                }
                RenderableBlock.getRenderableBlock(curBlockID).redrawFromTop();
                this.getConnectorTag(socket).setDimension(this.calcDimensionOfSocket(socket));
                continue;
            }
            this.getConnectorTag(socket).setDimension(null);
        }
        this.reformBlockShape();
        this.clearBufferedImage();
    }

    public int getMaxWidthOfSockets(Long blockID) {
        int width = 0;
        Block block = Block.getBlock(blockID);
        RenderableBlock rb = RenderableBlock.getRenderableBlock(blockID);
        for (BlockConnector socket : block.getSockets()) {
            Dimension socketDim = rb.getSocketSpaceDimension(socket);
            if (socketDim == null || socketDim.width <= width) continue;
            width = socketDim.width;
        }
        return width;
    }

    public void blockConnected(BlockConnector connectedSocket, long connectedBlockID) {
        this.getBlock().blockConnected(connectedSocket, connectedBlockID);
        this.synchronizeSockets();
        this.moveConnectedBlocks();
        this.updateSocketSpace(connectedSocket, connectedBlockID, true);
    }

    public void blockDisconnected(BlockConnector disconnectedSocket) {
        this.getBlock().blockDisconnected(disconnectedSocket);
        this.updateSocketSpace(disconnectedSocket, Block.NULL, false);
        this.synchronizeSockets();
    }

    public void clearBufferedImage() {
        GraphicsManager.recycleGCCompatibleImage(this.buffImg);
        this.buffImg = null;
    }

    public void repaintBlock() {
        this.clearBufferedImage();
        if (this.isVisible()) {
            this.repaint();
            this.highlighter.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (!this.isLoading) {
            if (this.buffImg == null) {
                this.updateBuffImg();
            }
            if (this.dragging) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.66f));
                g2.drawImage((Image)this.buffImg, 0, 0, null);
                g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            } else {
                g2.drawImage((Image)this.buffImg, 0, 0, null);
            }
        }
    }

    private void reformBlockShape() {
        this.abstractBlockArea = this.blockShape.reformArea();
        AffineTransform at = new AffineTransform();
        at.setToScale(this.zoom, this.zoom);
        this.blockArea = this.abstractBlockArea.createTransformedArea(at);
        Rectangle updatedDimensionRect = new Rectangle(this.getX(), this.getY(), this.blockArea.getBounds().width, this.blockArea.getBounds().height);
        if (!this.getBounds().equals(updatedDimensionRect)) {
            this.moveConnectedBlocks();
        }
        this.setBounds(updatedDimensionRect);
        if (this.pageLabel != null && this.getBlock().hasPageLabel()) {
            this.pageLabel.update();
        }
        if (this.blockLabel != null) {
            this.blockLabel.update();
        }
        if (this.collapseLabel != null) {
            this.collapseLabel.update();
        }
        if (this.comment != null) {
            this.comment.update();
        }
        for (ConnectorTag tag : this.socketTags) {
            BlockConnector socket = tag.getSocket();
            SocketLabel label = tag.getLabel();
            if (label == null || SocketLabel.ignoreSocket(socket)) continue;
            label.update(this.getSocketAbstractPoint(socket));
        }
    }

    public Area getBlockArea() {
        return this.blockArea;
    }

    private void updateBuffImg() {
        if (!this.synchronizeLabelsAndSockets()) {
            this.reformBlockShape();
        }
        GraphicsManager.recycleGCCompatibleImage(this.buffImg);
        this.buffImg = GraphicsManager.getGCCompatibleImage(this.blockArea.getBounds().width, this.blockArea.getBounds().height);
        Graphics2D buffImgG2 = (Graphics2D)this.buffImg.getGraphics();
        Dimension updatedDimensionRect = new Dimension(this.blockArea.getBounds().getSize());
        Image bevelImage = BlockShapeUtil.getBevelImage(updatedDimensionRect.width, updatedDimensionRect.height, this.blockArea);
        buffImgG2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color blockColor = this.getBLockColor();
        buffImgG2.setColor(blockColor);
        buffImgG2.fill(this.blockArea);
        buffImgG2.drawImage(bevelImage, 0, 0, null);
        this.repositionBlockImages(this.blockArea.getBounds().width, this.blockArea.getBounds().height);
    }

    private void repositionBlockImages(int width, int height) {
        int margin = 5;
        for (BlockImageIcon img : this.imageMap.values()) {
            ImageIcon icon = img.getImageIcon();
            Point imgLoc = new Point(0, 0);
            if (img.getImageLocation() == BlockImageIcon.ImageLocation.CENTER) {
                imgLoc.setLocation((width - icon.getIconWidth()) / 2, (height - icon.getIconHeight()) / 2);
            } else if (img.getImageLocation() == BlockImageIcon.ImageLocation.NORTH) {
                imgLoc.setLocation((width - icon.getIconWidth()) / 2, margin);
            } else if (img.getImageLocation() == BlockImageIcon.ImageLocation.SOUTH) {
                imgLoc.setLocation((width - icon.getIconWidth()) / 2, height - margin - icon.getIconHeight());
            } else if (img.getImageLocation() == BlockImageIcon.ImageLocation.EAST) {
                imgLoc.setLocation(width - margin - icon.getIconWidth(), (height - icon.getIconHeight()) / 2);
            } else if (img.getImageLocation() == BlockImageIcon.ImageLocation.WEST) {
                imgLoc.setLocation(margin, (height - icon.getIconHeight()) / 2);
            } else if (img.getImageLocation() == BlockImageIcon.ImageLocation.NORTHEAST) {
                imgLoc.setLocation(width - margin - icon.getIconWidth(), margin);
            } else if (img.getImageLocation() == BlockImageIcon.ImageLocation.NORTHWEST) {
                imgLoc.setLocation(margin, margin);
            } else if (img.getImageLocation() == BlockImageIcon.ImageLocation.SOUTHEAST) {
                imgLoc.setLocation(width - margin - icon.getIconWidth(), height - margin - icon.getIconHeight());
            } else if (img.getImageLocation() == BlockImageIcon.ImageLocation.SOUTHWEST) {
                imgLoc.setLocation(margin, height - (icon.getIconHeight() + margin));
            }
            if (!this.getBlock().hasPlug() || img.getImageLocation() != BlockImageIcon.ImageLocation.EAST || img.getImageLocation() != BlockImageIcon.ImageLocation.NORTHEAST || img.getImageLocation() != BlockImageIcon.ImageLocation.SOUTHEAST) {
                // empty if block
            }
            imgLoc.x += 4;
            img.setLocation(imgLoc.x, imgLoc.y);
        }
    }

    public void setBlockHighlightColor(Color color) {
        this.highlighter.setHighlightColor(color);
    }

    public void resetHighlight() {
        this.highlighter.resetHighlight();
    }

    public void setHighlightParent(RBParent parent) {
        this.highlighter.setParent(parent);
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getParent() != null && this.getParent().isVisible();
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public void addComment() {
        if (!this.hasComment()) {
            int x = this.getX() + this.getWidth() + 30;
            int y = this.getY() - 40;
            this.comment = new Comment("", this, this.getBlock().getColor(), this.zoom);
            if (this.getParentWidget() != null) {
                this.comment.setParent(this.getParentWidget().getJComponent());
            } else {
                this.comment.setParent(this.getParent());
            }
            this.comment.setLocation(x, y);
            this.commentLabelChanged = true;
        }
        this.revalidate();
        this.getHighlightHandler().revalidate();
        this.updateBuffImg();
        this.comment.getArrow().updateArrow();
        this.getParent().repaint();
    }

    public void removeComment() {
        if (this.hasComment()) {
            this.comment.delete();
            this.comment = null;
            this.commentLabelChanged = true;
            this.reformBlockShape();
            this.revalidate();
            this.getHighlightHandler().revalidate();
            this.updateBuffImg();
            this.getParent().repaint();
        }
    }

    @Override
    public Point getCommentLocation() {
        CommentLabel commentLabel;
        Point location = this.getLocation();
        if (this.comment != null && (commentLabel = this.comment.getCommentLabel()) != null) {
            location.translate(commentLabel.getX() - 2, commentLabel.getY() - 2);
            location.translate(commentLabel.getWidth() / 2, commentLabel.getHeight() / 2);
        }
        return location;
    }

    public void moveConnectedBlocks() {
        if (this.getParent() == null) {
            return;
        }
        Block b = Block.getBlock(this.blockID);
        Point myScreenOffset = this.getLocation();
        for (BlockConnector socket : BlockLinkChecker.getSocketEquivalents(b)) {
            Point socketLocation = this.getSocketPixelPoint(socket);
            if (!socket.hasBlock()) continue;
            RenderableBlock rb = RenderableBlock.getRenderableBlock(socket.getBlockID());
            if (rb == null) {
                System.out.println("Block doesn't exist yet: " + socket.getBlockID());
                continue;
            }
            Point plugLocation = rb.getSocketPixelPoint(BlockLinkChecker.getPlugEquivalent(Block.getBlock(socket.getBlockID())));
            Point otherScreenOffset = SwingUtilities.convertPoint(rb.getParent(), rb.getLocation(), this.getParent());
            otherScreenOffset.translate(-rb.getX(), -rb.getY());
            rb.setLocation((int)Math.round((double)((float)myScreenOffset.getX()) + socketLocation.getX() - (double)((float)otherScreenOffset.getX()) - plugLocation.getX()), (int)Math.round((double)((float)myScreenOffset.getY()) + socketLocation.getY() - (double)((float)otherScreenOffset.getY()) - plugLocation.getY()));
            rb.moveConnectedBlocks();
        }
    }

    private static void startDragging(RenderableBlock renderable, WorkspaceWidget widget) {
        renderable.pickedUp = true;
        renderable.lastDragWidget = widget;
        if (renderable.hasComment()) {
            renderable.comment.setConstrainComment(false);
        }
        Container oldParent = renderable.getParent();
        Workspace.getInstance().addToBlockLayer(renderable);
        renderable.setLocation(SwingUtilities.convertPoint(oldParent, renderable.getLocation(), Workspace.getInstance()));
        renderable.setHighlightParent(Workspace.getInstance());
        for (BlockConnector socket : BlockLinkChecker.getSocketEquivalents(Block.getBlock(renderable.blockID))) {
            if (!socket.hasBlock()) continue;
            RenderableBlock.startDragging(RenderableBlock.getRenderableBlock(socket.getBlockID()), widget);
        }
    }

    public static void stopDragging(RenderableBlock renderable, WorkspaceWidget widget) {
        if (!renderable.dragging) {
            throw new RuntimeException("dropping without prior dragging?");
        }
        for (BlockConnector socket : BlockLinkChecker.getSocketEquivalents(renderable.getBlock())) {
            if (!socket.hasBlock()) continue;
            RenderableBlock.stopDragging(RenderableBlock.getRenderableBlock(socket.getBlockID()), widget);
        }
        widget.blockDropped(renderable);
        renderable.dragging = false;
        if (renderable.hasComment()) {
            if (renderable.getParentWidget() != null) {
                renderable.comment.setParent(renderable.getParentWidget().getJComponent(), 0);
            } else {
                renderable.comment.setParent(null, renderable.getBounds());
            }
            renderable.comment.setConstrainComment(true);
            renderable.comment.setLocation(renderable.comment.getLocation());
            renderable.comment.getArrow().updateArrow();
        }
    }

    private static void drag(RenderableBlock renderable, int dx, int dy, WorkspaceWidget widget, boolean isTopLevelBlock) {
        if (!renderable.pickedUp) {
            throw new RuntimeException("dragging without prior pickup");
        }
        renderable.dragging = true;
        if (!isTopLevelBlock) {
            renderable.setLocation(renderable.getX() + dx, renderable.getY() + dy);
        }
        if (widget != null) {
            if (!widget.equals(renderable.lastDragWidget)) {
                widget.blockEntered(renderable);
                if (renderable.lastDragWidget != null) {
                    renderable.lastDragWidget.blockExited(renderable);
                }
            }
            widget.blockDragged(renderable);
            renderable.lastDragWidget = widget;
        }
        renderable.highlighter.repaint();
        for (BlockConnector socket : BlockLinkChecker.getSocketEquivalents(renderable.getBlock())) {
            if (!socket.hasBlock()) continue;
            RenderableBlock.drag(RenderableBlock.getRenderableBlock(socket.getBlockID()), dx, dy, widget, false);
        }
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (!this.pickedUp) {
                throw new RuntimeException("dropping without prior dragging?");
            }
            this.dragHandler.mouseReleased(e);
            if (this.dragging) {
                BlockLink link = this.getNearbyLink();
                WorkspaceWidget widget = null;
                if (link == null) {
                    widget = this.lastDragWidget;
                    RenderableBlock.stopDragging(this, widget);
                } else {
                    widget = this.blockID.equals(link.getSocketBlockID()) ? RenderableBlock.getRenderableBlock(link.getPlugBlockID()).getParentWidget() : RenderableBlock.getRenderableBlock(link.getSocketBlockID()).getParentWidget();
                    RenderableBlock.stopDragging(this, widget);
                    link.connect();
                    Workspace.getInstance().notifyListeners(new WorkspaceEvent(widget, link, 5));
                    RenderableBlock.getRenderableBlock(link.getSocketBlockID()).moveConnectedBlocks();
                }
                this.unzoomedX = this.calculateUnzoomedX(this.getX());
                this.unzoomedY = this.calculateUnzoomedY(this.getY());
                Workspace.getInstance().notifyListeners(new WorkspaceEvent(widget, link, 11, true));
                if (widget instanceof MiniMap) {
                    Workspace.getInstance().getMiniMap().animateAutoCenter(this);
                }
            }
        }
        this.pickedUp = false;
        if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e) || e.isControlDown()) {
            PopupMenu popup = ContextMenu.getContextMenuFor(this);
            this.add(popup);
            popup.show(this, e.getX(), e.getY());
        }
        Workspace.getInstance().getMiniMap().repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (!this.pickedUp) {
                throw new RuntimeException("dragging without prior pickup?");
            }
            Point pp = SwingUtilities.convertPoint(this, e.getPoint(), Workspace.getInstance().getMiniMap());
            if (Workspace.getInstance().getMiniMap().contains(pp)) {
                Workspace.getInstance().getMiniMap().blockDragged(this, e.getPoint());
                this.lastDragWidget = Workspace.getInstance().getMiniMap();
                return;
            }
            this.dragHandler.mouseDragged(e);
            this.dragHandler.myLoc.move(this.getX() + this.dragHandler.mPressedX, this.getY() + this.dragHandler.mPressedY);
            Point p = SwingUtilities.convertPoint(this.getParent(), this.dragHandler.myLoc, Workspace.getInstance());
            WorkspaceWidget widget = Workspace.getInstance().getWidgetAt(p);
            if (!this.dragging) {
                Block block = this.getBlock();
                BlockConnector plug = BlockLinkChecker.getPlugEquivalent(block);
                if (plug != null && plug.hasBlock()) {
                    Block parent = Block.getBlock(plug.getBlockID());
                    BlockConnector socket = parent.getConnectorTo(this.blockID);
                    BlockLink link = BlockLink.getBlockLink(block, parent, plug, socket);
                    link.disconnect();
                    RenderableBlock.getRenderableBlock(parent.getBlockID()).blockDisconnected(socket);
                    Workspace.getInstance().notifyListeners(new WorkspaceEvent(widget, link, 6));
                }
                RenderableBlock.startDragging(this, widget);
            }
            RenderableBlock.drag(this, this.dragHandler.dragDX, this.dragHandler.dragDY, widget, true);
            Workspace.getInstance().getMiniMap().repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.dragHandler.mouseEntered(e);
        if (!SwingUtilities.isLeftMouseButton(e) && !this.dragging && this.getBlock().hasSiblings()) {
            this.blockLabel.showMenuIcon(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.dragHandler.mouseExited(e);
        if (!(SwingUtilities.isLeftMouseButton(e) || this.dragging || this.blockArea.contains(e.getPoint()))) {
            this.blockLabel.showMenuIcon(false);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.dragHandler.mouseClicked(e);
            if (e.getClickCount() == 2 && !this.dragging) {
                Workspace.getInstance().notifyListeners(new WorkspaceEvent(this.getParentWidget(), this.getBlockID(), 7));
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.dragHandler.mousePressed(e);
            this.pickedUp = true;
        }
    }

    @Override
    public String getKeyword() {
        return this.getBlock().getBlockLabel();
    }

    public String getGenus() {
        return this.getBlock().getGenusName();
    }

    @Override
    public void updateInSearchResults(boolean inSearchResults) {
        this.isSearchResult = inSearchResults;
        this.highlighter.setIsSearchResult(this.isSearchResult);
    }

    public boolean isSearchResult() {
        return this.isSearchResult;
    }

    public String getSaveString() {
        if (this.comment != null) {
            return this.getBlock().getSaveString(this.descale(this.getX()), this.descale(this.getY()), this.comment.getSaveString(), this.isCollapsed());
        }
        return this.getBlock().getSaveString(this.descale(this.getX()), this.descale(this.getY()), null, this.isCollapsed());
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public static RenderableBlock loadBlockNode(Node blockNode, WorkspaceWidget parent, HashMap<Long, Long> idMapping) {
        boolean isBlock = blockNode.getNodeName().equals("Block");
        boolean isBlockStub = blockNode.getNodeName().equals("BlockStub");
        if (isBlock || isBlockStub) {
            RenderableBlock rb = new RenderableBlock(parent, Block.loadBlockFrom(blockNode, idMapping).getBlockID(), true);
            if (isBlockStub) {
                NodeList stubchildren = blockNode.getChildNodes();
                for (int j = 0; j < stubchildren.getLength(); ++j) {
                    Node node = stubchildren.item(j);
                    if (!node.getNodeName().equals("Block")) continue;
                    blockNode = node;
                    break;
                }
            }
            if (rb.getBlock().labelMustBeUnique()) {
                // empty if block
            }
            Point blockLoc = new Point(0, 0);
            NodeList children = blockNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeName().equals("Location")) {
                    RenderableBlock.extractLocationInfo(child, blockLoc);
                    continue;
                }
                if (child.getNodeName().equals("Comment")) {
                    rb.comment = Comment.loadComment(child.getChildNodes(), rb);
                    if (rb.comment == null) continue;
                    rb.comment.setParent(rb.getParentWidget().getJComponent());
                    continue;
                }
                if (!child.getNodeName().equals("Collapsed")) continue;
                rb.setCollapsed(true);
            }
            rb.setLocation(blockLoc.x, blockLoc.y);
            if (rb.comment != null) {
                rb.comment.getArrow().updateArrow();
            }
            return rb;
        }
        return null;
    }

    public static void extractLocationInfo(Node location, Point loc) {
        NodeList coordinates = location.getChildNodes();
        for (int j = 0; j < coordinates.getLength(); ++j) {
            Node coor = coordinates.item(j);
            if (coor.getNodeName().equals("X")) {
                loc.x = Integer.parseInt(coor.getTextContent());
                continue;
            }
            if (!coor.getNodeName().equals("Y")) continue;
            loc.y = Integer.parseInt(coor.getTextContent());
        }
    }

    public static void extractBoxSizeInfo(Node boxSizeNode, Dimension boxSize) {
        NodeList coordinates = boxSizeNode.getChildNodes();
        for (int j = 0; j < coordinates.getLength(); ++j) {
            Node coor = coordinates.item(j);
            if (coor.getNodeName().equals("Width")) {
                boxSize.width = Integer.parseInt(coor.getTextContent());
                continue;
            }
            if (!coor.getNodeName().equals("Height")) continue;
            boxSize.height = Integer.parseInt(coor.getTextContent());
        }
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("RenderableBlock " + this.getBlockID() + ": " + this.getBlock().getBlockLabel());
        return buf.toString();
    }

    @Override
    public Object getState() {
        RenderableBlockState blockState = new RenderableBlockState();
        blockState.x = this.getX();
        blockState.y = this.getY();
        return blockState;
    }

    @Override
    public void loadState(Object memento) {
        assert (memento instanceof RenderableBlockState) : "ISupportMemento contract violated in RenderableBlock";
        if (memento instanceof RenderableBlockState) {
            RenderableBlockState state = (RenderableBlockState)memento;
            this.setLocation(state.x, state.y);
        }
    }

    public void setZoomLevel(double newZoom) {
        this.zoom = newZoom;
        if (this.pageLabel != null && this.getBlock().hasPageLabel()) {
            this.pageLabel.setZoomLevel(newZoom);
        }
        if (this.blockLabel != null) {
            this.blockLabel.setZoomLevel(newZoom);
        }
        if (this.collapseLabel != null) {
            this.collapseLabel.setZoomLevel(newZoom);
        }
        this.plugTag.setZoomLevel(newZoom);
        this.afterTag.setZoomLevel(newZoom);
        this.beforeTag.setZoomLevel(newZoom);
        for (ConnectorTag tag : this.socketTags) {
            tag.setZoomLevel(newZoom);
        }
        if (this.hasComment()) {
            this.comment.setZoomLevel(newZoom);
        }
    }

    public double getZoom() {
        return this.zoom;
    }

    int rescale(int x) {
        return (int)((double)x * this.zoom);
    }

    int rescale(double x) {
        return (int)(x * this.zoom);
    }

    private int descale(int x) {
        return (int)((double)x / this.zoom);
    }

    private int descale(double x) {
        return (int)(x / this.zoom);
    }

    public int calculateUnzoomedX(int x) {
        return (int)((double)x / this.zoom);
    }

    public int calculateUnzoomedY(int y) {
        return (int)((double)y / this.zoom);
    }

    public void setUnzoomedX(double unzoomedX) {
        this.unzoomedX = unzoomedX;
    }

    public void setUnzoomedY(double unzoomedY) {
        this.unzoomedY = unzoomedY;
    }

    public double getUnzoomedX() {
        return this.unzoomedX;
    }

    public double getUnzoomedY() {
        return this.unzoomedY;
    }

    public void processKeyPressed(KeyEvent e) {
        for (KeyListener l : this.getKeyListeners()) {
            l.keyPressed(e);
        }
    }

    @Override
    public JToolTip createToolTip() {
        return new CToolTip(new Color(255, 255, 225));
    }

    public void setBlockToolTip(String text) {
        this.setToolTipText(text);
        this.blockLabel.setToolTipText(text);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        switch (e.getKeyCode()) {
            case 38: {
                return false;
            }
            case 40: {
                return false;
            }
            case 37: {
                return false;
            }
            case 39: {
                return false;
            }
            case 10: {
                return false;
            }
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    private ConnectorTag getConnectorTag(BlockConnector socket) {
        if (socket == null) {
            throw new RuntimeException("Socket may not be null");
        }
        if (socket.equals(this.plugTag.getSocket())) {
            return this.plugTag;
        }
        if (socket.equals(this.afterTag.getSocket())) {
            return this.afterTag;
        }
        if (socket.equals(this.beforeTag.getSocket())) {
            return this.beforeTag;
        }
        for (ConnectorTag tag : this.socketTags) {
            if (!socket.equals(tag.getSocket())) continue;
            return tag;
        }
        return null;
    }

    public boolean isCollapsed() {
        if (this.collapseLabel != null) {
            return this.collapseLabel.isActive();
        }
        return false;
    }

    public void setCollapsed(boolean collapse) {
        if (this.collapseLabel != null) {
            this.collapseLabel.setActive(collapse);
        }
    }

    public void updateCollapse() {
        if (this.collapseLabel != null) {
            this.collapseLabel.updateCollapse();
        }
    }

    public int getCollapseLabelWidth() {
        if (this.collapseLabel != null) {
            return this.collapseLabel.getWidth();
        }
        return 0;
    }

    RBHighlightHandler getHighlightHandler() {
        return this.highlighter;
    }

    int getControlLabelsWidth() {
        int x = 0;
        x = this.getComment() != null ? (x += Math.max(this.getComment().getCommentLabelWidth(), this.getCollapseLabelWidth())) : (x += this.getCollapseLabelWidth());
        return x;
    }

    private class RenderableBlockState {
        public int x;
        public int y;

        private RenderableBlockState() {
        }
    }
}

