/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.renderable;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.JComponentDragHandler;
import edu.mit.blocks.renderable.BlockUtilities;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.WorkspaceWidget;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class FactoryRenderableBlock
extends RenderableBlock {
    private static final long serialVersionUID = 1L;
    private RenderableBlock createdRB = null;
    private boolean createdRB_dragged = false;
    private JComponentDragHandler dragHandler;

    public FactoryRenderableBlock(WorkspaceWidget widget, Long blockID) {
        super(widget, blockID);
        this.setBlockLabelUneditable();
        this.dragHandler = new JComponentDragHandler(this);
    }

    public RenderableBlock createNewInstance() {
        return BlockUtilities.cloneBlock(Block.getBlock(super.getBlockID()));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        this.createdRB = this.createNewInstance();
        this.getParent().add((Component)this.createdRB, 0);
        this.createdRB.setParentWidget(this.getParentWidget());
        this.createdRB.setLocation(this.getX(), this.getY());
        MouseEvent newE = SwingUtilities.convertMouseEvent(this, e, this.createdRB);
        this.createdRB.mousePressed(newE);
        this.mouseDragged(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.createdRB != null) {
            MouseEvent newE = SwingUtilities.convertMouseEvent(this, e, this.createdRB);
            this.createdRB.mouseDragged(newE);
            this.createdRB_dragged = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.createdRB != null) {
            if (!this.createdRB_dragged) {
                Container parent = this.createdRB.getParent();
                parent.remove(this.createdRB);
                parent.validate();
                parent.repaint();
            } else {
                MouseEvent newE = SwingUtilities.convertMouseEvent(this, e, this.createdRB);
                this.createdRB.mouseReleased(newE);
            }
            this.createdRB_dragged = false;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.dragHandler.mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.dragHandler.mouseExited(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public void startDragging(MouseEvent e) {
    }

    public void stopDragging(MouseEvent e, WorkspaceWidget w) {
    }

    @Override
    public void setZoomLevel(double newZoom) {
    }
}

