/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.renderable;

import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.renderable.BlockControlLabel;
import edu.mit.blocks.renderable.Comment;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEvent;
import java.awt.Color;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;

public class CommentLabel
extends BlockControlLabel {
    private static final long serialVersionUID = 1L;

    public CommentLabel(long blockID) {
        super(blockID);
        this.setBackground(Color.darkGray);
        this.setOpaque(true);
    }

    @Override
    public void update() {
        RenderableBlock rb = RenderableBlock.getRenderableBlock(this.getBlockID());
        if (rb != null) {
            int x = 5;
            int y = 7;
            if (rb.getBlock().isCommandBlock()) {
                y -= 2;
                x -= 3;
            }
            if (rb.getBlock().isDataBlock() || rb.getBlock().isFunctionBlock()) {
                x += 6;
                y -= 2;
            }
            if (rb.getBlock().isInfix() && rb.getBlock().getSocketAt(0) != null) {
                if (!rb.getBlock().getSocketAt(0).hasBlock()) {
                    x += 30;
                } else if (rb.getSocketSpaceDimension(rb.getBlock().getSocketAt(0)) != null) {
                    x += rb.getSocketSpaceDimension((BlockConnector)rb.getBlock().getSocketAt((int)0)).width + 2;
                }
                y += 2;
                ++x;
            }
            x = rb.rescale(x);
            y = rb.rescale(y);
            this.setLocation(x, y);
            this.setSize(rb.rescale(14), rb.rescale(14));
            if (this.isActive()) {
                this.setText("?");
                this.setForeground(new Color(255, 255, 0));
            } else {
                this.setText("?");
                this.setForeground(Color.lightGray);
            }
            rb.setComponentZOrder(this, 0);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.toggle();
        RenderableBlock rb = RenderableBlock.getRenderableBlock(this.getBlockID());
        rb.getComment().setVisible(this.isActive());
        Workspace.getInstance().notifyListeners(new WorkspaceEvent(rb.getComment().getCommentSource().getParentWidget(), 17));
        this.update();
        rb.revalidate();
        rb.repaint();
        Workspace.getInstance().getMiniMap().repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        this.setBorder(BorderFactory.createLineBorder(Color.yellow));
        Comment comment = RenderableBlock.getRenderableBlock(this.getBlockID()).getComment();
        comment.setVisible(true);
        comment.showOnTop();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        this.setBorder(BorderFactory.createLineBorder(Color.gray));
        Comment comment = RenderableBlock.getRenderableBlock(this.getBlockID()).getComment();
        if (!this.isActive()) {
            comment.setVisible(false);
        }
    }
}

