/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.controller;

import edu.mit.blocks.codeblocks.BlockConnectorShape;
import edu.mit.blocks.codeblocks.BlockGenus;
import edu.mit.blocks.codeblocks.BlockLinkChecker;
import edu.mit.blocks.codeblocks.CommandRule;
import edu.mit.blocks.codeblocks.SocketRule;
import edu.mit.blocks.workspace.SearchBar;
import edu.mit.blocks.workspace.SearchableContainer;
import edu.mit.blocks.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WorkspaceController {
    private Element langDefRoot;
    private boolean isWorkspacePanelInitialized = false;
    protected JPanel workspacePanel;
    protected Workspace workspace = Workspace.getInstance();
    protected SearchBar searchBar;
    private boolean langDefDirty = true;
    private boolean workspaceLoaded = false;

    public void setLangDefFilePath(String filePath) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new File(filePath));
            this.langDefRoot = doc.getDocumentElement();
            this.langDefDirty = true;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadBlockLanguage(Element root) {
        BlockConnectorShape.loadBlockConnectorShapes(root);
        BlockGenus.loadBlockGenera(root);
        BlockLinkChecker.addRule(new CommandRule());
        BlockLinkChecker.addRule(new SocketRule());
        this.langDefDirty = false;
    }

    public void resetLanguage() {
        BlockConnectorShape.resetConnectorShapeMappings();
        BlockGenus.resetAllGenuses();
        BlockLinkChecker.reset();
    }

    public String getSaveString() {
        StringBuilder saveString = new StringBuilder();
        saveString.append("<?xml version=\"1.0\" encoding=\"ISO-8859\"?>");
        saveString.append("\r\n");
        saveString.append("<CODEBLOCKS>");
        saveString.append(this.workspace.getSaveString());
        saveString.append("</CODEBLOCKS>");
        return saveString.toString();
    }

    public void loadFreshWorkspace() {
        if (this.workspaceLoaded) {
            this.resetWorkspace();
        }
        if (this.langDefDirty) {
            this.loadBlockLanguage(this.langDefRoot);
        }
        this.workspace.loadWorkspaceFrom(null, this.langDefRoot);
        this.workspaceLoaded = true;
    }

    public void loadProjectFromPath(String path) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new File(path));
            Element projectRoot = doc.getDocumentElement();
            this.workspace.loadWorkspaceFrom(projectRoot, this.langDefRoot);
            this.workspaceLoaded = true;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadProject(String projectContents, String langDefContents) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document projectDoc = builder.parse(new InputSource(new StringReader(projectContents)));
            Element projectRoot = projectDoc.getDocumentElement();
            Document langDoc = builder.parse(new InputSource(new StringReader(projectContents)));
            Element langRoot = langDoc.getDocumentElement();
            if (this.workspaceLoaded) {
                this.resetWorkspace();
            }
            if (langDefContents == null) {
                this.loadBlockLanguage(this.langDefRoot);
            } else {
                this.loadBlockLanguage(langRoot);
            }
            this.workspace.loadWorkspaceFrom(projectRoot, langRoot);
            this.workspaceLoaded = true;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void resetWorkspace() {
        this.workspace.reset();
    }

    private void initWorkspacePanel() {
        this.workspacePanel = new JPanel();
        this.workspacePanel.setLayout(new BorderLayout());
        this.workspacePanel.add((Component)this.workspace, "Center");
        this.isWorkspacePanelInitialized = true;
    }

    public JComponent getWorkspacePanel() {
        if (!this.isWorkspacePanelInitialized) {
            this.initWorkspacePanel();
        }
        return this.workspacePanel;
    }

    public JComponent getSearchBar() {
        SearchBar sb = new SearchBar("Search blocks", "Search for blocks in the drawers and workspace", this.workspace);
        for (SearchableContainer con : this.getAllSearchableContainers()) {
            sb.addSearchableContainer(con);
        }
        return sb.getComponent();
    }

    public Iterable<SearchableContainer> getAllSearchableContainers() {
        return this.workspace.getAllSearchableContainers();
    }

    private void createAndShowGUI() {
        JFrame frame = new JFrame("WorkspaceDemo");
        frame.setDefaultCloseOperation(3);
        frame.setBounds(100, 100, 500, 500);
        SearchBar sb = new SearchBar("Search blocks", "Search for blocks in the drawers and workspace", this.workspace);
        for (SearchableContainer con : this.getAllSearchableContainers()) {
            sb.addSearchableContainer(con);
        }
        JPanel topPane = new JPanel();
        sb.getComponent().setPreferredSize(new Dimension(130, 23));
        topPane.add(sb.getComponent());
        frame.add((Component)topPane, "First");
        frame.add((Component)this.getWorkspacePanel(), "Center");
        frame.setVisible(true);
    }

    public static void main(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WorkspaceController wc = new WorkspaceController();
                wc.setLangDefFilePath(args[0]);
                wc.loadFreshWorkspace();
                wc.createAndShowGUI();
            }
        });
    }
}

