/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CArrowButton;
import edu.mit.blocks.codeblockutil.Canvas;
import edu.mit.blocks.codeblockutil.DefaultCanvas;
import edu.mit.blocks.codeblockutil.Explorer;
import edu.mit.blocks.codeblockutil.GlassExplorer;
import edu.mit.blocks.codeblockutil.MagicExplorer;
import edu.mit.blocks.codeblockutil.PopupExplorer;
import edu.mit.blocks.codeblockutil.StackExplorer;
import edu.mit.blocks.codeblockutil.TabbedExplorer;
import edu.mit.blocks.codeblockutil.WindowExplorer;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;

public final class Navigator {
    private Type explorerModel;
    private int position;
    private List<Explorer> explorers;
    private JScrollPane scroll;
    private JComponent view;
    private ExplorerSwitcher switcher;
    private NavigationAnimator animator;

    public Navigator() {
        this(Type.GLASS);
    }

    public Navigator(Type UIModel) {
        this.explorerModel = UIModel;
        this.animator = new NavigationAnimator();
        this.explorers = new ArrayList<Explorer>();
        this.view = new JPanel();
        this.position = 0;
        this.view.setBackground(Color.darkGray);
        this.view.setLayout(null);
        this.scroll = new JScrollPane(this.view, 21, 31);
        this.switcher = new ExplorerSwitcher();
    }

    private void printError(String m) {
        System.err.println(m);
    }

    public final void addExlorer(String name) {
        if (name == null) {
            this.printError("Name of explorer may not be assigned as null");
            return;
        }
        for (Explorer explorer : this.explorers) {
            if (!explorer.getName().equals(name)) continue;
            this.printError("May not add duplicate explorers named: " + name);
            return;
        }
        JComponent explorer = this.explorerModel == Type.GLASS ? new GlassExplorer() : (this.explorerModel == Type.MAGIC ? new MagicExplorer() : (this.explorerModel == Type.POPUP ? new PopupExplorer() : (this.explorerModel == Type.WINDOW ? new WindowExplorer() : (this.explorerModel == Type.TABBED ? new TabbedExplorer() : new StackExplorer()))));
        explorer.setName(name);
        this.explorers.add((Explorer)((Object)explorer));
        this.view.add(explorer.getJComponent());
        this.reformView();
    }

    public final void removeExplorer(String name) {
        if (name == null) {
            this.printError("Name of explorer may not be assigned as null");
            return;
        }
        Explorer explorer = null;
        for (Explorer ex : this.explorers) {
            if (!ex.getName().equals(name)) continue;
            if (explorer == null) {
                explorer = ex;
                continue;
            }
            this.printError("Navigator has duplicate explorers named: " + name);
            return;
        }
        if (explorer == null) {
            this.printError("Navigator does not have a explorer named: " + name);
            return;
        }
        this.explorers.remove(explorer);
        this.view.remove(explorer.getJComponent());
        this.reformView();
    }

    public List<Explorer> getExplorers() {
        return this.explorers;
    }

    public boolean hasExplorer(String name) {
        if (name == null) {
            return false;
        }
        for (Explorer explorer : this.explorers) {
            if (!explorer.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void reformView() {
        int accumWidth = 0;
        int height = this.scroll.getHeight();
        int width = this.scroll.getWidth();
        for (Explorer explorer : this.explorers) {
            explorer.getJComponent().setBounds(accumWidth, 0, width, height);
            explorer.reformView();
            accumWidth += width;
        }
        this.view.setPreferredSize(new Dimension(accumWidth, height));
        this.view.setBounds(0, 0, accumWidth, height);
        this.scroll.revalidate();
        this.scroll.repaint();
        this.scroll.getHorizontalScrollBar().setValue(this.explorers.get(this.position).getJComponent().getX());
    }

    public void setCanvas(List<? extends Canvas> canvases, String explorer) {
        for (Explorer ex : this.explorers) {
            if (!ex.getName().equals(explorer)) continue;
            ex.setDrawersCard(canvases);
        }
        this.reformView();
    }

    public void setView(String name) {
        for (int i = 0; i < this.explorers.size(); ++i) {
            Explorer ex = this.explorers.get(i);
            if (!ex.getName().equals(name)) continue;
            this.setView(i);
        }
    }

    private void setView(int index) {
        if (!this.explorers.isEmpty()) {
            int middlePosition = index < 0 ? this.explorers.size() - 1 : index;
            middlePosition = index >= this.explorers.size() ? 0 : middlePosition;
            int leftPosition = middlePosition - 1;
            int rightPosition = middlePosition + 1;
            if (leftPosition < 0) {
                leftPosition = this.explorers.size() - 1;
            }
            if (rightPosition > this.explorers.size() - 1) {
                rightPosition = 0;
            }
            this.position = middlePosition;
            this.switcher.switchView(this.explorers.get(leftPosition).getName(), this.explorers.get(this.position).getName(), this.explorers.get(rightPosition).getName());
            this.animator.start(this.explorers.get(this.position).getJComponent().getX());
        }
    }

    public JComponent getJComponent() {
        return this.scroll;
    }

    public JComponent getSwitcher() {
        return this.switcher;
    }

    public static void main(String[] args) {
        final Navigator n = new Navigator();
        for (int i = 0; i < 8; ++i) {
            class CC
            extends DefaultCanvas {
                private static final long serialVersionUID = 328149080298L;

                public CC(String label) {
                    super.setName(label);
                }

                @Override
                public JComponent getJComponent() {
                    return new JButton(this.getName());
                }
            }
            ArrayList<CC> c1 = new ArrayList<CC>();
            for (int j = 0; j < 10; ++j) {
                c1.add(new CC("# " + j));
            }
            n.addExlorer("Ex" + i);
            n.setCanvas(c1, "Ex" + i);
        }
        JFrame f = new JFrame();
        f.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                n.reformView();
            }
        });
        f.setDefaultCloseOperation(3);
        f.setLayout(new BorderLayout());
        f.setSize(400, 600);
        f.add((Component)n.getJComponent(), "Center");
        f.add((Component)n.getSwitcher(), "North");
        f.setVisible(true);
    }

    private class NavigationAnimator
    implements ActionListener {
        private final int partitions = 10;
        private Timer timer = new Timer(50, this);
        private int value = 0;
        private int dx;
        private int count;

        private NavigationAnimator() {
        }

        private void start(int x) {
            this.count = 10;
            this.value = x;
            this.dx = (x - Navigator.this.scroll.getHorizontalScrollBar().getValue()) / 10;
            this.timer.start();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.count < 0) {
                this.timer.stop();
                Navigator.this.scroll.getHorizontalScrollBar().setValue(this.value);
                Navigator.this.scroll.revalidate();
                Navigator.this.scroll.repaint();
            } else {
                Navigator.this.scroll.getHorizontalScrollBar().setValue(this.value - this.dx * this.count);
                --this.count;
                Navigator.this.scroll.revalidate();
                Navigator.this.scroll.repaint();
            }
        }
    }

    private class ExplorerSwitcher
    extends JPanel {
        private static final long serialVersionUID = 328149080295L;
        private int LABEL_HEIGHT = 9;
        private JLabel mainLabel;
        private JLabel leftLabel = new JLabel("", 2);
        private CArrowButton leftArrow;
        private JLabel rightLabel;
        private CArrowButton rightArrow;

        private ExplorerSwitcher() {
            this.leftLabel.setForeground(Color.white);
            this.leftLabel.setFont(new Font("Ariel", 0, this.LABEL_HEIGHT));
            this.leftArrow = new CArrowButton(CArrowButton.Direction.WEST){
                private static final long serialVersionUID = 328149080296L;

                @Override
                public void triggerAction() {
                    Navigator.this.setView(Navigator.this.position - 1);
                }
            };
            this.rightLabel = new JLabel("", 4);
            this.rightLabel.setForeground(Color.white);
            this.rightLabel.setFont(new Font("Ariel", 0, this.LABEL_HEIGHT));
            this.rightArrow = new CArrowButton(CArrowButton.Direction.EAST){
                private static final long serialVersionUID = 328149080297L;

                @Override
                public void triggerAction() {
                    Navigator.this.setView(Navigator.this.position + 1);
                }
            };
            this.mainLabel = new JLabel("", 0);
            this.mainLabel.setFont(new Font("Ariel", 1, 15));
            this.mainLabel.setForeground(Color.white);
            this.mainLabel.setOpaque(false);
            double[][] constraints = new double[][]{{15.0, 15.0, 15.0, -1.0, 15.0, 15.0, 15.0}, {-1.0, 20.0, 10.0, 5.0}};
            this.setLayout((LayoutManager)new TableLayout((double[][])constraints));
            this.setOpaque(false);
            this.add((Component)this.leftLabel, "0, 2, 2, 2");
            this.add((Component)this.leftArrow, "1, 1");
            this.add((Component)this.rightLabel, "4, 2, 6, 2");
            this.add((Component)this.rightArrow, "5, 1");
            this.add((Component)this.mainLabel, "3, 0, 3, 2");
        }

        void switchView(String left, String middle, String right) {
            this.leftLabel.setText(left);
            this.mainLabel.setText(middle);
            this.rightLabel.setText(right);
        }
    }

    public static enum Type {
        GLASS,
        MAGIC,
        POPUP,
        STACK,
        TABBED,
        WINDOW;

    }
}

