/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CScrollPane;
import edu.mit.blocks.codeblockutil.HorizontalBar;
import edu.mit.blocks.codeblockutil.LowerRightCorner;
import edu.mit.blocks.codeblockutil.VerticalBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class CTracklessScrollPane
extends CScrollPane
implements KeyListener {
    private static final long serialVersionUID = 328149080244L;
    private int SCROLLINGUNIT = 3;
    private VerticalBar verticalbar;
    private HorizontalBar horizontalbar;
    private JScrollPane scrollviewport;

    public CTracklessScrollPane(JComponent view) {
        this(view, CScrollPane.ScrollPolicy.VERTICAL_BAR_ALWAYS, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_ALWAYS);
    }

    public CTracklessScrollPane(JComponent view, CScrollPane.ScrollPolicy verticalPolicy, CScrollPane.ScrollPolicy horizontalPolicy) {
        this(view, verticalPolicy, horizontalPolicy, 10, Color.darkGray, Color.gray);
    }

    public CTracklessScrollPane(JComponent view, int thumbWidth, Color thumbColor, Color trackColor) {
        this(view, CScrollPane.ScrollPolicy.VERTICAL_BAR_ALWAYS, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_ALWAYS, thumbWidth, thumbColor, trackColor);
    }

    public CTracklessScrollPane(JComponent view, CScrollPane.ScrollPolicy verticalPolicy, CScrollPane.ScrollPolicy horizontalPolicy, int thumbWidth, Color thumbColor, Color trackColor) {
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.scrollviewport = new JScrollPane(view, 21, 31){
            private static final long serialVersionUID = 328149080245L;

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                switch (e.getKeyCode()) {
                    case 38: {
                        return false;
                    }
                    case 40: {
                        return false;
                    }
                    case 37: {
                        return false;
                    }
                    case 39: {
                        return false;
                    }
                    case 9: {
                        System.out.println("bl.enter tab");
                        return false;
                    }
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        };
        this.scrollviewport.setBorder(null);
        this.scrollviewport.setWheelScrollingEnabled(true);
        if (thumbWidth < 0) {
            thumbWidth = 0;
        }
        if (thumbColor == null) {
            thumbColor = Color.black;
        }
        if (trackColor == null) {
            trackColor = Color.white;
        }
        this.verticalbar = new VerticalBar(thumbWidth, thumbColor, this.scrollviewport.getVerticalScrollBar().getModel());
        this.verticalbar.setBackground(trackColor);
        this.horizontalbar = new HorizontalBar(thumbWidth, thumbColor, this.scrollviewport.getHorizontalScrollBar().getModel());
        this.horizontalbar.setBackground(trackColor);
        view.addKeyListener(this);
        this.scrollviewport.addMouseWheelListener(this);
        if (verticalPolicy.equals((Object)CScrollPane.ScrollPolicy.VERTICAL_BAR_NEVER)) {
            if (horizontalPolicy.equals((Object)CScrollPane.ScrollPolicy.HORIZONTAL_BAR_NEVER)) {
                this.add((Component)this.scrollviewport, "Center");
            } else {
                this.add((Component)this.horizontalbar, "South");
                this.add((Component)this.scrollviewport, "Center");
            }
        } else if (horizontalPolicy.equals((Object)CScrollPane.ScrollPolicy.HORIZONTAL_BAR_NEVER)) {
            this.add((Component)this.verticalbar, "East");
            this.add((Component)this.scrollviewport, "Center");
        } else {
            this.add((Component)this.verticalbar, "East");
            this.add((Component)this.scrollviewport, "Center");
            JPanel horizontalScrollBarPane = new JPanel(new BorderLayout());
            horizontalScrollBarPane.add((Component)this.horizontalbar, "Center");
            horizontalScrollBarPane.add((Component)new LowerRightCorner(thumbWidth, trackColor), "East");
            this.add((Component)horizontalScrollBarPane, "South");
        }
        this.revalidate();
    }

    @Override
    public BoundedRangeModel getVerticalModel() {
        return this.scrollviewport.getVerticalScrollBar().getModel();
    }

    @Override
    public BoundedRangeModel getHorizontalModel() {
        return this.scrollviewport.getHorizontalScrollBar().getModel();
    }

    public void setThumbWidth(int thumbWidth) {
        this.verticalbar.setPreferredSize(new Dimension(thumbWidth, 0));
        this.horizontalbar.setPreferredSize(new Dimension(0, thumbWidth));
        this.repaint();
    }

    @Override
    public void scrollRectToVisible(Rectangle contentRect) {
        this.scrollviewport.getViewport().scrollRectToVisible(contentRect);
    }

    @Override
    public void setScrollingUnit(int x) {
        this.SCROLLINGUNIT = x;
        this.verticalbar.setScrollingUnit(x);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isShiftDown()) {
            this.scrollviewport.getHorizontalScrollBar().getModel().setValue(this.scrollviewport.getHorizontalScrollBar().getModel().getValue() + e.getUnitsToScroll() * e.getScrollAmount() * this.SCROLLINGUNIT);
            this.horizontalbar.repaint();
        } else {
            this.scrollviewport.getVerticalScrollBar().getModel().setValue(this.scrollviewport.getVerticalScrollBar().getModel().getValue() + e.getUnitsToScroll() * e.getScrollAmount() * this.SCROLLINGUNIT);
            this.verticalbar.repaint();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.verticalbar.repaint();
        this.horizontalbar.repaint();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.verticalbar.repaint();
        this.horizontalbar.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.verticalbar.repaint();
        this.horizontalbar.repaint();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setLayout(new BorderLayout());
        f.setSize(400, 400);
        JTextArea b = new JTextArea(20, 30);
        f.getContentPane().add(new CTracklessScrollPane(b, CScrollPane.ScrollPolicy.VERTICAL_BAR_ALWAYS, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_ALWAYS, 20, Color.red, Color.blue));
        f.setVisible(true);
    }
}

