/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CGraphite;
import edu.mit.blocks.codeblockutil.CScrollPane;
import edu.mit.blocks.codeblockutil.CTracklessScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CTable
extends JPanel {
    private static final long serialVersionUID = 328149080251L;
    private static final int COLUMN_WIDTH = 50;
    private static final int ROW_HEIGHT = 15;
    private static final Color foreground = Color.white;
    private static final Font font = new Font("Ariel", 1, 12);
    private final List<double[]> data;
    private final JComponent view;
    private final JComponent scroll;
    private String[] columns = new String[0];
    private JLabel[] columnLabels = new JLabel[0];

    public CTable() {
        this(9);
    }

    public CTable(int i) {
        super(new BorderLayout());
        this.data = new ArrayList<double[]>();
        this.view = new JPanel();
        this.view.setBackground(foreground);
        this.scroll = new CTracklessScrollPane(this.view, CScrollPane.ScrollPolicy.VERTICAL_BAR_AS_NEEDED, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_AS_NEEDED, i, CGraphite.blue, new Color(100, 100, 100));
        this.add((Component)this.scroll, "Center");
    }

    @Override
    public void addMouseListener(MouseListener l) {
        this.view.addMouseListener(l);
    }

    public void setColumns(String[] columns) {
        this.data.clear();
        this.view.removeAll();
        this.view.setLayout(new GridLayout(0, columns.length));
        this.columnLabels = new JLabel[columns.length];
        int i = 0;
        for (String name : columns) {
            JLabel label = new JLabel(name, 0);
            label.setFont(font);
            label.setForeground(foreground);
            label.setOpaque(true);
            label.setBackground(CGraphite.blue);
            label.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLUE));
            this.view.add(label);
            this.columnLabels[i] = label;
            ++i;
        }
        this.columns = columns;
        this.view.setPreferredSize(new Dimension(columns.length * 50, 30));
        this.scroll.revalidate();
    }

    public void updateColumns(String[] columns) {
        this.columns = columns;
        for (int i = 0; i < columns.length; ++i) {
            this.columnLabels[i].setText(columns[i]);
        }
        this.scroll.revalidate();
        this.scroll.repaint();
    }

    public void clearTable() {
        this.setColumns(this.columns);
    }

    public void addRow(double[] datum) {
        for (int i = 0; i < this.columns.length; ++i) {
            JLabel label = i < datum.length ? new JLabel(Double.toString(datum[i]), 0) : new JLabel();
            label.setOpaque(true);
            if (i == 0) {
                label.setFont(font);
                label.setBackground(CGraphite.blue);
                label.setForeground(foreground);
                label.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLUE));
            } else {
                label.setFont(font);
                label.setBackground(CGraphite.gray);
                label.setForeground(foreground);
                label.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLUE));
            }
            this.view.add(label);
        }
        this.data.add(datum);
        this.view.setPreferredSize(new Dimension(this.columns.length * 50, 15 * (1 + this.data.size())));
        this.scroll.revalidate();
        this.scroll.repaint();
    }

    public String getCSV() {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < this.columns.length; ++i) {
            output.append(this.columns[i] + ",");
        }
        output.append("\n");
        for (double[] datum : this.data) {
            for (int i = 0; i < datum.length; ++i) {
                output.append(datum[i] + ",");
            }
            output.append("\n");
        }
        output.append("\n");
        return output.toString();
    }

    @Override
    public Insets getInsets() {
        return new Insets(10, 10, 35, 10);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setLayout(new BorderLayout());
        f.setSize(300, 200);
        final CTable c = new CTable();
        c.setColumns(new String[]{"a", "b", "c"});
        f.add((Component)c, "Center");
        JButton button = new JButton("add data");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                c.addRow(new double[]{1.0, 2.0, 3.0});
            }
        });
        f.add((Component)button, "South");
        JButton button2 = new JButton("save data");
        button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(c.getCSV());
            }
        });
        f.add((Component)button2, "North");
        f.setVisible(true);
        f.repaint();
    }
}

