/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CButton;
import edu.mit.blocks.codeblockutil.CGraphite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;

public class CTabButton
extends CButton {
    private static final long serialVersionUID = 328149080252L;

    public CTabButton(String text) {
        super(Color.black, CGraphite.blue, text);
    }

    @Override
    public void paint(Graphics g) {
        Color bottomColoring;
        Color topColoring;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int buttonHeight = this.getHeight() - 6;
        int buttonWidth = this.getWidth() - 6;
        int arc = buttonHeight / 3;
        if (this.focus || this.selected) {
            topColoring = this.selectedColor.darker().darker().darker();
            bottomColoring = this.selectedColor;
        } else {
            topColoring = this.buttonColor;
            bottomColoring = this.buttonColor;
        }
        g2.setPaint(new GradientPaint(0.0f, 0.0f, topColoring, 0.0f, buttonHeight, bottomColoring, false));
        g2.fillRoundRect(3, 3, buttonWidth, buttonHeight + arc, arc, arc);
        g2.setColor(Color.darkGray);
        g2.drawRoundRect(3, 3, buttonWidth, buttonHeight + arc, arc, arc);
        int highlightHeight = buttonHeight / 2 - 2;
        int highlightWidth = buttonWidth - 4 + 1;
        if (this.focus || this.selected) {
            topColoring = Color.white;
            bottomColoring = this.selectedColor;
        } else {
            topColoring = Color.gray;
            bottomColoring = Color.darkGray;
        }
        g2.setPaint(new GradientPaint(0.0f, 0.0f, topColoring, 0.0f, buttonHeight, bottomColoring, false));
        g2.fillRoundRect(5, 6, highlightWidth, highlightHeight, arc, arc);
        if (this.getText() != null) {
            Font font;
            if (this.selected) {
                g2.setColor(Color.white);
                font = new Font("Ariel", 1, buttonHeight * 2 / 3);
            } else {
                g2.setColor(Color.white);
                font = new Font("Ariel", 0, buttonHeight * 2 / 3);
            }
            g2.setFont(font);
            FontMetrics metrics = g2.getFontMetrics();
            Rectangle2D textBounds = metrics.getStringBounds(this.getText(), g2);
            float x = (float)((double)(this.getWidth() / 2) - textBounds.getWidth() / 2.0);
            float y = (float)((double)(this.getHeight() / 2) + textBounds.getHeight() / 2.0) - (float)metrics.getDescent();
            g2.drawString(this.getText(), x, y);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setLayout(new FlowLayout());
        f.setSize(500, 300);
        CTabButton c = new CTabButton("hi");
        c.setPreferredSize(new Dimension(400, 200));
        f.add(c);
        f.setVisible(true);
        f.repaint();
    }
}

