/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CGraphite;
import edu.mit.blocks.codeblockutil.CGraphiteButton;
import edu.mit.blocks.codeblockutil.CMenuItem;
import edu.mit.blocks.codeblockutil.CScrollPane;
import edu.mit.blocks.codeblockutil.CTracklessScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class CPopupMenu
extends JPopupMenu
implements ActionListener {
    private static final long serialVersionUID = 328149080311L;
    private int ITEM_HEIGHT = 14;
    private Color background = CGraphite.white;
    private JComponent scroll;
    private JComponent view;
    private double zoom = 1.0;
    private int items = 0;

    CPopupMenu() {
        this.setLayout(new BorderLayout());
        this.setBackground(this.background);
        this.setOpaque(false);
        this.removeAll();
        this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, CGraphite.blue));
        this.view = new JPanel(new GridLayout(0, 1));
        this.view.setBackground(this.background);
        this.scroll = new CTracklessScrollPane(this.view, CScrollPane.ScrollPolicy.VERTICAL_BAR_AS_NEEDED, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_NEVER, 9, CGraphite.blue, this.background);
        this.add(this.scroll);
    }

    @Override
    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    public void add(CMenuItem item) {
        ++this.items;
        item.addActionListener(this);
        this.view.add(item);
    }

    public void setZoomLevel(double zoom) {
        this.zoom = zoom;
        this.view.setPreferredSize(new Dimension((int)(100.0 * this.zoom), (int)((double)(this.items * this.ITEM_HEIGHT) * this.zoom)));
        this.setPopupSize((int)(100.0 * this.zoom), (int)((double)Math.min(this.items * this.ITEM_HEIGHT + 10, 100) * this.zoom));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isVisible()) {
            this.setVisible(false);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setLayout(new FlowLayout());
        f.setSize(500, 300);
        f.getContentPane().setBackground(Color.red);
        final CGraphiteButton c = new CGraphiteButton("hi");
        f.add(c);
        f.setVisible(true);
        f.repaint();
        final CPopupMenu menu = new CPopupMenu();
        for (int i = 0; i < 17; ++i) {
            menu.add(new CMenuItem("hi"));
        }
        c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                menu.show(c, 0, 0);
            }
        });
        c.add(menu);
        System.out.println(menu.getParent());
    }
}

