/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CButton;
import edu.mit.blocks.codeblockutil.GraphicsManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.JFrame;

public class CIconButton
extends CButton {
    private static final long serialVersionUID = 328149080213L;
    private static final int ICON_INSET = 12;
    private Icon icon;

    public CIconButton(Icon icon) {
        super(Color.black, Color.blue, null);
        this.icon = icon;
        super.setPreferredSize(new Dimension(40, 40));
        super.setSize(new Dimension(40, 40));
    }

    public CIconButton(Color backColor, Color selectedColor, Icon icon) {
        super(backColor, selectedColor, null);
        this.icon = icon;
        super.setPreferredSize(new Dimension(40, 40));
        super.setSize(new Dimension(40, 40));
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    private Shape getIconShape(Icon icon) {
        int width = this.getWidth() - 24;
        if (icon == Icon.PLAY) {
            GeneralPath shape = new GeneralPath();
            shape.moveTo(12.0f, 12.0f);
            shape.lineTo(12 + width, 12 + width / 2);
            shape.lineTo(12.0f, 12 + width);
            shape.lineTo(12.0f, 12.0f);
            shape.closePath();
            return shape;
        }
        if (icon == Icon.PAUSE) {
            Rectangle2D.Float rect1 = new Rectangle2D.Float(12.0f, 12.0f, width / 3, width);
            Rectangle2D.Float rect2 = new Rectangle2D.Float(12 + width * 2 / 3, 12.0f, width / 3, width);
            Area shape1 = new Area(rect1);
            Area shape2 = new Area(rect2);
            shape1.add(shape2);
            return shape1;
        }
        if (icon == Icon.STEP) {
            Rectangle2D.Float rect = new Rectangle2D.Float(12.0f, 12.0f, width / 5, width);
            GeneralPath triangle = new GeneralPath();
            triangle.moveTo(12 + width * 2 / 5, 12.0f);
            triangle.lineTo(12 + width, 12 + width / 2);
            triangle.lineTo(12 + width * 2 / 5, 12 + width);
            triangle.closePath();
            Area area1 = new Area(rect);
            Area area2 = new Area(triangle);
            area1.add(area2);
            return area1;
        }
        if (icon == Icon.STOP) {
            Rectangle2D.Float rect1 = new Rectangle2D.Float(12.0f, 12.0f, width, width);
            Area shape1 = new Area(rect1);
            return shape1;
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        Color backgroundColor = this.pressed ? this.selectedColor : this.buttonColor;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BufferedImage buffer = GraphicsManager.gc.createCompatibleImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D gb = buffer.createGraphics();
        gb.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int buttonHeight = this.getHeight() - 6;
        int buttonWidth = this.getWidth() - 6;
        Color topColoring = backgroundColor.darker().darker().darker();
        Color bottomColoring = backgroundColor.brighter().brighter().brighter();
        gb.setPaint(new GradientPaint(0.0f, 3.0f, topColoring, 0.0f, buttonHeight, bottomColoring, false));
        gb.fillOval(3, 3, buttonWidth, buttonHeight);
        int highlightHeight = buttonHeight - 4;
        int highlightWidth = buttonWidth - 4;
        topColoring = Color.WHITE;
        bottomColoring = backgroundColor.brighter();
        gb.setComposite(AlphaComposite.getInstance(3, 0.8f));
        gb.setPaint(new GradientPaint(0.0f, 5.0f, topColoring, 0.0f, 5 + highlightHeight / 2, backgroundColor.brighter(), false));
        gb.setClip(new Ellipse2D.Float(5.0f, 5.0f, highlightWidth, highlightHeight / 2));
        gb.fillOval(5, 5, highlightWidth, highlightHeight);
        ConvolveOp blurOp = new ConvolveOp(new Kernel(3, 3, BLUR));
        BufferedImage blurredImage = blurOp.filter(buffer, null);
        g2.drawImage((Image)blurredImage, 0, 0, null);
        if (this.icon != null) {
            if (this.focus) {
                g2.setColor(Color.white);
            } else {
                g2.setColor(Color.gray);
            }
            g2.fill(this.getIconShape(this.icon));
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setLayout(new FlowLayout());
        f.setDefaultCloseOperation(3);
        f.setSize(300, 100);
        f.getContentPane().add(new CIconButton(Icon.PAUSE));
        f.setVisible(true);
    }

    public static enum Icon {
        PLAY,
        PAUSE,
        STEP,
        STOP;

    }
}

