/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CHeader {
    private CHeader() {
    }

    public static JComponent makeBasicHeader(JComponent factory, JComponent[] buttons, JComponent search) {
        return new BasicHeader(factory, buttons, search);
    }

    private static class BasicHeader
    extends JPanel {
        private static final long serialVersionUID = 328149080219L;

        protected BasicHeader(JComponent factory, JComponent[] buttons, JComponent search) {
            this.setOpaque(false);
            double[][] size = new double[][]{{170.0, -1.0, search.getPreferredSize().width + 10}, {45.0}};
            this.setLayout((LayoutManager)new TableLayout((double[][])size));
            this.add((Component)factory, "0, 0");
            JPanel buttonPane = new JPanel(new FlowLayout(3, 35, 3));
            buttonPane.setOpaque(false);
            for (int j = 0; j < buttons.length; ++j) {
                buttonPane.add(buttons[j]);
            }
            this.add((Component)buttonPane, "1, 0");
            JPanel searchPane = new JPanel(new FlowLayout(2, 3, 10));
            searchPane.setOpaque(false);
            searchPane.add(search);
            this.add((Component)searchPane, "2 , 0");
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(new GradientPaint(0.0f, 0.0f, Color.darkGray, 0.0f, this.getHeight(), Color.DARK_GRAY, false));
            g2.fillRect(0, 0, this.getWidth(), this.getHeight() / 2);
            g2.setPaint(new GradientPaint(0.0f, 0.0f, Color.darkGray, 0.0f, this.getHeight(), Color.black, false));
            g2.fillRect(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
            super.paint(g);
        }
    }
}

