/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CButton;
import edu.mit.blocks.codeblockutil.CGraphite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;

public class CGraphiteButton
extends CButton {
    private static final long serialVersionUID = 328149080221L;

    public CGraphiteButton(String text) {
        super(Color.black, CGraphite.blue, text);
    }

    @Override
    public void paint(Graphics g) {
        Color bottomColoring;
        Color topColoring;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int buttonHeight = this.getHeight() - 6;
        int buttonWidth = this.getWidth() - 6;
        int arc = buttonHeight / 3;
        if (this.pressed || this.selected) {
            if (this.focus) {
                topColoring = this.selectedColor.darker().darker().darker();
                bottomColoring = CGraphite.blue;
            } else {
                topColoring = CGraphite.blue.darker().darker().darker();
                bottomColoring = CGraphite.blue;
            }
        } else if (this.focus) {
            topColoring = this.buttonColor;
            bottomColoring = Color.darkGray;
        } else {
            topColoring = this.buttonColor;
            bottomColoring = this.buttonColor;
        }
        g2.setPaint(new GradientPaint(0.0f, 0.0f, topColoring, 0.0f, buttonHeight, bottomColoring, false));
        g2.fillRoundRect(3, 3, buttonWidth, buttonHeight, arc, arc);
        g2.setColor(Color.darkGray);
        g2.drawRoundRect(3, 3, buttonWidth, buttonHeight, arc, arc);
        int highlightHeight = buttonHeight / 2 - 2;
        int highlightWidth = buttonWidth - 4 + 1;
        if (this.pressed || this.selected) {
            if (this.focus) {
                topColoring = Color.white;
                bottomColoring = this.selectedColor;
            } else {
                topColoring = Color.white;
                bottomColoring = this.selectedColor;
            }
        } else if (this.focus) {
            topColoring = Color.white;
            bottomColoring = Color.darkGray;
        } else {
            topColoring = Color.gray;
            bottomColoring = Color.darkGray;
        }
        g2.setPaint(new GradientPaint(0.0f, 0.0f, topColoring, 0.0f, buttonHeight, bottomColoring, false));
        g2.fillRoundRect(5, 6, highlightWidth, highlightHeight, arc, arc);
        if (this.getText() != null) {
            if (this.focus) {
                g2.setColor(Color.white);
            } else {
                g2.setColor(Color.white);
            }
            Font font = g2.getFont().deriveFont((float)((double)buttonHeight * 0.4));
            g2.setFont(font);
            FontMetrics metrics = g2.getFontMetrics();
            Rectangle2D textBounds = metrics.getStringBounds(this.getText(), g2);
            float x = (float)((double)(this.getWidth() / 2) - textBounds.getWidth() / 2.0);
            float y = (float)((double)(this.getHeight() / 2) + textBounds.getHeight() / 2.0) - (float)metrics.getDescent();
            g2.drawString(this.getText(), x, y);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setLayout(new FlowLayout());
        f.setSize(500, 300);
        CGraphiteButton c = new CGraphiteButton("hi");
        c.setPreferredSize(new Dimension(400, 200));
        f.add(c);
        f.setVisible(true);
        f.repaint();
    }
}

