/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks.rendering;

import edu.mit.blocks.codeblocks.rendering.BevelIterator;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class ShapeBevel {
    public static void createShapeBevel(Graphics2D g2, Shape theShape, double flatness, int numBands, float bevelSize, float[] light) {
        for (int i = numBands - 1; i >= 0; --i) {
            BevelIterator bi = new BevelIterator(theShape, flatness);
            float theCos = 1.0f - ((float)i + 0.5f) / (float)numBands;
            float theSin = (float)Math.sqrt(1.0f - theCos * theCos);
            float from = 0.0f;
            float to = 1.0f / (float)numBands * (float)(i + 1) * bevelSize;
            g2.setStroke(new BasicStroke(to - from));
            float[] p = new float[]{0.0f, 0.0f};
            float[] norm = new float[]{0.0f, 0.0f, 0.0f};
            float[] grayAlpha = new float[]{0.0f, 0.0f};
            while (!bi.isDone()) {
                bi.nextSegment();
                norm[0] = bi.perpVec[0] * theCos;
                norm[1] = bi.perpVec[1] * theCos;
                norm[2] = theSin;
                ShapeBevel.getLightingOverlay(norm, light, grayAlpha);
                g2.setColor(new Color(grayAlpha[0], grayAlpha[0], grayAlpha[0], grayAlpha[1]));
                g2.setComposite(AlphaComposite.Src);
                GeneralPath gp = new GeneralPath();
                bi.insetPoint2(from, p);
                gp.moveTo(p[0], p[1]);
                bi.insetPoint3(from, p);
                gp.lineTo(p[0], p[1]);
                bi.insetPoint3(to, p);
                gp.lineTo(p[0], p[1]);
                bi.insetPoint2(to, p);
                gp.lineTo(p[0], p[1]);
                gp.closePath();
                g2.fill(gp);
            }
        }
    }

    public static Color getFrontFaceOverlay(float[] light) {
        float[] frontNorm = new float[]{0.0f, 0.0f, 1.0f};
        float[] frontGrayAlpha = new float[]{0.0f, 0.0f};
        ShapeBevel.getLightingOverlay(frontNorm, light, frontGrayAlpha);
        return new Color(frontGrayAlpha[0], frontGrayAlpha[0], frontGrayAlpha[0], frontGrayAlpha[1]);
    }

    public static float[] getLightVector(float x, float y, float z) {
        float[] light = new float[]{x, y, z};
        float lightLen = (float)Math.sqrt(light[0] * light[0] + light[1] * light[1] + light[2] * light[2]);
        light[0] = light[0] / lightLen;
        light[1] = light[1] / lightLen;
        light[2] = light[2] / lightLen;
        return light;
    }

    private static void getLightingOverlay(float[] norm, float[] light, float[] grayAlpha) {
        float lum = norm[0] * light[0] + norm[1] * light[1] + norm[2] * light[2];
        float shine = 2.0f * norm[2] * lum - light[2];
        if (shine < 0.0f) {
            shine = 0.0f;
        }
        shine = shine * shine * shine * shine * 0.9f;
        if (lum < 0.0f) {
            lum = 0.0f;
        }
        float shad = 1.0f - lum;
        shad *= shad;
        grayAlpha[1] = (shad *= 0.8f) + shine - shad * shine;
        grayAlpha[0] = shine > 0.0f ? shine / grayAlpha[1] : 0.0f;
    }
}

