/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockConnectorShape;
import edu.mit.blocks.renderable.BlockImageIcon;
import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BlockGenus {
    private static final String EMPTY_STRING = "";
    private static Map<String, BlockGenus> nameToGenus = new HashMap<String, BlockGenus>();
    private String genusName;
    private Color color;
    private String kind;
    private String initLabel;
    private String labelPrefix = "";
    private String labelSuffix = "";
    private String blockDescription;
    private boolean isStarter;
    private boolean isTerminator;
    private boolean isLabelEditable;
    private boolean labelMustBeUnique;
    private boolean isLabelValue;
    private boolean isPageLabelEnabled;
    private boolean hasDefArgs;
    private boolean areSocketsExpandable;
    private boolean isInfix;
    private BlockConnector plug = null;
    private List<BlockConnector> sockets = new ArrayList<BlockConnector>();
    private BlockConnector before = null;
    private BlockConnector after = null;
    private List<String> familyList = new ArrayList<String>();
    private List<String> stubList = new ArrayList<String>();
    private Map<BlockImageIcon.ImageLocation, BlockImageIcon> blockImageMap = new HashMap<BlockImageIcon.ImageLocation, BlockImageIcon>();
    private Map<String, String> properties = new HashMap<String, String>();
    private List<String> argumentDescriptions = new ArrayList<String>();
    private List<List<BlockConnector>> expandGroups = new ArrayList<List<BlockConnector>>();

    private BlockGenus() {
    }

    private BlockGenus(String genusName, String newGenusName) {
        assert (!genusName.equals(newGenusName)) : "BlockGenuses must have unique names: " + genusName;
        BlockGenus genusToCopy = BlockGenus.getGenusWithName(genusName);
        this.genusName = newGenusName;
        this.areSocketsExpandable = genusToCopy.areSocketsExpandable;
        this.color = new Color(genusToCopy.color.getRed(), genusToCopy.color.getGreen(), genusToCopy.color.getBlue());
        this.familyList = new ArrayList<String>(genusToCopy.familyList);
        this.hasDefArgs = genusToCopy.hasDefArgs;
        this.initLabel = new String(genusToCopy.initLabel);
        this.isLabelEditable = genusToCopy.isLabelEditable;
        this.isLabelValue = genusToCopy.isLabelValue;
        this.isStarter = genusToCopy.isStarter;
        this.isTerminator = genusToCopy.isTerminator;
        this.isInfix = genusToCopy.isInfix;
        this.kind = genusToCopy.kind;
        this.labelPrefix = genusToCopy.labelPrefix;
        this.labelSuffix = genusToCopy.labelSuffix;
        if (genusToCopy.plug != null) {
            this.plug = new BlockConnector(genusToCopy.plug);
        }
        if (genusToCopy.before != null) {
            this.before = new BlockConnector(genusToCopy.before);
        }
        if (genusToCopy.after != null) {
            this.after = new BlockConnector(genusToCopy.after);
        }
        this.properties = new HashMap<String, String>(genusToCopy.properties);
        this.sockets = new ArrayList<BlockConnector>(genusToCopy.sockets);
        this.stubList = new ArrayList<String>(genusToCopy.stubList);
        this.expandGroups = genusToCopy.expandGroups;
    }

    public static void resetAllGenuses() {
        nameToGenus.clear();
    }

    public static BlockGenus getGenusWithName(String name) {
        return nameToGenus.get(name);
    }

    public List<String> getSiblingsList() {
        return Collections.unmodifiableList(this.familyList);
    }

    public boolean hasSiblings() {
        return this.familyList.size() > 0;
    }

    public Iterable<String> getStubList() {
        return Collections.unmodifiableList(this.stubList);
    }

    public boolean hasStubs() {
        return this.stubList.size() > 0;
    }

    public boolean hasDefaultArgs() {
        return this.hasDefArgs;
    }

    public boolean isCommandBlock() {
        return this.kind.equals("command");
    }

    public boolean isDataBlock() {
        return this.kind.equals("data");
    }

    public boolean isFunctionBlock() {
        return this.kind.equals("function");
    }

    public boolean isVariableDeclBlock() {
        return this.kind.equals("variable");
    }

    public boolean isProcedureDeclBlock() {
        return this.kind.equals("procedure");
    }

    public boolean isProcedureParamBlock() {
        return this.kind.equals("param");
    }

    public boolean isDeclaration() {
        return this.isVariableDeclBlock() || this.isProcedureDeclBlock();
    }

    public boolean isListRelated() {
        boolean hasListConn = false;
        if (this.plug != null) {
            hasListConn = this.plug.getKind().contains("list");
        }
        for (BlockConnector socket : this.sockets) {
            hasListConn |= socket.getKind().contains("list");
        }
        return hasListConn;
    }

    public boolean hasBeforeConnector() {
        return !this.isStarter;
    }

    public boolean hasAfterConnector() {
        return !this.isTerminator;
    }

    public boolean isLabelValue() {
        return this.isLabelValue;
    }

    public boolean isLabelEditable() {
        return this.isLabelEditable;
    }

    public boolean isPageLabelSetByPage() {
        return this.isPageLabelEnabled;
    }

    public boolean labelMustBeUnique() {
        return this.labelMustBeUnique;
    }

    public boolean areSocketsExpandable() {
        return this.areSocketsExpandable;
    }

    public boolean isInfix() {
        return this.isInfix;
    }

    public String getGenusName() {
        return this.genusName;
    }

    public String getInitialLabel() {
        return this.initLabel;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public String getLabelSuffix() {
        return this.labelSuffix;
    }

    public String getBlockDescription() {
        return this.blockDescription;
    }

    public Iterable<String> getInitialArgumentDescriptions() {
        return Collections.unmodifiableList(this.argumentDescriptions);
    }

    public Color getColor() {
        return this.color;
    }

    public Map<BlockImageIcon.ImageLocation, BlockImageIcon> getInitBlockImageMap() {
        return Collections.unmodifiableMap(this.blockImageMap);
    }

    public String getProperty(String property) {
        return this.properties.get(property);
    }

    public Iterable<BlockConnector> getInitSockets() {
        return Collections.unmodifiableList(this.sockets);
    }

    public BlockConnector getInitPlug() {
        return this.plug;
    }

    public BlockConnector getInitBefore() {
        return this.before;
    }

    public BlockConnector getInitAfter() {
        return this.after;
    }

    public List<List<BlockConnector>> getExpandGroups() {
        return Collections.unmodifiableList(this.expandGroups);
    }

    private static List<BlockConnector> getExpandGroup(List<List<BlockConnector>> groups, String group) {
        for (List<BlockConnector> list : groups) {
            if (!list.get(0).getExpandGroup().equals(group)) continue;
            return list;
        }
        return null;
    }

    private static void addToExpandGroup(List<List<BlockConnector>> groups, BlockConnector socket) {
        List<BlockConnector> eGroup = BlockGenus.getExpandGroup(groups, socket.getExpandGroup());
        if (eGroup == null) {
            eGroup = new ArrayList<BlockConnector>();
            groups.add(eGroup);
        }
        eGroup.add(new BlockConnector(socket));
    }

    private static void loadGenusDescription(NodeList descriptions, BlockGenus genus) {
        for (int k = 0; k < descriptions.getLength(); ++k) {
            String argumentDescription;
            Node description = descriptions.item(k);
            if (description.getNodeName().equals("text")) {
                genus.blockDescription = description.getTextContent();
                continue;
            }
            if (!description.getNodeName().equals("arg-description") || (argumentDescription = description.getTextContent()) == null) continue;
            genus.argumentDescriptions.add(argumentDescription);
        }
    }

    private static void loadBlockConnectorInformation(NodeList connectors, BlockGenus genus) {
        Pattern attrExtractor = Pattern.compile("\"(.*)\"");
        for (int k = 0; k < connectors.getLength(); ++k) {
            Node opt_item;
            Matcher nameMatcher;
            Node connector = connectors.item(k);
            if (!connector.getNodeName().equals("BlockConnector")) continue;
            String label = EMPTY_STRING;
            String connectorType = "none";
            boolean connectorKind = false;
            String positionType = "single";
            boolean isExpandable = false;
            boolean isLabelEditable = false;
            String expandGroup = EMPTY_STRING;
            String defargname = null;
            String defarglabel = null;
            if (connector.getAttributes().getLength() > 0) {
                nameMatcher = attrExtractor.matcher(connector.getAttributes().getNamedItem("connector-kind").toString());
                if (nameMatcher.find()) {
                    boolean bl = connectorKind = !nameMatcher.group(1).equals("socket");
                }
                if ((nameMatcher = attrExtractor.matcher(connector.getAttributes().getNamedItem("connector-type").toString())).find()) {
                    connectorType = nameMatcher.group(1);
                }
                if ((nameMatcher = attrExtractor.matcher(connector.getAttributes().getNamedItem("position-type").toString())).find()) {
                    positionType = nameMatcher.group(1);
                }
                if ((nameMatcher = attrExtractor.matcher(connector.getAttributes().getNamedItem("is-expandable").toString())).find()) {
                    isExpandable = nameMatcher.group(1).equals("yes");
                }
                if ((nameMatcher = attrExtractor.matcher(connector.getAttributes().getNamedItem("label-editable").toString())).find()) {
                    isLabelEditable = nameMatcher.group(1).equals("yes");
                }
                if ((opt_item = connector.getAttributes().getNamedItem("label")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                    label = nameMatcher.group(1);
                }
                if ((opt_item = connector.getAttributes().getNamedItem("expand-group")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                    expandGroup = nameMatcher.group(1);
                }
            }
            if (connector.hasChildNodes()) {
                NodeList defargs = connector.getChildNodes();
                for (int l = 0; l < defargs.getLength(); ++l) {
                    Node defarg = defargs.item(l);
                    if (!defarg.getNodeName().equals("DefaultArg") || defarg.getAttributes().getLength() <= 0) continue;
                    nameMatcher = attrExtractor.matcher(defarg.getAttributes().getNamedItem("genus-name").toString());
                    if (nameMatcher.find()) {
                        defargname = nameMatcher.group(1);
                    }
                    assert (nameToGenus.get(defargname) != null) : "Unknown BlockGenus: " + defargname;
                    opt_item = defarg.getAttributes().getNamedItem("label");
                    if (opt_item != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                        defarglabel = nameMatcher.group(1);
                    }
                    genus.hasDefArgs = true;
                }
            }
            BlockConnector socket = positionType.equals("mirror") ? new BlockConnector(connectorType, BlockConnector.PositionType.MIRROR, label, isLabelEditable, isExpandable, expandGroup, Block.NULL) : (positionType.equals("bottom") ? new BlockConnector(connectorType, BlockConnector.PositionType.BOTTOM, label, isLabelEditable, isExpandable, expandGroup, Block.NULL) : new BlockConnector(connectorType, BlockConnector.PositionType.SINGLE, label, isLabelEditable, isExpandable, expandGroup, Block.NULL));
            if (defargname != null) {
                socket.setDefaultArgument(defargname, defarglabel);
            }
            if (!connectorKind) {
                genus.sockets.add(socket);
            } else {
                genus.plug = socket;
                assert (!socket.isExpandable()) : genus.genusName + " can not have an expandable plug.  Every block has at most one plug.";
            }
            if (socket.isExpandable()) {
                genus.areSocketsExpandable = true;
            }
            if (expandGroup.length() <= 0) continue;
            BlockGenus.addToExpandGroup(genus.expandGroups, socket);
        }
    }

    private static void loadBlockImages(NodeList images, BlockGenus genus) {
        Pattern attrExtractor = Pattern.compile("\"(.*)\"");
        String location = null;
        boolean isEditable = false;
        boolean textWrap = false;
        for (int i = 0; i < images.getLength(); ++i) {
            Node imageNode = images.item(i);
            if (!imageNode.getNodeName().equals("Image") || imageNode.getAttributes().getLength() <= 0) continue;
            Matcher nameMatcher = attrExtractor.matcher(imageNode.getAttributes().getNamedItem("block-location").toString());
            if (nameMatcher.find()) {
                location = nameMatcher.group(1);
            }
            if ((nameMatcher = attrExtractor.matcher(imageNode.getAttributes().getNamedItem("image-editable").toString())).find()) {
                boolean bl = isEditable = nameMatcher.group(1).equals("yes");
            }
            if ((nameMatcher = attrExtractor.matcher(imageNode.getAttributes().getNamedItem("wrap-text").toString())).find()) {
                textWrap = nameMatcher.group(1).equals("yes");
            }
            int width = -1;
            int height = -1;
            Node opt_item = imageNode.getAttributes().getNamedItem("width");
            if (opt_item != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                width = Integer.parseInt(nameMatcher.group(1));
            }
            if ((opt_item = imageNode.getAttributes().getNamedItem("height")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                height = Integer.parseInt(nameMatcher.group(1));
            }
            NodeList imageChildren = imageNode.getChildNodes();
            for (int j = 0; j < imageChildren.getLength(); ++j) {
                Node imageLocationNode = imageChildren.item(j);
                if (!imageLocationNode.getNodeName().equals("FileLocation")) continue;
                String fileLocation = imageLocationNode.getTextContent();
                try {
                    URL fileURL = new URL("file", EMPTY_STRING, fileLocation);
                    if (fileURL == null || location == null) continue;
                    BlockImageIcon.ImageLocation imgLoc = BlockImageIcon.ImageLocation.getImageLocation(location);
                    assert (imgLoc != null) : "Invalid location string loaded: " + (Object)((Object)imgLoc);
                    ImageIcon icon = new ImageIcon(fileURL);
                    if (width > 0 && height > 0) {
                        icon.setImage(icon.getImage().getScaledInstance(width, height, 4));
                    }
                    genus.blockImageMap.put(imgLoc, new BlockImageIcon(icon, imgLoc, isEditable, textWrap));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static void loadLangDefProperties(NodeList properties, BlockGenus genus) {
        Pattern attrExtractor = Pattern.compile("\"(.*)\"");
        String key = null;
        String value = null;
        for (int l = 0; l < properties.getLength(); ++l) {
            Node opt_item;
            Node prop = properties.item(l);
            if (!prop.getNodeName().equals("LangSpecProperty") || prop.getAttributes().getLength() <= 0) continue;
            Matcher nameMatcher = attrExtractor.matcher(prop.getAttributes().getNamedItem("key").toString());
            if (nameMatcher.find()) {
                key = nameMatcher.group(1);
            }
            if ((opt_item = prop.getAttributes().getNamedItem("value")) != null) {
                nameMatcher = attrExtractor.matcher(opt_item.toString());
                if (nameMatcher.find()) {
                    value = nameMatcher.group(1);
                }
            } else {
                value = prop.getTextContent();
            }
            if (key == null || value == null) continue;
            genus.properties.put(key, value);
        }
    }

    private static void loadStubs(NodeList stubs, BlockGenus genus) {
        Pattern attrExtractor = Pattern.compile("\"(.*)\"");
        String stubGenus = EMPTY_STRING;
        for (int m = 0; m < stubs.getLength(); ++m) {
            Node stub = stubs.item(m);
            if (!stub.getNodeName().equals("Stub") || stub.getAttributes().getLength() <= 0) continue;
            Matcher nameMatcher = attrExtractor.matcher(stub.getAttributes().getNamedItem("stub-genus").toString());
            if (nameMatcher.find()) {
                stubGenus = nameMatcher.group(1);
            }
            if (stub.hasChildNodes()) {
                BlockGenus newStubGenus = new BlockGenus(stubGenus, stubGenus + genus.genusName);
                NodeList stubChildren = stub.getChildNodes();
                for (int n = 0; n < stubChildren.getLength(); ++n) {
                    Node stubChild = stubChildren.item(n);
                    if (!stubChild.getNodeName().equals("LangSpecProperties")) continue;
                    BlockGenus.loadLangDefProperties(stubChild.getChildNodes(), newStubGenus);
                }
                nameToGenus.put(newStubGenus.genusName, newStubGenus);
                genus.stubList.add(newStubGenus.genusName);
                continue;
            }
            genus.stubList.add(stubGenus);
        }
    }

    public static void loadBlockGenera(Element root) {
        Pattern attrExtractor = Pattern.compile("\"(.*)\"");
        NodeList genusNodes = root.getElementsByTagName("BlockGenus");
        for (int i = 0; i < genusNodes.getLength(); ++i) {
            Node opt_item;
            Node genusNode = genusNodes.item(i);
            if (!genusNode.getNodeName().equals("BlockGenus")) continue;
            BlockGenus newGenus = new BlockGenus();
            Matcher nameMatcher = attrExtractor.matcher(genusNode.getAttributes().getNamedItem("name").toString());
            if (nameMatcher.find()) {
                newGenus.genusName = nameMatcher.group(1);
            }
            assert (nameToGenus.get(newGenus.genusName) == null) : "Block genus names must be unique.  A block genus already exists with this name: " + newGenus.genusName;
            nameMatcher = attrExtractor.matcher(genusNode.getAttributes().getNamedItem("color").toString());
            if (nameMatcher.find()) {
                StringTokenizer col = new StringTokenizer(nameMatcher.group(1));
                newGenus.color = col.countTokens() == 3 ? new Color(Integer.parseInt(col.nextToken()), Integer.parseInt(col.nextToken()), Integer.parseInt(col.nextToken())) : Color.BLACK;
            }
            if ((nameMatcher = attrExtractor.matcher(genusNode.getAttributes().getNamedItem("kind").toString())).find()) {
                newGenus.kind = nameMatcher.group(1);
            }
            if ((nameMatcher = attrExtractor.matcher(genusNode.getAttributes().getNamedItem("initlabel").toString())).find()) {
                newGenus.initLabel = nameMatcher.group(1);
            }
            if ((nameMatcher = attrExtractor.matcher(genusNode.getAttributes().getNamedItem("editable-label").toString())).find()) {
                boolean bl = newGenus.isLabelEditable = nameMatcher.group(1).equals("yes");
            }
            if ((nameMatcher = attrExtractor.matcher(genusNode.getAttributes().getNamedItem("label-unique").toString())).find()) {
                boolean bl = newGenus.labelMustBeUnique = nameMatcher.group(1).equals("yes");
            }
            if ((opt_item = genusNode.getAttributes().getNamedItem("is-starter")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                boolean bl = newGenus.isStarter = nameMatcher.group(1).equals("yes");
            }
            if ((opt_item = genusNode.getAttributes().getNamedItem("is-terminator")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                boolean bl = newGenus.isTerminator = nameMatcher.group(1).equals("yes");
            }
            if ((opt_item = genusNode.getAttributes().getNamedItem("is-label-value")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                boolean bl = newGenus.isLabelValue = nameMatcher.group(1).equals("yes");
            }
            if ((opt_item = genusNode.getAttributes().getNamedItem("label-prefix")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                newGenus.labelPrefix = nameMatcher.group(1);
            }
            if ((opt_item = genusNode.getAttributes().getNamedItem("label-suffix")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                newGenus.labelSuffix = nameMatcher.group(1);
            }
            if ((opt_item = genusNode.getAttributes().getNamedItem("page-label-enabled")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                boolean bl = newGenus.isPageLabelEnabled = nameMatcher.group(1).equals("yes");
            }
            if (newGenus.isDataBlock() || newGenus.isVariableDeclBlock() || newGenus.isFunctionBlock()) {
                newGenus.isStarter = true;
                newGenus.isTerminator = true;
            }
            NodeList genusChildren = genusNode.getChildNodes();
            for (int j = 0; j < genusChildren.getLength(); ++j) {
                Node genusChild = genusChildren.item(j);
                if (genusChild.getNodeName().equals("description")) {
                    BlockGenus.loadGenusDescription(genusChild.getChildNodes(), newGenus);
                    continue;
                }
                if (genusChild.getNodeName().equals("BlockConnectors")) {
                    BlockGenus.loadBlockConnectorInformation(genusChild.getChildNodes(), newGenus);
                    if (newGenus.sockets == null || newGenus.sockets.size() != 2 || newGenus.sockets.get(0).getPositionType() != BlockConnector.PositionType.BOTTOM || newGenus.sockets.get(1).getPositionType() != BlockConnector.PositionType.BOTTOM) continue;
                    newGenus.isInfix = true;
                    continue;
                }
                if (genusChild.getNodeName().equals("Images")) {
                    BlockGenus.loadBlockImages(genusChild.getChildNodes(), newGenus);
                    continue;
                }
                if (genusChild.getNodeName().equals("LangSpecProperties")) {
                    BlockGenus.loadLangDefProperties(genusChild.getChildNodes(), newGenus);
                    continue;
                }
                if (!genusChild.getNodeName().equals("Stubs")) continue;
                BlockGenus.loadStubs(genusChild.getChildNodes(), newGenus);
            }
            if (!newGenus.isStarter) {
                newGenus.before = new BlockConnector(BlockConnectorShape.getCommandShapeName(), BlockConnector.PositionType.TOP, EMPTY_STRING, false, false, Block.NULL);
            }
            if (!newGenus.isTerminator) {
                newGenus.after = new BlockConnector(BlockConnectorShape.getCommandShapeName(), BlockConnector.PositionType.BOTTOM, EMPTY_STRING, false, false, Block.NULL);
            }
            nameToGenus.put(newGenus.genusName, newGenus);
        }
        NodeList families = root.getElementsByTagName("BlockFamily");
        ArrayList<String> famList = new ArrayList<String>();
        for (int i = 0; i < families.getLength(); ++i) {
            Node family = families.item(i);
            for (int j = 0; j < family.getChildNodes().getLength(); ++j) {
                Node member = family.getChildNodes().item(j);
                if (!member.getNodeName().equals("FamilyMember")) continue;
                String name = member.getTextContent();
                assert (nameToGenus.get(name) != null) : "Unknown BlockGenus: " + name;
                assert (!BlockGenus.nameToGenus.get((Object)name).isLabelEditable) : "Genus " + name + " is in a family, but its name is editable";
                famList.add(name);
            }
            if (famList.size() > 0) {
                for (String memName : famList) {
                    ArrayList<String> newFamList = new ArrayList<String>(famList);
                    newFamList.remove(memName);
                    BlockGenus.nameToGenus.get((Object)memName).familyList = newFamList;
                }
            }
            famList.clear();
        }
    }

    public String toString() {
        StringBuffer out = new StringBuffer("BlockGenus ");
        out.append(this.genusName);
        out.append(" kind: ");
        out.append(this.kind);
        out.append(" with label ");
        out.append(this.initLabel);
        out.append(" with color: ");
        out.append(this.color);
        out.append("\n");
        out.append("isStarter=");
        out.append(this.isStarter);
        out.append(" isTerminator=");
        out.append(this.isTerminator);
        out.append("\n");
        if (this.before != null) {
            out.append("before:");
            out.append(this.before.toString());
            out.append("\n");
        }
        if (this.after != null) {
            out.append("after:");
            out.append(this.after.toString());
            out.append("\n");
        }
        if (this.plug != null) {
            out.append("plug:");
            out.append(this.plug.toString());
            out.append("\n");
        }
        for (int i = 0; i < this.sockets.size(); ++i) {
            out.append(this.sockets.get(i).toString());
            out.append("\n");
        }
        return out.toString();
    }
}

