/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.workspace.ISupportMemento;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

public class BlockConnector
implements ISupportMemento {
    private String kind;
    private String initKind;
    private PositionType positionType;
    private String label;
    private Long connBlockID = Block.NULL;
    private DefArgument arg = null;
    private boolean hasDefArg = false;
    private boolean isExpandable = false;
    private boolean isLabelEditable = false;
    private String expandGroup = "";
    private static final String EQ_OPEN_QUOTE = "=\"";
    private static final String CLOSE_QUOTE = "\" ";

    public BlockConnector(String kind, PositionType positionType, String label, boolean isLabelEditable, boolean isExpandable, String expandGroup, Long connBlockID) {
        this(kind, positionType, label, isLabelEditable, isExpandable, connBlockID);
        this.expandGroup = expandGroup == null ? "" : expandGroup;
    }

    public BlockConnector(String kind, PositionType positionType, String label, boolean isLabelEditable, boolean isExpandable, Long connBlockID) {
        this.kind = kind;
        this.positionType = positionType;
        this.label = label;
        this.isLabelEditable = isLabelEditable;
        this.connBlockID = connBlockID;
        this.isExpandable = isExpandable;
        this.initKind = kind;
    }

    public BlockConnector(String kind, String label, Long socketBlockID) {
        this(kind, PositionType.SINGLE, label, false, false, socketBlockID);
    }

    public BlockConnector(String label, String kind, boolean isLabelEditable, boolean isExpandable) {
        this(kind, PositionType.SINGLE, label, isLabelEditable, isExpandable, Block.NULL);
    }

    public BlockConnector(BlockConnector con) {
        this(con.kind, con.positionType, con.label, con.isLabelEditable, con.isExpandable, con.connBlockID);
        this.hasDefArg = con.hasDefArg;
        this.arg = con.arg;
        this.isLabelEditable = con.isLabelEditable;
        this.expandGroup = con.expandGroup;
    }

    public String getLabel() {
        return this.label;
    }

    public String getKind() {
        return this.kind;
    }

    public String initKind() {
        return this.initKind;
    }

    public PositionType getPositionType() {
        return this.positionType;
    }

    public Long getBlockID() {
        return this.connBlockID;
    }

    public boolean hasBlock() {
        return !this.connBlockID.equals(Block.NULL);
    }

    public boolean isExpandable() {
        return this.isExpandable;
    }

    public String getExpandGroup() {
        return this.expandGroup;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isLabelEditable() {
        return this.isLabelEditable;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public void setConnectorBlockID(Long id) {
        this.connBlockID = id;
    }

    public void setPositionType(PositionType pos) {
        this.positionType = pos;
    }

    public boolean hasDefArg() {
        return this.hasDefArg;
    }

    public void setDefaultArgument(String genusName, String label) {
        this.hasDefArg = true;
        this.arg = new DefArgument(genusName, label);
    }

    public Long linkDefArgument() {
        if (this.hasDefArg && this.connBlockID == Block.NULL) {
            Block block = new Block(this.arg.getGenusName(), this.arg.label);
            this.connBlockID = block.getBlockID();
            return this.connBlockID;
        }
        return Block.NULL;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("Connector label: ");
        out.append(this.label);
        out.append(", Connector kind: ");
        out.append(this.kind);
        out.append(", blockID: ");
        out.append(this.connBlockID);
        out.append(" with pos type: ");
        out.append((Object)this.getPositionType());
        return out.toString();
    }

    public static BlockConnector loadBlockConnector(Node node, HashMap<Long, Long> idMapping) {
        Pattern attrExtractor = Pattern.compile("\"(.*)\"");
        BlockConnector con = null;
        String initKind = null;
        String kind = null;
        Long idConnected = Block.NULL;
        String label = "";
        boolean isExpandable = false;
        boolean isLabelEditable = false;
        String expandGroup = "";
        String positionType = "single";
        if (node.getNodeName().equals("BlockConnector")) {
            Node opt_item;
            Matcher nameMatcher = attrExtractor.matcher(node.getAttributes().getNamedItem("init-type").toString());
            if (nameMatcher.find()) {
                initKind = nameMatcher.group(1);
            }
            if ((nameMatcher = attrExtractor.matcher(node.getAttributes().getNamedItem("connector-type").toString())).find()) {
                kind = nameMatcher.group(1);
            }
            if ((nameMatcher = attrExtractor.matcher(node.getAttributes().getNamedItem("label").toString())).find()) {
                label = nameMatcher.group(1);
            }
            if ((opt_item = node.getAttributes().getNamedItem("con-block-id")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                idConnected = Block.translateLong(Long.parseLong(nameMatcher.group(1)), idMapping);
            }
            if ((opt_item = node.getAttributes().getNamedItem("label-editable")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                isLabelEditable = nameMatcher.group(1).equals("true");
            }
            if ((opt_item = node.getAttributes().getNamedItem("is-expandable")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                boolean bl = isExpandable = nameMatcher.group(1).equals("yes");
            }
            if ((opt_item = node.getAttributes().getNamedItem("expand-group")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                expandGroup = nameMatcher.group(1);
            }
            if ((opt_item = node.getAttributes().getNamedItem("position-type")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                positionType = nameMatcher.group(1);
            }
            assert (initKind != null) : "BlockConnector was not specified a initial connection kind";
            if (positionType.equals("single")) {
                con = new BlockConnector(initKind, PositionType.SINGLE, label, isLabelEditable, isExpandable, idConnected);
            } else if (positionType.equals("bottom")) {
                con = new BlockConnector(initKind, PositionType.BOTTOM, label, isLabelEditable, isExpandable, idConnected);
            } else if (positionType.equals("mirror")) {
                con = new BlockConnector(initKind, PositionType.MIRROR, label, isLabelEditable, isExpandable, idConnected);
            } else if (positionType.endsWith("top")) {
                con = new BlockConnector(initKind, PositionType.TOP, label, isLabelEditable, isExpandable, idConnected);
            }
            con.expandGroup = expandGroup;
            if (!initKind.equals(kind)) {
                con.setKind(kind);
            }
        }
        assert (con != null) : "BlockConnector was not loaded " + node;
        return con;
    }

    private static String escape(String s) {
        return s.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public String getSaveString(String conKind) {
        StringBuffer saveString = new StringBuffer();
        saveString.append("<BlockConnector ");
        this.appendAttribute("connector-kind", conKind, saveString);
        this.appendAttribute("connector-type", this.kind, saveString);
        this.appendAttribute("init-type", this.initKind, saveString);
        this.appendAttribute("label", this.label, saveString);
        if (this.expandGroup.length() > 0) {
            this.appendAttribute("expand-group", this.expandGroup, saveString);
        }
        if (this.isExpandable) {
            this.appendAttribute("is-expandable", "yes", saveString);
        }
        if (this.positionType.equals((Object)PositionType.SINGLE)) {
            this.appendAttribute("position-type", "single", saveString);
        } else if (this.positionType.equals((Object)PositionType.MIRROR)) {
            this.appendAttribute("position-type", "mirror", saveString);
        } else if (this.positionType.equals((Object)PositionType.BOTTOM)) {
            this.appendAttribute("position-type", "bottom", saveString);
        } else if (this.positionType.equals((Object)PositionType.TOP)) {
            this.appendAttribute("position-type", "top", saveString);
        }
        if (this.isLabelEditable) {
            this.appendAttribute("label-editable", "true", saveString);
        }
        if (!this.connBlockID.equals(Block.NULL)) {
            this.appendAttribute("con-block-id", this.connBlockID.toString(), saveString);
        }
        saveString.append("></BlockConnector>");
        return saveString.toString();
    }

    private void appendAttribute(String att, String value, StringBuffer buf) {
        buf.append(att);
        buf.append(EQ_OPEN_QUOTE);
        buf.append(BlockConnector.escape(value));
        buf.append(CLOSE_QUOTE);
    }

    @Override
    public Object getState() {
        BlockConnectorState state = new BlockConnectorState();
        state.kind = this.getKind();
        state.initKind = this.initKind;
        state.positionType = this.getPositionType();
        state.label = this.getLabel();
        state.connBlockID = this.getBlockID();
        if (this.hasDefArg()) {
            state.defArgGenusName = this.arg.getGenusName();
            state.defArgLabel = this.arg.getLabel();
            state.hasDefArg = true;
        } else {
            state.defArgGenusName = null;
            state.defArgLabel = null;
            state.hasDefArg = false;
        }
        state.isExpandable = this.isExpandable();
        state.isLabelEditable = this.isLabelEditable;
        state.expandGroup = this.expandGroup;
        return state;
    }

    @Override
    public void loadState(Object memento) {
        if (memento instanceof BlockConnectorState) {
            BlockConnectorState state = (BlockConnectorState)memento;
            this.setKind(state.kind);
            this.setPositionType(state.positionType);
            this.setLabel(state.label);
            this.setConnectorBlockID(state.connBlockID);
            if (state.hasDefArg) {
                this.setDefaultArgument(state.defArgGenusName, state.defArgLabel);
            } else {
                this.arg = null;
            }
            this.isExpandable = state.isExpandable;
            this.isLabelEditable = state.isLabelEditable;
            this.expandGroup = state.expandGroup;
        }
    }

    public static BlockConnector instantiateFromState(Object memento) {
        if (memento instanceof BlockConnectorState) {
            BlockConnectorState state = (BlockConnectorState)memento;
            BlockConnector instance = new BlockConnector(state.kind, state.positionType, state.label, state.isLabelEditable, state.isExpandable, state.connBlockID);
            instance.isLabelEditable = state.isLabelEditable;
            if (state.hasDefArg) {
                instance.setDefaultArgument(state.defArgGenusName, state.defArgLabel);
            }
            return instance;
        }
        return null;
    }

    private class BlockConnectorState {
        public String kind;
        public String initKind;
        public PositionType positionType;
        public String label;
        public Long connBlockID = Block.NULL;
        public boolean hasDefArg;
        public String defArgGenusName;
        public String defArgLabel;
        public boolean isExpandable;
        public String expandGroup;
        public boolean isLabelEditable;

        private BlockConnectorState() {
        }
    }

    private class DefArgument {
        private String genusName;
        private String label;

        public DefArgument(String genusName, String label) {
            this.genusName = genusName;
            this.label = label;
        }

        public String getGenusName() {
            return this.genusName;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum PositionType {
        SINGLE,
        MIRROR,
        BOTTOM,
        TOP;

    }
}

