/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.CharMatchScore;
import com.wcohen.ss.MemoMatrix;
import com.wcohen.ss.api.StringWrapper;

public class SmithWaterman
extends AbstractStringDistance {
    private CharMatchScore charMatchScore;
    private double gapCost;

    public SmithWaterman() {
        this(CharMatchScore.DIST_21, 1.0);
    }

    public SmithWaterman(CharMatchScore charMatchScore, double gapCost) {
        this.charMatchScore = charMatchScore;
        this.gapCost = gapCost;
    }

    @Override
    public double score(StringWrapper s, StringWrapper t) {
        MyMatrix mat = new MyMatrix(s, t);
        return this.score(s, t, mat);
    }

    private double score(StringWrapper s, StringWrapper t, MyMatrix mat) {
        double best = -1.7976931348623157E308;
        for (int i = 0; i <= s.length(); ++i) {
            for (int j = 0; j <= t.length(); ++j) {
                best = Math.max(best, mat.get(i, j));
            }
        }
        return best;
    }

    @Override
    public String explainScore(StringWrapper s, StringWrapper t) {
        MyMatrix mat = new MyMatrix(s, t);
        double d = this.score(s, t, mat);
        return mat.toString() + "\nScore = " + d;
    }

    public String toString() {
        return "[SmithWaterman]";
    }

    public static void main(String[] argv) {
        SmithWaterman.doMain(new SmithWaterman(), argv);
    }

    private class MyMatrix
    extends MemoMatrix {
        public MyMatrix(StringWrapper s, StringWrapper t) {
            super(s, t);
        }

        @Override
        public double compute(int i, int j) {
            if (i == 0) {
                return 0.0;
            }
            if (j == 0) {
                return 0.0;
            }
            return MyMatrix.max4(0.0, this.get(i - 1, j - 1) + SmithWaterman.this.charMatchScore.matchScore(this.sAt(i), this.tAt(j)), this.get(i - 1, j) - SmithWaterman.this.gapCost, this.get(i, j - 1) - SmithWaterman.this.gapCost);
        }
    }
}

