(ns idm.graph.alg.arborescence
  "Functions in theory implementing an arborescence algorithm but in practice
  broken for the forseeable future"
  (:require
    [clojure.tools.logging :as log]
    [idm.graph.alg.kosaraju :as kosaraju]
    [ubergraph.core :as uber]))

(defn arborescence
  ; TODO: broken at the moment
  "Calculate an arborescence in `D` rooted at `r` with cost fn `w`.
  Minimum spanning tree algorithm for a directed graph.
  See https://en.wikipedia.org/wiki/Edmonds%27_algorithm

  `w` should be a function of the edge attributes map"
  [G r w]
  (let [w' (fn [[_src _dest attrs]]
             (if-some [cost (::cost attrs)]
               ; return previously specified value
               cost
               ; otherwise just call w on edge
               (w attrs)))
        ; set of edges that are cheapest for each node
        P (into #{}
                (map #(->> (uber/in-edges G %)
                           (mapv (fn [e-obj]
                                   (conj (uber/edge-with-attrs G e-obj) e-obj)))
                           (into (sorted-set-by (fn [e1 e2] (compare (w' e1) (w' e2)))))
                           first))
                (disj (set (uber/nodes G)) r))]
        ;P (into #{}
        ;        ; we don't care about losing duplicates; tie-breaking is arbitrary
        ;        ; though maybe this should just be a reduce; TODO
        ;        (map #(->> % (uber/in-edges G) (into (sorted-set-by w')) first))
        ;        (disj (set (uber/nodes G)) r))]
    (if-some [C_edges (val (first (kosaraju/find-cycle G P)))]
      (let [_ (log/trace "Edges:" C_edges)
            C (into #{} (map uber/src) C_edges)
            _ (log/trace "Nodes in cycle:" C)
            P-by-dest (into {} (map (juxt uber/dest identity)) P)
            ;Cn (into #{} (map uber/src) C)
            _ (log/trace "P by dest:" P-by-dest)
            vC (keyword "idm.graph.alg" (str (gensym "v#")))
            ; TODO: yeah this definitely doesn't work. Kills all inbound and outbound edges as well.
            G' (-> G
                   (uber/remove-edges* C_edges)
                   (uber/add-nodes vC))
            ; TODO: maybe ::prev needs to be generated to avoid somehow overlapping?
            G' (reduce
                 (fn [G' e]
                   (let [u (uber/src e)
                         v (uber/dest e)]
                     (cond
                       ; edge coming into cycle
                       (contains? C v) 
                       ; add an edge to E' whose cost is original cost minus
                       ; cost of cheapest edge to same destination
                       (-> G'
                           (uber/remove-edges e)
                           (uber/add-edges [u vC (assoc (uber/attrs G' e)
                                                        ::cost (- (w' e) (w' (P-by-dest v)))
                                                        ::prev e)]))
                       ; edge going away from cycle
                       (contains? C u)
                       ; add an edge to E' whose cost is same as before
                       (-> G'
                           (uber/remove-edges e)
                           (uber/add-edges [vC v (assoc (uber/attrs G' e)
                                                        ::cost (w' e)
                                                        ::prev e)]))

                       ; edge not related to cycle; unmodified
                       :else G')))
                 G' 
                 (mapv (partial uber/edge-with-attrs G')
                       (uber/edges G')))
            _ (do (println "G'")
                  (uber/pprint G'))
            ; recur with original cost function
            A' (arborescence G' r w)
            A'-by-dest (into {} (map (juxt uber/dest identity)) (uber/edges A'))
            ; this edge corresponds with some edge u->v in E with v in C
            u->vC (A'-by-dest vC)
            ; edge was present in G' so we can retrieve corresponding original edge
            u->v (uber/attr G' u->vC ::prev)
            C_edges' (disj C_edges (P-by-dest (uber/dest u->v)))
            G'' (-> G ; original graph
                    ; remove all edges
                    (uber/remove-edges* (uber/edges G))
                    (uber/add-edges* C_edges'))]
        (reduce
          (fn [G'' e]
            (uber/add-edges G'' (uber/attr G' e ::prev)))
          G''
          (uber/edges A')))
      P)))
               
(defn msp-directed
  [graph root cost-fn]
  (arborescence [(set (uber/nodes graph))
                 (set (uber/edges graph))]
                root
                cost-fn))

