(defproject edu.bard/idm.graph "0.1.3"
  :description "Attribute graph traversal for Bard IdM"
  :url "https://github.com/bardcollege/idm.graph"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}
  :repl-options {:init-ns idm.graph}
  :deploy-repositories {"github" {:url "https://maven.pkg.github.com/bardcollege/idm.graph"
                                  :username :env
                                  :password :env
                                  :sign-releases false}
                        "clojars" {:url "https://repo.clojars.org"
                                   :username :env/clojars_user
                                   :password :env/clojars_password
                                   :sign-releases false}}
  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" ":release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "v" "--no-sign"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]
  :dependencies [[org.clojure/clojure "1.10.1"]
                 [org.clojure/data.priority-map "1.0.0"]
                 [edu.bard/idm.log "0.1.3"]
                 [ubergraph "0.8.2"]])
