(ns idm.graph.multipath
  "Multipath protocol")

(defprotocol Multipath
  "Functions going beyond the Ubergraph IPath protocol to deal with extended
  requirements, such as retrieving lists of relations etc."
  (end-nodes [path] "A set of the nodes this path goes to.")
  (relations [path] "A list of relations in this path")
  (edge-sets [path] 
    "A list of edge sets comprising a full traversal of this multipath. Even
    single edges will be wrapped in a set.")
  (path [path] 
    "Get a vector of edges and relations in this multipath. For a
    path with only one->one edges, equivalent to [[alg/edges-in-path]]")
  (-multipath-to [path dests]
    "Required workaround for variadic [[multipath-to]]."))

(defn multipath-to
  "Get a Multipath, based on this one, to the given destinations."
  [path & dests]
  (-multipath-to path dests))
