(ns
 pandect.algo.whirlpool
 "Whirlpool algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1391 (compute-whirlpool1387 [data1388]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1391 #'compute-whirlpool1387]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1391
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-whirlpool1387
    [data1388]
    (clojure.core/let
     [md__682__auto__
      (java.security.MessageDigest/getInstance "Whirlpool")]
     (.digest md__682__auto__ data1388)))
   java.lang.String
   (compute-whirlpool1387
    [data1388]
    (clojure.core/let
     [data1388 (.getBytes data1388 "UTF-8")]
     (clojure.core/let
      [md__682__auto__
       (java.security.MessageDigest/getInstance "Whirlpool")]
      (.digest md__682__auto__ data1388)))))
  (clojure.core/extend-protocol
   G__1391
   java.io.InputStream
   (compute-whirlpool1387
    [data1388]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "Whirlpool")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1388]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-whirlpool1387
    [data1388]
    (clojure.core/with-open
     [data1388 (clojure.java.io/input-stream data1388)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "Whirlpool")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1388]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1391)
 (do
  (clojure.core/defn
   whirlpool*
   "[Hash] Whirlpool (raw value)"
   [x]
   (compute-whirlpool1387 x))
  (clojure.core/defn
   whirlpool-file*
   "[Hash] Whirlpool (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-whirlpool1387 x)))
  (clojure.core/defn
   whirlpool-bytes
   "[Hash] Whirlpool (value -> byte array)"
   [x]
   (compute-whirlpool1387 x))
  (clojure.core/defn
   whirlpool-file-bytes
   "[Hash] Whirlpool (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-whirlpool1387 x)))
  (clojure.core/defn
   whirlpool
   "[Hash] Whirlpool (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-whirlpool1387 x)))
  (clojure.core/defn
   whirlpool-file
   "[Hash] Whirlpool (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-whirlpool1387 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1395
   (compute-whirlpool1392 [data1393 key1394]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1395 #'compute-whirlpool1392]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1395
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-whirlpool1392
    [data1393 key1394]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "Hmac-Whirlpool")
      msg__558__auto__
      (clojure.core/bytes data1393)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1394 "Hmac-Whirlpool")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-whirlpool1392
    [data1393 key1394]
    (clojure.core/let
     [data1393 (.getBytes data1393 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "Hmac-Whirlpool")
       msg__558__auto__
       (clojure.core/bytes data1393)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1394 "Hmac-Whirlpool")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1395
   java.io.InputStream
   (compute-whirlpool1392
    [data1393 key1394]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "Hmac-Whirlpool")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1394 "Hmac-Whirlpool")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1393]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-whirlpool1392
    [data1393 key1394]
    (clojure.core/with-open
     [data1393 (clojure.java.io/input-stream data1393)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "Hmac-Whirlpool")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1394 "Hmac-Whirlpool")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1393]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1395)
 (do
  (clojure.core/defn
   whirlpool-hmac*
   "[HMAC] Hmac-Whirlpool (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-whirlpool1392
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   whirlpool-hmac-file*
   "[HMAC] Hmac-Whirlpool (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-whirlpool1392
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   whirlpool-hmac-bytes
   "[HMAC] Hmac-Whirlpool (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-whirlpool1392
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   whirlpool-hmac-file-bytes
   "[HMAC] Hmac-Whirlpool (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-whirlpool1392
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   whirlpool-hmac
   "[HMAC] Hmac-Whirlpool (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-whirlpool1392
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   whirlpool-hmac-file
   "[HMAC] Hmac-Whirlpool (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-whirlpool1392
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
