(ns
 pandect.algo.tiger
 "Tiger algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1390 (compute-tiger1386 [data1389]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1390 #'compute-tiger1386]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1390
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-tiger1386
    [data1389]
    (clojure.core/let
     [md__682__auto__
      (java.security.MessageDigest/getInstance "Tiger")]
     (.digest md__682__auto__ data1389)))
   java.lang.String
   (compute-tiger1386
    [data1389]
    (clojure.core/let
     [data1389 (.getBytes data1389 "UTF-8")]
     (clojure.core/let
      [md__682__auto__
       (java.security.MessageDigest/getInstance "Tiger")]
      (.digest md__682__auto__ data1389)))))
  (clojure.core/extend-protocol
   G__1390
   java.io.InputStream
   (compute-tiger1386
    [data1389]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "Tiger")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1389]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-tiger1386
    [data1389]
    (clojure.core/with-open
     [data1389 (clojure.java.io/input-stream data1389)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "Tiger")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1389]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1390)
 (do
  (clojure.core/defn
   tiger*
   "[Hash] Tiger (raw value)"
   [x]
   (compute-tiger1386 x))
  (clojure.core/defn
   tiger-file*
   "[Hash] Tiger (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-tiger1386 x)))
  (clojure.core/defn
   tiger-bytes
   "[Hash] Tiger (value -> byte array)"
   [x]
   (compute-tiger1386 x))
  (clojure.core/defn
   tiger-file-bytes
   "[Hash] Tiger (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-tiger1386 x)))
  (clojure.core/defn
   tiger
   "[Hash] Tiger (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-tiger1386 x)))
  (clojure.core/defn
   tiger-file
   "[Hash] Tiger (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-tiger1386 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1399
   (compute-tiger1396 [data1397 key1398]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1399 #'compute-tiger1396]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1399
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-tiger1396
    [data1397 key1398]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "Hmac-Tiger")
      msg__558__auto__
      (clojure.core/bytes data1397)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1398 "Hmac-Tiger")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-tiger1396
    [data1397 key1398]
    (clojure.core/let
     [data1397 (.getBytes data1397 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "Hmac-Tiger")
       msg__558__auto__
       (clojure.core/bytes data1397)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1398 "Hmac-Tiger")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1399
   java.io.InputStream
   (compute-tiger1396
    [data1397 key1398]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "Hmac-Tiger")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1398 "Hmac-Tiger")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1397]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-tiger1396
    [data1397 key1398]
    (clojure.core/with-open
     [data1397 (clojure.java.io/input-stream data1397)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "Hmac-Tiger")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1398 "Hmac-Tiger")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1397]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1399)
 (do
  (clojure.core/defn
   tiger-hmac*
   "[HMAC] Hmac-Tiger (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-tiger1396
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   tiger-hmac-file*
   "[HMAC] Hmac-Tiger (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-tiger1396
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   tiger-hmac-bytes
   "[HMAC] Hmac-Tiger (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-tiger1396
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   tiger-hmac-file-bytes
   "[HMAC] Hmac-Tiger (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-tiger1396
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   tiger-hmac
   "[HMAC] Hmac-Tiger (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-tiger1396
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   tiger-hmac-file
   "[HMAC] Hmac-Tiger (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-tiger1396
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
