(ns
 pandect.algo.sha512
 "SHA-512 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1324 (compute-sha5121322 [data1323]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1324 #'compute-sha5121322]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1324
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha5121322
    [data1323]
    (clojure.core/let
     [md__682__auto__
      (java.security.MessageDigest/getInstance "SHA-512")]
     (.digest md__682__auto__ data1323)))
   java.lang.String
   (compute-sha5121322
    [data1323]
    (clojure.core/let
     [data1323 (.getBytes data1323 "UTF-8")]
     (clojure.core/let
      [md__682__auto__
       (java.security.MessageDigest/getInstance "SHA-512")]
      (.digest md__682__auto__ data1323)))))
  (clojure.core/extend-protocol
   G__1324
   java.io.InputStream
   (compute-sha5121322
    [data1323]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "SHA-512")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1323]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-sha5121322
    [data1323]
    (clojure.core/with-open
     [data1323 (clojure.java.io/input-stream data1323)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "SHA-512")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1323]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1324)
 (do
  (clojure.core/defn
   sha512*
   "[Hash] SHA-512 (raw value)"
   [x]
   (compute-sha5121322 x))
  (clojure.core/defn
   sha512-file*
   "[Hash] SHA-512 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha5121322 x)))
  (clojure.core/defn
   sha512-bytes
   "[Hash] SHA-512 (value -> byte array)"
   [x]
   (compute-sha5121322 x))
  (clojure.core/defn
   sha512-file-bytes
   "[Hash] SHA-512 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha5121322 x)))
  (clojure.core/defn
   sha512
   "[Hash] SHA-512 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-sha5121322 x)))
  (clojure.core/defn
   sha512-file
   "[Hash] SHA-512 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-sha5121322 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1336
   (compute-sha5121333 [data1334 key1335]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1336 #'compute-sha5121333]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1336
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha5121333
    [data1334 key1335]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "HmacSHA512")
      msg__558__auto__
      (clojure.core/bytes data1334)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1335 "HmacSHA512")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-sha5121333
    [data1334 key1335]
    (clojure.core/let
     [data1334 (.getBytes data1334 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "HmacSHA512")
       msg__558__auto__
       (clojure.core/bytes data1334)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1335 "HmacSHA512")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1336
   java.io.InputStream
   (compute-sha5121333
    [data1334 key1335]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "HmacSHA512")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1335 "HmacSHA512")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1334]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-sha5121333
    [data1334 key1335]
    (clojure.core/with-open
     [data1334 (clojure.java.io/input-stream data1334)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "HmacSHA512")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1335 "HmacSHA512")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1334]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1336)
 (do
  (clojure.core/defn
   sha512-hmac*
   "[HMAC] HmacSHA512 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha5121333
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha512-hmac-file*
   "[HMAC] HmacSHA512 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha5121333
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha512-hmac-bytes
   "[HMAC] HmacSHA512 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha5121333
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha512-hmac-file-bytes
   "[HMAC] HmacSHA512 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha5121333
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha512-hmac
   "[HMAC] HmacSHA512 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-sha5121333
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha512-hmac-file
   "[HMAC] HmacSHA512 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha5121333
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
(do
 (do
  (clojure.core/defprotocol
   G__1363
   (compute-sha5121359 [data1360 key1362])
   (compute-sha5121359-verify [data1360 sig1361 key1362]))
  (clojure.core/doseq
   [v__198__auto__
    [#'G__1363 #'compute-sha5121359 #'compute-sha5121359-verify]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1363
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha5121359
    [data1360 key1362]
    (clojure.core/let
     [signer__861__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA512withRSA")
       (.initSign key1362)
       (.update (clojure.core/bytes data1360)))]
     (.sign signer__861__auto__)))
   (compute-sha5121359-verify
    [data1360 sig1361 key1362]
    (clojure.core/let
     [signer__862__auto__
      (java.security.Signature/getInstance "SHA512withRSA")
      key__863__auto__
      (pandect.utils.convert/as-public-key key1362)]
     (.initVerify signer__862__auto__ key__863__auto__)
     (.update signer__862__auto__ (clojure.core/bytes data1360))
     (.verify signer__862__auto__ (clojure.core/bytes sig1361))))
   java.lang.String
   (compute-sha5121359
    [data1360 key1362]
    (clojure.core/let
     [data1360 (.getBytes data1360 "UTF-8")]
     (clojure.core/let
      [signer__861__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA512withRSA")
        (.initSign key1362)
        (.update (clojure.core/bytes data1360)))]
      (.sign signer__861__auto__))))
   (compute-sha5121359-verify
    [data1360 sig1361 key1362]
    (clojure.core/let
     [data1360 (.getBytes data1360 "UTF-8")]
     (clojure.core/let
      [signer__862__auto__
       (java.security.Signature/getInstance "SHA512withRSA")
       key__863__auto__
       (pandect.utils.convert/as-public-key key1362)]
      (.initVerify signer__862__auto__ key__863__auto__)
      (.update signer__862__auto__ (clojure.core/bytes data1360))
      (.verify signer__862__auto__ (clojure.core/bytes sig1361))))))
  (clojure.core/extend-protocol
   G__1363
   java.io.InputStream
   (compute-sha5121359
    [data1360 key1362]
    (clojure.core/let
     [signer__864__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA512withRSA")
       (.initSign key1362))
      c__865__auto__
      (clojure.core/int *buffer-size*)
      buf__866__auto__
      (clojure.core/byte-array c__865__auto__)
      s__867__auto__
      data1360]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__868__auto__
        (.read s__867__auto__ buf__866__auto__ 0 c__865__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__868__auto__ -1)
        (.update signer__864__auto__ buf__866__auto__ 0 r__868__auto__)
        (recur))))
     (.sign signer__864__auto__)))
   (compute-sha5121359-verify
    [data1360 sig1361 key1362]
    (clojure.core/let
     [signer__869__auto__
      (java.security.Signature/getInstance "SHA512withRSA")
      c__870__auto__
      (clojure.core/int *buffer-size*)
      buf__871__auto__
      (clojure.core/byte-array c__870__auto__)
      s__872__auto__
      data1360
      key__873__auto__
      (pandect.utils.convert/as-public-key key1362)]
     (.initVerify signer__869__auto__ key__873__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__874__auto__
        (.read s__872__auto__ buf__871__auto__ 0 c__870__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__874__auto__ -1)
        (.update signer__869__auto__ buf__871__auto__ 0 r__874__auto__)
        (recur))))
     (.verify signer__869__auto__ (clojure.core/bytes sig1361))))
   java.io.File
   (compute-sha5121359
    [data1360 key1362]
    (clojure.core/with-open
     [data1360 (clojure.java.io/input-stream data1360)]
     (clojure.core/let
      [signer__864__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA512withRSA")
        (.initSign key1362))
       c__865__auto__
       (clojure.core/int *buffer-size*)
       buf__866__auto__
       (clojure.core/byte-array c__865__auto__)
       s__867__auto__
       data1360]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__868__auto__
         (.read s__867__auto__ buf__866__auto__ 0 c__865__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__868__auto__ -1)
         (.update
          signer__864__auto__
          buf__866__auto__
          0
          r__868__auto__)
         (recur))))
      (.sign signer__864__auto__))))
   (compute-sha5121359-verify
    [data1360 sig1361 key1362]
    (clojure.core/with-open
     [data1360 (clojure.java.io/input-stream data1360)]
     (clojure.core/let
      [signer__869__auto__
       (java.security.Signature/getInstance "SHA512withRSA")
       c__870__auto__
       (clojure.core/int *buffer-size*)
       buf__871__auto__
       (clojure.core/byte-array c__870__auto__)
       s__872__auto__
       data1360
       key__873__auto__
       (pandect.utils.convert/as-public-key key1362)]
      (.initVerify signer__869__auto__ key__873__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__874__auto__
         (.read s__872__auto__ buf__871__auto__ 0 c__870__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__874__auto__ -1)
         (.update
          signer__869__auto__
          buf__871__auto__
          0
          r__874__auto__)
         (recur))))
      (.verify signer__869__auto__ (clojure.core/bytes sig1361))))))
  'G__1363)
 (do
  (clojure.core/defn
   sha512-rsa*
   "[Signature] SHA512withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha5121359 x private-key))
  (clojure.core/defn
   sha512-rsa-file*
   "[Signature] SHA512withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha5121359 x private-key)))
  (clojure.core/defn
   sha512-rsa-bytes
   "[Signature] SHA512withRSA (value -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha5121359 x private-key))
  (clojure.core/defn
   sha512-rsa-file-bytes
   "[Signature] SHA512withRSA (file path -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha5121359 x private-key)))
  (clojure.core/defn
   sha512-rsa
   "[Signature] SHA512withRSA (value -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (pandect.utils.convert/bytes->hex
    (compute-sha5121359 x private-key)))
  (clojure.core/defn
   sha512-rsa-file
   "[Signature] SHA512withRSA (file path -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha5121359 x private-key))))
  (clojure.core/defn
   sha512-rsa-verify
   "[Signature] SHA512withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (compute-sha5121359-verify
    x
    (pandect.utils.convert/convert-signature-to-byte-array signature)
    (pandect.utils.convert/convert-to-public-key public-key)))
  (clojure.core/defn
   sha512-rsa-verify-file
   "[Signature] SHA512withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha5121359-verify
     x
     (pandect.utils.convert/convert-signature-to-byte-array signature)
     (pandect.utils.convert/convert-to-public-key public-key))))))
