(ns
 pandect.algo.md2
 "MD2 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1245 (compute-md21243 [data1244]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1245 #'compute-md21243]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1245
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md21243
    [data1244]
    (clojure.core/let
     [md__682__auto__ (java.security.MessageDigest/getInstance "MD2")]
     (.digest md__682__auto__ data1244)))
   java.lang.String
   (compute-md21243
    [data1244]
    (clojure.core/let
     [data1244 (.getBytes data1244 "UTF-8")]
     (clojure.core/let
      [md__682__auto__ (java.security.MessageDigest/getInstance "MD2")]
      (.digest md__682__auto__ data1244)))))
  (clojure.core/extend-protocol
   G__1245
   java.io.InputStream
   (compute-md21243
    [data1244]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "MD2")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1244]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-md21243
    [data1244]
    (clojure.core/with-open
     [data1244 (clojure.java.io/input-stream data1244)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "MD2")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1244]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1245)
 (do
  (clojure.core/defn
   md2*
   "[Hash] MD2 (raw value)"
   [x]
   (compute-md21243 x))
  (clojure.core/defn
   md2-file*
   "[Hash] MD2 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md21243 x)))
  (clojure.core/defn
   md2-bytes
   "[Hash] MD2 (value -> byte array)"
   [x]
   (compute-md21243 x))
  (clojure.core/defn
   md2-file-bytes
   "[Hash] MD2 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md21243 x)))
  (clojure.core/defn
   md2
   "[Hash] MD2 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-md21243 x)))
  (clojure.core/defn
   md2-file
   "[Hash] MD2 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-md21243 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1284
   (compute-md21280 [data1281 key1283])
   (compute-md21280-verify [data1281 sig1282 key1283]))
  (clojure.core/doseq
   [v__198__auto__
    [#'G__1284 #'compute-md21280 #'compute-md21280-verify]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1284
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md21280
    [data1281 key1283]
    (clojure.core/let
     [signer__861__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "MD2withRSA")
       (.initSign key1283)
       (.update (clojure.core/bytes data1281)))]
     (.sign signer__861__auto__)))
   (compute-md21280-verify
    [data1281 sig1282 key1283]
    (clojure.core/let
     [signer__862__auto__
      (java.security.Signature/getInstance "MD2withRSA")
      key__863__auto__
      (pandect.utils.convert/as-public-key key1283)]
     (.initVerify signer__862__auto__ key__863__auto__)
     (.update signer__862__auto__ (clojure.core/bytes data1281))
     (.verify signer__862__auto__ (clojure.core/bytes sig1282))))
   java.lang.String
   (compute-md21280
    [data1281 key1283]
    (clojure.core/let
     [data1281 (.getBytes data1281 "UTF-8")]
     (clojure.core/let
      [signer__861__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "MD2withRSA")
        (.initSign key1283)
        (.update (clojure.core/bytes data1281)))]
      (.sign signer__861__auto__))))
   (compute-md21280-verify
    [data1281 sig1282 key1283]
    (clojure.core/let
     [data1281 (.getBytes data1281 "UTF-8")]
     (clojure.core/let
      [signer__862__auto__
       (java.security.Signature/getInstance "MD2withRSA")
       key__863__auto__
       (pandect.utils.convert/as-public-key key1283)]
      (.initVerify signer__862__auto__ key__863__auto__)
      (.update signer__862__auto__ (clojure.core/bytes data1281))
      (.verify signer__862__auto__ (clojure.core/bytes sig1282))))))
  (clojure.core/extend-protocol
   G__1284
   java.io.InputStream
   (compute-md21280
    [data1281 key1283]
    (clojure.core/let
     [signer__864__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "MD2withRSA")
       (.initSign key1283))
      c__865__auto__
      (clojure.core/int *buffer-size*)
      buf__866__auto__
      (clojure.core/byte-array c__865__auto__)
      s__867__auto__
      data1281]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__868__auto__
        (.read s__867__auto__ buf__866__auto__ 0 c__865__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__868__auto__ -1)
        (.update signer__864__auto__ buf__866__auto__ 0 r__868__auto__)
        (recur))))
     (.sign signer__864__auto__)))
   (compute-md21280-verify
    [data1281 sig1282 key1283]
    (clojure.core/let
     [signer__869__auto__
      (java.security.Signature/getInstance "MD2withRSA")
      c__870__auto__
      (clojure.core/int *buffer-size*)
      buf__871__auto__
      (clojure.core/byte-array c__870__auto__)
      s__872__auto__
      data1281
      key__873__auto__
      (pandect.utils.convert/as-public-key key1283)]
     (.initVerify signer__869__auto__ key__873__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__874__auto__
        (.read s__872__auto__ buf__871__auto__ 0 c__870__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__874__auto__ -1)
        (.update signer__869__auto__ buf__871__auto__ 0 r__874__auto__)
        (recur))))
     (.verify signer__869__auto__ (clojure.core/bytes sig1282))))
   java.io.File
   (compute-md21280
    [data1281 key1283]
    (clojure.core/with-open
     [data1281 (clojure.java.io/input-stream data1281)]
     (clojure.core/let
      [signer__864__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "MD2withRSA")
        (.initSign key1283))
       c__865__auto__
       (clojure.core/int *buffer-size*)
       buf__866__auto__
       (clojure.core/byte-array c__865__auto__)
       s__867__auto__
       data1281]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__868__auto__
         (.read s__867__auto__ buf__866__auto__ 0 c__865__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__868__auto__ -1)
         (.update
          signer__864__auto__
          buf__866__auto__
          0
          r__868__auto__)
         (recur))))
      (.sign signer__864__auto__))))
   (compute-md21280-verify
    [data1281 sig1282 key1283]
    (clojure.core/with-open
     [data1281 (clojure.java.io/input-stream data1281)]
     (clojure.core/let
      [signer__869__auto__
       (java.security.Signature/getInstance "MD2withRSA")
       c__870__auto__
       (clojure.core/int *buffer-size*)
       buf__871__auto__
       (clojure.core/byte-array c__870__auto__)
       s__872__auto__
       data1281
       key__873__auto__
       (pandect.utils.convert/as-public-key key1283)]
      (.initVerify signer__869__auto__ key__873__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__874__auto__
         (.read s__872__auto__ buf__871__auto__ 0 c__870__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__874__auto__ -1)
         (.update
          signer__869__auto__
          buf__871__auto__
          0
          r__874__auto__)
         (recur))))
      (.verify signer__869__auto__ (clojure.core/bytes sig1282))))))
  'G__1284)
 (do
  (clojure.core/defn
   md2-rsa*
   "[Signature] MD2withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-md21280 x private-key))
  (clojure.core/defn
   md2-rsa-file*
   "[Signature] MD2withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md21280 x private-key)))
  (clojure.core/defn
   md2-rsa-bytes
   "[Signature] MD2withRSA (value -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-md21280 x private-key))
  (clojure.core/defn
   md2-rsa-file-bytes
   "[Signature] MD2withRSA (file path -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md21280 x private-key)))
  (clojure.core/defn
   md2-rsa
   "[Signature] MD2withRSA (value -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (pandect.utils.convert/bytes->hex (compute-md21280 x private-key)))
  (clojure.core/defn
   md2-rsa-file
   "[Signature] MD2withRSA (file path -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-md21280 x private-key))))
  (clojure.core/defn
   md2-rsa-verify
   "[Signature] MD2withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (compute-md21280-verify
    x
    (pandect.utils.convert/convert-signature-to-byte-array signature)
    (pandect.utils.convert/convert-to-public-key public-key)))
  (clojure.core/defn
   md2-rsa-verify-file
   "[Signature] MD2withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md21280-verify
     x
     (pandect.utils.convert/convert-signature-to-byte-array signature)
     (pandect.utils.convert/convert-to-public-key public-key))))))
