(ns
 pandect.algo.keccak-384
 "Keccak-384 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol
   G__1215
   (compute-keccak-3841213 [data1214]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1215 #'compute-keccak-3841213]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1215
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-keccak-3841213
    [data1214]
    (clojure.core/let
     [md__682__auto__
      (java.security.MessageDigest/getInstance "Keccak-384")]
     (.digest md__682__auto__ data1214)))
   java.lang.String
   (compute-keccak-3841213
    [data1214]
    (clojure.core/let
     [data1214 (.getBytes data1214 "UTF-8")]
     (clojure.core/let
      [md__682__auto__
       (java.security.MessageDigest/getInstance "Keccak-384")]
      (.digest md__682__auto__ data1214)))))
  (clojure.core/extend-protocol
   G__1215
   java.io.InputStream
   (compute-keccak-3841213
    [data1214]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "Keccak-384")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1214]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-keccak-3841213
    [data1214]
    (clojure.core/with-open
     [data1214 (clojure.java.io/input-stream data1214)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "Keccak-384")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1214]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1215)
 (do
  (clojure.core/defn
   keccak-384*
   "[Hash] Keccak-384 (raw value)"
   [x]
   (compute-keccak-3841213 x))
  (clojure.core/defn
   keccak-384-file*
   "[Hash] Keccak-384 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-3841213 x)))
  (clojure.core/defn
   keccak-384-bytes
   "[Hash] Keccak-384 (value -> byte array)"
   [x]
   (compute-keccak-3841213 x))
  (clojure.core/defn
   keccak-384-file-bytes
   "[Hash] Keccak-384 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-3841213 x)))
  (clojure.core/defn
   keccak-384
   "[Hash] Keccak-384 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-keccak-3841213 x)))
  (clojure.core/defn
   keccak-384-file
   "[Hash] Keccak-384 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-keccak-3841213 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1234
   (compute-keccak-3841231 [data1232 key1233]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1234 #'compute-keccak-3841231]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1234
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-keccak-3841231
    [data1232 key1233]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "Hmac-Keccak384")
      msg__558__auto__
      (clojure.core/bytes data1232)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1233 "Hmac-Keccak384")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-keccak-3841231
    [data1232 key1233]
    (clojure.core/let
     [data1232 (.getBytes data1232 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "Hmac-Keccak384")
       msg__558__auto__
       (clojure.core/bytes data1232)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1233 "Hmac-Keccak384")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1234
   java.io.InputStream
   (compute-keccak-3841231
    [data1232 key1233]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "Hmac-Keccak384")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1233 "Hmac-Keccak384")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1232]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-keccak-3841231
    [data1232 key1233]
    (clojure.core/with-open
     [data1232 (clojure.java.io/input-stream data1232)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "Hmac-Keccak384")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1233 "Hmac-Keccak384")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1232]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1234)
 (do
  (clojure.core/defn
   keccak-384-hmac*
   "[HMAC] Hmac-Keccak384 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-keccak-3841231
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   keccak-384-hmac-file*
   "[HMAC] Hmac-Keccak384 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-3841231
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-384-hmac-bytes
   "[HMAC] Hmac-Keccak384 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-keccak-3841231
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   keccak-384-hmac-file-bytes
   "[HMAC] Hmac-Keccak384 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-3841231
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-384-hmac
   "[HMAC] Hmac-Keccak384 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-keccak-3841231
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-384-hmac-file
   "[HMAC] Hmac-Keccak384 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-keccak-3841231
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
