(ns
 pandect.algo.gost
 "GOST3411 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1224 (compute-gost1222 [data1223]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1224 #'compute-gost1222]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1224
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-gost1222
    [data1223]
    (clojure.core/let
     [md__682__auto__
      (java.security.MessageDigest/getInstance "GOST3411")]
     (.digest md__682__auto__ data1223)))
   java.lang.String
   (compute-gost1222
    [data1223]
    (clojure.core/let
     [data1223 (.getBytes data1223 "UTF-8")]
     (clojure.core/let
      [md__682__auto__
       (java.security.MessageDigest/getInstance "GOST3411")]
      (.digest md__682__auto__ data1223)))))
  (clojure.core/extend-protocol
   G__1224
   java.io.InputStream
   (compute-gost1222
    [data1223]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "GOST3411")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1223]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-gost1222
    [data1223]
    (clojure.core/with-open
     [data1223 (clojure.java.io/input-stream data1223)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "GOST3411")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1223]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1224)
 (do
  (clojure.core/defn
   gost*
   "[Hash] GOST3411 (raw value)"
   [x]
   (compute-gost1222 x))
  (clojure.core/defn
   gost-file*
   "[Hash] GOST3411 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-gost1222 x)))
  (clojure.core/defn
   gost-bytes
   "[Hash] GOST3411 (value -> byte array)"
   [x]
   (compute-gost1222 x))
  (clojure.core/defn
   gost-file-bytes
   "[Hash] GOST3411 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-gost1222 x)))
  (clojure.core/defn
   gost
   "[Hash] GOST3411 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-gost1222 x)))
  (clojure.core/defn
   gost-file
   "[Hash] GOST3411 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-gost1222 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1238
   (compute-gost1235 [data1236 key1237]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1238 #'compute-gost1235]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1238
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-gost1235
    [data1236 key1237]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "Hmac-GOST3411")
      msg__558__auto__
      (clojure.core/bytes data1236)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1237 "Hmac-GOST3411")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-gost1235
    [data1236 key1237]
    (clojure.core/let
     [data1236 (.getBytes data1236 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "Hmac-GOST3411")
       msg__558__auto__
       (clojure.core/bytes data1236)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1237 "Hmac-GOST3411")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1238
   java.io.InputStream
   (compute-gost1235
    [data1236 key1237]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "Hmac-GOST3411")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1237 "Hmac-GOST3411")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1236]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-gost1235
    [data1236 key1237]
    (clojure.core/with-open
     [data1236 (clojure.java.io/input-stream data1236)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "Hmac-GOST3411")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1237 "Hmac-GOST3411")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1236]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1238)
 (do
  (clojure.core/defn
   gost-hmac*
   "[HMAC] Hmac-GOST3411 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-gost1235
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   gost-hmac-file*
   "[HMAC] Hmac-GOST3411 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-gost1235
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   gost-hmac-bytes
   "[HMAC] Hmac-GOST3411 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-gost1235
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   gost-hmac-file-bytes
   "[HMAC] Hmac-GOST3411 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-gost1235
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   gost-hmac
   "[HMAC] Hmac-GOST3411 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-gost1235
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   gost-hmac-file
   "[HMAC] Hmac-GOST3411 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-gost1235
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
