(ns
 pandect.algo.sha1
 "SHA-1 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1309 (compute-sha11307 [data1308]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1309 #'compute-sha11307]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1309
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha11307
    [data1308]
    (clojure.core/let
     [md__682__auto__
      (java.security.MessageDigest/getInstance "SHA-1")]
     (.digest md__682__auto__ data1308)))
   java.lang.String
   (compute-sha11307
    [data1308]
    (clojure.core/let
     [data1308 (.getBytes data1308 "UTF-8")]
     (clojure.core/let
      [md__682__auto__
       (java.security.MessageDigest/getInstance "SHA-1")]
      (.digest md__682__auto__ data1308)))))
  (clojure.core/extend-protocol
   G__1309
   java.io.InputStream
   (compute-sha11307
    [data1308]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "SHA-1")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1308]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-sha11307
    [data1308]
    (clojure.core/with-open
     [data1308 (clojure.java.io/input-stream data1308)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "SHA-1")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1308]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1309)
 (do
  (clojure.core/defn
   sha1*
   "[Hash] SHA-1 (raw value)"
   [x]
   (compute-sha11307 x))
  (clojure.core/defn
   sha1-file*
   "[Hash] SHA-1 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11307 x)))
  (clojure.core/defn
   sha1-bytes
   "[Hash] SHA-1 (value -> byte array)"
   [x]
   (compute-sha11307 x))
  (clojure.core/defn
   sha1-file-bytes
   "[Hash] SHA-1 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11307 x)))
  (clojure.core/defn
   sha1
   "[Hash] SHA-1 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-sha11307 x)))
  (clojure.core/defn
   sha1-file
   "[Hash] SHA-1 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-sha11307 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1329
   (compute-sha11326 [data1327 key1328]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1329 #'compute-sha11326]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1329
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha11326
    [data1327 key1328]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "HmacSHA1")
      msg__558__auto__
      (clojure.core/bytes data1327)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1328 "HmacSHA1")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-sha11326
    [data1327 key1328]
    (clojure.core/let
     [data1327 (.getBytes data1327 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "HmacSHA1")
       msg__558__auto__
       (clojure.core/bytes data1327)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1328 "HmacSHA1")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1329
   java.io.InputStream
   (compute-sha11326
    [data1327 key1328]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "HmacSHA1")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1328 "HmacSHA1")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1327]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-sha11326
    [data1327 key1328]
    (clojure.core/with-open
     [data1327 (clojure.java.io/input-stream data1327)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "HmacSHA1")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1328 "HmacSHA1")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1327]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1329)
 (do
  (clojure.core/defn
   sha1-hmac*
   "[HMAC] HmacSHA1 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha11326
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha1-hmac-file*
   "[HMAC] HmacSHA1 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11326
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha1-hmac-bytes
   "[HMAC] HmacSHA1 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha11326
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha1-hmac-file-bytes
   "[HMAC] HmacSHA1 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11326
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha1-hmac
   "[HMAC] HmacSHA1 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-sha11326
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha1-hmac-file
   "[HMAC] HmacSHA1 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha11326
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
(do
 (do
  (clojure.core/defprotocol
   G__1380
   (compute-sha11376 [data1377 key1379])
   (compute-sha11376-verify [data1377 sig1378 key1379]))
  (clojure.core/doseq
   [v__198__auto__
    [#'G__1380 #'compute-sha11376 #'compute-sha11376-verify]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1380
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha11376
    [data1377 key1379]
    (clojure.core/let
     [signer__861__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA1withRSA")
       (.initSign key1379)
       (.update (clojure.core/bytes data1377)))]
     (.sign signer__861__auto__)))
   (compute-sha11376-verify
    [data1377 sig1378 key1379]
    (clojure.core/let
     [signer__862__auto__
      (java.security.Signature/getInstance "SHA1withRSA")
      key__863__auto__
      (pandect.utils.convert/as-public-key key1379)]
     (.initVerify signer__862__auto__ key__863__auto__)
     (.update signer__862__auto__ (clojure.core/bytes data1377))
     (.verify signer__862__auto__ (clojure.core/bytes sig1378))))
   java.lang.String
   (compute-sha11376
    [data1377 key1379]
    (clojure.core/let
     [data1377 (.getBytes data1377 "UTF-8")]
     (clojure.core/let
      [signer__861__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA1withRSA")
        (.initSign key1379)
        (.update (clojure.core/bytes data1377)))]
      (.sign signer__861__auto__))))
   (compute-sha11376-verify
    [data1377 sig1378 key1379]
    (clojure.core/let
     [data1377 (.getBytes data1377 "UTF-8")]
     (clojure.core/let
      [signer__862__auto__
       (java.security.Signature/getInstance "SHA1withRSA")
       key__863__auto__
       (pandect.utils.convert/as-public-key key1379)]
      (.initVerify signer__862__auto__ key__863__auto__)
      (.update signer__862__auto__ (clojure.core/bytes data1377))
      (.verify signer__862__auto__ (clojure.core/bytes sig1378))))))
  (clojure.core/extend-protocol
   G__1380
   java.io.InputStream
   (compute-sha11376
    [data1377 key1379]
    (clojure.core/let
     [signer__864__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA1withRSA")
       (.initSign key1379))
      c__865__auto__
      (clojure.core/int *buffer-size*)
      buf__866__auto__
      (clojure.core/byte-array c__865__auto__)
      s__867__auto__
      data1377]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__868__auto__
        (.read s__867__auto__ buf__866__auto__ 0 c__865__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__868__auto__ -1)
        (.update signer__864__auto__ buf__866__auto__ 0 r__868__auto__)
        (recur))))
     (.sign signer__864__auto__)))
   (compute-sha11376-verify
    [data1377 sig1378 key1379]
    (clojure.core/let
     [signer__869__auto__
      (java.security.Signature/getInstance "SHA1withRSA")
      c__870__auto__
      (clojure.core/int *buffer-size*)
      buf__871__auto__
      (clojure.core/byte-array c__870__auto__)
      s__872__auto__
      data1377
      key__873__auto__
      (pandect.utils.convert/as-public-key key1379)]
     (.initVerify signer__869__auto__ key__873__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__874__auto__
        (.read s__872__auto__ buf__871__auto__ 0 c__870__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__874__auto__ -1)
        (.update signer__869__auto__ buf__871__auto__ 0 r__874__auto__)
        (recur))))
     (.verify signer__869__auto__ (clojure.core/bytes sig1378))))
   java.io.File
   (compute-sha11376
    [data1377 key1379]
    (clojure.core/with-open
     [data1377 (clojure.java.io/input-stream data1377)]
     (clojure.core/let
      [signer__864__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA1withRSA")
        (.initSign key1379))
       c__865__auto__
       (clojure.core/int *buffer-size*)
       buf__866__auto__
       (clojure.core/byte-array c__865__auto__)
       s__867__auto__
       data1377]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__868__auto__
         (.read s__867__auto__ buf__866__auto__ 0 c__865__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__868__auto__ -1)
         (.update
          signer__864__auto__
          buf__866__auto__
          0
          r__868__auto__)
         (recur))))
      (.sign signer__864__auto__))))
   (compute-sha11376-verify
    [data1377 sig1378 key1379]
    (clojure.core/with-open
     [data1377 (clojure.java.io/input-stream data1377)]
     (clojure.core/let
      [signer__869__auto__
       (java.security.Signature/getInstance "SHA1withRSA")
       c__870__auto__
       (clojure.core/int *buffer-size*)
       buf__871__auto__
       (clojure.core/byte-array c__870__auto__)
       s__872__auto__
       data1377
       key__873__auto__
       (pandect.utils.convert/as-public-key key1379)]
      (.initVerify signer__869__auto__ key__873__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__874__auto__
         (.read s__872__auto__ buf__871__auto__ 0 c__870__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__874__auto__ -1)
         (.update
          signer__869__auto__
          buf__871__auto__
          0
          r__874__auto__)
         (recur))))
      (.verify signer__869__auto__ (clojure.core/bytes sig1378))))))
  'G__1380)
 (do
  (clojure.core/defn
   sha1-rsa*
   "[Signature] SHA1withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha11376 x private-key))
  (clojure.core/defn
   sha1-rsa-file*
   "[Signature] SHA1withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11376 x private-key)))
  (clojure.core/defn
   sha1-rsa-bytes
   "[Signature] SHA1withRSA (value -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha11376 x private-key))
  (clojure.core/defn
   sha1-rsa-file-bytes
   "[Signature] SHA1withRSA (file path -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11376 x private-key)))
  (clojure.core/defn
   sha1-rsa
   "[Signature] SHA1withRSA (value -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (pandect.utils.convert/bytes->hex (compute-sha11376 x private-key)))
  (clojure.core/defn
   sha1-rsa-file
   "[Signature] SHA1withRSA (file path -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha11376 x private-key))))
  (clojure.core/defn
   sha1-rsa-verify
   "[Signature] SHA1withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (compute-sha11376-verify
    x
    (pandect.utils.convert/convert-signature-to-byte-array signature)
    (pandect.utils.convert/convert-to-public-key public-key)))
  (clojure.core/defn
   sha1-rsa-verify-file
   "[Signature] SHA1withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11376-verify
     x
     (pandect.utils.convert/convert-signature-to-byte-array signature)
     (pandect.utils.convert/convert-to-public-key public-key))))))
(do
 (do
  (clojure.core/defprotocol
   G__1385
   (compute-sha11381 [data1382 key1384])
   (compute-sha11381-verify [data1382 sig1383 key1384]))
  (clojure.core/doseq
   [v__198__auto__
    [#'G__1385 #'compute-sha11381 #'compute-sha11381-verify]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1385
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha11381
    [data1382 key1384]
    (clojure.core/let
     [signer__861__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA1withDSA")
       (.initSign key1384)
       (.update (clojure.core/bytes data1382)))]
     (.sign signer__861__auto__)))
   (compute-sha11381-verify
    [data1382 sig1383 key1384]
    (clojure.core/let
     [signer__862__auto__
      (java.security.Signature/getInstance "SHA1withDSA")
      key__863__auto__
      (pandect.utils.convert/as-public-key key1384)]
     (.initVerify signer__862__auto__ key__863__auto__)
     (.update signer__862__auto__ (clojure.core/bytes data1382))
     (.verify signer__862__auto__ (clojure.core/bytes sig1383))))
   java.lang.String
   (compute-sha11381
    [data1382 key1384]
    (clojure.core/let
     [data1382 (.getBytes data1382 "UTF-8")]
     (clojure.core/let
      [signer__861__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA1withDSA")
        (.initSign key1384)
        (.update (clojure.core/bytes data1382)))]
      (.sign signer__861__auto__))))
   (compute-sha11381-verify
    [data1382 sig1383 key1384]
    (clojure.core/let
     [data1382 (.getBytes data1382 "UTF-8")]
     (clojure.core/let
      [signer__862__auto__
       (java.security.Signature/getInstance "SHA1withDSA")
       key__863__auto__
       (pandect.utils.convert/as-public-key key1384)]
      (.initVerify signer__862__auto__ key__863__auto__)
      (.update signer__862__auto__ (clojure.core/bytes data1382))
      (.verify signer__862__auto__ (clojure.core/bytes sig1383))))))
  (clojure.core/extend-protocol
   G__1385
   java.io.InputStream
   (compute-sha11381
    [data1382 key1384]
    (clojure.core/let
     [signer__864__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA1withDSA")
       (.initSign key1384))
      c__865__auto__
      (clojure.core/int *buffer-size*)
      buf__866__auto__
      (clojure.core/byte-array c__865__auto__)
      s__867__auto__
      data1382]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__868__auto__
        (.read s__867__auto__ buf__866__auto__ 0 c__865__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__868__auto__ -1)
        (.update signer__864__auto__ buf__866__auto__ 0 r__868__auto__)
        (recur))))
     (.sign signer__864__auto__)))
   (compute-sha11381-verify
    [data1382 sig1383 key1384]
    (clojure.core/let
     [signer__869__auto__
      (java.security.Signature/getInstance "SHA1withDSA")
      c__870__auto__
      (clojure.core/int *buffer-size*)
      buf__871__auto__
      (clojure.core/byte-array c__870__auto__)
      s__872__auto__
      data1382
      key__873__auto__
      (pandect.utils.convert/as-public-key key1384)]
     (.initVerify signer__869__auto__ key__873__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__874__auto__
        (.read s__872__auto__ buf__871__auto__ 0 c__870__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__874__auto__ -1)
        (.update signer__869__auto__ buf__871__auto__ 0 r__874__auto__)
        (recur))))
     (.verify signer__869__auto__ (clojure.core/bytes sig1383))))
   java.io.File
   (compute-sha11381
    [data1382 key1384]
    (clojure.core/with-open
     [data1382 (clojure.java.io/input-stream data1382)]
     (clojure.core/let
      [signer__864__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA1withDSA")
        (.initSign key1384))
       c__865__auto__
       (clojure.core/int *buffer-size*)
       buf__866__auto__
       (clojure.core/byte-array c__865__auto__)
       s__867__auto__
       data1382]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__868__auto__
         (.read s__867__auto__ buf__866__auto__ 0 c__865__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__868__auto__ -1)
         (.update
          signer__864__auto__
          buf__866__auto__
          0
          r__868__auto__)
         (recur))))
      (.sign signer__864__auto__))))
   (compute-sha11381-verify
    [data1382 sig1383 key1384]
    (clojure.core/with-open
     [data1382 (clojure.java.io/input-stream data1382)]
     (clojure.core/let
      [signer__869__auto__
       (java.security.Signature/getInstance "SHA1withDSA")
       c__870__auto__
       (clojure.core/int *buffer-size*)
       buf__871__auto__
       (clojure.core/byte-array c__870__auto__)
       s__872__auto__
       data1382
       key__873__auto__
       (pandect.utils.convert/as-public-key key1384)]
      (.initVerify signer__869__auto__ key__873__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__874__auto__
         (.read s__872__auto__ buf__871__auto__ 0 c__870__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__874__auto__ -1)
         (.update
          signer__869__auto__
          buf__871__auto__
          0
          r__874__auto__)
         (recur))))
      (.verify signer__869__auto__ (clojure.core/bytes sig1383))))))
  'G__1385)
 (do
  (clojure.core/defn
   sha1-dsa*
   "[Signature] SHA1withDSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha11381 x private-key))
  (clojure.core/defn
   sha1-dsa-file*
   "[Signature] SHA1withDSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11381 x private-key)))
  (clojure.core/defn
   sha1-dsa-bytes
   "[Signature] SHA1withDSA (value -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha11381 x private-key))
  (clojure.core/defn
   sha1-dsa-file-bytes
   "[Signature] SHA1withDSA (file path -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11381 x private-key)))
  (clojure.core/defn
   sha1-dsa
   "[Signature] SHA1withDSA (value -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (pandect.utils.convert/bytes->hex (compute-sha11381 x private-key)))
  (clojure.core/defn
   sha1-dsa-file
   "[Signature] SHA1withDSA (file path -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha11381 x private-key))))
  (clojure.core/defn
   sha1-dsa-verify
   "[Signature] SHA1withDSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (compute-sha11381-verify
    x
    (pandect.utils.convert/convert-signature-to-byte-array signature)
    (pandect.utils.convert/convert-to-public-key public-key)))
  (clojure.core/defn
   sha1-dsa-verify-file
   "[Signature] SHA1withDSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11381-verify
     x
     (pandect.utils.convert/convert-signature-to-byte-array signature)
     (pandect.utils.convert/convert-to-public-key public-key))))))
