(ns
 pandect.algo.sha384
 "SHA-384 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1308 (compute-sha3841306 [data1307]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1308 #'compute-sha3841306]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1308
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha3841306
    [data1307]
    (clojure.core/let
     [md__682__auto__
      (java.security.MessageDigest/getInstance "SHA-384")]
     (.digest md__682__auto__ data1307)))
   java.lang.String
   (compute-sha3841306
    [data1307]
    (clojure.core/let
     [data1307 (.getBytes data1307 "UTF-8")]
     (clojure.core/let
      [md__682__auto__
       (java.security.MessageDigest/getInstance "SHA-384")]
      (.digest md__682__auto__ data1307)))))
  (clojure.core/extend-protocol
   G__1308
   java.io.InputStream
   (compute-sha3841306
    [data1307]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "SHA-384")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1307]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-sha3841306
    [data1307]
    (clojure.core/with-open
     [data1307 (clojure.java.io/input-stream data1307)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "SHA-384")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1307]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1308)
 (do
  (clojure.core/defn
   sha384*
   "[Hash] SHA-384 (raw value)"
   [x]
   (compute-sha3841306 x))
  (clojure.core/defn
   sha384-file*
   "[Hash] SHA-384 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841306 x)))
  (clojure.core/defn
   sha384-bytes
   "[Hash] SHA-384 (value -> byte array)"
   [x]
   (compute-sha3841306 x))
  (clojure.core/defn
   sha384-file-bytes
   "[Hash] SHA-384 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841306 x)))
  (clojure.core/defn
   sha384
   "[Hash] SHA-384 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-sha3841306 x)))
  (clojure.core/defn
   sha384-file
   "[Hash] SHA-384 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-sha3841306 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1324
   (compute-sha3841321 [data1322 key1323]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1324 #'compute-sha3841321]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1324
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha3841321
    [data1322 key1323]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "HmacSHA384")
      msg__558__auto__
      (clojure.core/bytes data1322)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1323 "HmacSHA384")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-sha3841321
    [data1322 key1323]
    (clojure.core/let
     [data1322 (.getBytes data1322 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "HmacSHA384")
       msg__558__auto__
       (clojure.core/bytes data1322)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1323 "HmacSHA384")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1324
   java.io.InputStream
   (compute-sha3841321
    [data1322 key1323]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "HmacSHA384")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1323 "HmacSHA384")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1322]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-sha3841321
    [data1322 key1323]
    (clojure.core/with-open
     [data1322 (clojure.java.io/input-stream data1322)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "HmacSHA384")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1323 "HmacSHA384")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1322]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1324)
 (do
  (clojure.core/defn
   sha384-hmac*
   "[HMAC] HmacSHA384 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha3841321
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha384-hmac-file*
   "[HMAC] HmacSHA384 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841321
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha384-hmac-bytes
   "[HMAC] HmacSHA384 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha3841321
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha384-hmac-file-bytes
   "[HMAC] HmacSHA384 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841321
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha384-hmac
   "[HMAC] HmacSHA384 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-sha3841321
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha384-hmac-file
   "[HMAC] HmacSHA384 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha3841321
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
(do
 (do
  (clojure.core/defprotocol
   G__1349
   (compute-sha3841345 [data1346 key1348])
   (compute-sha3841345-verify [data1346 sig1347 key1348]))
  (clojure.core/doseq
   [v__198__auto__
    [#'G__1349 #'compute-sha3841345 #'compute-sha3841345-verify]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1349
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha3841345
    [data1346 key1348]
    (clojure.core/let
     [signer__861__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA384withRSA")
       (.initSign key1348)
       (.update (clojure.core/bytes data1346)))]
     (.sign signer__861__auto__)))
   (compute-sha3841345-verify
    [data1346 sig1347 key1348]
    (clojure.core/let
     [signer__862__auto__
      (java.security.Signature/getInstance "SHA384withRSA")
      key__863__auto__
      (pandect.utils.convert/as-public-key key1348)]
     (.initVerify signer__862__auto__ key__863__auto__)
     (.update signer__862__auto__ (clojure.core/bytes data1346))
     (.verify signer__862__auto__ (clojure.core/bytes sig1347))))
   java.lang.String
   (compute-sha3841345
    [data1346 key1348]
    (clojure.core/let
     [data1346 (.getBytes data1346 "UTF-8")]
     (clojure.core/let
      [signer__861__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA384withRSA")
        (.initSign key1348)
        (.update (clojure.core/bytes data1346)))]
      (.sign signer__861__auto__))))
   (compute-sha3841345-verify
    [data1346 sig1347 key1348]
    (clojure.core/let
     [data1346 (.getBytes data1346 "UTF-8")]
     (clojure.core/let
      [signer__862__auto__
       (java.security.Signature/getInstance "SHA384withRSA")
       key__863__auto__
       (pandect.utils.convert/as-public-key key1348)]
      (.initVerify signer__862__auto__ key__863__auto__)
      (.update signer__862__auto__ (clojure.core/bytes data1346))
      (.verify signer__862__auto__ (clojure.core/bytes sig1347))))))
  (clojure.core/extend-protocol
   G__1349
   java.io.InputStream
   (compute-sha3841345
    [data1346 key1348]
    (clojure.core/let
     [signer__864__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA384withRSA")
       (.initSign key1348))
      c__865__auto__
      (clojure.core/int *buffer-size*)
      buf__866__auto__
      (clojure.core/byte-array c__865__auto__)
      s__867__auto__
      data1346]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__868__auto__
        (.read s__867__auto__ buf__866__auto__ 0 c__865__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__868__auto__ -1)
        (.update signer__864__auto__ buf__866__auto__ 0 r__868__auto__)
        (recur))))
     (.sign signer__864__auto__)))
   (compute-sha3841345-verify
    [data1346 sig1347 key1348]
    (clojure.core/let
     [signer__869__auto__
      (java.security.Signature/getInstance "SHA384withRSA")
      c__870__auto__
      (clojure.core/int *buffer-size*)
      buf__871__auto__
      (clojure.core/byte-array c__870__auto__)
      s__872__auto__
      data1346
      key__873__auto__
      (pandect.utils.convert/as-public-key key1348)]
     (.initVerify signer__869__auto__ key__873__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__874__auto__
        (.read s__872__auto__ buf__871__auto__ 0 c__870__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__874__auto__ -1)
        (.update signer__869__auto__ buf__871__auto__ 0 r__874__auto__)
        (recur))))
     (.verify signer__869__auto__ (clojure.core/bytes sig1347))))
   java.io.File
   (compute-sha3841345
    [data1346 key1348]
    (clojure.core/with-open
     [data1346 (clojure.java.io/input-stream data1346)]
     (clojure.core/let
      [signer__864__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA384withRSA")
        (.initSign key1348))
       c__865__auto__
       (clojure.core/int *buffer-size*)
       buf__866__auto__
       (clojure.core/byte-array c__865__auto__)
       s__867__auto__
       data1346]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__868__auto__
         (.read s__867__auto__ buf__866__auto__ 0 c__865__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__868__auto__ -1)
         (.update
          signer__864__auto__
          buf__866__auto__
          0
          r__868__auto__)
         (recur))))
      (.sign signer__864__auto__))))
   (compute-sha3841345-verify
    [data1346 sig1347 key1348]
    (clojure.core/with-open
     [data1346 (clojure.java.io/input-stream data1346)]
     (clojure.core/let
      [signer__869__auto__
       (java.security.Signature/getInstance "SHA384withRSA")
       c__870__auto__
       (clojure.core/int *buffer-size*)
       buf__871__auto__
       (clojure.core/byte-array c__870__auto__)
       s__872__auto__
       data1346
       key__873__auto__
       (pandect.utils.convert/as-public-key key1348)]
      (.initVerify signer__869__auto__ key__873__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__874__auto__
         (.read s__872__auto__ buf__871__auto__ 0 c__870__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__874__auto__ -1)
         (.update
          signer__869__auto__
          buf__871__auto__
          0
          r__874__auto__)
         (recur))))
      (.verify signer__869__auto__ (clojure.core/bytes sig1347))))))
  'G__1349)
 (do
  (clojure.core/defn
   sha384-rsa*
   "[Signature] SHA384withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha3841345 x private-key))
  (clojure.core/defn
   sha384-rsa-file*
   "[Signature] SHA384withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841345 x private-key)))
  (clojure.core/defn
   sha384-rsa-bytes
   "[Signature] SHA384withRSA (value -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha3841345 x private-key))
  (clojure.core/defn
   sha384-rsa-file-bytes
   "[Signature] SHA384withRSA (file path -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841345 x private-key)))
  (clojure.core/defn
   sha384-rsa
   "[Signature] SHA384withRSA (value -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (pandect.utils.convert/bytes->hex
    (compute-sha3841345 x private-key)))
  (clojure.core/defn
   sha384-rsa-file
   "[Signature] SHA384withRSA (file path -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha3841345 x private-key))))
  (clojure.core/defn
   sha384-rsa-verify
   "[Signature] SHA384withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (compute-sha3841345-verify
    x
    (pandect.utils.convert/convert-signature-to-byte-array signature)
    (pandect.utils.convert/convert-to-public-key public-key)))
  (clojure.core/defn
   sha384-rsa-verify-file
   "[Signature] SHA384withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841345-verify
     x
     (pandect.utils.convert/convert-signature-to-byte-array signature)
     (pandect.utils.convert/convert-to-public-key public-key))))))
